/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SliceStatROIOp {
    private final Volume volume;
    private final VolumeManager volumeManager;
    private final LabelManager labelManager;
    private final VolumeROI roi;
    private final long selectedROIs;

    public SliceStatROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi, long selectedROIs, LabelManager labelManager) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.roi = roi;
        this.selectedROIs = selectedROIs;
        this.labelManager = labelManager;
    }

    public Map<Long, Analysis> process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int sliceNum = this.volumeManager.getSliceNumber();
        int sliceDirection = this.volumeManager.getSliceDirection();
        int currentTimepoint = bounds.getMinT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        boolean dynamicROI = this.roi.getSeriesLength() > 1;
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        TreeMap<Long, Analysis> map = new TreeMap<Long, Analysis>();
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            int offsetROIZ = xDimROI * yDimROI * ctrZ;
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                int offsetROIY = xDimROI * ctrY;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    long roiIndex = dynamicROI ? this.roi.get(ctrX + offsetROIY + offsetROIZ, currentTimepoint) : this.roi.getCurrent(ctrX + offsetROIY + offsetROIZ);
                    if ((roiIndex & this.selectedROIs) == 0L) continue;
                    roiIndex &= this.selectedROIs;
                    double current = volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint);
                    long bit = 0L;
                    while ((bit = Long.lowestOneBit(roiIndex)) != 0L) {
                        AnalysisImpl stat = (AnalysisImpl)map.get(bit);
                        if (stat == null) {
                            stat = new AnalysisImpl();
                            stat.roiIndex = BitUtilities.findHighestOneBitIndex((long)bit);
                            stat.centroidCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.maxCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.minCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.maxCoordinate.seriesPoint = currentTimepoint;
                            stat.minCoordinate.seriesPoint = currentTimepoint;
                            map.put(bit, stat);
                            stat.max = stat.min = current;
                            stat.maxCoordinate.xInt = stat.minCoordinate.xInt = ctrX;
                            stat.maxCoordinate.yInt = stat.minCoordinate.yInt = ctrY;
                            stat.maxCoordinate.zInt = stat.minCoordinate.zInt = ctrZ;
                        }
                        if (stat.max < current) {
                            stat.max = current;
                            stat.maxCoordinate.xInt = ctrX;
                            stat.maxCoordinate.yInt = ctrY;
                            stat.maxCoordinate.zInt = ctrZ;
                        } else if (stat.min > current) {
                            stat.min = current;
                            stat.minCoordinate.xInt = ctrX;
                            stat.minCoordinate.yInt = ctrY;
                            stat.minCoordinate.zInt = ctrZ;
                        }
                        double currentABS = Math.abs(current);
                        stat.weightedSumX += currentABS * (double)ctrX;
                        stat.weightedSumY += currentABS * (double)ctrY;
                        stat.weightedSumZ += currentABS * (double)ctrZ;
                        stat.sum += current;
                        stat.comSum += currentABS;
                        stat.sumSquared += MathUtilities.pow((double)current, (double)2.0);
                        ++stat.count;
                        roiIndex &= bit ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
            }
        }
        for (Analysis stat : map.values()) {
            AnalysisImpl statImpl = (AnalysisImpl)stat;
            statImpl.setMaxCoordinate(statImpl.maxCoordinate);
            statImpl.setMinCoordinate(statImpl.minCoordinate);
            statImpl.mean = statImpl.sum / (double)statImpl.count;
            statImpl.stdev = Math.sqrt(((double)statImpl.count * statImpl.sumSquared - MathUtilities.pow((double)statImpl.sum, (double)2.0)) / ((double)statImpl.count * ((double)statImpl.count - 1.0)));
            statImpl.centroidCoordinate.setValues(statImpl.weightedSumX / statImpl.comSum, statImpl.weightedSumY / statImpl.comSum, statImpl.weightedSumZ / statImpl.comSum, currentTimepoint);
            statImpl.centroid = volData.getValue(statImpl.centroidCoordinate.xInt, statImpl.centroidCoordinate.yInt, statImpl.centroidCoordinate.zInt, currentTimepoint);
            statImpl.setCentroidCoordinate(statImpl.centroidCoordinate);
            statImpl.setType(2);
            statImpl.setDescription("Slice");
            statImpl.setDescription(this.labelManager.getLabel(stat.getROI(), "ROI " + stat.getDescription()));
            statImpl.setName(this.volumeManager.getName((ImageVolume)this.volume));
            statImpl.setSliceDirection(sliceDirection);
            statImpl.setSliceNum(sliceNum);
            if (sliceDirection == 0) {
                statImpl.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize());
                continue;
            }
            if (sliceDirection == 1) {
                statImpl.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getZSize());
                continue;
            }
            if (sliceDirection != 2) continue;
            statImpl.setUnitSize(this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
        }
        return map;
    }

    public void calculateAllSliceStatsAsync(final int sliceDirection, final OperationListener listener) {
        Thread workThread = new Thread(){

            @Override
            public void run() {
                SliceStatROIOp.this.calculateAllSliceStatsSync(sliceDirection, listener);
            }
        };
        workThread.start();
    }

    public List<Analysis> calculateAllSliceStatsSync(int sliceDirection, OperationListener listener) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int xDimViewer = this.volumeManager.getBaseVolume().getXDim();
        int yDimViewer = this.volumeManager.getBaseVolume().getYDim();
        int zDimViewer = this.volumeManager.getBaseVolume().getZDim();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Slice Stats");
        if (sliceDirection == 0) {
            pb.start(0, 0, zDimViewer);
            for (int ctr = 0; ctr < zDimViewer; ++ctr) {
                Map<Long, Analysis> analysisMap = this.process(new ImageBounds(0, xDimViewer - 1, 0, yDimViewer - 1, ctr, ctr));
                for (Analysis stat : analysisMap.values()) {
                    stats.add(stat);
                }
                if (listener != null) {
                    listener.operationFinished(analysisMap, this.volume);
                    Thread.yield();
                }
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        } else if (sliceDirection == 1) {
            pb.start(0, 0, yDimViewer);
            for (int ctr = 0; ctr < yDimViewer; ++ctr) {
                Map<Long, Analysis> analysisMap = this.process(new ImageBounds(0, xDimViewer - 1, ctr, ctr, 0, zDimViewer - 1));
                for (Analysis stat : analysisMap.values()) {
                    stats.add(stat);
                }
                if (listener != null) {
                    listener.operationFinished(analysisMap, this.volume);
                    Thread.yield();
                }
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        } else if (sliceDirection == 2) {
            pb.start(0, 0, xDimViewer);
            for (int ctr = 0; ctr < xDimViewer; ++ctr) {
                Map<Long, Analysis> analysisMap = this.process(new ImageBounds(ctr, ctr, 0, yDimViewer - 1, 0, zDimViewer - 1));
                for (Analysis stat : analysisMap.values()) {
                    stats.add(stat);
                }
                if (listener != null) {
                    listener.operationFinished(analysisMap, this.volume);
                    Thread.yield();
                }
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        }
        return stats;
    }
}

