/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.List;

public class SeriesStatOp
implements Operation<Analysis> {
    private final VolumeManager volumeManager;
    private final Volume volume;

    public SeriesStatOp(VolumeManager volumeManager, Volume volume) {
        this.volumeManager = volumeManager;
        this.volume = volume;
    }

    @Override
    public Analysis process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int tMin = bounds.getMinT();
        int tMax = bounds.getMaxT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double size = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        double weightedSumT = 0.0;
        boolean notInitialized = true;
        double comSum = 0.0;
        for (int ctrT = tMin; ctrT <= tMax; ++ctrT) {
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        if (notInitialized) {
                            max = min = current;
                            maxVoxel.xInt = minVoxel.xInt = ctrX;
                            maxVoxel.yInt = minVoxel.yInt = ctrY;
                            maxVoxel.zInt = minVoxel.zInt = ctrZ;
                            maxVoxel.seriesPoint = minVoxel.seriesPoint = ctrT;
                            notInitialized = false;
                        }
                        if (max < current) {
                            max = current;
                            maxVoxel.xInt = ctrX;
                            maxVoxel.yInt = ctrY;
                            maxVoxel.zInt = ctrZ;
                            maxVoxel.seriesPoint = ctrT;
                        } else if (min > current) {
                            min = current;
                            minVoxel.xInt = ctrX;
                            minVoxel.yInt = ctrY;
                            minVoxel.zInt = ctrZ;
                            minVoxel.seriesPoint = ctrT;
                        }
                        double currentABS = Math.abs(current);
                        weightedSumX += currentABS * (double)ctrX;
                        weightedSumY += currentABS * (double)ctrY;
                        weightedSumZ += currentABS * (double)ctrZ;
                        weightedSumT += currentABS * (double)ctrT;
                        sum += current;
                        comSum += currentABS;
                        sumSquared += MathUtilities.pow((double)current, (double)2.0);
                        size += 1.0;
                    }
                }
            }
        }
        mean = sum / size;
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, (int)Math.round(weightedSumT / comSum));
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, centerOfMass.seriesPoint);
        AnalysisImpl analysis = new AnalysisImpl(mean, min, max, sum, 0.0, (int)size);
        analysis.setMaxCoordinate(maxVoxel);
        analysis.setMinCoordinate(minVoxel);
        analysis.setCentroid(com);
        analysis.setCentroidCoordinate(centerOfMass);
        analysis.setSumSquared(sumSquared);
        analysis.setWeightedSumX(weightedSumX);
        analysis.setWeightedSumY(weightedSumY);
        analysis.setWeightedSumZ(weightedSumZ);
        analysis.setWeightedSumT(weightedSumT);
        analysis.setComSum(comSum);
        return analysis;
    }

    @Override
    public Analysis accumulate(List<Analysis> results) {
        VolumeData volData = new VolumeData(this.volumeManager);
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double size = 0.0;
        double stdev = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        double weightedSumT = 0.0;
        boolean notInitialized = true;
        double comSum = 0.0;
        for (Analysis analysis : results) {
            AnalysisImpl ai = (AnalysisImpl)analysis;
            if (notInitialized) {
                max = ai.getMaxValue();
                maxVoxel.xInt = ai.getMaxCoordinate().xInt;
                maxVoxel.yInt = ai.getMaxCoordinate().yInt;
                maxVoxel.zInt = ai.getMaxCoordinate().zInt;
                maxVoxel.seriesPoint = ai.getMaxCoordinate().seriesPoint;
                min = ai.getMinValue();
                minVoxel.xInt = ai.getMinCoordinate().xInt;
                minVoxel.yInt = ai.getMinCoordinate().yInt;
                minVoxel.zInt = ai.getMinCoordinate().zInt;
                minVoxel.seriesPoint = ai.getMinCoordinate().seriesPoint;
                notInitialized = false;
            } else {
                if (max < ai.getMaxValue() || max == ai.getMaxValue() && this.distanceFromCorner(ai.getMaxCoordinate()) < this.distanceFromCorner(maxVoxel)) {
                    max = ai.getMaxValue();
                    maxVoxel.xInt = ai.getMaxCoordinate().xInt;
                    maxVoxel.yInt = ai.getMaxCoordinate().yInt;
                    maxVoxel.zInt = ai.getMaxCoordinate().zInt;
                    maxVoxel.seriesPoint = ai.getMaxCoordinate().seriesPoint;
                }
                if (min > ai.getMinValue() || min == ai.getMinValue() && this.distanceFromCorner(ai.getMinCoordinate()) < this.distanceFromCorner(minVoxel)) {
                    min = ai.getMinValue();
                    minVoxel.xInt = ai.getMinCoordinate().xInt;
                    minVoxel.yInt = ai.getMinCoordinate().yInt;
                    minVoxel.zInt = ai.getMinCoordinate().zInt;
                    minVoxel.seriesPoint = ai.getMinCoordinate().seriesPoint;
                }
            }
            weightedSumX += ai.getWeightedSumX();
            weightedSumY += ai.getWeightedSumY();
            weightedSumZ += ai.getWeightedSumZ();
            weightedSumT += ai.getWeightedSumT();
            sum += ai.getSum();
            comSum += ai.getComSum();
            sumSquared += ai.getSumSquared();
            size += (double)ai.getCount();
        }
        mean = sum / size;
        stdev = Math.sqrt((size * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (size * (size - 1.0)));
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, (int)Math.round(weightedSumT / comSum));
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, centerOfMass.seriesPoint);
        AnalysisImpl stats = new AnalysisImpl(mean, min, max, sum, stdev, (int)size);
        stats.setMaxCoordinate(maxVoxel);
        stats.setMinCoordinate(minVoxel);
        stats.setCentroid(com);
        stats.setCentroidCoordinate(centerOfMass);
        stats.setType(4);
        stats.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
        stats.setDescription("Series");
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        return stats;
    }

    private double distanceFromCorner(Coordinate4D coor) {
        double disX = 0 - coor.xInt;
        double disY = 0 - coor.yInt;
        double disZ = 0 - coor.zInt;
        double disT = 0 - coor.seriesPoint;
        return Math.sqrt(disX * disX + disY * disY + disZ * disZ + disT * disT);
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(0, volumeBase.getSeriesLength() - 1);
        }
        return bounds;
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

