/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ColorUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;

public class AnalysisImpl
implements Analysis,
Serializable {
    public Color color;
    public Coordinate4D centroidCoordinate;
    public Coordinate4D maxCoordinate;
    public Coordinate4D minCoordinate;
    public String description;
    public String name;
    public double centroid;
    public double comSum;
    public double max;
    public double mean;
    public double min;
    public double regionSize;
    public double stdev;
    public double sum;
    public double sumSquared;
    public double unitSize;
    public double weightedSumT;
    public double weightedSumX;
    public double weightedSumY;
    public double weightedSumZ;
    public int count;
    public int roiIndex = -1;
    public int sliceDirection;
    public int sliceNum;
    public int type;
    private static final long serialVersionUID = 1L;

    public AnalysisImpl() {
    }

    public AnalysisImpl(double mean, double min, double max, double sum) {
        this();
        this.mean = mean;
        this.min = min;
        this.max = max;
        this.sum = sum;
    }

    public AnalysisImpl(double mean, double min, double max, double sum, double stdev, int count) {
        this(mean, min, max, sum);
        this.stdev = stdev;
        this.count = count;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisImpl other = (AnalysisImpl)obj;
        if (!MathUtilities.essentiallyEqual2((double)this.centroid, (double)other.centroid)) {
            return false;
        }
        if (this.centroidCoordinate == null ? other.centroidCoordinate != null : !this.centroidCoordinate.equals((Object)other.centroidCoordinate)) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.max, (double)other.max)) {
            return false;
        }
        if (this.maxCoordinate == null ? other.maxCoordinate != null : !this.maxCoordinate.equals((Object)other.maxCoordinate)) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.mean, (double)other.mean)) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.min, (double)other.min)) {
            return false;
        }
        if (this.minCoordinate == null ? other.minCoordinate != null : !this.minCoordinate.equals((Object)other.minCoordinate)) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.regionSize, (double)other.regionSize)) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.stdev, (double)other.stdev)) {
            return false;
        }
        if (!MathUtilities.essentiallyEqual2((double)this.sum, (double)other.sum)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return MathUtilities.essentiallyEqual2((double)this.unitSize, (double)other.unitSize);
    }

    public Coordinate4D getCentroidCoordinate() {
        return this.centroidCoordinate;
    }

    public double getCentroidValue() {
        return this.centroid;
    }

    public Color getColor() {
        return this.color;
    }

    public double getComSum() {
        return this.comSum;
    }

    public int getCount() {
        return this.count;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExportableDescription() {
        String str = this.description;
        if (this.roiIndex != -1 && str.startsWith("ROI")) {
            str = str + " (" + ColorUtilities.getHexRepresentation((Color)ROIColor.getColor(this.roiIndex)) + ")";
        }
        return str;
    }

    public Coordinate4D getMaxCoordinate() {
        return this.maxCoordinate;
    }

    public double getMaxValue() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public Coordinate4D getMinCoordinate() {
        return this.minCoordinate;
    }

    public double getMinValue() {
        return this.min;
    }

    public String getName() {
        return this.name;
    }

    public double getRegionSize() {
        return this.regionSize;
    }

    public int getROI() {
        return this.roiIndex;
    }

    public int getSliceDirection() {
        return this.sliceDirection;
    }

    public int getSliceNum() {
        return this.sliceNum;
    }

    public double getStandardDev() {
        return this.stdev;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSquared() {
        return this.sumSquared;
    }

    public int getType() {
        return this.type;
    }

    public double getUnitSize() {
        return this.unitSize;
    }

    public double getWeightedSumT() {
        return this.weightedSumT;
    }

    public double getWeightedSumX() {
        return this.weightedSumX;
    }

    public double getWeightedSumY() {
        return this.weightedSumY;
    }

    public double getWeightedSumZ() {
        return this.weightedSumZ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.centroid);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.centroidCoordinate == null ? 0 : this.centroidCoordinate.hashCode());
        result = 31 * result + this.count;
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.maxCoordinate == null ? 0 : this.maxCoordinate.hashCode());
        temp = Double.doubleToLongBits(this.mean);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minCoordinate == null ? 0 : this.minCoordinate.hashCode());
        temp = Double.doubleToLongBits(this.regionSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.stdev);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.type;
        temp = Double.doubleToLongBits(this.unitSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void setCentroid(double centroid) {
        this.centroid = centroid;
    }

    public void setCentroidCoordinate(Coordinate4D centroidCoordinate) {
        this.centroidCoordinate = this.fixCoordinate(centroidCoordinate);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setComSum(double comSum) {
        this.comSum = comSum;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxCoordinate(Coordinate4D maxCoordinate) {
        this.maxCoordinate = this.fixCoordinate(maxCoordinate);
    }

    public void setMinCoordinate(Coordinate4D minCoordinate) {
        this.minCoordinate = this.fixCoordinate(minCoordinate);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegionSize(double size) {
        this.regionSize = size;
    }

    public void setRoiIndex(int roiIndex, int roiMaxColors) {
        this.roiIndex = roiIndex;
    }

    public void setSliceDirection(int sliceDirection) {
        this.sliceDirection = sliceDirection;
    }

    public void setSliceNum(int sliceNum) {
        this.sliceNum = sliceNum;
    }

    public void setStandardDeviation(double stdev) {
        this.stdev = stdev;
    }

    public void setSumSquared(double sumSquared) {
        this.sumSquared = sumSquared;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUnitSize(double unitSize) {
        this.unitSize = unitSize;
        this.updateRegionSize();
    }

    public void setWeightedSumT(double weightedSumT) {
        this.weightedSumT = weightedSumT;
    }

    public void setWeightedSumX(double weightedSumX) {
        this.weightedSumX = weightedSumX;
    }

    public void setWeightedSumY(double weightedSumY) {
        this.weightedSumY = weightedSumY;
    }

    public void setWeightedSumZ(double weightedSumZ) {
        this.weightedSumZ = weightedSumZ;
    }

    private Coordinate4D fixCoordinate(Coordinate4D coord) {
        return new Coordinate4D((double)coord.xInt, (double)coord.yInt, (double)coord.zInt, coord.seriesPoint);
    }

    private void updateRegionSize() {
        if (this.unitSize != 0.0 && this.count != 0) {
            this.regionSize = this.unitSize * (double)this.count;
        }
    }

    public void printDiff(AnalysisImpl obj) {
        AnalysisImpl other = obj;
        if (!MathUtilities.essentiallyEqual2((double)this.centroid, (double)other.centroid)) {
            AppLogger.info((String)("centroid differs: " + this.centroid + " " + other.centroid));
        }
        if (!this.centroidCoordinate.equals((Object)other.centroidCoordinate)) {
            AppLogger.info((String)("centroidCoordinate differs: " + this.centroidCoordinate + " " + other.centroidCoordinate));
        }
        if (this.count != other.count) {
            AppLogger.info((String)("count differs: " + this.count + " " + other.count));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.max, (double)other.max)) {
            AppLogger.info((String)("max differs: " + this.max + " " + other.max));
        }
        if (!this.maxCoordinate.equals((Object)other.maxCoordinate)) {
            AppLogger.info((String)("maxCoordinate differs: " + this.maxCoordinate + " " + other.maxCoordinate));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.mean, (double)other.mean)) {
            AppLogger.info((String)("mean differs: " + this.mean + " " + other.mean));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.min, (double)other.min)) {
            AppLogger.info((String)("min differs: " + this.min + " " + other.min));
        }
        if (!this.minCoordinate.equals((Object)other.minCoordinate)) {
            AppLogger.info((String)("minCoordinate differs: " + this.minCoordinate + " " + other.minCoordinate));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.regionSize, (double)other.regionSize)) {
            AppLogger.info((String)("regionSize differs: " + this.regionSize + " " + other.regionSize));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.stdev, (double)other.stdev)) {
            AppLogger.info((String)("stdev differs: " + this.stdev + " " + other.stdev));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.sum, (double)other.sum)) {
            AppLogger.info((String)("sum differs: " + this.sum + " " + other.sum));
        }
        if (this.type != other.type) {
            AppLogger.info((String)("type differs: " + this.type + " " + other.type));
        }
        if (!MathUtilities.essentiallyEqual2((double)this.unitSize, (double)other.unitSize)) {
            AppLogger.info((String)("unitSize differs: " + this.unitSize + " " + other.unitSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(AnalysisImpl stat) {
        String result = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(output);
            out.writeObject(stat);
            Base64 base64 = new Base64();
            result = new String(base64.encode(output.toByteArray()));
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalysisImpl deserialize(String str) {
        Base64 base64 = new Base64();
        byte[] data = base64.decode(str);
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        AnalysisImpl statTrue = null;
        try {
            in = new ObjectInputStream(input);
            statTrue = (AnalysisImpl)in.readObject();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return statTrue;
    }
}

