/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.histogram;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.histogram.AnalysisHistogramImpl;
import java.util.List;

public class HistogramOp
implements Operation<Histogram> {
    protected final VolumeManager volumeManager;
    protected final Volume volume;
    protected final AnalysisHistogramImpl stat;
    public static final double EPSILON = 1.0E-10;

    public HistogramOp(VolumeManager volumeManager, Volume volume, AnalysisHistogramImpl stat) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.stat = stat;
    }

    @Override
    public Histogram process(ImageBounds bounds) {
        double binHalf;
        double binSize;
        AnalysisHistogramImpl histogram = new AnalysisHistogramImpl(this.stat.getNumBins(), this.stat.getMin(), this.stat.getMax());
        histogram.setExcludeZero(this.stat.isExcludeZero());
        histogram.setIntegerMode(this.stat.isIntegerMode());
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        int numBins = histogram.getNumBins();
        int[] bins = histogram.getBinCounts();
        double min = histogram.getMin();
        double max = histogram.getMax();
        double[] binMins = histogram.getBinRangeMinimums();
        double[] binMaxs = histogram.getBinRangeMaximums();
        if (histogram.isIntegerMode()) {
            double precision = this.volume.getImageRange().getDataScaleSlopes()[0];
            binSize = ((max - min) / precision + 1.0) * precision / (double)numBins;
            binHalf = precision / 2.0;
        } else {
            binSize = (max - min) / (double)numBins;
            binHalf = 0.0;
        }
        for (int ctr = 0; ctr < numBins; ++ctr) {
            binMins[ctr] = (double)ctr * binSize + min - binHalf;
            binMaxs[ctr] = (double)(ctr + 1) * binSize + min - binHalf;
        }
        double binMultiplier = 1.0 / binSize;
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    int index;
                    double current = volData.getValue(ctrX, ctrY, ctrZ);
                    if (!(current >= min) || !(current < max) || histogram.isExcludeZero() && !(Math.abs(current) > 1.0E-10) || (index = (int)((current - min) * binMultiplier)) < 0 || index >= bins.length) continue;
                    int n = index;
                    bins[n] = bins[n] + 1;
                }
            }
        }
        return histogram;
    }

    @Override
    public Histogram accumulate(List<Histogram> results) {
        AnalysisHistogramImpl histogram = (AnalysisHistogramImpl)results.get(0);
        int[] counts = histogram.getBinCounts();
        for (int ctr = 1; ctr < results.size(); ++ctr) {
            AnalysisHistogramImpl result = (AnalysisHistogramImpl)results.get(ctr);
            int[] currentCounts = result.getBinCounts();
            for (int ctrC = 0; ctrC < currentCounts.length; ++ctrC) {
                int n = ctrC;
                counts[n] = counts[n] + currentCounts[ctrC];
            }
        }
        return histogram;
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
        }
        return bounds;
    }

    public static int getValidAutoBinNumber(ImageVolume volume, double[] range) {
        double distinctValueRange = volume.getImageRange().getDataScaleSlopes()[0];
        double screenDiff = Math.abs(range[1] - range[0]);
        double numBinsVal = screenDiff / distinctValueRange + 1.0;
        double numBinsValCeil = Math.ceil(numBinsVal);
        range[0] = range[0] - (numBinsValCeil - numBinsVal) * distinctValueRange;
        range[1] = range[0] + (numBinsValCeil - 1.0) * distinctValueRange;
        range[0] = (double)Math.round(range[0] / distinctValueRange) * distinctValueRange;
        range[1] = (double)Math.round(range[1] / distinctValueRange) * distinctValueRange;
        numBinsVal = numBinsValCeil;
        if (volume.getImageType().getNumBytesPerVoxel() > 1) {
            double factor = numBinsVal / 128.0;
            while (factor > 2.0) {
                factor = (numBinsVal /= 2.0) / 128.0;
            }
        }
        return (int)Math.round(numBinsVal);
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

