/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.histogram;

import edu.uthscsa.ric.volume.Histogram;
import java.util.ArrayList;
import java.util.List;

public class AnalysisHistogramImpl
implements Histogram {
    private final int numBins;
    private final double min;
    private final double max;
    private final int[] binCounts;
    private final double[] binRangeMins;
    private final double[] binRangeMaxs;
    private int[] selectedStarts;
    private int[] selectedEnds;
    private boolean excludeZero;
    private boolean integerMode;

    public AnalysisHistogramImpl(int numBins, int[] binCounts, double min, double max, double[] binRangeMins, double[] binRangeMaxs, int[] selectedStarts, int[] selectedEnds) {
        this.numBins = numBins;
        this.binCounts = binCounts;
        this.min = min;
        this.max = max;
        this.binRangeMins = binRangeMins;
        this.binRangeMaxs = binRangeMaxs;
        this.selectedStarts = selectedStarts;
        this.selectedEnds = selectedEnds;
    }

    public AnalysisHistogramImpl(int numBins, double min, double max) {
        this.numBins = numBins;
        this.binCounts = new int[numBins];
        this.min = min;
        this.max = max;
        this.binRangeMins = new double[numBins];
        this.binRangeMaxs = new double[numBins];
    }

    public AnalysisHistogramImpl(int numBins, double min, double max, int numColors) {
        this(numBins, min, max);
        this.selectedStarts = new int[numColors];
        this.selectedEnds = new int[numColors];
    }

    public int getNumBins() {
        return this.numBins;
    }

    public int[] getBinCounts() {
        return this.binCounts;
    }

    public double[] getBinRangeMinimums() {
        return this.binRangeMins;
    }

    public double[] getBinRangeMaximums() {
        return this.binRangeMaxs;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getSelectedBinStartIndex(int color) {
        if (color < this.selectedStarts.length) {
            if (this.selectedEnds[color] != -1) {
                return Math.min(this.selectedStarts[color], this.selectedEnds[color]);
            }
            return this.selectedStarts[color];
        }
        return -1;
    }

    public int getSelectedBinEndIndex(int color) {
        if (color < this.selectedEnds.length) {
            if (this.selectedStarts[color] != -1) {
                return Math.max(this.selectedStarts[color], this.selectedEnds[color]);
            }
            return this.selectedEnds[color];
        }
        return -1;
    }

    public List<Integer> getSelectedColors() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int ctr = 0; ctr < this.selectedStarts.length; ++ctr) {
            if (this.selectedStarts[ctr] == -1) continue;
            indices.add(ctr);
        }
        return indices;
    }

    public boolean isExcludeZero() {
        return this.excludeZero;
    }

    public void setExcludeZero(boolean excludeZero) {
        this.excludeZero = excludeZero;
    }

    public boolean isIntegerMode() {
        return this.integerMode;
    }

    public void setIntegerMode(boolean integerMode) {
        this.integerMode = integerMode;
    }
}

