/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import java.nio.FloatBuffer;

public class FilterSlice
extends AbstractFilter
implements Cloneable,
Comparable<Object> {
    private String formula1;
    private String formula2;
    private String formula;
    private float[] kernelCol;
    private float[] kernelRow;
    private float[][] kernel2D;
    public static final String TYPE_STRING = "SLICE";
    public static final int NUM_DIMENSIONS = 2;

    protected FilterSlice(String aName, float[] kernel1, float[] kernel2, boolean norm) {
        super(aName, norm);
        this.kernelRow = kernel1;
        this.kernelCol = kernel2;
    }

    protected FilterSlice(String aName, float[][] kernel, boolean norm) {
        super(aName, norm);
        this.kernel2D = kernel;
    }

    protected FilterSlice(String aName, String aFormula, int size, boolean norm) {
        super(aName, norm);
        this.formula = aFormula;
        this.makeValues(size);
    }

    protected FilterSlice(String aName, String aFormula1, String aFormula2, int size, boolean norm) {
        super(aName, norm);
        this.formula1 = aFormula1;
        this.formula2 = aFormula2;
        this.makeValues(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(FilterBuffer filterBuffer) {
        float[] first = filterBuffer.bufferFirst;
        float[] second = filterBuffer.bufferSecond;
        int sliceSize = filterBuffer.sliceSize;
        int offset = 0;
        float minimum = (float)filterBuffer.getIntercept();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Filtering Image");
        try {
            pb.start(0, 0, this.slices * this.timepoints, true);
            pb.setDescription("Filtering Slices");
            for (int ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                FloatBuffer workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                for (int ctr = 0; ctr < this.slices; ++ctr) {
                    offset = ctr * sliceSize;
                    workBuffer.position(offset);
                    workBuffer.get(first);
                    float[] filteredData = this.filterSlice(first, second, minimum);
                    workBuffer.position(offset);
                    workBuffer.put(filteredData);
                    pb.setValue(ctrT * this.slices + ctr);
                }
            }
        }
        finally {
            pb.setValue(pb.getMax());
        }
    }

    public float[] getColFilterArray() {
        float[] array = null;
        if (this.kernelCol != null) {
            array = new float[this.kernelCol.length];
            for (int ctr = 0; ctr < array.length; ++ctr) {
                array[ctr] = this.kernelCol[ctr];
            }
        }
        return array;
    }

    @Override
    public Object getFullFilterArray() {
        float[][] array = null;
        if (this.kernel2D != null) {
            int size = this.kernel2D.length;
            array = new float[size][size];
            for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                    array[ctrRow][ctrCol] = this.kernel2D[ctrRow][ctrCol];
                }
            }
        } else {
            int size = this.kernelRow.length;
            array = new float[size][size];
            for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                    array[ctrRow][ctrCol] = this.kernelRow[ctrCol] * this.kernelCol[ctrRow];
                }
            }
        }
        return array;
    }

    @Override
    public int getNumDimensions() {
        return 2;
    }

    public float[] getRowFilterArray() {
        float[] array = null;
        if (this.kernelRow != null) {
            array = new float[this.kernelRow.length];
            for (int ctr = 0; ctr < array.length; ++ctr) {
                array[ctr] = this.kernelRow[ctr];
            }
        }
        return array;
    }

    @Override
    public int getSize() {
        int size = 0;
        size = this.kernel2D != null ? this.kernel2D.length : this.kernelRow.length;
        return size;
    }

    @Override
    public String getStringFormattedFilter() {
        StringBuffer sb = new StringBuffer();
        String string = null;
        if (this.formula != null) {
            sb.append("(" + this.formula + ")");
            string = sb.toString();
        } else if (this.formula1 != null && this.formula2 != null) {
            sb.append("(" + this.formula1 + ") | (" + this.formula2 + ")");
            string = sb.toString();
        } else if (this.kernel2D != null) {
            int size = this.kernel2D.length;
            for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                    sb.append(FORMATTER.format(this.kernel2D[ctrRow][ctrCol]) + " ");
                }
            }
            string = sb.toString().trim();
            string = "(" + string + ")";
        } else {
            int size = this.kernelRow.length;
            StringBuffer sbStringRow = new StringBuffer();
            StringBuffer sbStringCol = new StringBuffer();
            for (int ctr = 0; ctr < size; ++ctr) {
                sbStringRow.append(FORMATTER.format(this.kernelRow[ctr]));
                sbStringRow.append(' ');
            }
            String stringRow = "(" + sbStringRow.toString().trim() + ")";
            for (int ctr = 0; ctr < size; ++ctr) {
                sbStringCol.append(FORMATTER.format(this.kernelCol[ctr]));
                sbStringCol.append(' ');
            }
            String stringCol = "(" + sbStringCol.toString().trim() + ")";
            string = stringRow + " | " + stringCol;
        }
        return string;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_STRING;
    }

    @Override
    public boolean isFormula() {
        return this.formula != null || this.formula1 != null || this.formula2 != null;
    }

    @Override
    public boolean isSeparable() {
        return this.kernel2D == null;
    }

    @Override
    public void normalize() {
        block11: {
            int ctr;
            double sum;
            block10: {
                int ctrCol;
                int ctrRow;
                sum = 0.0;
                if (this.kernel2D == null) break block10;
                int size = this.kernel2D.length;
                for (ctrRow = 0; ctrRow < size; ++ctrRow) {
                    for (ctrCol = 0; ctrCol < size; ++ctrCol) {
                        sum += (double)this.kernel2D[ctrRow][ctrCol];
                    }
                }
                if (sum == 0.0) break block11;
                for (ctrRow = 0; ctrRow < size; ++ctrRow) {
                    ctrCol = 0;
                    while (ctrCol < size) {
                        float[] fArray = this.kernel2D[ctrRow];
                        int n = ctrCol++;
                        fArray[n] = (float)((double)fArray[n] / sum);
                    }
                }
                break block11;
            }
            int size = this.kernelRow.length;
            for (ctr = 0; ctr < size; ++ctr) {
                sum += (double)this.kernelRow[ctr];
            }
            if (sum != 0.0) {
                ctr = 0;
                while (ctr < size) {
                    int n = ctr++;
                    this.kernelRow[n] = (float)((double)this.kernelRow[n] / sum);
                }
            }
            sum = 0.0;
            for (ctr = 0; ctr < size; ++ctr) {
                sum += (double)this.kernelCol[ctr];
            }
            if (sum != 0.0) {
                ctr = 0;
                while (ctr < size) {
                    int n = ctr++;
                    this.kernelCol[n] = (float)((double)this.kernelCol[n] / sum);
                }
            }
        }
    }

    protected void makeValues(int size) {
        int halfSize = size / 2;
        if (this.formula != null) {
            StringBuffer operationString = new StringBuffer(this.formula);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
            this.kernel2D = new float[size][size];
            for (int ctrR = -halfSize; ctrR <= halfSize; ++ctrR) {
                for (int ctrC = -halfSize; ctrC <= halfSize; ++ctrC) {
                    this.kernel2D[ctrR + halfSize][ctrC + halfSize] = (float)startNode.getLookupTableResultAtIndex(ctrC, ctrR, 0, 0);
                }
            }
        } else {
            int ctr;
            StringBuffer operationString = new StringBuffer(this.formula2);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
            this.kernelCol = new float[size];
            for (ctr = -halfSize; ctr <= halfSize; ++ctr) {
                this.kernelCol[ctr + halfSize] = (float)startNode.getLookupTableResultAtIndex(0, ctr, 0, 0);
            }
            operationString = new StringBuffer(this.formula1);
            parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
            this.kernelRow = new float[size];
            for (ctr = -halfSize; ctr <= halfSize; ++ctr) {
                this.kernelRow[ctr + halfSize] = (float)startNode.getLookupTableResultAtIndex(ctr, 0, 0, 0);
            }
        }
    }

    private float[] filterSlice(float[] first, float[] second, float minimum) {
        int ctr;
        int rowOffset = 0;
        int rowOffsetK = 0;
        int offset = 0;
        int colPos = 0;
        int rowPos = 0;
        if (this.kernel2D != null) {
            int length = this.kernel2D.length;
            int halfLength = length / 2;
            for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                rowOffset = ctrRows * this.cols;
                for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                    offset = rowOffset + ctrCols;
                    second[offset] = 0.0f;
                    for (int ctrRowK = -halfLength; ctrRowK <= halfLength; ++ctrRowK) {
                        rowOffsetK = ctrRowK + halfLength;
                        for (int ctrColK = -halfLength; ctrColK <= halfLength; ++ctrColK) {
                            colPos = ctrCols + ctrColK;
                            rowPos = ctrRows + ctrRowK;
                            if (colPos >= 0 && colPos < this.cols && rowPos >= 0 && rowPos < this.rows) {
                                int n = offset;
                                second[n] = second[n] + this.kernel2D[rowOffsetK][ctrColK + halfLength] * first[rowPos * this.cols + colPos];
                                continue;
                            }
                            int n = offset;
                            second[n] = second[n] + this.kernel2D[rowOffsetK][ctrColK + halfLength] * minimum;
                        }
                    }
                }
            }
            return second;
        }
        int halfLength = this.kernelRow.length / 2;
        for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
            rowOffset = ctrRows * this.cols;
            for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                offset = rowOffset + ctrCols;
                second[offset] = 0.0f;
                for (ctr = -halfLength; ctr <= halfLength; ++ctr) {
                    colPos = ctr + ctrCols;
                    if (colPos >= 0 && colPos < this.cols) {
                        int n = offset;
                        second[n] = second[n] + FilterSlice.getWeight(ctrCols, this.cols, this.kernelRow, ctr + halfLength) * first[rowOffset + colPos];
                        continue;
                    }
                    int n = offset;
                    second[n] = second[n] + FilterSlice.getWeight(ctrCols, this.cols, this.kernelRow, ctr + halfLength) * minimum;
                }
            }
        }
        for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
            for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                rowOffset = ctrRows * this.cols;
                offset = rowOffset + ctrCols;
                first[offset] = 0.0f;
                for (ctr = -halfLength; ctr <= halfLength; ++ctr) {
                    rowPos = ctr + ctrRows;
                    if (rowPos >= 0 && rowPos < this.rows) {
                        int n = offset;
                        first[n] = first[n] + FilterSlice.getWeight(ctrRows, this.rows, this.kernelCol, ctr + halfLength) * second[rowPos * this.cols + ctrCols];
                        continue;
                    }
                    int n = offset;
                    first[n] = first[n] + FilterSlice.getWeight(ctrRows, this.rows, this.kernelCol, ctr + halfLength) * minimum;
                }
            }
        }
        return first;
    }
}

