/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.utilities.RankSearch;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import java.nio.FloatBuffer;

public class FilterRankVolume
extends AbstractFilterRank
implements Cloneable {
    public FilterRankVolume(int type, int size) {
        super(type, size);
    }

    @Override
    public void filter(FilterBuffer filterBuffer) {
        int rowOffsetGetting = 0;
        int rowKernel = 0;
        int sliceKernel = 0;
        int slicePosBuf = 0;
        int kernelSize = 0;
        int colPos = 0;
        int rowPos = 0;
        int slicePos = 0;
        int offset = 0;
        int sliceOffsetPutting = 0;
        int sliceOffsetGetting = 0;
        int sliceSize = filterBuffer.sliceSize;
        float[][] bufferVolume = null;
        float[] first = filterBuffer.bufferFirst;
        float minimum = (float)filterBuffer.getIntercept();
        int halfLength = this.size / 2;
        if (this.size > filterBuffer.bufferVolume.length) {
            filterBuffer.bufferVolume = new float[this.size][filterBuffer.sliceSize];
            bufferVolume = filterBuffer.bufferVolume;
        } else {
            bufferVolume = filterBuffer.bufferVolume;
        }
        kernelSize = this.size;
        boolean isMedian = (this.type & 2) == 2;
        boolean isMax = (this.type & 4) == 4;
        boolean isMin = (this.type & 1) == 1;
        int medianStartIndex = this.size * this.size * this.size / 2 + 2;
        float[] sort = new float[this.size * this.size * this.size];
        if (this.pb != null) {
            this.pb.start(0, 0, this.slices * this.timepoints);
            this.pb.setDescription("Filtering Volume");
        }
        for (int ctrT = 0; ctrT < this.timepoints; ++ctrT) {
            int ctrSlices;
            FloatBuffer workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
            int numSlicesToPrime = Math.min(halfLength, this.slices);
            for (ctrSlices = 0; ctrSlices < numSlicesToPrime; ++ctrSlices) {
                offset = ctrSlices * sliceSize;
                workBuffer.position(offset);
                workBuffer.get(bufferVolume[ctrSlices]);
            }
            for (ctrSlices = 0; ctrSlices < this.slices; ++ctrSlices) {
                if (ctrSlices + halfLength < this.slices) {
                    offset = (ctrSlices + halfLength) * sliceSize;
                    workBuffer.position(offset);
                    workBuffer.get(bufferVolume[(ctrSlices + halfLength) % kernelSize]);
                }
                for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                    for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                        sliceOffsetPutting = ctrRows * this.cols + ctrCols;
                        for (int ctrKSlices = -halfLength; ctrKSlices <= halfLength; ++ctrKSlices) {
                            slicePos = ctrSlices + ctrKSlices;
                            slicePosBuf = slicePos % kernelSize;
                            sliceKernel = (ctrKSlices + halfLength) * this.size * this.size;
                            for (int ctrKRows = -halfLength; ctrKRows <= halfLength; ++ctrKRows) {
                                rowPos = ctrRows + ctrKRows;
                                rowKernel = (ctrKRows + halfLength) * this.size;
                                rowOffsetGetting = rowPos * this.cols;
                                for (int ctrKCols = -halfLength; ctrKCols <= halfLength; ++ctrKCols) {
                                    colPos = ctrCols + ctrKCols;
                                    if (slicePos >= 0 && slicePos < this.slices && rowPos >= 0 && rowPos < this.rows && colPos >= 0 && colPos < this.cols) {
                                        sliceOffsetGetting = rowOffsetGetting + colPos;
                                        sort[sliceKernel + rowKernel + (ctrKCols + halfLength)] = bufferVolume[slicePosBuf][sliceOffsetGetting];
                                        continue;
                                    }
                                    sort[sliceKernel + rowKernel + (ctrKCols + halfLength)] = minimum;
                                }
                            }
                        }
                        first[sliceOffsetPutting] = isMedian ? RankSearch.searchMedian((float[])sort, (int)medianStartIndex, (boolean)true) : (isMax ? RankSearch.searchMax((float[])sort) : (isMin ? RankSearch.searchMin((float[])sort) : 0.0f));
                    }
                }
                workBuffer.position(ctrSlices * sliceSize);
                workBuffer.put(first);
                if (this.pb == null) continue;
                this.pb.setValue(ctrT * this.slices + ctrSlices);
            }
        }
        if (this.pb != null) {
            this.pb.setValue(this.pb.getMax());
        }
    }

    @Override
    public String toString() {
        return "Volume " + super.toString();
    }

    @Override
    public int getFilterType() {
        return 4;
    }
}

