/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;

public class FilterOp {
    private final VolumeManager volumeManager;
    private final VolumeListener listener;

    public FilterOp(VolumeManager user, VolumeListener listener) {
        this.volumeManager = user;
        this.listener = listener;
    }

    public void processFilter(final AbstractFilter filter, final FilterBuffer buffer) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FilterOp.this.runFilter(filter, null, buffer, true, false);
            }
        }, "FilterOp.processFilter() Thread");
        workThread.start();
    }

    public void processRankFilter(final AbstractFilterRank filter, final FilterBuffer buffer) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FilterOp.this.runRankfilter(filter, buffer);
            }
        }, "FilterOp.processRankFilter() Thread");
        workThread.start();
    }

    public boolean runFilter(AbstractFilter filter, Volume vol, FilterBuffer buffer, boolean updateViewer, boolean doCurrentTimepointOnly) {
        Volume volume = vol;
        if (volume == null) {
            volume = (Volume)this.volumeManager.getBaseVolume();
        }
        if (updateViewer) {
            volume.setImageDirty(true);
        }
        boolean success = true;
        volume.setOperationInProgress(true);
        ImageDimensions id = volume.getImageDimensions();
        if (doCurrentTimepointOnly) {
            filter.setBounds(id.getCols(), id.getRows(), id.getSlices(), 1);
        } else {
            filter.setBounds(id.getCols(), id.getRows(), id.getSlices(), id.getTimepoints());
        }
        filter.setUser(this.volumeManager);
        if (filter.isNormalize()) {
            filter.normalize();
        }
        filter.filter(buffer);
        volume.setOperationInProgress(false);
        if (updateViewer) {
            this.listener.volumeChanged();
            this.listener.volumeOperationCompleted(true, volume);
        }
        return true;
    }

    public void runRankfilter(AbstractFilterRank filter, FilterBuffer buffer) {
        Volume volume = (Volume)this.volumeManager.getBaseVolume();
        volume.setImageDirty(true);
        volume.setOperationInProgress(true);
        ImageDimensions id = volume.getImageDimensions();
        filter.setBounds(id.getCols(), id.getRows(), id.getSlices(), id.getTimepoints());
        filter.setProgressBar(this.volumeManager.makeProgressMeter());
        filter.filter(buffer);
        volume.setOperationInProgress(false);
        this.listener.volumeChanged();
        this.listener.volumeOperationCompleted(true, volume);
    }
}

