/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterException;
import edu.uthscsa.ric.volume.operations.filter.FilterSlice;
import edu.uthscsa.ric.volume.operations.filter.FilterTime;
import edu.uthscsa.ric.volume.operations.filter.FilterVolume;
import edu.uthscsa.ric.volume.operations.filter.Filters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class FilterManager
implements Filters {
    private static TreeSet<AbstractFilter> filters = new TreeSet();
    public static final String EXTENSION = ".flt";

    public void reloadFilters() {
        filters.clear();
        filters.add(SOBEL_3V);
        filters.add(SOBEL_3H);
        filters.add(LAPLACE_4);
        filters.add(GAUSS5_11);
        filters.add(SLICE_AVERAGE_3);
        filters.add(CUBE_AVERAGE_3);
        this.loadUserFilters();
    }

    public void deleteFilter(String name) {
        File[] filterFiles;
        File filterDir = Platform.getFiltersDir();
        if (filterDir != null && filterDir.exists() && (filterFiles = filterDir.listFiles()) != null && filterFiles.length > 0) {
            for (File filterFile : filterFiles) {
                AbstractFilter filter;
                if (!filterFile.getName().endsWith(EXTENSION) || (filter = FilterManager.readFilter(filterFile)) == null || !filter.getName().equals(name)) continue;
                FileUtilities.delete((File)filterFile);
            }
        }
        this.reloadFilters();
    }

    public static AbstractFilter getFilter(String name) {
        for (AbstractFilter currentFilter : filters) {
            if (!currentFilter.getName().equals(name)) continue;
            AbstractFilter aFilter = null;
            try {
                aFilter = (AbstractFilter)currentFilter.clone();
            }
            catch (CloneNotSupportedException ex) {
                AppLogger.warn((Throwable)ex);
                return null;
            }
            return aFilter;
        }
        return null;
    }

    public static AbstractFilter makeFilter(String name, String dimString, String normalize, String sizeString, String kernel, String formula) throws FilterException {
        int size = 0;
        boolean isNormalize = false;
        float[] filter1D = null;
        float[][] filter2D = null;
        float[][][] filter3D = null;
        float[][] filter1DMultiple = null;
        int numDims = 0;
        if (dimString.equals("TIME")) {
            numDims = 1;
        } else if (dimString.equals("SLICE")) {
            numDims = 2;
        } else if (dimString.equals("VOLUME")) {
            numDims = 3;
        }
        size = Integer.parseInt(sizeString);
        if (normalize.toLowerCase().indexOf("true") != -1) {
            isNormalize = true;
        }
        if (kernel != null) {
            boolean valid;
            String lineSub = kernel;
            StringTokenizer tokenizer = new StringTokenizer(lineSub, "|");
            int numTokens = tokenizer.countTokens();
            boolean bl = valid = numTokens == 1 || numTokens == numDims;
            if (valid) {
                if (numTokens > 1) {
                    filter1DMultiple = new float[numTokens][size];
                    int indexOut = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String valuesSet = tokenizer.nextToken();
                        int startIndex = valuesSet.indexOf(40) + 1;
                        int endIndex = valuesSet.lastIndexOf(41);
                        String values = valuesSet.substring(startIndex, endIndex);
                        StringTokenizer tokenizerIn = new StringTokenizer(values);
                        int indexIn = 0;
                        while (tokenizerIn.hasMoreTokens()) {
                            filter1DMultiple[indexOut][indexIn++] = Float.parseFloat(tokenizerIn.nextToken());
                        }
                        ++indexOut;
                    }
                } else {
                    int index;
                    StringTokenizer tokenizerIn;
                    String values;
                    int endIndex;
                    int startIndex;
                    String line = lineSub;
                    if (numDims == 1) {
                        filter1D = new float[size];
                        startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        values = line.substring(startIndex, endIndex);
                        tokenizerIn = new StringTokenizer(values);
                        index = 0;
                        while (tokenizerIn.hasMoreTokens()) {
                            filter1D[index] = Float.parseFloat(tokenizerIn.nextToken());
                            ++index;
                        }
                    } else if (numDims == 2) {
                        filter2D = new float[size][size];
                        startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        values = line.substring(startIndex, endIndex);
                        tokenizerIn = new StringTokenizer(values);
                        index = 0;
                        while (tokenizerIn.hasMoreTokens()) {
                            filter2D[index / size][index % size] = Float.parseFloat(tokenizerIn.nextToken());
                            ++index;
                        }
                    } else if (numDims == 3) {
                        filter3D = new float[size][size][size];
                        startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        values = line.substring(startIndex, endIndex);
                        tokenizerIn = new StringTokenizer(values);
                        index = 0;
                        while (tokenizerIn.hasMoreTokens()) {
                            filter3D[index / (size * size)][index % (size * size) / size][index % size] = Float.parseFloat(tokenizerIn.nextToken());
                            ++index;
                        }
                    }
                }
            } else {
                throw new FilterException("Bad filter format!");
            }
        }
        String formula1D = null;
        String formula2D = null;
        String formula3D = null;
        String[] formula1DMultiple = null;
        if (formula != null) {
            boolean valid;
            String lineSub = formula;
            StringTokenizer tokenizer = new StringTokenizer(lineSub, "|");
            int numTokens = tokenizer.countTokens();
            boolean bl = valid = numTokens == 1 || numTokens == numDims;
            if (valid) {
                if (numTokens > 1) {
                    formula1DMultiple = new String[numTokens];
                    int indexOut = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String valuesSet = tokenizer.nextToken();
                        int startIndex = valuesSet.indexOf(40) + 1;
                        int endIndex = valuesSet.lastIndexOf(41);
                        formula1DMultiple[indexOut] = valuesSet.substring(startIndex, endIndex);
                        ++indexOut;
                    }
                } else {
                    int endIndex;
                    String line = lineSub;
                    if (numDims == 1) {
                        int startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        formula1D = line.substring(startIndex, endIndex);
                    } else if (numDims == 2) {
                        int startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        formula2D = line.substring(startIndex, endIndex);
                    } else if (numDims == 3) {
                        int startIndex = line.indexOf(40) + 1;
                        endIndex = line.lastIndexOf(41);
                        formula3D = line.substring(startIndex, endIndex);
                    }
                }
            } else {
                throw new FilterException("Bad filter format!");
            }
        }
        AbstractFilter filter = null;
        if (filter1D != null) {
            filter = new FilterTime(name, filter1D, isNormalize);
        } else if (filter2D != null) {
            filter = new FilterSlice(name, filter2D, isNormalize);
        } else if (filter3D != null) {
            filter = new FilterVolume(name, filter3D, isNormalize);
        } else if (filter1DMultiple != null) {
            if (filter1DMultiple.length == 1) {
                filter = new FilterTime(name, filter1DMultiple[0], isNormalize);
            } else if (filter1DMultiple.length == 2) {
                filter = new FilterSlice(name, filter1DMultiple[0], filter1DMultiple[1], isNormalize);
            } else if (filter1DMultiple.length == 3) {
                filter = new FilterVolume(name, filter1DMultiple[0], filter1DMultiple[1], filter1DMultiple[2], isNormalize);
            }
        } else if (formula1D != null) {
            filter = new FilterTime(name, formula1D, size, isNormalize);
        } else if (formula2D != null) {
            filter = new FilterSlice(name, formula2D, size, isNormalize);
        } else if (formula3D != null) {
            filter = new FilterVolume(name, formula3D, size, isNormalize);
        } else if (formula1DMultiple != null) {
            if (formula1DMultiple.length == 1) {
                filter = new FilterTime(name, formula1DMultiple[0], size, isNormalize);
            } else if (formula1DMultiple.length == 2) {
                filter = new FilterSlice(name, formula1DMultiple[0], formula1DMultiple[1], size, isNormalize);
            } else if (formula1DMultiple.length == 3) {
                filter = new FilterVolume(name, formula1DMultiple[0], formula1DMultiple[1], formula1DMultiple[2], size, isNormalize);
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractFilter readFilter(File file) {
        AbstractFilter filter = null;
        BufferedReader reader = null;
        String formulaString = null;
        String kernelString = null;
        String normalizeString = null;
        String sizeString = null;
        String dimString = null;
        String name = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                int startIndex;
                if (line.startsWith("Name=")) {
                    startIndex = line.indexOf(34) + 1;
                    int endIndex = line.lastIndexOf(34);
                    name = line.substring(startIndex, endIndex);
                } else if (line.startsWith("Type=")) {
                    startIndex = line.indexOf(61) + 1;
                    dimString = line.substring(startIndex);
                } else if (line.startsWith("Size=")) {
                    startIndex = line.indexOf(61) + 1;
                    sizeString = line.substring(startIndex);
                } else if (line.startsWith("Normalize=")) {
                    normalizeString = line.toLowerCase().indexOf("true") != -1 ? "true" : "false";
                } else if (line.startsWith("Kernel=")) {
                    kernelString = line.substring(line.indexOf(61) + 1);
                } else if (line.startsWith("Formula=")) {
                    formulaString = line.substring(line.indexOf(61) + 1);
                }
                line = reader.readLine();
            }
            filter = FilterManager.makeFilter(name, dimString, normalizeString, sizeString, kernelString, formulaString);
            if (filter == null) {
                throw new FilterException("Filter not successful!");
            }
        }
        catch (FilterException ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic("Not a valid filter! (" + file.getName() + ")", "Load Filter Error");
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUserFilter(AbstractFilter filter, File file) {
        File filterFile = null;
        File filterDir = Platform.getFiltersDir();
        if (!filterDir.exists()) {
            FileUtilities.mkdirs((File)filterDir);
        }
        filterFile = file != null ? file : new File(filterDir, filter.getName() + EXTENSION);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(filterFile)));
            writer.println("Name=\"" + filter.getName() + "\"");
            writer.println("Type=" + filter.getTypeAsString());
            writer.println("Normalize=" + filter.isNormalize());
            writer.println("Size=" + filter.getSize());
            if (filter.isFormula()) {
                String formula = filter.getStringFormattedFilter();
                formula = formula.replaceAll("\\u03C0", "pi");
                writer.println("Formula=" + formula);
            } else {
                writer.println("Kernel=" + filter.getStringFormattedFilter());
            }
        }
    }

    private static void saveUserFilter(AbstractFilter filter) {
        FilterManager.saveUserFilter(filter, null);
    }

    public boolean addFilter(AbstractFilter filter) {
        boolean addedNew;
        if (filters.contains(filter)) {
            AbstractFilter originalFilter = FilterManager.getFilter(filter.getName());
            if (originalFilter.isNonEditable()) {
                filter.setName(filter.getName() + " New");
                return this.addFilter(filter);
            }
            filters.remove(filter);
            filters.add(filter);
            FilterManager.saveUserFilter(filter);
            addedNew = false;
        } else {
            filters.add(filter);
            FilterManager.saveUserFilter(filter);
            addedNew = true;
        }
        return addedNew;
    }

    public String[] getAllFilterNames() {
        String[] filterArray = new String[filters.size()];
        Iterator<AbstractFilter> it = filters.iterator();
        int index = 0;
        while (it.hasNext()) {
            filterArray[index++] = it.next().getName();
        }
        return filterArray;
    }

    public void loadUserFilters() {
        File[] filterFiles;
        File filterDir = Platform.getFiltersDir();
        if (filterDir != null && filterDir.exists() && (filterFiles = filterDir.listFiles()) != null && filterFiles.length > 0) {
            for (File filterFile : filterFiles) {
                AbstractFilter filter;
                if (!filterFile.getName().endsWith(EXTENSION) || (filter = FilterManager.readFilter(filterFile)) == null) continue;
                filters.add(filter);
            }
        }
    }

    static {
        filters.add(SOBEL_3V);
        filters.add(SOBEL_3H);
        filters.add(LAPLACE_4);
        filters.add(GAUSS5_11);
        filters.add(SLICE_AVERAGE_3);
        filters.add(CUBE_AVERAGE_3);
        SOBEL_3V.setAsNonEditable();
        SOBEL_3H.setAsNonEditable();
        LAPLACE_4.setAsNonEditable();
        GAUSS5_11.setAsNonEditable();
        SLICE_AVERAGE_3.setAsNonEditable();
        CUBE_AVERAGE_3.setAsNonEditable();
    }
}

