/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.volume.TimepointUser;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class FilterBuffer {
    private ByteBuffer tempBuffer;
    private ByteBuffer[] workBuffers;
    private final TimepointUser timepointUser;
    protected double intercept;
    protected float[] bufferFirst;
    protected float[] bufferSecond;
    protected float[][] bufferVolume;
    protected int sliceSize;
    public static final int DEFAULT_NUM_SLICES = 5;

    public FilterBuffer(int sliceSize, ByteBuffer tempBuffer, double intercept) {
        this(null, sliceSize, intercept);
        this.tempBuffer = tempBuffer;
    }

    public FilterBuffer(TimepointUser timepointUser, int sliceSize, ByteBuffer[] workBuffers, double intercept) {
        this(timepointUser, sliceSize, intercept);
        this.workBuffers = workBuffers;
    }

    private FilterBuffer(TimepointUser timepointUser, int sliceSize, double intercept) {
        this.timepointUser = timepointUser;
        this.sliceSize = sliceSize;
        this.intercept = intercept;
    }

    public float[] getBufferFirst() {
        return this.bufferFirst;
    }

    public float[] getBufferSecond() {
        return this.bufferSecond;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public void initialize() {
        this.bufferFirst = new float[this.sliceSize];
        this.bufferSecond = new float[this.sliceSize];
        this.bufferVolume = new float[5][this.sliceSize];
    }

    public boolean isInitialized() {
        return this.bufferFirst != null && this.bufferSecond != null;
    }

    protected FloatBuffer getWorkBuffer(int timeIndex, int timepoints) {
        if (this.workBuffers != null) {
            if (timepoints <= 1) {
                int timepoint = this.timepointUser.getCurrentTimepoint();
                return ((ByteBuffer)this.workBuffers[timepoint].rewind()).asFloatBuffer();
            }
            if (timeIndex < this.workBuffers.length) {
                return ((ByteBuffer)this.workBuffers[timeIndex].rewind()).asFloatBuffer();
            }
            return ((ByteBuffer)this.workBuffers[0].rewind()).asFloatBuffer();
        }
        if (this.tempBuffer != null) {
            return ((ByteBuffer)this.tempBuffer.rewind()).asFloatBuffer();
        }
        return null;
    }
}

