/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;

public abstract class AbstractFilter
implements Cloneable,
Comparable<Object> {
    private boolean nonEditable;
    protected VolumeManager volumeManager;
    protected String name;
    protected boolean normalize;
    protected int cols;
    protected int rows;
    protected int slices;
    protected int timepoints;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(1);
    public static final int TYPE_SLICE = 2;
    public static final int TYPE_TIME = 1;
    public static final int TYPE_VOLUME = 4;

    protected static float getWeight(int index, int length, float[] data, int dataIndex) {
        int filterHalfSize = data.length / 2;
        float weight = 0.0f;
        if (index < filterHalfSize) {
            int start = filterHalfSize - index;
            float sum = 0.0f;
            for (int ctr = start; ctr < data.length; ++ctr) {
                sum += data[ctr];
            }
            weight = dataIndex >= start ? data[dataIndex] / sum : 0.0f;
        } else if (index >= length - filterHalfSize) {
            int end = data.length - (filterHalfSize - (length - index - 1));
            float sum = 0.0f;
            for (int ctr = 0; ctr < end; ++ctr) {
                sum += data[ctr];
            }
            weight = dataIndex < end ? data[dataIndex] / sum : 0.0f;
        } else {
            weight = data[dataIndex];
        }
        if (Float.isNaN(weight) || Float.isInfinite(weight)) {
            return 0.0f;
        }
        return weight;
    }

    protected AbstractFilter(String name, boolean normalize) {
        this.name = name;
        this.normalize = normalize;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof AbstractFilter) {
            return this.name.compareTo(((AbstractFilter)obj).getName());
        }
        throw new ClassCastException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFilter other = (AbstractFilter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public abstract void filter(FilterBuffer var1);

    public abstract Object getFullFilterArray();

    public String getName() {
        return this.name;
    }

    public abstract int getNumDimensions();

    public abstract int getSize();

    public abstract String getStringFormattedFilter();

    public abstract int getType();

    public abstract String getTypeAsString();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public abstract boolean isFormula();

    public boolean isNonEditable() {
        return this.nonEditable;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public abstract boolean isSeparable();

    public abstract void normalize();

    public void setBounds(int aCols, int aRows, int aSlices, int aTimepoints) {
        this.cols = aCols;
        this.rows = aRows;
        this.slices = aSlices;
        this.timepoints = aTimepoints;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setUser(VolumeManager user) {
        this.volumeManager = user;
    }

    public String toString() {
        return this.name;
    }

    protected void setAsNonEditable() {
        this.nonEditable = true;
    }
}

