/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.calculation;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.mask.Mask;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ImageOperationTreeNode {
    private ImageOperationTreeNode operation1;
    private ImageOperationTreeNode operation2;
    private String operandString1;
    private String operandString2;
    private Volume volume;
    private VolumeData volData;
    private boolean makeStatsHolder;
    private char operatorCode;
    private int numTimepoints;
    private int valueIndex;
    private Map<Integer, Analysis> roiStatsHolder;
    private final VolumeManager[] allVolManagers;
    private final boolean lutMode;
    private final double[] values;
    private static final char[] ALGEBRAIC_FUNCTION_CODES = new char[]{'g', 'h', 'q', 'r', 's', 't', 'u'};
    private static final char[] ARITHMETIC_CODES = new char[]{'*', '/', '+', '-'};
    private static final char[] LOGIC_FUNCTION_CODES = new char[]{'&', '^', '|', '~', '?', 'v', 'w', '{', '}', ';', '!'};
    private static final char[] MISC_FUNCTION_CODES = new char[]{'T', 'M', 'N', 'O', 'P', 'x', 'y', 'z', 'F', '#', 'R', ':', '@'};
    private static final char[] PRE_BINARY_OPERATORS = new char[]{'u', 'x', 'y', '@', '?', '_', 'R', 'H', 'I', 'J', 'K', 'L'};
    private static final char[] PRE_UNARY_OPERATORS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'q', 'r', 's', 't', 'z', 'F', '#', ':', '~', 'T', 'B', 'C', 'D', 'E', 'G', 'M', 'N', 'O', 'P'};
    private static final char[] SPECIAL_CODES = new char[]{'`'};
    private static final char[] STATS_FUNCTION_CODES = new char[]{'B', 'C', 'D', 'E', 'G', 'H', 'I', 'J', 'K', 'L'};
    private static final char[] TRIG_FUNCTION_CODES = new char[]{'d', 'e', 'f', 'a', 'b', 'c'};
    public static final List<String> ALGEBRAIC_FUNCTION_NAMES = CollectionUtilities.immutable((String[])new String[]{"abs", "sqrt", "cbrt", "exp", "log", "log10", "pow"});
    public static final List<String> LOGIC_FUNCTION_NAMES = CollectionUtilities.immutable((String[])new String[]{"and", "xor", "or", "not", "if", ">=", "<=", ">", "<", "==", "!="});
    public static final List<String> MISC_FUNCTION_NAMES = CollectionUtilities.immutable((String[])new String[]{"volume", "col", "row", "slice", "time", "max", "min", "ceil", "floor", "round", "remainder", "bin", "rand"});
    public static final List<String> SPECIAL_NAMES = CollectionUtilities.immutable((String[])new String[]{"else"});
    public static final List<String> STATS_FUNCTION_NAMES = CollectionUtilities.immutable((String[])new String[]{"meanROI", "maxROI", "minROI", "sdROI", "sumROI", "meanTime", "maxTime", "minTime", "sdTime", "sumTime"});
    public static final List<String> TRIG_FUNCTION_NAMES = CollectionUtilities.immutable((String[])new String[]{"asin", "acos", "atan", "sin", "cos", "tan"});
    public static final int MAX_VALUES = 64;
    public static final int MAX_VOLUMES = 64;

    public static boolean hasValidParentheses(String string) {
        int stackCtr = 0;
        for (int ctr = 0; ctr < string.length(); ++ctr) {
            char currentChar = string.charAt(ctr);
            if (currentChar == '(') {
                ++stackCtr;
                continue;
            }
            if (currentChar != ')') continue;
            --stackCtr;
        }
        return stackCtr == 0;
    }

    public static boolean isValidStartNode(ImageOperationTreeNode startNode) {
        boolean valid = false;
        try {
            startNode.getResultAtIndex(0, 0, 0, 0);
            valid = true;
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return valid;
    }

    public static ImageOperationTreeNode makeOperationTree(String string, double[] someValues, VolumeManager[] allVolumeManagers, VolumeManager manager) {
        return ImageOperationTreeNode.makeOperationTree(string, someValues, allVolumeManagers, manager, false);
    }

    public static ImageOperationTreeNode makeOperationTree(String string, double[] someValues, VolumeManager[] allVolumeManagers, VolumeManager manager, boolean lutMode) {
        String operation = string;
        ImageOperationTreeNode op = null;
        if (!ImageOperationTreeNode.hasValidParentheses(operation)) {
            return null;
        }
        try {
            op = new ImageOperationTreeNode(operation, someValues, allVolumeManagers, manager, lutMode);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return op;
    }

    public static double[] makeReplacements(StringBuffer stringBuf) {
        return ImageOperationTreeNode.makeReplacements(stringBuf, null);
    }

    public static double[] makeReplacements(StringBuffer stringBuf, VolumeManager manager) {
        int ctr;
        String string = ImageOperationTreeNode.removeSpaces(stringBuf.toString());
        string = string.replaceAll("\\(r\\)", "(0)");
        string = string.replaceAll("\\(g\\)", "(1)");
        string = string.replaceAll("\\(b\\)", "(2)");
        string = string.replaceAll("\\(m\\)", "(3)");
        string = string.replaceAll("\\(c\\)", "(4)");
        string = string.replaceAll("\\(y\\)", "(5)");
        string = string.replaceAll("\\(o\\)", "(6)");
        string = string.replaceAll("\\(s\\)", "(7)");
        string = string.replaceAll("\\(red\\)", "(0)");
        string = string.replaceAll("\\(green\\)", "(1)");
        string = string.replaceAll("\\(blue\\)", "(2)");
        string = string.replaceAll("\\(magenta\\)", "(3)");
        string = string.replaceAll("\\(cyan\\)", "(4)");
        string = string.replaceAll("\\(yellow\\)", "(5)");
        string = string.replaceAll("\\(orange\\)", "(6)");
        string = string.replaceAll("\\(slate\\)", "(7)");
        string = string.replaceAll("value", "this");
        string = string.replaceAll("this", "(ii0)");
        string = string.replaceAll("col", "col(0)");
        string = string.replaceAll("row", "row(1)");
        string = string.replaceAll("slice", "slice(2)");
        string = string.replaceAll("time", "time(3)");
        string = string.replaceAll("\\u03C0", String.valueOf(Math.PI));
        string = string.replaceAll("pi", String.valueOf(Math.PI));
        string = string.replaceAll("NaN", "[");
        if (manager != null) {
            if (string.contains("meanROI") && !string.contains("meanROI(")) {
                string = string.replaceAll("meanROI", "meanROI(" + manager.getRoiColor() + ")");
            }
            if (string.contains("maxROI") && !string.contains("maxROI(")) {
                string = string.replaceAll("maxROI", "maxROI(" + manager.getRoiColor() + ")");
            }
            if (string.contains("minROI") && !string.contains("minROI(")) {
                string = string.replaceAll("minROI", "minROI(" + manager.getRoiColor() + ")");
            }
            if (string.contains("sdROI") && !string.contains("sdROI(")) {
                string = string.replaceAll("sdROI", "sdROI(" + manager.getRoiColor() + ")");
            }
            if (string.contains("sumROI") && !string.contains("sumROI(")) {
                string = string.replaceAll("sumROI", "sumROI(" + manager.getRoiColor() + ")");
            }
        }
        string = string.replaceAll("true", "(1==1)");
        string = string.replaceAll("false", "(1!=1)");
        String OPEN = "\\(";
        for (ctr = 64; ctr >= 1; --ctr) {
            if (string.indexOf("other(" + ctr + ")") == -1) continue;
            string = string.replaceAll("other\\(" + ctr + "\\)", (ctr < 10 ? "(ii" : "(i") + ctr + ")");
        }
        for (ctr = 0; ctr < TRIG_FUNCTION_NAMES.size(); ++ctr) {
            string = string.replaceAll(TRIG_FUNCTION_NAMES.get(ctr) + "\\(", "(" + TRIG_FUNCTION_CODES[ctr]);
        }
        for (ctr = 0; ctr < STATS_FUNCTION_NAMES.size(); ++ctr) {
            string = string.replaceAll(STATS_FUNCTION_NAMES.get(ctr) + "\\(", "(" + STATS_FUNCTION_CODES[ctr]);
        }
        for (ctr = 0; ctr < ALGEBRAIC_FUNCTION_NAMES.size(); ++ctr) {
            string = string.replaceAll(ALGEBRAIC_FUNCTION_NAMES.get(ctr) + "\\(", "(" + ALGEBRAIC_FUNCTION_CODES[ctr]);
        }
        for (ctr = 0; ctr < MISC_FUNCTION_NAMES.size(); ++ctr) {
            string = string.replaceAll(MISC_FUNCTION_NAMES.get(ctr) + "\\(", "(" + MISC_FUNCTION_CODES[ctr]);
        }
        for (ctr = 0; ctr < LOGIC_FUNCTION_NAMES.size(); ++ctr) {
            string = ctr == 3 || ctr == 4 ? string.replaceAll(LOGIC_FUNCTION_NAMES.get(ctr) + "\\(", "(" + LOGIC_FUNCTION_CODES[ctr]) : string.replaceAll(LOGIC_FUNCTION_NAMES.get(ctr), String.valueOf(LOGIC_FUNCTION_CODES[ctr]));
        }
        string = string.replaceAll(SPECIAL_NAMES.get(0), String.valueOf(SPECIAL_CODES[0]));
        for (ctr = 0; ctr < string.length(); ++ctr) {
            if (string.charAt(ctr) != '-' || ctr <= 0) continue;
            char previousChar = string.charAt(ctr - 1);
            for (int previousCtr = ctr - 2; previousCtr >= 0 && previousChar == ' '; --previousCtr) {
                previousChar = string.charAt(previousCtr);
            }
            boolean found = false;
            for (char element : ARITHMETIC_CODES) {
                found |= previousChar == element;
            }
            for (char element : TRIG_FUNCTION_CODES) {
                found |= previousChar == element;
            }
            for (char element : STATS_FUNCTION_CODES) {
                found |= previousChar == element;
            }
            for (char element : ALGEBRAIC_FUNCTION_CODES) {
                found |= previousChar == element;
            }
            for (char element : LOGIC_FUNCTION_CODES) {
                found |= previousChar == element;
            }
            for (char element : MISC_FUNCTION_CODES) {
                found |= previousChar == element;
            }
            for (char element : SPECIAL_CODES) {
                found |= previousChar == element;
            }
            found |= previousChar == ',';
            if (!(found |= previousChar == '(')) {
                string = string.substring(0, ctr) + " - " + string.substring(ctr + 1, string.length());
            }
            ++ctr;
        }
        stringBuf.delete(0, stringBuf.length());
        stringBuf.append(string);
        for (ctr = 1; ctr < stringBuf.length(); ++ctr) {
            char currentChar = stringBuf.charAt(ctr);
            char previous = stringBuf.charAt(ctr - 1);
            if (Character.isDigit(currentChar) || currentChar == '.' || currentChar == 'i') {
                if (previous == '-' || previous == 'i' || Character.isDigit(previous) || previous == '.') continue;
                stringBuf.insert(ctr, " ");
                ++ctr;
                continue;
            }
            stringBuf.insert(ctr, " ");
            ++ctr;
        }
        string = stringBuf.toString();
        String[] tokens = string.split(" ");
        StringBuffer sbReturnString = new StringBuffer();
        double[] doubleValues = new double[64];
        int valueCtr = 0;
        for (int ctr2 = 0; ctr2 < tokens.length && valueCtr < 64; ++ctr2) {
            try {
                doubleValues[valueCtr] = tokens[ctr2].equals("[") ? Double.NaN : Double.parseDouble(tokens[ctr2]);
                sbReturnString.append((valueCtr < 10 ? "(nn" : "(n") + valueCtr + ") ");
                ++valueCtr;
                continue;
            }
            catch (NumberFormatException ex) {
                sbReturnString.append(tokens[ctr2]);
                sbReturnString.append(' ');
            }
        }
        stringBuf.delete(0, stringBuf.length());
        stringBuf.append(ImageOperationTreeNode.addParentheses(ImageOperationTreeNode.removeSpaces(sbReturnString.toString())));
        for (char element : PRE_BINARY_OPERATORS) {
            for (int ctr3 = 0; ctr3 < stringBuf.length(); ++ctr3) {
                char current = stringBuf.charAt(ctr3);
                char next = '\u0000';
                if (ctr3 < stringBuf.length() - 1) {
                    next = stringBuf.charAt(ctr3 + 1);
                }
                if (current != element || next == ',') continue;
                boolean changed = false;
                int deleteChar = ctr3;
                int stackCtr = 0;
                for (int ctrComma = ctr3 + 1; !changed && ctrComma < stringBuf.length(); ++ctrComma) {
                    char commaSearch = stringBuf.charAt(ctrComma);
                    if (commaSearch == '(') {
                        ++stackCtr;
                        continue;
                    }
                    if (commaSearch == ')') {
                        --stackCtr;
                        continue;
                    }
                    if (commaSearch != ',' || stackCtr != 0) continue;
                    stringBuf.insert(ctrComma, element);
                    stringBuf.deleteCharAt(deleteChar);
                    changed = true;
                }
            }
        }
        string = stringBuf.toString();
        string = string.replaceAll("[,]", "");
        stringBuf.delete(0, stringBuf.length());
        stringBuf.append(string);
        return doubleValues;
    }

    private static String addParentheses(String string) {
        int ctrIn;
        boolean added;
        char currentChar;
        int ctr;
        StringBuffer stringBuffer = new StringBuffer(string);
        int stackCtr = 0;
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '`') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '*' && currentChar != '/') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '+' && currentChar != '-') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != 'v' && currentChar != 'w' && currentChar != '{' && currentChar != '}') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != ';' && currentChar != '!') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '^') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '&') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '|') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = stringBuffer.length() - 1; ctr >= 0; --ctr) {
            currentChar = stringBuffer.charAt(ctr);
            boolean isUnary = false;
            for (char element : PRE_UNARY_OPERATORS) {
                isUnary |= currentChar == element;
            }
            if (!isUnary) continue;
            stringBuffer.insert(ctr, '(');
            stackCtr = 0;
            added = false;
            for (int ctrIn2 = ctr + 2; ctrIn2 < stringBuffer.length() && !added; ++ctrIn2) {
                currentChar = stringBuffer.charAt(ctrIn2);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn2 + 1, ')');
                added = true;
            }
        }
        return stringBuffer.toString();
    }

    private static String removeSpaces(String string) {
        boolean found;
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            found = false;
            for (int ctr = 0; ctr < stringBuffer.length(); ++ctr) {
                char currentChar = stringBuffer.charAt(ctr);
                if (!Character.isWhitespace(currentChar)) continue;
                stringBuffer.deleteCharAt(ctr);
                found = true;
            }
        } while (found);
        return stringBuffer.toString();
    }

    private static String trimParentheses(String stringVal) {
        boolean trimmed;
        String string = stringVal;
        do {
            trimmed = false;
            int stackCtr = 0;
            int lastFreshOpen = 0;
            for (int ctr = 0; ctr < string.length(); ++ctr) {
                char currentChar = string.charAt(ctr);
                if (currentChar == '(') {
                    if (stackCtr == 0) {
                        lastFreshOpen = ctr;
                    }
                    ++stackCtr;
                    continue;
                }
                if (currentChar != ')' || ctr != string.length() - 1 || --stackCtr != 0 || lastFreshOpen != 0) continue;
                string = string.substring(1, string.length() - 1);
                trimmed = true;
            }
        } while (trimmed);
        return string;
    }

    private ImageOperationTreeNode(String original, double[] someValues, VolumeManager[] allVolManagers, VolumeManager manager, boolean lutMode) {
        this.values = someValues;
        this.allVolManagers = allVolManagers;
        this.lutMode = lutMode;
        this.valueIndex = -1;
        this.parse(original);
        if (this.operatorCode != '\u0000') {
            boolean isBinary = true;
            for (char element : PRE_UNARY_OPERATORS) {
                isBinary &= this.operatorCode != element;
            }
            if (isBinary) {
                this.operation1 = new ImageOperationTreeNode(this.operandString1, someValues, allVolManagers, manager, lutMode);
            }
            this.operation2 = new ImageOperationTreeNode(this.operandString2, someValues, allVolManagers, manager, lutMode);
        }
    }

    public ImageOperationTreeNode getOperation1() {
        return this.operation1;
    }

    public ImageOperationTreeNode getOperation2() {
        return this.operation2;
    }

    public char getOperationCode() {
        return this.operatorCode;
    }

    public double getResultAtIndex(int ctrX, int ctrY, int ctrZ, int ctrL) {
        return this.calculateResult(ctrX, ctrY, ctrZ, ctrL);
    }

    public double getLookupTableResultAtIndex(int ctrX, int ctrY, int ctrZ, int ctrL) {
        double temp = this.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        if (MathUtilities.essentiallyEqual((double)temp, (double)Double.MAX_VALUE)) {
            return 1.0;
        }
        if (MathUtilities.essentiallyEqual((double)temp, (double)Double.MIN_VALUE)) {
            return 0.0;
        }
        if (Double.isInfinite(temp)) {
            return 0.0;
        }
        return temp;
    }

    public Volume getVolume() {
        return (Volume)this.allVolManagers[0].getBaseVolume();
    }

    private double doTimeStats(int statCode, int ctrX, int ctrY, int ctrZ, int startVal, int endVal) {
        double currentVal;
        double max;
        this.volData = new VolumeData(this.allVolManagers[0]);
        int numTimepoints = this.allVolManagers[0].getBaseVolume().getSeriesLength();
        int start = startVal;
        int end = endVal;
        if (start < 1 || start > numTimepoints || end < 1 || end > numTimepoints || start > end) {
            return 0.0;
        }
        --end;
        double min = max = (currentVal = this.volData.getValue(ctrX, ctrY, ctrZ, --start));
        double sum = max;
        double sumSquared = currentVal * currentVal;
        int count = 1;
        for (int ctr = start + 1; ctr <= end; ++ctr) {
            currentVal = this.volData.getValue(ctrX, ctrY, ctrZ, ctr);
            sum += currentVal;
            sumSquared += currentVal * currentVal;
            if (currentVal < min) {
                min = currentVal;
            } else if (currentVal > max) {
                max = currentVal;
            }
            ++count;
        }
        if (statCode == 0) {
            return sum / (double)count;
        }
        if (statCode == 1) {
            return max;
        }
        if (statCode == 2) {
            return min;
        }
        if (statCode == 3) {
            return Math.sqrt(((double)count * sumSquared - sum * sum) / (double)(count * (count - 1)));
        }
        if (statCode == 4) {
            return sum;
        }
        return 0.0;
    }

    private double calculateResult(int ctrX, int ctrY, int ctrZ, int ctrLVal) {
        int ctrL = ctrLVal;
        if (this.operatorCode == '\u0000') {
            if (this.valueIndex != -1) {
                return this.values[this.valueIndex];
            }
            if (this.lutMode) {
                return (double)ctrX / 255.0;
            }
            if (this.numTimepoints == 1) {
                ctrL = 0;
            } else if (ctrL >= this.numTimepoints) {
                return 0.0;
            }
            return this.volData.getValue(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == SPECIAL_CODES[0]) {
            return 0.0;
        }
        if (this.operatorCode == ARITHMETIC_CODES[0]) {
            return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) * this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == ARITHMETIC_CODES[1]) {
            return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) / this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == ARITHMETIC_CODES[2]) {
            return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) + this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == ARITHMETIC_CODES[3]) {
            return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) - this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[0]) {
            return Math.asin(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[1]) {
            return Math.acos(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[2]) {
            return Math.atan(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[3]) {
            return Math.sin(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[4]) {
            return Math.cos(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == TRIG_FUNCTION_CODES[5]) {
            return Math.tan(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[0]) {
            return Math.abs(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[1]) {
            return Math.sqrt(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[2]) {
            return Math.cbrt(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[3]) {
            return Math.exp(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[4]) {
            return Math.log(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[5]) {
            return Math.log10(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == ALGEBRAIC_FUNCTION_CODES[6]) {
            return MathUtilities.pow((double)this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL), (double)this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[0]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE && this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[1]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE ^ this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[2]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE || this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[3]) {
            if (this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE) {
                return Double.MIN_VALUE;
            }
            return Double.MAX_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[4]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE) {
                return this.operation2.getResultAsFirstOperand(ctrX, ctrY, ctrZ, ctrL);
            }
            return this.operation2.getResultAsSecondOperand(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[5]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) >= this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[6]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) <= this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[7]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) > this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[8]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) < this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[9]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) == this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == LOGIC_FUNCTION_CODES[10]) {
            if (this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) != this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL)) {
                return Double.MAX_VALUE;
            }
            return Double.MIN_VALUE;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[0]) {
            int timepoint = (int)this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) - 1;
            if (timepoint >= 0 && timepoint < this.allVolManagers[0].getBaseVolume().getSeriesLength()) {
                return this.volData.getValue(ctrX, ctrY, ctrZ, timepoint);
            }
            return 0.0;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[1]) {
            return ctrX;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[2]) {
            return ctrY;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[3]) {
            return ctrZ;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[4]) {
            return ctrL;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[5]) {
            return Math.max(this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL), this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[6]) {
            return Math.min(this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL), this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[7]) {
            return Math.ceil(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[8]) {
            return Math.floor(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[9]) {
            return Math.round(this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL));
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[10]) {
            return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL) % this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[11]) {
            return this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) == Double.MAX_VALUE ? 1 : 0;
        }
        if (this.operatorCode == MISC_FUNCTION_CODES[12]) {
            double op1 = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double diff = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL) - op1;
            return Math.random() * diff + op1;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[0]) {
            double color = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            Analysis analysis = null;
            if (this.makeStatsHolder) {
                this.makeStatsHolder = false;
                List allUsedROIs = this.allVolManagers[0].getRoiData().getUsedMasks();
                for (ROI allUsedROI : allUsedROIs) {
                    if ((double)((Mask)allUsedROI).getColor() != color) continue;
                    this.roiStatsHolder.put((int)color, allUsedROI.getStats(ctrL));
                }
            }
            if ((analysis = this.roiStatsHolder.get((int)color)) != null) {
                return analysis.getMean();
            }
            return 0.0;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[1]) {
            double color = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            Analysis analysis = null;
            if (this.makeStatsHolder) {
                this.makeStatsHolder = false;
                List allUsedROIs = this.allVolManagers[0].getRoiData().getUsedMasks();
                for (ROI allUsedROI : allUsedROIs) {
                    if ((double)((Mask)allUsedROI).getColor() != color) continue;
                    this.roiStatsHolder.put((int)color, allUsedROI.getStats(ctrL));
                }
            }
            if ((analysis = this.roiStatsHolder.get((int)color)) != null) {
                return analysis.getMaxValue();
            }
            return 0.0;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[2]) {
            double color = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            Analysis analysis = null;
            if (this.makeStatsHolder) {
                this.makeStatsHolder = false;
                List allUsedROIs = this.allVolManagers[0].getRoiData().getUsedMasks();
                for (ROI allUsedROI : allUsedROIs) {
                    if ((double)((Mask)allUsedROI).getColor() != color) continue;
                    this.roiStatsHolder.put((int)color, allUsedROI.getStats(ctrL));
                }
            }
            if ((analysis = this.roiStatsHolder.get((int)color)) != null) {
                return analysis.getMinValue();
            }
            return 0.0;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[3]) {
            double color = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            Analysis analysis = null;
            if (this.makeStatsHolder) {
                this.makeStatsHolder = false;
                List allUsedROIs = this.allVolManagers[0].getRoiData().getUsedMasks();
                for (ROI allUsedROI : allUsedROIs) {
                    if ((double)((Mask)allUsedROI).getColor() != color) continue;
                    this.roiStatsHolder.put((int)color, allUsedROI.getStats(ctrL));
                }
            }
            if ((analysis = this.roiStatsHolder.get((int)color)) != null) {
                return analysis.getStandardDev();
            }
            return 0.0;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[4]) {
            double color = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            Analysis analysis = null;
            if (this.makeStatsHolder) {
                this.makeStatsHolder = false;
                List allUsedROIs = this.allVolManagers[0].getRoiData().getUsedMasks();
                for (ROI allUsedROI : allUsedROIs) {
                    if ((double)((Mask)allUsedROI).getColor() != color) continue;
                    this.roiStatsHolder.put((int)color, allUsedROI.getStats(ctrL));
                }
            }
            if ((analysis = this.roiStatsHolder.get((int)color)) != null) {
                return analysis.getSum();
            }
            return 0.0;
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[5]) {
            double start = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double end = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            return this.doTimeStats(0, ctrX, ctrY, ctrZ, (int)start, (int)end);
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[6]) {
            double start = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double end = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            return this.doTimeStats(1, ctrX, ctrY, ctrZ, (int)start, (int)end);
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[7]) {
            double start = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double end = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            return this.doTimeStats(2, ctrX, ctrY, ctrZ, (int)start, (int)end);
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[8]) {
            double start = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double end = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            return this.doTimeStats(3, ctrX, ctrY, ctrZ, (int)start, (int)end);
        }
        if (this.operatorCode == STATS_FUNCTION_CODES[9]) {
            double start = this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            double end = this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
            return this.doTimeStats(4, ctrX, ctrY, ctrZ, (int)start, (int)end);
        }
        return Double.POSITIVE_INFINITY;
    }

    private double getResultAsFirstOperand(int ctrX, int ctrY, int ctrZ, int ctrL) {
        return this.operation1.calculateResult(ctrX, ctrY, ctrZ, ctrL);
    }

    private double getResultAsSecondOperand(int ctrX, int ctrY, int ctrZ, int ctrL) {
        return this.operation2.calculateResult(ctrX, ctrY, ctrZ, ctrL);
    }

    private void parse(String originalVal) {
        int ctr;
        char currentChar;
        String original = originalVal;
        original = original.trim();
        original = ImageOperationTreeNode.removeSpaces(original);
        int length = (original = ImageOperationTreeNode.trimParentheses(original)).length();
        if (length == 3) {
            currentChar = original.charAt(0);
            if (currentChar == 'n') {
                this.valueIndex = Integer.parseInt(original.substring(original.lastIndexOf(110) + 1));
                return;
            }
            if (currentChar == 'i') {
                if (CollectionUtilities.isNotEmpty((Object)this.allVolManagers)) {
                    int index = Integer.parseInt(original.substring(original.lastIndexOf(105) + 1));
                    this.volume = (Volume)this.allVolManagers[index].getBaseVolume();
                    this.numTimepoints = this.volume.getNumTimepoints();
                    this.volData = new VolumeData(this.allVolManagers[0], this.volume);
                    this.volData.setUsingTransform(this.allVolManagers[index].isVolumeUsingTransform((ImageVolume)this.volume));
                }
                return;
            }
        }
        int stackCtr = 0;
        boolean found = false;
        for (ctr = length - 1; ctr >= 0 && !found; --ctr) {
            currentChar = original.charAt(ctr);
            if (currentChar == ')') {
                ++stackCtr;
                continue;
            }
            if (currentChar == '(') {
                if (--stackCtr != 0) continue;
                this.operandString2 = original.substring(ctr, length);
                found = true;
                continue;
            }
            if (currentChar != 'i' && currentChar != 'n' || stackCtr != 0) continue;
            this.operandString2 = original.substring(ctr, ctr + 3);
            found = true;
        }
        found = false;
        while (ctr >= 0 && !found) {
            int ctrOp;
            currentChar = original.charAt(ctr);
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < ARITHMETIC_CODES.length; ++ctrOp) {
                if (currentChar != ARITHMETIC_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < TRIG_FUNCTION_CODES.length; ++ctrOp) {
                if (currentChar != TRIG_FUNCTION_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < STATS_FUNCTION_CODES.length; ++ctrOp) {
                if (currentChar != STATS_FUNCTION_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < ALGEBRAIC_FUNCTION_CODES.length; ++ctrOp) {
                if (currentChar != ALGEBRAIC_FUNCTION_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < LOGIC_FUNCTION_CODES.length; ++ctrOp) {
                if (currentChar != LOGIC_FUNCTION_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            for (ctrOp = 0; this.operatorCode == '\u0000' && ctrOp < MISC_FUNCTION_CODES.length; ++ctrOp) {
                if (currentChar != MISC_FUNCTION_CODES[ctrOp]) continue;
                this.operatorCode = currentChar;
            }
            if (currentChar == SPECIAL_CODES[0]) {
                this.operatorCode = currentChar;
            }
            if (this.operatorCode != '\u0000') {
                found = true;
            }
            --ctr;
        }
        found = false;
        int firstOperandEndMark = ctr;
        while (ctr >= 0 && !found) {
            currentChar = original.charAt(ctr);
            if (currentChar == ')') {
                ++stackCtr;
            } else if (currentChar == '(') {
                if (--stackCtr == 0) {
                    this.operandString1 = original.substring(ctr, firstOperandEndMark + 1);
                    found = true;
                }
            } else if ((currentChar == 'i' || currentChar == 'n') && stackCtr == 0) {
                this.operandString2 = original.substring(ctr, ctr + 3);
                found = true;
            }
            --ctr;
        }
    }

    public void setROIStatsHolder(Map<Integer, Analysis> map) {
        this.roiStatsHolder = map;
        if (this.operation1 != null) {
            this.operation1.setROIStatsHolder(this.roiStatsHolder);
        }
        if (this.operation2 != null) {
            this.operation2.setROIStatsHolder(this.roiStatsHolder);
        }
    }

    public void setMakeROIStatsHolder() {
        this.makeStatsHolder = true;
        if (this.operation1 != null) {
            this.operation1.setMakeROIStatsHolder();
        }
        if (this.operation2 != null) {
            this.operation2.setMakeROIStatsHolder();
        }
    }

    public Map<Integer, Analysis> getROIStatsHolder() {
        return this.roiStatsHolder;
    }

    public Map<Integer, Analysis> makeROIStatsHolder() {
        this.setMakeROIStatsHolder();
        this.setROIStatsHolder(new HashMap<Integer, Analysis>());
        if (this.operation1 != null) {
            this.operation1.setROIStatsHolder(this.roiStatsHolder);
        }
        if (this.operation2 != null) {
            this.operation2.setROIStatsHolder(this.roiStatsHolder);
        }
        return this.roiStatsHolder;
    }
}

