/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.calculation;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;

public class ImageCalcExpressionImpl
implements ImageCalcExpression {
    private final String expression;
    private final VolumeManager originatingManager;
    private ImageOperationTreeNode node;
    private final boolean allSeriesPoints;
    private final boolean onlyROISlices;
    private final int areaSelection;
    private final int seriesEnd;
    private final int seriesStart;
    private final int seriesStep;
    private final int seriesTypeSelection;
    private final int type;
    private final int sliceDirection;
    private final int sliceNumber;

    public ImageCalcExpressionImpl(String expression, VolumeManager originatingManager, int areaSelection, boolean allSeriesPoints, boolean onlyROISlices) {
        this(expression, originatingManager, -1, -1, areaSelection, allSeriesPoints, onlyROISlices);
    }

    public ImageCalcExpressionImpl(String expression, VolumeManager originatingManager, int sliceDirection, int sliceNumber, int areaSelection, boolean allSeriesPoints, boolean onlyROISlices) {
        this.expression = expression;
        this.originatingManager = originatingManager;
        this.areaSelection = areaSelection;
        this.allSeriesPoints = allSeriesPoints;
        this.onlyROISlices = onlyROISlices;
        this.type = 0;
        this.sliceDirection = sliceDirection;
        this.sliceNumber = sliceNumber;
        this.seriesStart = -1;
        this.seriesEnd = -1;
        this.seriesTypeSelection = -1;
        this.seriesStep = -1;
    }

    public ImageCalcExpressionImpl(VolumeManager originatingManager, int seriesStart, int seriesEnd, int seriesStep, int seriesTypeSelection) {
        this.originatingManager = originatingManager;
        this.seriesTypeSelection = seriesTypeSelection;
        this.seriesStart = seriesStart;
        this.seriesEnd = seriesEnd;
        this.seriesStep = seriesStep;
        this.type = 1;
        this.onlyROISlices = false;
        this.allSeriesPoints = false;
        this.areaSelection = -1;
        this.expression = null;
        this.sliceDirection = -1;
        this.sliceNumber = -1;
    }

    @Override
    public int getAreaSelection() {
        return this.areaSelection;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public VolumeManager getOriginatingManager() {
        return this.originatingManager;
    }

    @Override
    public int getSeriesEnd() {
        return this.seriesEnd;
    }

    @Override
    public int getSeriesStart() {
        return this.seriesStart;
    }

    @Override
    public int getSeriesStep() {
        return this.seriesStep;
    }

    @Override
    public int getSeriesType() {
        return this.seriesTypeSelection;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isAllSeriesPoints() {
        return this.allSeriesPoints;
    }

    @Override
    public boolean isOnlyROISlices() {
        return this.onlyROISlices;
    }

    @Override
    public int getSliceDirection() {
        return this.sliceDirection;
    }

    @Override
    public int getSliceNumber() {
        return this.sliceNumber;
    }

    public ImageOperationTreeNode getNode() {
        return this.node;
    }

    public void setNode(ImageOperationTreeNode node) {
        this.node = node;
    }
}

