/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.calculation;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class CalcSeriesOp {
    private final VolumeManager volumeManager;
    private final VolumeListener listener;

    public CalcSeriesOp(VolumeManager volumeManager, VolumeListener listener) {
        this.volumeManager = volumeManager;
        this.listener = listener;
    }

    public void processOperationSeriesStat(final ImageCalcExpression op) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CalcSeriesOp.this.runOperationSeriesStat(op);
            }
        }, "CalcOp.processOperationSeriesStat() Thread");
        workThread.start();
    }

    public void runOperationSeriesStat(ImageCalcExpression op) {
        Volume volume = (Volume)this.volumeManager.getBaseVolume();
        Volume fromVol = (Volume)op.getOriginatingManager().getBaseVolume();
        int startT = op.getSeriesStart();
        int endT = op.getSeriesEnd();
        int groupByF = op.getSeriesStep();
        int opType = op.getSeriesType();
        volume.setImageDirty(true);
        volume.setOperationInProgress(true);
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Image");
        boolean isMean = opType == 1;
        boolean isMax = opType == 2;
        boolean isMin = opType == 3;
        boolean isSum = opType == 0;
        boolean isStdev = opType == 4;
        ImageDimensions id = volume.getImageDimensions();
        float[] floatBuffer = new float[id.getNumVoxelsSlice()];
        double[] doubleBuffer = new double[floatBuffer.length];
        double[] doubleBuffer2 = null;
        if (isStdev) {
            doubleBuffer2 = new double[floatBuffer.length];
        }
        int slices = id.getSlices();
        int sliceSize = id.getNumVoxelsSlice();
        int offsetSlice = 0;
        int offset = 0;
        int groupBy = groupByF;
        int timeStart = Math.max(startT, 0);
        int timeEnd = Math.min(endT, fromVol.getNumTimepoints() - 1);
        if (groupBy > fromVol.getNumTimepoints()) {
            groupBy = fromVol.getNumTimepoints();
        }
        int timepoints = (timeEnd - timeStart + 1) / groupBy * groupBy;
        ByteBuffer[] fromBuffers = fromVol.getWorkBuffers();
        ByteBuffer[] toBuffers = volume.getWorkBuffers();
        pb.start(0, 0, slices);
        for (int ctr = 0; ctr < slices; ++ctr) {
            offsetSlice = ctr * sliceSize;
            for (int ctrT = timeStart; ctrT <= timeEnd; ++ctrT) {
                int ctrS;
                FloatBuffer fromWorkBuffer = ((ByteBuffer)fromBuffers[ctrT].rewind()).asFloatBuffer();
                offset = offsetSlice;
                fromWorkBuffer.position(offset);
                fromWorkBuffer.get(floatBuffer);
                if ((ctrT - timeStart) % groupBy == 0) {
                    if (isStdev) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            double temp;
                            doubleBuffer[ctrS] = temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            doubleBuffer2[ctrS] = temp * temp;
                        }
                    } else {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            doubleBuffer[ctrS] = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                        }
                    }
                } else if ((ctrT - timeStart + 1) % groupBy == 0) {
                    if (isMean) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            int n = ctrS;
                            doubleBuffer[n] = doubleBuffer[n] + fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            floatBuffer[ctrS] = (float)(doubleBuffer[ctrS] / (double)groupBy);
                        }
                    } else if (isMax) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            if (temp > doubleBuffer[ctrS]) {
                                doubleBuffer[ctrS] = temp;
                            }
                            floatBuffer[ctrS] = (float)doubleBuffer[ctrS];
                        }
                    } else if (isMin) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            if (temp < doubleBuffer[ctrS]) {
                                doubleBuffer[ctrS] = temp;
                            }
                            floatBuffer[ctrS] = (float)doubleBuffer[ctrS];
                        }
                    } else if (isSum) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            int n = ctrS;
                            doubleBuffer[n] = doubleBuffer[n] + fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            floatBuffer[ctrS] = (float)doubleBuffer[ctrS];
                        }
                    } else if (isStdev) {
                        for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                            double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                            int n = ctrS;
                            doubleBuffer[n] = doubleBuffer[n] + temp;
                            int n2 = ctrS;
                            doubleBuffer2[n2] = doubleBuffer2[n2] + temp * temp;
                            temp = Math.sqrt(((double)timepoints * doubleBuffer2[ctrS] - doubleBuffer[ctrS] * doubleBuffer[ctrS]) / (double)(groupBy * (groupBy - 1)));
                            floatBuffer[ctrS] = (float)temp;
                        }
                    }
                    int toIndex = (ctrT - timeStart + 1) / groupBy - 1;
                    FloatBuffer toWorkBuffer = ((ByteBuffer)toBuffers[toIndex].rewind()).asFloatBuffer();
                    toWorkBuffer.position(offsetSlice);
                    toWorkBuffer.put(floatBuffer);
                } else if (isMean || isSum) {
                    for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                        int n = ctrS;
                        doubleBuffer[n] = doubleBuffer[n] + fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                    }
                } else if (isMax) {
                    for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                        double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                        if (!(temp > doubleBuffer[ctrS])) continue;
                        doubleBuffer[ctrS] = temp;
                    }
                } else if (isMin) {
                    for (ctrS = 0; ctrS < sliceSize; ++ctrS) {
                        double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                        if (!(temp < doubleBuffer[ctrS])) continue;
                        doubleBuffer[ctrS] = temp;
                    }
                } else if (isStdev) {
                    ctrS = 0;
                    while (ctrS < sliceSize) {
                        double temp = fromVol.applyDataScale(offsetSlice + ctrS, ctrT, floatBuffer[ctrS]);
                        int n = ctrS;
                        doubleBuffer[n] = doubleBuffer[n] + temp;
                        int n3 = ctrS++;
                        doubleBuffer2[n3] = doubleBuffer2[n3] + temp * temp;
                    }
                }
                pb.setValue(ctr);
            }
        }
        pb.setValue(pb.getMax());
        volume.setOperationInProgress(false);
        this.listener.volumeChanged();
        this.listener.volumeOperationCompleted(true, volume);
    }
}

