/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.OperationThread;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class OperationBuilder<T> {
    private ProgressMeter progressBar;
    private Volume volumeCurrent;
    private final List<T> results;
    private final Operation<T> runner;
    private final VolumeManager volumeManager;
    private final int numProcessors;
    private final int[] numProcessesPerThread;
    public static final int OCTANTS_MAX_THREADS = 8;
    public static final int OCTANTS_NUM = 8;

    public OperationBuilder(VolumeManager volumeManager, Operation<T> runner) {
        this.volumeManager = volumeManager;
        this.runner = runner;
        Volume volumeBase = (Volume)volumeManager.getBaseVolume();
        this.volumeCurrent = (Volume)volumeManager.getCurrentVolume();
        if (this.volumeCurrent == null) {
            this.volumeCurrent = volumeBase;
        }
        int numProcessorsTotal = Platform.PROCESSOR_COUNT;
        this.numProcessors = Math.min(numProcessorsTotal, 8);
        this.numProcessesPerThread = new int[this.numProcessors];
        this.results = new ArrayList<T>();
        for (int ctr = 0; ctr < 8; ++ctr) {
            int n = ctr % this.numProcessesPerThread.length;
            this.numProcessesPerThread[n] = this.numProcessesPerThread[n] + 1;
        }
    }

    public Volume getVolume() {
        return this.volumeCurrent;
    }

    public void runAsynchronously(final OperationListener listener) {
        if (!this.runner.testProcessValidity()) {
            this.volumeManager.showErrorMessage("Operation could not run!", "Operation Error");
        } else {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    OperationBuilder.this.start();
                    listener.operationFinished(OperationBuilder.this.runner.accumulate(OperationBuilder.this.results), OperationBuilder.this.volumeCurrent);
                }
            }, "OctantOpBuilder.runAsynchronously() Thread");
            workThread.start();
        }
    }

    public T runSynchronously() {
        if (this.runner.testProcessValidity()) {
            this.start();
            return this.runner.accumulate(this.results);
        }
        this.volumeManager.showErrorMessage("Operation could not run!", "Operation Error");
        return null;
    }

    protected synchronized void addResult(T result) {
        if (result != null) {
            this.results.add(result);
        }
    }

    private void finishProgress() {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationBuilder.this.progressBar.setValue(OperationBuilder.this.progressBar.getMax());
                    OperationBuilder.this.progressBar.setIndeterminateMode(false);
                }
            });
        }
    }

    private void start() {
        int processIndex = 0;
        ArrayList<OperationThread<T>> threadList = new ArrayList<OperationThread<T>>();
        this.startProgress();
        if (this.numProcessors == 1) {
            ImageBounds bounds = this.runner.getSectionBounds(0);
            ImageBounds imageBounds = this.getVolumeBounds();
            bounds.setRangeX(imageBounds.getMinX(), imageBounds.getMaxX());
            bounds.setRangeY(imageBounds.getMinY(), imageBounds.getMaxY());
            bounds.setRangeZ(imageBounds.getMinZ(), imageBounds.getMaxZ());
            this.addResult(this.runner.process(bounds));
        } else {
            for (int ctr = 0; ctr < this.numProcessors; ++ctr) {
                int[] nArray = new int[this.numProcessesPerThread[ctr]];
                for (int ctrP = 0; ctrP < nArray.length; ++ctrP) {
                    nArray[ctrP] = processIndex++;
                }
                OperationThread<T> workThread = new OperationThread<T>(this, this.runner, nArray);
                threadList.add(workThread);
                workThread.start();
            }
            for (OperationThread operationThread : threadList) {
                try {
                    operationThread.join();
                }
                catch (InterruptedException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }
        this.finishProgress();
    }

    private void startProgress() {
        if (this.volumeManager != null) {
            this.progressBar = this.volumeManager.makeProgressMeter();
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    OperationBuilder.this.progressBar.setDescription("Calculating...");
                    OperationBuilder.this.progressBar.start(0, 0, 100, true);
                    OperationBuilder.this.progressBar.setIndeterminateMode(true);
                }
            });
        }
    }

    private ImageBounds getVolumeBounds() {
        int zDim;
        int yDim;
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        ImageBounds bounds = new ImageBounds(0, xDim - 1, 0, (yDim = volumeBase.getYDim()) - 1, 0, (zDim = volumeBase.getZDim()) - 1);
        if (bounds != null) {
            bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
        }
        return bounds;
    }
}

