/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.tiff;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.tiff.IFD;
import edu.uthscsa.ric.volume.formats.tiff.Tag;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class TIFF
implements ReadableHeader,
Cloneable {
    private File headerFile;
    private IFD firstIFD;
    private boolean isLittleEndian;
    private boolean isTiled;
    private int numBytesRow;
    private int numBytesSlice;
    private int numBytesTotal;
    private int numBytesVoxel;
    private int numSlices;
    private int[] blockOffsets;
    private int[] blockSums;
    private final Vector<IFD> allIFDs = new Vector();
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("YYYY:MM:DD HH:MM:SS");
    private static final byte[] MACIC_NUMBER_LITTLE = new byte[]{73, 73, 42, 0};
    private static final byte[] MAGIC_NUMBER_BIG = new byte[]{77, 77, 0, 42};
    public static final String EXT = "tiff";
    public static final String MIN_MANGO_SUPPORTED = "3.1";
    public static final String NAME = "TIFF";
    public static final String PLUGIN_URL = "http://ric.uthscsa.edu/mango/plugin_tiff.html";
    public static final String VERSION = "0.3.1";
    public static final int IFD_HEADER_SIZE = 2;
    public static final int IFD_NEXT_OFFSET_SIZE = 4;
    public static final int RES_CODE_CM = 3;
    public static final int RES_CODE_INCH = 2;
    public static final int TAG_SIZE = 12;
    public static final int TOP_HEADER_SIZE = 8;
    public static final short TAG_TYPE_ASCII = 2;
    public static final short TAG_TYPE_BYTE = 6;
    public static final short TAG_TYPE_DOUBLE = 12;
    public static final short TAG_TYPE_FLOAT = 11;
    public static final short TAG_TYPE_INT = 9;
    public static final short TAG_TYPE_RATIONAL = 10;
    public static final short TAG_TYPE_SHORT = 8;
    public static final short TAG_TYPE_UNDEFINED = 7;
    public static final short TAG_TYPE_UNSIGNED_BYTE = 1;
    public static final short TAG_TYPE_UNSIGNED_INT = 4;
    public static final short TAG_TYPE_UNSIGNED_RATIONAL = 5;
    public static final short TAG_TYPE_UNSIGNED_SHORT = 3;
    static final String[] TAG_TYPE_NAMES = new String[16];
    static final String[] TIFF_TAG_NAMES = new String[512];

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public int getFirstOffset() {
        int min = this.blockOffsets[0];
        for (int ctr = 1; ctr < this.blockOffsets.length; ++ctr) {
            if (this.blockOffsets[ctr] >= min) continue;
            min = this.blockOffsets[ctr];
        }
        return min;
    }

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        String dateStr = this.firstIFD.getDateTime();
        Date date = null;
        if (StringUtils.isNotBlank((CharSequence)dateStr)) {
            try {
                date = this.DATE_FORMAT.parse(dateStr);
            }
            catch (ParseException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        ImageDescription id = new ImageDescription(this.firstIFD.getDocumentInfo(), this.firstIFD.getMakeModel(), date, this.firstIFD.getDescription());
        id.setFile(this.headerFile.toURI());
        return id;
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions id = new ImageDimensions(this.firstIFD.getImageWidth(), this.firstIFD.getImageHeight(), this.numSlices, 1);
        id.setImageOffset(this.getFirstOffset());
        return id;
    }

    public URI getImageFile() {
        return this.headerFile.toURI();
    }

    public ImageRange getImageRange() {
        ImageRange ir = new ImageRange(0.0, 0.0, 0.0, 0.0);
        ir.setGlobalDataScaleSlope(this.numSlices, 1.0f);
        ir.setGlobalDataScaleIntercept(this.numSlices, 0.0f);
        return ir;
    }

    public ImageType getImageType() {
        ImageType it = null;
        try {
            int numBytes = this.firstIFD.getNumBytes();
            int numBitsStored = this.firstIFD.getNumBitsStored();
            boolean isRGB = this.firstIFD.isRGB();
            int byteType = isRGB ? 6 : 3;
            it = new ImageType(numBytes, byteType, numBitsStored, this.isLittleEndian);
            it.setRGBMode(isRGB);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        return it;
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOrientation() {
        return "XYZ+--";
    }

    public int getOrientationCertainty() {
        int code = this.firstIFD.getOrientationCode();
        int certainty = 0;
        if (code > 0) {
            ++certainty;
        }
        if (this.numSlices == 1) {
            ++certainty;
        }
        return certainty;
    }

    public Coordinate getOrigin() {
        return new Coordinate();
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        try {
            return new URL(PLUGIN_URL);
        }
        catch (MalformedURLException ex) {
            AppLogger.warn((Throwable)ex);
            return null;
        }
    }

    public String getPreferredFileExtension() {
        return EXT;
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return VERSION;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = new VoxelDimensions(this.firstIFD.getVoxelSizeX(), this.firstIFD.getVoxelSizeY(), 1.0, 1.0);
        vd.setSpatialUnit(this.firstIFD.getSpatialUnit());
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isContiguous() {
        boolean isContiguous = true;
        if (this.blockOffsets.length > 1) {
            int firstOffset = this.getFirstOffset();
            for (int ctr = 0; ctr < this.blockOffsets.length && isContiguous; ++ctr) {
                if (this.blockOffsets[ctr] - firstOffset == this.blockSums[ctr]) continue;
                isContiguous = false;
            }
            if (this.firstIFD.isTiled()) {
                if (this.firstIFD.getTileWidth() != this.firstIFD.getImageWidth()) {
                    isContiguous = false;
                }
                if (this.firstIFD.getTileHeight() != this.firstIFD.getImageHeight()) {
                    isContiguous = false;
                }
            }
        }
        return isContiguous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        RandomAccessFile fileReader = null;
        boolean isFormat = false;
        try {
            fileReader = new RandomAccessFile(file, "r");
            byte[] topHeaderArray = new byte[8];
            int bytesRead = fileReader.read(topHeaderArray);
            if (bytesRead >= 4 && (topHeaderArray[0] == MACIC_NUMBER_LITTLE[0] && topHeaderArray[1] == MACIC_NUMBER_LITTLE[1] && topHeaderArray[2] == MACIC_NUMBER_LITTLE[2] && topHeaderArray[3] == MACIC_NUMBER_LITTLE[3] || topHeaderArray[0] == MAGIC_NUMBER_BIG[0] && topHeaderArray[1] == MAGIC_NUMBER_BIG[1] && topHeaderArray[2] == MAGIC_NUMBER_BIG[2] && topHeaderArray[3] == MAGIC_NUMBER_BIG[3])) {
                isFormat = true;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return isFormat;
    }

    public boolean isTiled() {
        return this.isTiled;
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.clear();
        RandomAccessFile fileReader = null;
        ByteBuffer byteBuffer = null;
        this.headerFile = file;
        try {
            IFD ifd;
            fileReader = new RandomAccessFile(file, "r");
            byte[] topHeaderArray = new byte[8];
            fileReader.readFully(topHeaderArray);
            if (topHeaderArray[0] == MACIC_NUMBER_LITTLE[0] && topHeaderArray[1] == MACIC_NUMBER_LITTLE[1] && topHeaderArray[2] == MACIC_NUMBER_LITTLE[2] && topHeaderArray[3] == MACIC_NUMBER_LITTLE[3]) {
                this.isLittleEndian = true;
            }
            byteBuffer = ByteBuffer.wrap(topHeaderArray);
            if (this.isLittleEndian) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            long offsetToFirstIFD = (long)byteBuffer.getInt(4) & 0xFFFFFFFFL;
            this.firstIFD = ifd = this.readIFD(fileReader, offsetToFirstIFD);
            while (ifd.getNextOffset() != 0L) {
                this.allIFDs.add(ifd);
                ifd = this.readIFD(fileReader, ifd.getNextOffset());
            }
            this.allIFDs.add(ifd);
            this.numBytesTotal = this.firstIFD.getTotalBytes();
            this.numBytesVoxel = this.firstIFD.getNumBytes();
            this.numBytesRow = this.firstIFD.getImageWidth() * this.numBytesVoxel;
            this.numBytesSlice = this.numBytesRow * this.firstIFD.getImageHeight();
            this.numSlices = this.numBytesTotal / this.numBytesSlice;
            this.blockSums = this.firstIFD.getBlockSums();
            this.blockOffsets = this.firstIFD.getBlockOffsets();
            if (this.firstIFD.isUsingCompression()) {
                throw new InvalidHeaderException("TIFF reader does not support compression.");
            }
            if (!this.isContiguous()) {
                throw new InvalidHeaderException("TIFF reader does not support non-contiguous data.");
            }
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.readHeader(new File(uri), tempDir);
    }

    public String toString() {
        String string = "";
        if (this.firstIFD != null) {
            string = string + this.firstIFD.toString();
        }
        return string;
    }

    private void clear() {
        this.headerFile = null;
        this.allIFDs.clear();
        this.firstIFD = null;
        this.blockOffsets = null;
        this.blockSums = null;
        this.numSlices = 0;
        this.numBytesVoxel = 0;
        this.numBytesRow = 0;
        this.numBytesSlice = 0;
        this.numBytesTotal = 0;
        this.isTiled = false;
        this.isLittleEndian = false;
    }

    private IFD readIFD(RandomAccessFile fileReader, long offset) throws IOException {
        fileReader.seek(offset);
        byte[] numTagsArray = new byte[2];
        fileReader.readFully(numTagsArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(numTagsArray);
        if (this.isLittleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        int numTags = byteBuffer.getShort(0) & 0xFFFF;
        Tag[] tags = new Tag[numTags];
        fileReader.seek(offset + 2L + (long)(numTags * 12));
        byte[] offsetNext = new byte[4];
        fileReader.readFully(offsetNext);
        byteBuffer = ByteBuffer.wrap(offsetNext);
        if (this.isLittleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        int offsetOfNextIFD = byteBuffer.getInt();
        for (int ctr = 0; ctr < numTags; ++ctr) {
            tags[ctr] = this.readTag(fileReader, offset + 2L + (long)(ctr * 12));
        }
        return new IFD(offset, tags, offsetOfNextIFD);
    }

    private Tag readTag(RandomAccessFile fileReader, long offset) throws IOException {
        fileReader.seek(offset);
        byte[] tagArray = new byte[12];
        fileReader.readFully(tagArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(tagArray);
        if (this.isLittleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        int code = byteBuffer.getShort(0) & 0xFFFF;
        int type = byteBuffer.getShort(2) & 0xFFFF;
        long numValues = (long)byteBuffer.getInt(4) & 0xFFFFFFFFL;
        byte[] data = new byte[]{byteBuffer.get(8), byteBuffer.get(9), byteBuffer.get(10), byteBuffer.get(11)};
        Object object = Tag.getData(code, type, (int)numValues, data, this.isLittleEndian, fileReader);
        return new Tag(code, type, numValues, object);
    }

    static {
        TIFF.TIFF_TAG_NAMES[254] = "NewSubfileType";
        TIFF.TIFF_TAG_NAMES[255] = "SubfileType";
        TIFF.TIFF_TAG_NAMES[256] = "ImageWidth";
        TIFF.TIFF_TAG_NAMES[257] = "ImageLength";
        TIFF.TIFF_TAG_NAMES[258] = "BitsPerSample";
        TIFF.TIFF_TAG_NAMES[259] = "Compression";
        TIFF.TIFF_TAG_NAMES[262] = "PhotometricInterpretation";
        TIFF.TIFF_TAG_NAMES[263] = "Threshholding";
        TIFF.TIFF_TAG_NAMES[264] = "CellWidth";
        TIFF.TIFF_TAG_NAMES[265] = "CellLength";
        TIFF.TIFF_TAG_NAMES[266] = "FillOrder";
        TIFF.TIFF_TAG_NAMES[270] = "ImageDescription";
        TIFF.TIFF_TAG_NAMES[271] = "Make";
        TIFF.TIFF_TAG_NAMES[272] = "Model";
        TIFF.TIFF_TAG_NAMES[273] = "StripOffsets";
        TIFF.TIFF_TAG_NAMES[274] = "Orientation";
        TIFF.TIFF_TAG_NAMES[277] = "SamplesPerPixel";
        TIFF.TIFF_TAG_NAMES[278] = "RowsPerStrip";
        TIFF.TIFF_TAG_NAMES[279] = "StripByteCounts";
        TIFF.TIFF_TAG_NAMES[280] = "MinSampleValue";
        TIFF.TIFF_TAG_NAMES[281] = "MaxSampleValue";
        TIFF.TIFF_TAG_NAMES[282] = "XResolution";
        TIFF.TIFF_TAG_NAMES[283] = "YResolution";
        TIFF.TIFF_TAG_NAMES[284] = "PlanarConfiguration";
        TIFF.TIFF_TAG_NAMES[288] = "FreeOffsets";
        TIFF.TIFF_TAG_NAMES[289] = "FreeByteCounts";
        TIFF.TIFF_TAG_NAMES[290] = "GrayResponseUnit";
        TIFF.TIFF_TAG_NAMES[291] = "GrayResponseCurve";
        TIFF.TIFF_TAG_NAMES[296] = "ResolutionUnit";
        TIFF.TIFF_TAG_NAMES[305] = "Software";
        TIFF.TIFF_TAG_NAMES[306] = "DateTime";
        TIFF.TIFF_TAG_NAMES[315] = "Artist";
        TIFF.TIFF_TAG_NAMES[316] = "HostComputer";
        TIFF.TIFF_TAG_NAMES[320] = "ColorMap";
        TIFF.TIFF_TAG_NAMES[338] = "ExtraSamples";
        TIFF.TIFF_TAG_NAMES[269] = "DocumentName";
        TIFF.TIFF_TAG_NAMES[285] = "PageName";
        TIFF.TIFF_TAG_NAMES[286] = "XPosition";
        TIFF.TIFF_TAG_NAMES[287] = "YPosition";
        TIFF.TIFF_TAG_NAMES[292] = "T4Options";
        TIFF.TIFF_TAG_NAMES[293] = "T6Options";
        TIFF.TIFF_TAG_NAMES[297] = "PageNumber";
        TIFF.TIFF_TAG_NAMES[301] = "TransferFunction";
        TIFF.TIFF_TAG_NAMES[317] = "Predictor";
        TIFF.TIFF_TAG_NAMES[318] = "WhitePoint";
        TIFF.TIFF_TAG_NAMES[319] = "PrimaryChromaticities";
        TIFF.TIFF_TAG_NAMES[321] = "HalftoneHints";
        TIFF.TIFF_TAG_NAMES[322] = "TileWidth";
        TIFF.TIFF_TAG_NAMES[323] = "TileLength";
        TIFF.TIFF_TAG_NAMES[324] = "TileOffsets";
        TIFF.TIFF_TAG_NAMES[325] = "TileByteCounts";
        TIFF.TIFF_TAG_NAMES[326] = "BadFaxLines";
        TIFF.TIFF_TAG_NAMES[327] = "CleanFaxData";
        TIFF.TIFF_TAG_NAMES[328] = "ConsecutiveBadFaxLines";
        TIFF.TIFF_TAG_NAMES[330] = "SubIFDs";
        TIFF.TIFF_TAG_NAMES[332] = "InkSet";
        TIFF.TIFF_TAG_NAMES[333] = "InkNames";
        TIFF.TIFF_TAG_NAMES[334] = "NumberOfInks";
        TIFF.TIFF_TAG_NAMES[336] = "DotRange";
        TIFF.TIFF_TAG_NAMES[337] = "TargetPrinter";
        TIFF.TIFF_TAG_NAMES[339] = "SampleFormat";
        TIFF.TIFF_TAG_NAMES[340] = "SMinSampleValue";
        TIFF.TIFF_TAG_NAMES[341] = "SMaxSampleValue";
        TIFF.TIFF_TAG_NAMES[342] = "TransferRange";
        TIFF.TIFF_TAG_NAMES[343] = "ClipPath";
        TIFF.TIFF_TAG_NAMES[344] = "XClipPathUnits";
        TIFF.TIFF_TAG_NAMES[345] = "YClipPathUnits";
        TIFF.TIFF_TAG_NAMES[346] = "Indexed";
        TIFF.TIFF_TAG_NAMES[347] = "JPEGTables";
        TIFF.TIFF_TAG_NAMES[351] = "OPIProxy";
        TIFF.TIFF_TAG_NAMES[400] = "GlobalParametersIFD";
        TIFF.TIFF_TAG_NAMES[401] = "ProfileType";
        TIFF.TIFF_TAG_NAMES[402] = "FaxProfile";
        TIFF.TIFF_TAG_NAMES[403] = "CodingMethods";
        TIFF.TIFF_TAG_NAMES[404] = "VersionYear";
        TIFF.TIFF_TAG_NAMES[405] = "ModeNumber";
        TIFF.TIFF_TAG_NAMES[433] = "Decode";
        TIFF.TIFF_TAG_NAMES[434] = "DefaultImageColor";
        TIFF.TAG_TYPE_NAMES[0] = "Unknown";
        TIFF.TAG_TYPE_NAMES[1] = "Unsigned Byte";
        TIFF.TAG_TYPE_NAMES[2] = "ASCII";
        TIFF.TAG_TYPE_NAMES[3] = "Unsigned 2-Byte";
        TIFF.TAG_TYPE_NAMES[4] = "Unsigned 4-Byte";
        TIFF.TAG_TYPE_NAMES[5] = "Unsigned Rational";
        TIFF.TAG_TYPE_NAMES[6] = "Byte";
        TIFF.TAG_TYPE_NAMES[7] = "Undefined";
        TIFF.TAG_TYPE_NAMES[8] = "2-Byte";
        TIFF.TAG_TYPE_NAMES[9] = "4-Byte";
        TIFF.TAG_TYPE_NAMES[10] = "Rational";
        TIFF.TAG_TYPE_NAMES[11] = "Float 4-Byte";
        TIFF.TAG_TYPE_NAMES[12] = "Float 8-Byte";
    }
}

