/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.stimulate;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;

public class Stimulate
implements EditableHeader,
WritableHeader {
    private File headerFile;
    private String byteOrder;
    private String datatype;
    private String fidName;
    private String header;
    private String orientation;
    private Vector<Double> displayRange;
    private Vector<Double> fov;
    private Vector<Double> origin;
    private Vector<Double> voxelDims;
    private Vector<Integer> imageDims;
    private double dataScale;
    private int numDims;
    private final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("0.000000");
    public static final List<String> VALID_ORIENTATIONS = CollectionUtilities.immutable((String[])new String[]{"XYZ---", "XZY---", "YZX---"});
    public static final String EXTENSION_HEADER = ".spr";
    public static final String EXTENSION_IMAGE = ".sdt";
    public static final String KEY_BYTE_ORDER = "endian";
    public static final String KEY_DATATYPE = "dataType";
    public static final String KEY_DATA_SCALE = "Real2WordScale";
    public static final String KEY_DISPLAY_RANGE = "displayRange";
    public static final String KEY_EXTENT = "extent";
    public static final String KEY_FID_NAME = "fidName";
    public static final String KEY_FOV = "fov";
    public static final String KEY_IMAGE_DIMS = "dim";
    public static final String KEY_NUM_DIMS = "numDim";
    public static final String KEY_ORIENTATION = "sdtOrient";
    public static final String KEY_ORIGIN = "origin";
    public static final String KEY_VOXEL_DIMS = "interval";
    public static final String NAME = "Stimulate";
    public static final String VALUE_BYTE_ORDER_BIG = "ieee-be";
    public static final String VALUE_BYTE_ORDER_LITTLE = "ieee-le";
    public static final String VALUE_DATATYPE_BYTE = "BTYE";
    public static final String VALUE_DATATYPE_DOUBLE = "COMPLEX";
    public static final String VALUE_DATATYPE_FLOAT = "REAL";
    public static final String VALUE_DATATYPE_INT = "LWORD";
    public static final String VALUE_DATATYPE_SHORT = "WORD";
    public static final String VALUE_ORIENTATION_AXIAL = "ax";
    public static final String VALUE_ORIENTATION_CORONAL = "cor";
    public static final String VALUE_ORIENTATION_SAGITTAL = "sag";

    public boolean canCompress() {
        return false;
    }

    public File formatImageFile(File headerFile) {
        String filename = headerFile.getName();
        filename = filename.substring(0, filename.lastIndexOf(46)) + EXTENSION_IMAGE;
        return new File(headerFile.getParent(), filename);
    }

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        String des = "";
        if (this.fidName != null) {
            des = des + this.fidName;
        }
        ImageDescription id = new ImageDescription("", "", null, des);
        id.setFile(this.headerFile.toURI());
        return id;
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions id = null;
        if (this.numDims >= 2) {
            int cols = this.imageDims.get(0);
            int rows = this.imageDims.get(1);
            int slices = 1;
            int timepoints = 1;
            if (this.numDims >= 3) {
                slices = this.imageDims.get(2);
                if (this.numDims >= 4) {
                    timepoints = this.imageDims.get(3);
                }
            }
            id = new ImageDimensions(cols, rows, slices, timepoints);
        }
        return id;
    }

    public URI getImageFile() {
        String filename = this.headerFile.getName();
        filename = filename.substring(0, filename.lastIndexOf(46)) + EXTENSION_IMAGE;
        return new File(this.headerFile.getParent(), filename).toURI();
    }

    public ImageRange getImageRange() {
        double min = 0.0;
        double max = 0.0;
        if (this.displayRange != null && this.displayRange.size() == 2) {
            min = this.displayRange.get(0);
            max = this.displayRange.get(1);
        }
        ImageRange ir = new ImageRange(0.0, 0.0, min, max);
        int numSlices = 1;
        if (this.numDims > 2) {
            numSlices = this.imageDims.get(2);
            if (this.numDims > 3) {
                numSlices *= this.imageDims.get(3).intValue();
            }
        }
        if (this.dataScale != 0.0) {
            ir.setGlobalDataScaleSlope(numSlices, (float)this.dataScale);
            ir.setGlobalDataScaleIntercept(numSlices, 0.0f);
        } else {
            ir.setGlobalDataScaleSlope(numSlices, 1.0f);
            ir.setGlobalDataScaleIntercept(numSlices, 0.0f);
        }
        return ir;
    }

    public ImageType getImageType() {
        int numBytes = 0;
        int byteType = 0;
        if (this.datatype.equals(VALUE_DATATYPE_BYTE)) {
            numBytes = 1;
            byteType = 2;
        } else if (this.datatype.equals(VALUE_DATATYPE_SHORT)) {
            numBytes = 2;
            byteType = 2;
        } else if (this.datatype.equals(VALUE_DATATYPE_INT)) {
            numBytes = 4;
            byteType = 2;
        } else if (this.datatype.equals(VALUE_DATATYPE_FLOAT)) {
            numBytes = 4;
            byteType = 4;
        }
        boolean littleEndian = !VALUE_BYTE_ORDER_BIG.equals(this.byteOrder);
        return new ImageType(numBytes, byteType, numBytes * 8, littleEndian);
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getOrientation() {
        if (this.orientation.equals(VALUE_ORIENTATION_AXIAL)) {
            return "XYZ---";
        }
        if (this.orientation.equals(VALUE_ORIENTATION_CORONAL)) {
            return "XZY---";
        }
        if (this.orientation.equals(VALUE_ORIENTATION_SAGITTAL)) {
            return "YZX---";
        }
        return null;
    }

    public int getOrientationCertainty() {
        return 1;
    }

    public Coordinate getOrigin() {
        Coordinate coor = null;
        if (this.origin != null && this.origin.size() >= 3 && this.voxelDims != null) {
            double xLoc = -1.0 * this.origin.get(0) / this.voxelDims.get(0);
            double yLoc = -1.0 * this.origin.get(1) / this.voxelDims.get(1);
            double zLoc = -1.0 * this.origin.get(2) / this.voxelDims.get(2);
            coor = new Coordinate(xLoc, yLoc, zLoc);
        } else if (this.fov != null && this.fov.size() >= 3 && this.voxelDims != null) {
            double xLoc = this.fov.get(0) / 2.0 - this.voxelDims.get(0);
            double yLoc = this.fov.get(1) / 2.0 - this.voxelDims.get(1);
            double zLoc = this.fov.get(2) / 2.0 - this.voxelDims.get(2);
            coor = new Coordinate(xLoc, yLoc, zLoc);
        } else {
            coor = new Coordinate();
        }
        return coor;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return EXTENSION_HEADER;
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public int[] getSupportedBytesForType(int type) {
        if (type == 2) {
            return new int[]{1, 2, 4};
        }
        if (type == 4) {
            return new int[]{4};
        }
        return null;
    }

    public String[] getSupportedOrientations() {
        return CollectionUtilities.array(VALID_ORIENTATIONS);
    }

    public int[] getSupportedTypesForBytes(int bytes) {
        if (bytes == 1) {
            return new int[]{2};
        }
        if (bytes == 2) {
            return new int[]{2};
        }
        if (bytes == 4) {
            return new int[]{2, 4};
        }
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        double colSize = 1.0;
        double rowSize = 1.0;
        double sliceSize = 1.0;
        double timeSize = 1.0;
        if (this.voxelDims != null) {
            if (this.numDims >= 2) {
                colSize = this.voxelDims.get(0);
                rowSize = this.voxelDims.get(1);
                if (this.numDims >= 3) {
                    sliceSize = this.voxelDims.get(2);
                    if (this.numDims >= 4) {
                        timeSize = this.voxelDims.get(3);
                    }
                }
            }
        } else if (this.fov != null && this.numDims >= 2) {
            colSize = this.fov.get(0) / (double)this.imageDims.get(0).intValue();
            rowSize = this.fov.get(1) / (double)this.imageDims.get(1).intValue();
            if (this.numDims >= 3) {
                sliceSize = this.fov.get(2) / (double)this.imageDims.get(2).intValue();
                if (this.numDims >= 4) {
                    timeSize = this.fov.get(3) / (double)this.imageDims.get(3).intValue();
                }
            }
        }
        VoxelDimensions vd = new VoxelDimensions(colSize, rowSize, sliceSize, timeSize);
        vd.setSpatialUnit(2);
        vd.setTemporalUnit(0);
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isSupportedBigEndian() {
        return true;
    }

    public boolean isSupportedDataScaleIntercept() {
        return false;
    }

    public boolean isSupportedDataScaleSlope() {
        return true;
    }

    public boolean isSupportedLittleEndian() {
        return true;
    }

    public boolean isSupportedMultipleDataScales() {
        return false;
    }

    public boolean isThisFormat(File file) {
        return file.toString().endsWith(EXTENSION_HEADER);
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.readHeader(file.toURI(), tempDir);
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.clear();
        String filename = FileUtilities.getName((URI)uri);
        if (filename.endsWith(EXTENSION_IMAGE)) {
            filename = filename.substring(0, filename.lastIndexOf(46)) + EXTENSION_HEADER;
        }
        this.headerFile = new File(new File(uri).getParent(), filename);
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = FileUtilities.getReader((URI)this.headerFile.toURI());
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                String value = this.getValuePart(line);
                if (line.startsWith(KEY_NUM_DIMS)) {
                    this.numDims = this.getInteger(value);
                } else if (line.startsWith(KEY_IMAGE_DIMS)) {
                    this.imageDims = this.getIntegerArray(value);
                } else if (line.startsWith(KEY_ORIGIN)) {
                    this.origin = this.getDoubleArray(value);
                } else if (line.startsWith(KEY_FOV)) {
                    this.fov = this.getDoubleArray(value);
                } else if (line.startsWith(KEY_VOXEL_DIMS)) {
                    this.voxelDims = this.getDoubleArray(value);
                } else if (line.startsWith(KEY_DATATYPE)) {
                    this.datatype = value;
                } else if (line.startsWith(KEY_DISPLAY_RANGE)) {
                    this.displayRange = this.getDoubleArray(value);
                } else if (line.startsWith(KEY_ORIENTATION)) {
                    this.orientation = value;
                } else if (line.startsWith(KEY_FID_NAME)) {
                    this.fidName = value;
                } else if (line.startsWith(KEY_BYTE_ORDER)) {
                    this.byteOrder = value;
                } else if (line.startsWith(KEY_DATA_SCALE)) {
                    this.dataScale = this.getDouble(value);
                }
                sb.append(line);
                sb.append('\n');
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new InvalidHeaderException("There was a problem reading that file!", (Exception)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        this.header = sb.toString();
    }

    public String toString() {
        return "Header: " + this.headerFile.getName() + "\n\n" + this.header;
    }

    public boolean willWriteImage() {
        return false;
    }

    public byte[] writeHeader(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) throws VolumeIOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(headerFile)));
            writer.println("numDim: 4");
            writer.println("dim: " + id.getCols() + " " + id.getRows() + " " + id.getSlices() + " " + id.getTimepoints());
            writer.println("origin: " + this.DECIMAL_FORMATTER.format(0L) + " " + this.DECIMAL_FORMATTER.format(0L) + " " + this.DECIMAL_FORMATTER.format(0L) + " " + this.DECIMAL_FORMATTER.format(0L));
            writer.println("extent: " + this.DECIMAL_FORMATTER.format((double)(id.getCols() - 1) * vd.getColSize(true)) + " " + this.DECIMAL_FORMATTER.format((double)(id.getRows() - 1) * vd.getRowSize(true)) + " " + this.DECIMAL_FORMATTER.format((double)(id.getSlices() - 1) * vd.getSliceThickness(true)) + " " + this.DECIMAL_FORMATTER.format(0L));
            writer.println("fov: " + this.DECIMAL_FORMATTER.format((double)id.getCols() * vd.getColSize(true)) + " " + this.DECIMAL_FORMATTER.format((double)id.getRows() * vd.getRowSize(true)) + " " + this.DECIMAL_FORMATTER.format((double)id.getSlices() * vd.getSliceThickness(true)) + " " + this.DECIMAL_FORMATTER.format(id.getTimepoints()));
            writer.println("interval: " + this.DECIMAL_FORMATTER.format(vd.getColSize(true)) + " " + this.DECIMAL_FORMATTER.format(vd.getRowSize(true)) + " " + this.DECIMAL_FORMATTER.format(vd.getSliceThickness(true)) + " " + this.DECIMAL_FORMATTER.format(1L));
            writer.println("dataType: " + this.makeDatatype(it));
            writer.println("displayRange: " + this.DECIMAL_FORMATTER.format(ir.getDisplayMin()) + " " + this.DECIMAL_FORMATTER.format(ir.getDisplayMax()));
            writer.println("sdtOrient:" + this.makeOrientation(orientation));
            writer.println("fidName:");
            writer.println("endian:" + (it.isLittleEndian() ? VALUE_BYTE_ORDER_LITTLE : VALUE_BYTE_ORDER_BIG));
            writer.println("Real2WordScale:" + ir.getDataScaleSlopes()[0]);
        }
        return CollectionUtilities.EMPTY_BYTE_ARRAY;
    }

    public byte[][] writeSeriesHeaders(ImageDimensions arg0, VoxelDimensions arg1, ImageType arg2, ImageRange arg3, ImageDescription arg4, boolean arg5, Coordinate arg6, String arg7, ImageTransform[] arg8, File arg9, File arg10, ByteBuffer[] arg11, File arg12) throws InvalidHeaderException {
        return new byte[0][0];
    }

    private void clear() {
        this.numDims = 0;
        this.dataScale = 0.0;
        this.headerFile = null;
        this.datatype = null;
        this.orientation = null;
        this.fidName = null;
        this.byteOrder = null;
        this.header = null;
        this.imageDims = null;
        this.origin = null;
        this.fov = null;
        this.voxelDims = null;
        this.displayRange = null;
        this.header = null;
    }

    private double getDouble(String original) {
        String value = original;
        value = value.trim();
        return Double.parseDouble(value);
    }

    private Vector<Double> getDoubleArray(String value) {
        Scanner scanner = new Scanner(value);
        Vector<Double> vec = new Vector<Double>();
        while (scanner.hasNextDouble()) {
            vec.add(scanner.nextDouble());
        }
        scanner.close();
        return vec;
    }

    private int getInteger(String original) {
        String value = original;
        value = value.trim();
        return Integer.parseInt(value);
    }

    private Vector<Integer> getIntegerArray(String value) {
        Scanner scanner = new Scanner(value);
        Vector<Integer> vec = new Vector<Integer>();
        while (scanner.hasNextInt()) {
            vec.add(scanner.nextInt());
        }
        scanner.close();
        return vec;
    }

    private String getValuePart(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            return line.substring(colonIndex + 1).trim();
        }
        return line;
    }

    private String makeDatatype(ImageType it) {
        int numBytes = it.getNumBytesPerVoxel();
        if (numBytes == 1) {
            return VALUE_DATATYPE_BYTE;
        }
        if (numBytes == 2) {
            return VALUE_DATATYPE_SHORT;
        }
        if (numBytes == 4) {
            if (it.getByteType() == 4) {
                return VALUE_DATATYPE_FLOAT;
            }
            return VALUE_DATATYPE_INT;
        }
        return "Uknown";
    }

    private String makeOrientation(String orientation) {
        if (orientation.charAt(2) == 'Z') {
            return VALUE_ORIENTATION_AXIAL;
        }
        if (orientation.charAt(2) == 'Y') {
            return VALUE_ORIENTATION_CORONAL;
        }
        if (orientation.charAt(2) == 'X') {
            return VALUE_ORIENTATION_SAGITTAL;
        }
        return "Unknown";
    }

    public Map<String, List<String>> getEditableFieldValues() {
        return null;
    }

    public Map<String, List<EditableHeader.CodeOption>> getHumanReadableFieldOptions() {
        return null;
    }

    public boolean isTextEditableHeader() {
        return true;
    }

    public void setEditableFieldValue(String name, String value, int index) {
    }

    public List<String> getAnonymizableFields() {
        return null;
    }

    public Map<String, List<String>> anonymize() {
        return null;
    }

    public void writeHeader() {
    }
}

