/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.nema;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageIntent;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NEMA
implements EditableHeader,
ReadableHeader,
WritableHeader {
    private String byteType = "";
    private String description = "";
    private String orientationString = "";
    private String patientName = "";
    private String patientNumber = "";
    private String scanDate = "";
    private String spatialUnits = "";
    private URI headerURI;
    private URI imageFile;
    private URI[] multiImageFiles;
    private boolean hasGlobalDataScale;
    private boolean hasGlobalDataScaleOffset;
    private boolean hasSlicewiseDataScaleOffsets;
    private boolean hasSlicewiseDataScales;
    private boolean interleaved;
    private boolean offsetXSet;
    private boolean offsetYSet;
    private boolean offsetZSet;
    private boolean orientationSet;
    private double colVec;
    private double displayMax;
    private double displayMin;
    private double imageMax;
    private double imageMin;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private double rowVec;
    private double sliceVec;
    private double te1;
    private double te2;
    private double tr;
    private float globalDataScale;
    private float globalDataScaleOffset;
    private float[] dataScaleOffsets;
    private float[] dataScales;
    private float[] sliceSpacing;
    private float[] volumeTimes;
    private int bitsAllocated;
    private int bitsStored;
    private int cols;
    private int highBit;
    private int imageOffset;
    private int rows;
    private int slices;
    private int timepoints;
    private int[] multiImageOffsets;
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.mm.dd");
    private final List<String> originalHeader = new ArrayList<String>();
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String MAGIC_NUMBER = "NEMA01";
    public static final String NAME = "DES";
    public static final String PREFERRED_EXTENSION = "des";
    public static final String PREFERRED_IMAGE_EXTENSION = "ima";

    public boolean canCompress() {
        return false;
    }

    public File formatImageFile(File headerFile) {
        String dir = headerFile.getParent();
        String name = FileUtilities.removeExtension((String)headerFile.getName()) + "." + PREFERRED_IMAGE_EXTENSION;
        return new File(dir, name);
    }

    public Map<String, List<String>> getEditableFieldValues() {
        return null;
    }

    public Map<String, List<EditableHeader.CodeOption>> getHumanReadableFieldOptions() {
        return null;
    }

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        Date date = null;
        if (StringUtils.isNotBlank((CharSequence)this.scanDate)) {
            try {
                date = this.DATE_FORMAT.parse(this.scanDate.trim());
            }
            catch (ParseException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        ImageDescription imageDescription = new ImageDescription(this.patientNumber, this.patientName, date, this.description);
        if (this.multiImageFiles != null && this.multiImageFiles.length > 0) {
            imageDescription.setAssociatedFiles(this.multiImageFiles);
        }
        imageDescription.setFile(this.headerURI);
        return imageDescription;
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions imageDimensions = new ImageDimensions(this.cols, this.rows, this.slices, this.timepoints);
        imageDimensions.setImageOffset(this.imageOffset);
        if (this.multiImageOffsets != null && this.multiImageOffsets.length > 0) {
            imageDimensions.setImageOffsets(this.multiImageOffsets);
        }
        return imageDimensions;
    }

    public URI getImageFile() {
        return this.imageFile;
    }

    public ImageIntent getImageIntent() {
        return new ImageIntent();
    }

    public ImageRange getImageRange() {
        ImageRange imageRange = new ImageRange(this.imageMin, this.imageMax, this.displayMin, this.displayMax);
        if (this.hasSlicewiseDataScales) {
            imageRange.setDataScaleSlopes(this.dataScales);
        } else if (this.hasGlobalDataScale) {
            imageRange.setGlobalDataScaleSlope(this.slices * this.timepoints, this.globalDataScale);
        } else {
            imageRange.setGlobalDataScaleSlope(this.slices * this.timepoints, 1.0f);
        }
        if (this.hasSlicewiseDataScaleOffsets) {
            imageRange.setDataScaleIntercepts(this.dataScaleOffsets);
        } else if (this.hasGlobalDataScaleOffset) {
            imageRange.setGlobalDataScaleIntercept(this.slices * this.timepoints, this.globalDataScaleOffset);
        } else {
            imageRange.setGlobalDataScaleIntercept(this.slices * this.timepoints, 0.0f);
        }
        return imageRange;
    }

    public ImageType getImageType() {
        return new ImageType(this.getNumBytesPerVoxel(), this.getByteTypeValue(), this.bitsStored, this.isLittleEndian());
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getOrientation() {
        return this.getOrientationString();
    }

    public int getOrientationCertainty() {
        int orientationCertainty = 0;
        if (this.orientationSet && Orientation.isValidOrientationString(this.orientationString)) {
            ++orientationCertainty;
            if (this.offsetXSet && this.offsetYSet && this.offsetZSet && (this.offsetX != 0.0 || this.offsetY != 0.0 || this.offsetZ != 0.0)) {
                ++orientationCertainty;
            }
        }
        return orientationCertainty;
    }

    public String getOrientationString() {
        return this.orientationString;
    }

    public Coordinate getOrigin() {
        Coordinate origin = null;
        if (this.offsetXSet && this.offsetYSet && this.offsetZSet && Orientation.isValidOrientationString(this.orientationString)) {
            double[] voxelDims = new double[]{this.colVec, this.rowVec, this.sliceVec};
            origin = new Coordinate((double)((int)Math.round(this.offsetX / voxelDims[this.orientationString.indexOf(88)])), (double)((int)Math.round(this.offsetY / voxelDims[this.orientationString.indexOf(89)])), (double)((int)Math.round(this.offsetZ / voxelDims[this.orientationString.indexOf(90)])));
        } else {
            origin = new Coordinate(0.0, 0.0, 0.0);
        }
        return origin;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return ".des";
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public float[] getSliceSpacing() {
        return this.sliceSpacing;
    }

    public int[] getSupportedBytesForType(int type) {
        if (type == 2) {
            return new int[]{1, 2, 4};
        }
        if (type == 3) {
            return new int[]{1, 2, 4};
        }
        if (type == 4) {
            return new int[]{4};
        }
        return null;
    }

    public String[] getSupportedOrientations() {
        return CollectionUtilities.EMPTY_STRING_ARRAY;
    }

    public int[] getSupportedTypesForBytes(int bytes) {
        if (bytes == 1) {
            return new int[]{2, 3};
        }
        if (bytes == 2) {
            return new int[]{2, 3};
        }
        if (bytes == 4) {
            return new int[]{2, 3, 4};
        }
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return null;
    }

    public float[] getVolumeTiming() {
        return this.volumeTimes;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions voxelDimensions = new VoxelDimensions(this.colVec, this.rowVec, this.sliceVec, this.tr);
        if (this.spatialUnits == null) {
            voxelDimensions.setSpatialUnit(0);
        } else if (this.spatialUnits.indexOf("mm") != -1) {
            voxelDimensions.setSpatialUnit(2);
        } else if (this.spatialUnits.indexOf("met") != -1) {
            voxelDimensions.setSpatialUnit(1);
        } else if (this.spatialUnits.indexOf("mic") != -1) {
            voxelDimensions.setSpatialUnit(3);
        } else {
            voxelDimensions.setSpatialUnit(0);
        }
        voxelDimensions.setTemporalUnit(0);
        voxelDimensions.setTE1(this.te1);
        voxelDimensions.setTE2(this.te2);
        if (this.volumeTimes != null && this.volumeTimes.length > 0) {
            voxelDimensions.setVariableTiming(this.volumeTimes);
        }
        if (this.sliceSpacing != null && this.sliceSpacing.length > 0) {
            voxelDimensions.setVariableSpacing(this.sliceSpacing);
        }
        return voxelDimensions;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isLittleEndian() {
        return this.highBit == 7;
    }

    public boolean isSupportedBigEndian() {
        return true;
    }

    public boolean isSupportedDataScaleIntercept() {
        return true;
    }

    public boolean isSupportedDataScaleSlope() {
        return true;
    }

    public boolean isSupportedLittleEndian() {
        return true;
    }

    public boolean isSupportedMultipleDataScales() {
        return true;
    }

    public boolean isTextEditableHeader() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        boolean success = false;
        BufferedInputStream fileIn = null;
        byte[] byteArray = new byte[MAGIC_NUMBER.length()];
        try {
            fileIn = FileUtilities.getInputStream((URI)file.toURI(), (boolean)false);
            FileUtilities.readFully((InputStream)fileIn, (byte[])byteArray);
            success = MAGIC_NUMBER.equals(new String(byteArray, CHARACTER_ENCODING));
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return success;
    }

    public void readHeader(File aFile, File tempDir) throws InvalidHeaderException {
        this.readHeader(aFile.toURI(), tempDir);
    }

    public void readHeader(URI uri, File tempFir) throws InvalidHeaderException {
        this.headerURI = uri;
        BufferedReader reader = null;
        try {
            String path = uri.getPath();
            path = path.substring(0, path.lastIndexOf(47));
            reader = FileUtilities.getReader((URI)uri);
            this.orientationSet = false;
            this.offsetZSet = false;
            this.offsetYSet = false;
            this.offsetXSet = false;
            URI[] tempMultiImageFiles = null;
            float[] tempDataScales = null;
            float[] tempDataScaleOffsets = null;
            float[] slicePosition = null;
            int[] tempMultiImageOffsets = null;
            int volCtr = 0;
            int sliceCtr = 0;
            String line = reader.readLine();
            if (line == null || !line.equals(MAGIC_NUMBER)) {
                throw new InvalidHeaderException("Does not appear to be a valid NEMA file!");
            }
            String scheme = uri.getScheme();
            String userInfo = uri.getUserInfo();
            String host = uri.getHost();
            int port = uri.getPort();
            this.originalHeader.clear();
            while (line != null) {
                this.originalHeader.add(line);
                if (line.startsWith("TOTAL_VOLUMES")) {
                    this.timepoints = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                    if (this.timepoints > 1) {
                        this.volumeTimes = new float[this.timepoints];
                    }
                }
                if (line.startsWith("$VOLUME")) {
                    volCtr = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("TOTAL_SCANS")) {
                    this.slices = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("PATIENT_NAME")) {
                    this.patientName = line.indexOf(34) != -1 ? line.substring(line.indexOf(34) + 1, line.lastIndexOf(34)) : line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("PATIENT_NUMBER")) {
                    this.patientNumber = line.indexOf(34) != -1 ? line.substring(line.indexOf(34) + 1, line.lastIndexOf(34)) : line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("SCANDATE")) {
                    this.scanDate = line.indexOf(34) != -1 ? line.substring(line.indexOf(34) + 1, line.lastIndexOf(34)) : line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("DESCRIPTION")) {
                    this.description = line.indexOf(34) != -1 ? line.substring(line.indexOf(34) + 1, line.lastIndexOf(34)) : line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("XOFFSET")) {
                    this.setOffsetX(Double.parseDouble(line.substring(line.indexOf(61) + 1)));
                }
                if (line.startsWith("YOFFSET")) {
                    this.setOffsetY(Double.parseDouble(line.substring(line.indexOf(61) + 1)));
                }
                if (line.startsWith("ZOFFSET")) {
                    this.setOffsetZ(Double.parseDouble(line.substring(line.indexOf(61) + 1)));
                }
                if (line.startsWith("ROWS")) {
                    this.rows = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("COLUMNS")) {
                    this.cols = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("ROWVEC")) {
                    this.rowVec = Double.parseDouble(line.substring(line.indexOf(61) + 1, line.indexOf(44)));
                }
                if (line.startsWith("COLVEC")) {
                    this.colVec = Double.parseDouble(line.substring(line.indexOf(44) + 1, line.lastIndexOf(44)));
                }
                if (line.startsWith("SLICEVEC")) {
                    this.sliceVec = Double.parseDouble(line.substring(line.lastIndexOf(44) + 1));
                }
                if (line.startsWith("ORIENTATION")) {
                    this.setOrientationString(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("BITS_ALLOCATED")) {
                    this.bitsAllocated = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("BITS_STORED")) {
                    this.bitsStored = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("HIGH_BIT")) {
                    this.highBit = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("PIXEL_REPRESENTATION")) {
                    this.byteType = line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("IMAGE_MIN")) {
                    this.imageMin = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("IMAGE_MAX")) {
                    this.imageMax = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("DISPLAY_MIN")) {
                    this.displayMin = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("DISPLAY_MAX")) {
                    this.displayMax = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("SPATIAL_UNITS")) {
                    this.spatialUnits = line.substring(line.indexOf(61) + 1);
                }
                if (line.startsWith("REPETITION_TIME")) {
                    double val = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                    if (volCtr == 1) {
                        this.tr = val;
                    }
                    if (this.volumeTimes != null) {
                        this.volumeTimes[volCtr - 1] = (float)val;
                    }
                }
                if (line.startsWith("ECHO1_TIME")) {
                    this.te1 = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("ECHO2_TIME")) {
                    this.te2 = Double.parseDouble(line.substring(line.indexOf(61) + 1));
                }
                if (this.timepoints == 1 && !this.interleaved && this.te1 != 0.0 && this.te2 != 0.0) {
                    this.interleaved = true;
                }
                if (line.startsWith("$SLICE")) {
                    sliceCtr = Integer.parseInt(line.substring(line.indexOf(61) + 1));
                }
                if (line.startsWith("IMAGE_POSITION")) {
                    String spacingStr;
                    if (slicePosition == null) {
                        slicePosition = new float[this.slices * this.timepoints];
                    }
                    if ((spacingStr = line.substring(line.lastIndexOf(44) + 1).trim()).endsWith("\"")) {
                        spacingStr = spacingStr.substring(0, spacingStr.indexOf(34));
                    }
                    slicePosition[sliceCtr - 1 + (volCtr - 1) * this.slices] = Float.parseFloat(spacingStr);
                }
                if (line.startsWith("DATA") && !line.startsWith("DATA_SCALE") && !line.startsWith("DATA_UNITS") && sliceCtr <= this.slices && volCtr <= this.timepoints) {
                    if (tempMultiImageFiles == null) {
                        tempMultiImageFiles = new URI[this.slices * this.timepoints];
                    }
                    if (tempMultiImageOffsets == null) {
                        tempMultiImageOffsets = new int[this.slices * this.timepoints];
                    }
                    tempMultiImageFiles[sliceCtr - 1 + (volCtr - 1) * this.slices] = line.indexOf(34) != -1 ? new URI(scheme, userInfo, host, port, path + "/" + line.substring(line.indexOf(34) + 1, line.lastIndexOf(34)), null, null) : new URI(scheme, userInfo, host, port, path + "/" + line.substring(line.indexOf(61) + 1, line.lastIndexOf(44)), null, null);
                    tempMultiImageOffsets[sliceCtr - 1 + (volCtr - 1) * this.slices] = Integer.parseInt(line.substring(line.lastIndexOf(44) + 1).trim());
                }
                if (line.startsWith("DATA_SCALE_OFFSET")) {
                    if (sliceCtr == 0) {
                        this.setGlobalDataScaleOffset(Float.parseFloat(line.substring(line.indexOf(61) + 1)));
                    } else if (sliceCtr > 0 && sliceCtr <= this.slices && volCtr <= this.timepoints && !this.hasGlobalDataScaleOffset) {
                        if (tempDataScaleOffsets == null) {
                            tempDataScaleOffsets = new float[this.slices * this.timepoints];
                            this.setDataScaleOffsets(tempDataScaleOffsets);
                        }
                        tempDataScaleOffsets[sliceCtr - 1 + (volCtr - 1) * this.slices] = Float.parseFloat(line.substring(line.indexOf(61) + 1));
                    }
                }
                if (line.startsWith("DATA_SCALE") && !line.startsWith("DATA_SCALE_OFFSET")) {
                    if (sliceCtr == 0) {
                        this.setGlobalDataScale(Float.parseFloat(line.substring(line.indexOf(61) + 1)));
                    } else if (sliceCtr > 0 && sliceCtr <= this.slices && volCtr <= this.timepoints && !this.hasGlobalDataScale) {
                        if (tempDataScales == null) {
                            tempDataScales = new float[this.slices * this.timepoints];
                            this.setDataScales(tempDataScales);
                        }
                        tempDataScales[sliceCtr - 1 + (volCtr - 1) * this.slices] = Float.parseFloat(line.substring(line.indexOf(61) + 1));
                    }
                }
                line = reader.readLine();
            }
            if (tempMultiImageFiles.length > 1 && !tempMultiImageFiles[0].equals(tempMultiImageFiles[1])) {
                this.imageFile = tempMultiImageFiles[0];
                this.imageOffset = tempMultiImageOffsets[0];
                this.multiImageFiles = tempMultiImageFiles;
                this.multiImageOffsets = tempMultiImageOffsets;
            } else {
                this.imageFile = tempMultiImageFiles[0];
                void smallestOffset = tempMultiImageOffsets[0];
                for (int ctrOffset = 1; ctrOffset < tempMultiImageOffsets.length; ++ctrOffset) {
                    if (smallestOffset <= tempMultiImageOffsets[ctrOffset]) continue;
                    smallestOffset = tempMultiImageOffsets[ctrOffset];
                }
                this.imageOffset = smallestOffset;
            }
            if (this.interleaved && this.slices % 2 == 0) {
                this.timepoints = 2;
                this.slices /= 2;
                this.volumeTimes = new float[2];
                this.uninterleaveFiles();
                this.uninterleaveOffsets();
                this.uninterleaveDataScales();
                this.uninterleaveDataScaleOffsets();
            }
            this.sliceSpacing = Header.makeSliceSpacing(slicePosition, this.slices);
            if (StringUtils.isBlank((CharSequence)this.orientationString)) {
                this.orientationString = Orientation.getDefaultOrientation("NEMA");
            }
        }
        catch (FileNotFoundException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (URISyntaxException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    public void setEditableFieldValue(String name, String value, int index) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = this.originalHeader.iterator();
        while (it.hasNext()) {
            sb.append(it.next() + '\n');
        }
        return sb.toString();
    }

    public boolean willWriteImage() {
        return false;
    }

    public void writeHeader() {
    }

    public byte[] writeHeader(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) throws VolumeIOException {
        this.updateDims4D(id.getCols(), id.getRows(), id.getSlices(), id.getTimepoints());
        this.updatePixDims4D(vd.getColSize(true), vd.getRowSize(true), vd.getSliceThickness(true), vd.getTR());
        this.setOrientationString(orientation);
        this.updateOrigin(orientation, origin.xDbl, origin.yDbl, origin.zDbl);
        this.updateDisplayRange(ir.getDisplayMax(), ir.getDisplayMin());
        this.updateMaxMin(ir.getImageMax(), ir.getImageMin());
        this.updateSpatialUnits(vd.getSpatialUnit());
        this.updateDataType(it.getNumBytesPerVoxel(), it.getByteType(), it.isLittleEndian());
        this.imageOffset = id.getImageOffset();
        this.imageFile = imageFile.toURI();
        if (ir.hasGlobalDataScaleSlope()) {
            this.setGlobalDataScale(ir.getDataScaleSlopes()[0]);
        } else {
            this.setDataScales(ir.getDataScaleSlopes());
        }
        if (ir.hasGlobalDataScaleIntercept()) {
            this.setGlobalDataScaleOffset(ir.getDataScaleIntercepts()[0]);
        } else {
            this.setDataScaleOffsets(ir.getDataScaleIntercepts());
        }
        this.description = des.getDescription();
        this.patientName = des.getName();
        this.patientNumber = des.getID();
        Date studyDate = des.getStudyDate();
        this.scanDate = studyDate != null ? this.DATE_FORMAT.format(des.getStudyDate()) : "";
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(headerFile)));
            int numVoxelsInSlice = this.cols * this.rows;
            int numBytesPerVoxel = this.getNumBytesPerVoxel();
            boolean hasDefaultDataScaleSlopes = this.hasGlobalDataScale ? (double)this.globalDataScale == 1.0 : ImageRange.hasDefaultDataScaleSlope((float[])this.dataScales);
            boolean hasDefaultDataScaleIntercepts = this.hasGlobalDataScaleOffset ? this.globalDataScaleOffset == 0.0f : ImageRange.hasDefaultDataScaleIntercept((float[])this.dataScaleOffsets);
            writer.println(MAGIC_NUMBER);
            writer.println("TOTAL_VOLUMES=" + this.timepoints);
            for (int volCtr = 0; volCtr < this.timepoints; ++volCtr) {
                writer.println("$VOLUME=" + (volCtr + 1));
                writer.println("TOTAL_SCANS=" + this.slices);
                if (StringUtils.isNotBlank((CharSequence)this.patientName)) {
                    writer.println("PATIENT_NAME=\"" + StringUtilities.removeLineBreaks((String)this.patientName) + "\"");
                }
                if (StringUtils.isNotBlank((CharSequence)this.patientNumber)) {
                    writer.println("PATIENT_NUMBER=\"" + StringUtilities.removeLineBreaks((String)this.patientNumber) + "\"");
                }
                if (StringUtils.isNotBlank((CharSequence)this.scanDate)) {
                    writer.println("SCANDATE=\"" + StringUtilities.removeLineBreaks((String)this.scanDate) + "\"");
                }
                if (StringUtils.isNotBlank((CharSequence)this.description)) {
                    writer.println("DESCRIPTION=\"" + StringUtilities.removeLineBreaks((String)this.description) + "\"");
                }
                writer.println("ROWS=" + this.rows);
                writer.println("COLUMNS=" + this.cols);
                writer.println("REPETITION_TIME1=" + this.tr);
                writer.println("ECHO_TIME1=" + this.te1);
                writer.println("ECHO_TIME2=" + this.te2);
                writer.println("ROWVEC=" + this.rowVec + ",0.0,0.0");
                writer.println("COLVEC=0.0," + this.colVec + ",0.0");
                writer.println("SLICEVEC=0.0,0.0," + this.sliceVec);
                writer.println("ORIENTATION=" + this.getOrientationString());
                writer.println("XOFFSET=" + this.offsetX);
                writer.println("YOFFSET=" + this.offsetY);
                writer.println("ZOFFSET=" + this.offsetZ);
                writer.println("IMAGE_MAX=" + this.imageMax);
                writer.println("IMAGE_MIN=" + this.imageMin);
                writer.println("DISPLAY_MAX=" + this.displayMax);
                writer.println("DISPLAY_MIN=" + this.displayMin);
                writer.println("SPATIAL_UNITS=" + this.spatialUnits);
                writer.println("PIXEL_REPRESENTATION=" + this.byteType);
                writer.println("BITS_ALLOCATED=" + this.bitsAllocated);
                writer.println("BITS_STORED=" + this.bitsStored);
                writer.println("HIGH_BIT=" + (this.isLittleEndian() ? 7 : this.bitsStored - 1));
                if (this.hasGlobalDataScale && !hasDefaultDataScaleSlopes) {
                    writer.println("DATA_SCALE=" + this.globalDataScale);
                }
                if (this.hasGlobalDataScaleOffset && !hasDefaultDataScaleIntercepts) {
                    writer.println("DATA_SCALE_OFFSET=" + this.globalDataScaleOffset);
                }
                for (int sliceCtr = 0; sliceCtr < this.slices; ++sliceCtr) {
                    writer.println("$SLICE=" + (sliceCtr + 1));
                    writer.println("IMAGE_POSITION=0.0,0.0," + (double)sliceCtr * this.sliceVec);
                    if (!hasDefaultDataScaleSlopes && !this.hasGlobalDataScale) {
                        writer.println("DATA_SCALE=" + this.dataScales[sliceCtr + volCtr * this.slices]);
                    }
                    if (!hasDefaultDataScaleIntercepts && !this.hasGlobalDataScaleOffset && this.dataScaleOffsets != null) {
                        writer.println("DATA_SCALE_OFFSET=" + this.dataScaleOffsets[sliceCtr + volCtr * this.slices]);
                    }
                    writer.println("DATA=\"" + FileUtilities.getName((URI)this.imageFile) + "\"," + (sliceCtr * numVoxelsInSlice * numBytesPerVoxel + this.imageOffset));
                }
            }
        }
        return CollectionUtilities.EMPTY_BYTE_ARRAY;
    }

    public byte[][] writeSeriesHeaders(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) {
        return new byte[0][0];
    }

    private int getByteTypeValue() {
        if (this.byteType.equals("SIGNED")) {
            return 2;
        }
        if (this.byteType.equals("UNSIGNED")) {
            return 3;
        }
        if (this.byteType.equals("IEEE")) {
            return 4;
        }
        if (this.byteType.equals("IEEE_FLOAT")) {
            return 4;
        }
        return 0;
    }

    private int getNumBytesPerVoxel() {
        return this.bitsAllocated / 8;
    }

    private void setDataScaleOffsets(float[] val) {
        this.dataScaleOffsets = val;
        this.hasSlicewiseDataScaleOffsets = true;
    }

    private void setDataScales(float[] val) {
        this.dataScales = val;
        this.hasSlicewiseDataScales = true;
    }

    private void setGlobalDataScale(float val) {
        this.globalDataScale = val;
        this.hasGlobalDataScale = true;
    }

    private void setGlobalDataScaleOffset(float val) {
        this.globalDataScaleOffset = val;
        this.hasGlobalDataScaleOffset = true;
    }

    private void setOffsetX(double val) {
        this.offsetX = val;
        this.offsetXSet = true;
    }

    private void setOffsetY(double val) {
        this.offsetY = val;
        this.offsetYSet = true;
    }

    private void setOffsetZ(double val) {
        this.offsetZ = val;
        this.offsetZSet = true;
    }

    private void setOrientationString(String string) {
        this.orientationSet = true;
        this.orientationString = string;
    }

    private void uninterleaveDataScaleOffsets() {
        ArrayList<Float> first = new ArrayList<Float>();
        ArrayList<Float> second = new ArrayList<Float>();
        if (CollectionUtilities.isNotEmpty((Object)this.dataScaleOffsets)) {
            for (int ctr = 0; ctr < this.dataScaleOffsets.length; ++ctr) {
                if (ctr % 2 == 0) {
                    first.add(Float.valueOf(this.dataScaleOffsets[ctr]));
                    continue;
                }
                second.add(Float.valueOf(this.dataScaleOffsets[ctr]));
            }
            first.addAll(second);
            System.arraycopy(CollectionUtilities.arrayFloats(first), 0, this.dataScaleOffsets, 0, this.dataScaleOffsets.length);
        }
    }

    private void uninterleaveDataScales() {
        ArrayList<Float> first = new ArrayList<Float>();
        ArrayList<Float> second = new ArrayList<Float>();
        if (CollectionUtilities.isNotEmpty((Object)this.dataScales)) {
            for (int ctr = 0; ctr < this.dataScales.length; ++ctr) {
                if (ctr % 2 == 0) {
                    first.add(Float.valueOf(this.dataScales[ctr]));
                    continue;
                }
                second.add(Float.valueOf(this.dataScales[ctr]));
            }
            first.addAll(second);
            System.arraycopy(CollectionUtilities.arrayFloats(first), 0, this.dataScales, 0, this.dataScales.length);
        }
    }

    private void uninterleaveFiles() {
        ArrayList<URI> first = new ArrayList<URI>();
        ArrayList<URI> second = new ArrayList<URI>();
        for (int ctr = 0; ctr < this.multiImageFiles.length; ++ctr) {
            if (ctr % 2 == 0) {
                first.add(this.multiImageFiles[ctr]);
                continue;
            }
            second.add(this.multiImageFiles[ctr]);
        }
        first.addAll(second);
        System.arraycopy(first.toArray(new URI[first.size()]), 0, this.multiImageFiles, 0, this.multiImageFiles.length);
    }

    private void uninterleaveOffsets() {
        ArrayList<Integer> first = new ArrayList<Integer>();
        ArrayList<Integer> second = new ArrayList<Integer>();
        for (int ctr = 0; ctr < this.multiImageOffsets.length; ++ctr) {
            if (ctr % 2 == 0) {
                first.add(this.multiImageOffsets[ctr]);
                continue;
            }
            second.add(this.multiImageOffsets[ctr]);
        }
        first.addAll(second);
        System.arraycopy(CollectionUtilities.arrayInts(first), 0, this.multiImageOffsets, 0, this.multiImageOffsets.length);
    }

    private void updateDataType(int aNumBytes, int aByteType, boolean bool) {
        this.bitsStored = this.bitsAllocated = aNumBytes * 8;
        this.byteType = aByteType == 2 ? "SIGNED" : (aByteType == 3 ? "UNSIGNED" : (aByteType == 4 ? "IEEE_FLOAT" : "UNKNOWN"));
        this.highBit = bool ? 7 : this.bitsStored - 1;
    }

    private void updateDims4D(int dim1, int dim2, int dim3, int dim4) {
        this.cols = dim1;
        this.rows = dim2;
        this.slices = dim3;
        this.timepoints = dim4;
    }

    private void updateDisplayRange(double aMax, double aMin) {
        this.displayMin = aMin;
        this.displayMax = aMax;
    }

    private void updateMaxMin(double aMax, double aMin) {
        this.imageMin = aMin;
        this.imageMax = aMax;
    }

    private void updateOrigin(String aStringVal, double val1, double val2, double val3) {
        String aString = aStringVal;
        if (Orientation.isValidOrientationString(aString = aString.toUpperCase())) {
            double[] vecs = new double[]{this.colVec, this.rowVec, this.sliceVec};
            this.offsetX = val1 * Math.abs(vecs[aString.indexOf(88)]);
            this.offsetY = val2 * Math.abs(vecs[aString.indexOf(89)]);
            this.offsetZ = val3 * Math.abs(vecs[aString.indexOf(90)]);
        }
    }

    private void updatePixDims4D(double dim1, double dim2, double dim3, double dim4) {
        this.colVec = dim1;
        this.rowVec = dim2;
        this.sliceVec = dim3;
        this.tr = dim4;
    }

    private void updateSpatialUnits(int units) {
        this.spatialUnits = (units & 2) != 0 ? "mm" : ((units & 1) != 0 ? "met" : ((units & 1) != 0 ? "mic" : ""));
    }

    public List<String> getAnonymizableFields() {
        return null;
    }

    public Map<String, List<String>> anonymize() {
        return null;
    }
}

