/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.cti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.volume.formats.cti.Subheader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class ImageSubheader
extends Subheader {
    protected String annotation;
    protected String dataTypeS;
    protected String filterCodeS;
    protected String processingCodeS;
    protected String reconTypeS;
    protected String scatterTypeS;
    protected float decayCorrFactor;
    protected float filterCutoffFreq;
    protected float filterCutoffR;
    protected float filterCutoffZ;
    protected float filterRampSlope;
    protected float filterResolution;
    protected float filterResolutionR;
    protected float filterResolutionZ;
    protected float filterScatterFraction;
    protected float filterScatterSlope;
    protected float mt11;
    protected float mt12;
    protected float mt13;
    protected float mt14;
    protected float mt21;
    protected float mt22;
    protected float mt23;
    protected float mt24;
    protected float mt31;
    protected float mt32;
    protected float mt33;
    protected float mt34;
    protected float numAngles;
    protected float numElementsR;
    protected float offsetX;
    protected float offsetY;
    protected float offsetZ;
    protected float pixelSizeX;
    protected float pixelSizeY;
    protected float pixelSizeZ;
    protected float reconZoom;
    protected float resolutionX;
    protected float resolutionY;
    protected float resolutionZ;
    protected float rotationAngleZ;
    protected float scaleFactor;
    protected int frameDuration;
    protected int frameStartTime;
    protected int gateDuration;
    protected int numAcceptedBeats;
    protected int processingCode;
    protected int waveOffsetR;
    protected short dataType;
    protected short dimX;
    protected short dimY;
    protected short dimZ;
    protected short filterCode;
    protected short filterCodeR;
    protected short filterCodeZ;
    protected short filterOrder;
    protected short filterOrderR;
    protected short filterOrderZ;
    protected short imageMax;
    protected short imageMin;
    protected short numDimensions;
    protected short reconType;
    protected short reconViews;
    protected short scatterType;
    protected final short[] fillCti;
    protected final short[] fillUser;

    protected ImageSubheader(long f, long l) {
        this.setFirst(f);
        this.setLast(l);
        this.fillCti = new short[87];
        this.fillUser = new short[48];
    }

    @Override
    public void out() {
        this.out("./image_subheader.doc");
    }

    @Override
    public void out(String name) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(name));
            out.println("Image Subheader, first record: " + this.dataFirst + ", last record: " + this.dataLast + "\n");
            out.println("data type:\t\t\t\t\t" + this.dataType + ", " + this.dataTypeS);
            out.println("num dimensions:\t\t\t\t" + this.numDimensions);
            out.println("x dimension:\t\t\t\t" + this.dimX);
            out.println("y dimension:\t\t\t\t" + this.dimY);
            out.println("z dimension:\t\t\t\t" + this.dimZ);
            out.println("x offset:\t\t\t\t\t" + this.offsetX);
            out.println("y offset:\t\t\t\t\t" + this.offsetY);
            out.println("z offset:\t\t\t\t\t" + this.offsetZ);
            out.println("recon zoom:\t\t\t\t\t" + this.reconZoom);
            out.println("scale factor:\t\t\t\t" + this.scaleFactor);
            out.println("image min:\t\t\t\t\t" + this.imageMin);
            out.println("image max:\t\t\t\t\t" + this.imageMax);
            out.println("x pixel size:\t\t\t\t" + this.pixelSizeX);
            out.println("y pixel size:\t\t\t\t" + this.pixelSizeY);
            out.println("z pixel size:\t\t\t\t" + this.pixelSizeZ);
            out.println("frame duration:\t\t\t\t" + this.frameDuration + ", in milliseconds");
            out.println("frame start time:\t\t\t" + this.frameStartTime + ", offset from first frame in msec");
            out.println("filter code:\t\t\t\t" + this.filterCode + ", " + this.filterCodeS);
            out.println("x resolution:\t\t\t\t" + this.resolutionX);
            out.println("y resolution:\t\t\t\t" + this.resolutionY);
            out.println("z resolution:\t\t\t\t" + this.resolutionZ);
            out.println("num r elements:\t\t\t\t" + this.numElementsR);
            out.println("num angles:\t\t\t\t\t" + this.numAngles);
            out.println("z rotation angle:\t\t\t" + this.rotationAngleZ);
            out.println("decay corr factor:\t\t\t" + this.decayCorrFactor);
            out.println("processing code:\t\t\t" + this.processingCode + ", " + this.processingCodeS);
            out.println("gate duration:\t\t\t\t" + this.gateDuration);
            out.println("r wave offset:\t\t\t\t" + this.waveOffsetR);
            out.println("num accepted beats:\t\t\t" + this.numAcceptedBeats);
            out.println("filter cutoff frequency:\t" + this.filterCutoffFreq);
            out.println("filter resolution:\t\t\t" + this.filterResolution);
            out.println("filter ramp slope:\t\t\t" + this.filterRampSlope);
            out.println("filter filter order:\t\t" + this.filterOrder);
            out.println("filter scatter fraction:\t" + this.filterScatterFraction);
            out.println("filter scatter slope:\t\t" + this.filterScatterSlope);
            out.println("annotation:\t\t\t\t\t" + this.annotation);
            out.println("mt 1 1:\t\t\t\t\t\t" + this.mt11);
            out.println("mt 1 2:\t\t\t\t\t\t" + this.mt12);
            out.println("mt 1 3:\t\t\t\t\t\t" + this.mt13);
            out.println("mt 2 1:\t\t\t\t\t\t" + this.mt21);
            out.println("mt 2 2:\t\t\t\t\t\t" + this.mt22);
            out.println("mt 2 3:\t\t\t\t\t\t" + this.mt23);
            out.println("mt 3 1:\t\t\t\t\t\t" + this.mt31);
            out.println("mt 3 2:\t\t\t\t\t\t" + this.mt32);
            out.println("mt 3 3:\t\t\t\t\t\t" + this.mt33);
            out.println("rfilter cutoff:\t\t\t\t" + this.filterCutoffR);
            out.println("rfilter resolution:\t\t\t" + this.filterResolutionR);
            out.println("rfilter code:\t\t\t\t" + this.filterCodeR);
            out.println("rfilter order:\t\t\t\t" + this.filterOrderR);
            out.println("zfilter cutoff:\t\t\t\t" + this.filterCutoffZ);
            out.println("zfilter resolution:\t\t\t" + this.filterResolutionZ);
            out.println("zfilter code:\t\t\t\t" + this.filterCodeZ);
            out.println("zfilter order:\t\t\t\t" + this.filterOrderZ);
            out.println("mt 1 4:\t\t\t\t\t\t" + this.mt14);
            out.println("mt 2 4:\t\t\t\t\t\t" + this.mt24);
            out.println("mt 3 4:\t\t\t\t\t\t" + this.mt34);
            out.println("scatter type:\t\t\t\t" + this.scatterType + ", " + this.scatterTypeS);
            out.println("recon type:\t\t\t\t\t" + this.reconType + ", " + this.reconTypeS);
            out.println("recon views:\t\t\t\t" + this.reconViews);
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void read(byte[] b) {
        int i;
        super.read(b);
        this.dataType = ByteUtilities.getShort((byte[])b, (int)0);
        this.numDimensions = ByteUtilities.getShort((byte[])b, (int)2);
        this.dimX = ByteUtilities.getShort((byte[])b, (int)4);
        this.dimY = ByteUtilities.getShort((byte[])b, (int)6);
        this.dimZ = ByteUtilities.getShort((byte[])b, (int)8);
        this.offsetX = ByteUtilities.getFloat((byte[])b, (int)10);
        this.offsetY = ByteUtilities.getFloat((byte[])b, (int)14);
        this.offsetZ = ByteUtilities.getFloat((byte[])b, (int)18);
        this.reconZoom = ByteUtilities.getFloat((byte[])b, (int)22);
        this.scaleFactor = ByteUtilities.getFloat((byte[])b, (int)26);
        this.imageMin = ByteUtilities.getShort((byte[])b, (int)30);
        this.imageMax = ByteUtilities.getShort((byte[])b, (int)32);
        this.pixelSizeX = ByteUtilities.getFloat((byte[])b, (int)34);
        this.pixelSizeY = ByteUtilities.getFloat((byte[])b, (int)38);
        this.pixelSizeZ = ByteUtilities.getFloat((byte[])b, (int)42);
        this.frameDuration = ByteUtilities.getInt((byte[])b, (int)46);
        this.frameStartTime = ByteUtilities.getInt((byte[])b, (int)50);
        this.filterCode = ByteUtilities.getShort((byte[])b, (int)54);
        this.resolutionX = ByteUtilities.getFloat((byte[])b, (int)56);
        this.resolutionY = ByteUtilities.getFloat((byte[])b, (int)60);
        this.resolutionZ = ByteUtilities.getFloat((byte[])b, (int)64);
        this.numElementsR = ByteUtilities.getFloat((byte[])b, (int)68);
        this.numAngles = ByteUtilities.getFloat((byte[])b, (int)72);
        this.rotationAngleZ = ByteUtilities.getFloat((byte[])b, (int)76);
        this.decayCorrFactor = ByteUtilities.getFloat((byte[])b, (int)80);
        this.processingCode = ByteUtilities.getInt((byte[])b, (int)84);
        this.gateDuration = ByteUtilities.getInt((byte[])b, (int)88);
        this.waveOffsetR = ByteUtilities.getInt((byte[])b, (int)92);
        this.numAcceptedBeats = ByteUtilities.getInt((byte[])b, (int)96);
        this.filterCutoffFreq = ByteUtilities.getFloat((byte[])b, (int)100);
        this.filterResolution = ByteUtilities.getFloat((byte[])b, (int)104);
        this.filterRampSlope = ByteUtilities.getFloat((byte[])b, (int)108);
        this.filterOrder = ByteUtilities.getShort((byte[])b, (int)112);
        this.filterScatterFraction = ByteUtilities.getFloat((byte[])b, (int)114);
        this.filterScatterSlope = ByteUtilities.getFloat((byte[])b, (int)118);
        this.annotation = ByteUtilities.getString((byte[])b, (int)122, (int)40);
        this.mt11 = ByteUtilities.getFloat((byte[])b, (int)162);
        this.mt12 = ByteUtilities.getFloat((byte[])b, (int)166);
        this.mt13 = ByteUtilities.getFloat((byte[])b, (int)170);
        this.mt21 = ByteUtilities.getFloat((byte[])b, (int)174);
        this.mt22 = ByteUtilities.getFloat((byte[])b, (int)178);
        this.mt23 = ByteUtilities.getFloat((byte[])b, (int)182);
        this.mt31 = ByteUtilities.getFloat((byte[])b, (int)186);
        this.mt32 = ByteUtilities.getFloat((byte[])b, (int)190);
        this.mt33 = ByteUtilities.getFloat((byte[])b, (int)194);
        this.filterCutoffR = ByteUtilities.getFloat((byte[])b, (int)198);
        this.filterResolutionR = ByteUtilities.getFloat((byte[])b, (int)202);
        this.filterCodeR = ByteUtilities.getShort((byte[])b, (int)206);
        this.filterOrderR = ByteUtilities.getShort((byte[])b, (int)208);
        this.filterCutoffZ = ByteUtilities.getFloat((byte[])b, (int)210);
        this.filterResolutionZ = ByteUtilities.getFloat((byte[])b, (int)214);
        this.filterCodeZ = ByteUtilities.getShort((byte[])b, (int)218);
        this.filterOrderZ = ByteUtilities.getShort((byte[])b, (int)220);
        this.mt14 = ByteUtilities.getFloat((byte[])b, (int)224);
        this.mt24 = ByteUtilities.getFloat((byte[])b, (int)228);
        this.mt34 = ByteUtilities.getFloat((byte[])b, (int)232);
        this.scatterType = ByteUtilities.getShort((byte[])b, (int)234);
        this.reconType = ByteUtilities.getShort((byte[])b, (int)236);
        this.reconViews = ByteUtilities.getShort((byte[])b, (int)238);
        for (i = 0; i < 87; ++i) {
            this.fillCti[i] = ByteUtilities.getShort((byte[])b, (int)(240 + 2 * i));
        }
        for (i = 0; i < 48; ++i) {
            this.fillUser[i] = ByteUtilities.getShort((byte[])b, (int)(414 + 2 * i));
        }
        switch (this.dataType) {
            case 0: {
                this.dataTypeS = "Unknown Matrix Data Type";
                break;
            }
            case 1: {
                this.dataTypeS = "Byte Data";
                break;
            }
            case 2: {
                this.dataTypeS = "VAX_Ix2";
                break;
            }
            case 3: {
                this.dataTypeS = "VAX_Ix4";
                break;
            }
            case 4: {
                this.dataTypeS = "VAX_Rx4";
                break;
            }
            case 5: {
                this.dataTypeS = "IEEE Float";
                break;
            }
            case 6: {
                this.dataTypeS = "Sun short";
                break;
            }
            case 7: {
                this.dataTypeS = "Sun long";
                break;
            }
        }
        switch (this.filterCode) {
            case 0: {
                this.filterCodeS = "all pass";
                break;
            }
            case 1: {
                this.filterCodeS = "ramp";
                break;
            }
            case 2: {
                this.filterCodeS = "Butterworth";
                break;
            }
            case 3: {
                this.filterCodeS = "Hanning";
                break;
            }
            case 4: {
                this.filterCodeS = "Hamming";
                break;
            }
            case 5: {
                this.filterCodeS = "Parzen";
                break;
            }
            case 6: {
                this.filterCodeS = "Shepp";
                break;
            }
            case 7: {
                this.filterCodeS = "Butterworth-order";
                break;
            }
            case 8: {
                this.filterCodeS = "Gaussian";
                break;
            }
            case 9: {
                this.filterCodeS = "Median";
                break;
            }
            case 10: {
                this.filterCodeS = "Boxcar";
                break;
            }
        }
        switch (this.processingCode) {
            case 0: {
                this.processingCodeS = "Not Processed";
                break;
            }
            case 1: {
                this.processingCodeS = "Normalized";
                break;
            }
            case 2: {
                this.processingCodeS = "Measured Attenuation COrrection";
                break;
            }
            case 4: {
                this.processingCodeS = "Calculated Attenuation Correction";
                break;
            }
            case 8: {
                this.processingCodeS = "X smoothing";
                break;
            }
            case 16: {
                this.processingCodeS = "Y smoothing";
                break;
            }
            case 32: {
                this.processingCodeS = "Z smoothing";
                break;
            }
            case 64: {
                this.processingCodeS = "2D scatter correction";
                break;
            }
            case 128: {
                this.processingCodeS = "3D scatter correction";
                break;
            }
            case 256: {
                this.processingCodeS = "Arc correction";
                break;
            }
            case 512: {
                this.processingCodeS = "Decay correction";
                break;
            }
            case 1024: {
                this.processingCodeS = "Online compression";
                break;
            }
            default: {
                this.processingCodeS = "Other";
            }
        }
        switch (this.scatterType) {
            case 0: {
                this.scatterTypeS = "None";
                break;
            }
            case 1: {
                this.scatterTypeS = "Deconvolution";
                break;
            }
            case 2: {
                this.scatterTypeS = "Simulated";
                break;
            }
            case 3: {
                this.scatterTypeS = "Dual Energy";
                break;
            }
        }
        switch (this.reconType) {
            case 0: {
                this.reconTypeS = "Filtered backprojection";
                break;
            }
            case 1: {
                this.reconTypeS = "Forward projection 3D (PROMIS)";
                break;
            }
            case 2: {
                this.reconTypeS = "Ramp 3D";
                break;
            }
            case 3: {
                this.reconTypeS = "FAVOR 3D";
                break;
            }
            case 4: {
                this.reconTypeS = "SSRB";
                break;
            }
            case 5: {
                this.reconTypeS = "Multi-slice rebinning";
                break;
            }
            case 6: {
                this.reconTypeS = "FORE";
                break;
            }
            default: {
                this.reconTypeS = "Other";
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2048);
        sb.append("Image Subheader, first record: ").append(this.dataFirst).append(", last record: ").append(this.dataLast).append("\n\ndata type: ").append(this.dataType).append(" (").append(this.dataTypeS).append(")\nnum dimensions: ").append(this.numDimensions).append("\nx dimension: ").append(this.dimX).append("\ny dimension: ").append(this.dimY).append("\nz dimension: ").append(this.dimZ).append("\nx offset: ").append(this.offsetX).append("\ny offset: ").append(this.offsetY).append("\nz offset: ").append(this.offsetZ).append("\nrecon zoom: ").append(this.reconZoom).append("\nscale factor: ").append(this.scaleFactor).append("\nimage min: ").append(this.imageMin).append("\nimage max: ").append(this.imageMax).append("\nx pixel size: ").append(this.pixelSizeX).append("\ny pixel size: ").append(this.pixelSizeY).append("\nz pixel size: ").append(this.pixelSizeZ).append("\nframe duration: ").append(this.frameDuration).append(" ms\nframe start time: ").append(this.frameStartTime).append(" ms  # offset from first frame\nfilter code: ").append(this.filterCode).append(" (").append(this.filterCodeS).append(")\nx resolution: ").append(this.resolutionX).append("\ny resolution: ").append(this.resolutionY).append("\nz resolution: ").append(this.resolutionZ).append("\nnum r elements: ").append(this.numElementsR).append("\nnum angles: ").append(this.numAngles).append("\nz rotation angle: ").append(this.rotationAngleZ).append("\ndecay corr factor: ").append(this.decayCorrFactor).append("\nprocessing code: ").append(this.processingCode).append(" (").append(this.processingCodeS).append(")\ngate duration: ").append(this.gateDuration).append("\nr wave offset: ").append(this.waveOffsetR).append("\nnum accepted beats: ").append(this.numAcceptedBeats).append("\nfilter cutoff frequency: ").append(this.filterCutoffFreq).append("\nfilter resolution: ").append(this.filterResolution).append("\nfilter ramp slope: ").append(this.filterRampSlope).append("\nfilter filter order: ").append(this.filterOrder).append("\nfilter scatter fraction: ").append(this.filterScatterFraction).append("\nfilter scatter slope: ").append(this.filterScatterSlope).append("\nannotation: ").append(this.annotation).append("\nmt 1 1: ").append(this.mt11).append("\nmt 1 2: ").append(this.mt12).append("\nmt 1 3: ").append(this.mt13).append("\nmt 2 1: ").append(this.mt21).append("\nmt 2 2: ").append(this.mt22).append("\nmt 2 3: ").append(this.mt23).append("\nmt 3 1: ").append(this.mt31).append("\nmt 3 2: ").append(this.mt32).append("\nmt 3 3: ").append(this.mt33).append("\nrfilter cutoff: ").append(this.filterCutoffR).append("\nrfilter resolution: ").append(this.filterResolutionR).append("\nrfilter code: ").append(this.filterCodeR).append("\nrfilter order: ").append(this.filterOrderR).append("\nzfilter cutoff: ").append(this.filterCutoffZ).append("\nzfilter resolution: ").append(this.filterResolutionZ).append("\nzfilter code: ").append(this.filterCodeZ).append("\nzfilter order: ").append(this.filterOrderZ).append("\nmt 1 4: ").append(this.mt14).append("\nmt 2 4: ").append(this.mt24).append("\nmt 3 4: ").append(this.mt34).append("\nscatter type: ").append(this.scatterType).append(" (").append(this.scatterTypeS).append(")\nrecon type: ").append(this.reconType).append(" (").append(this.reconTypeS).append(")\nrecon views: ").append(this.reconViews).append('\n');
        return sb.toString();
    }
}

