/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.cti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.volume.formats.cti.Record;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class DirectoryList
extends Record {
    @Override
    public void out() {
        this.out("dir_list.doc");
    }

    @Override
    public void out(String outfile) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(outfile));
            for (int i = 0; i < 32; ++i) {
                out.println("identifier: " + this.getIdentifier(i) + ", first record: " + this.getFirstRecord(i) + ", last record: " + this.getLastRecord(i) + ", matrix status: " + this.getMatrixStatus(i));
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private int getIdentifier(int i) {
        return ByteUtilities.getInt((byte[])this.b, (int)(16 * i + 0));
    }

    private void init() {
        this.b = new byte[512];
    }

    private void setFirstRecord(int i, byte[] four) {
        if ((four == null || four.length != 4) && AppLogger.isDebugEnabled()) {
            AppLogger.debug((String)"DirectoryList.setFirstRecord error");
        }
        for (int j = 0; j < 4; ++j) {
            this.b[16 * i + 4 + j] = four[j];
        }
    }

    private void setIdentifier(int i, byte[] four) {
        if ((four == null || four.length != 4) && AppLogger.isDebugEnabled()) {
            AppLogger.debug((String)"DirectoryList.setIdentifier error");
        }
        for (int j = 0; j < 4; ++j) {
            this.b[16 * i + 0 + j] = four[j];
        }
    }

    private void setLastRecord(int i, byte[] four) {
        if ((four == null || four.length != 4) && AppLogger.isDebugEnabled()) {
            AppLogger.debug((String)"DirectoryList.setLastRecord error");
        }
        for (int j = 0; j < 4; ++j) {
            this.b[16 * i + 8 + j] = four[j];
        }
    }

    private void setMatrix(int i, int ident, int first, int last, int status) {
        byte[] four = ByteUtilities.getBytes((int)ident);
        this.setIdentifier(i, four);
        four = ByteUtilities.getBytes((int)first);
        this.setFirstRecord(i, four);
        four = ByteUtilities.getBytes((int)last);
        this.setLastRecord(i, four);
        four = ByteUtilities.getBytes((int)status);
        this.setMatrixStatus(i, four);
    }

    private void setMatrixStatus(int i, byte[] four) {
        if ((four == null || four.length != 4) && AppLogger.isDebugEnabled()) {
            AppLogger.debug((String)"DirectoryList.setMatrixStatus error");
        }
        for (int j = 0; j < 4; ++j) {
            this.b[16 * i + 12 + j] = four[j];
        }
    }

    protected int getFirstRecord(int i) {
        return ByteUtilities.getInt((byte[])this.b, (int)(16 * i + 4));
    }

    protected int getLastRecord(int i) {
        return ByteUtilities.getInt((byte[])this.b, (int)(16 * i + 8));
    }

    protected int getMatrixStatus(int i) {
        return ByteUtilities.getInt((byte[])this.b, (int)(16 * i + 12));
    }

    protected void setDefault() {
        if (this.b == null) {
            this.init();
        }
        this.setMatrix(0, 30, 2, 0, 1);
        this.setMatrix(1, 0x1010001, 3, 4035, 1);
        for (int i = 2; i < 32; ++i) {
            this.setMatrix(i, 0, 0, 0, 0);
        }
    }
}

