/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.afni;

import java.util.StringTokenizer;

public class Attribute {
    private final Object data;
    private final String name;
    private final String type;
    private final int count;
    public static final String ATTRIBUTE_FLT = "float-attribute";
    public static final String ATTRIBUTE_INT = "integer-attribute";
    public static final String ATTRIBUTE_STR = "string-attribute";

    protected Attribute(String name, String type, String count, String data) {
        this.name = name;
        this.type = type;
        this.count = Integer.parseInt(count.trim());
        this.data = this.parseData(data);
        if (this.data == null) {
            throw new IllegalArgumentException("Invalid attribute! (" + name + ")");
        }
    }

    public int getCount() {
        return this.count;
    }

    public Object getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("type = " + this.type + "\nname = " + this.name + "\ncount = " + this.count + "\n");
        if (this.type.equals(ATTRIBUTE_STR)) {
            sb.append("'" + this.data + "~\n");
        } else if (this.type.equals(ATTRIBUTE_INT)) {
            int[] dataInt;
            StringBuffer sbDataStr = new StringBuffer();
            for (int element : dataInt = (int[])this.data) {
                sbDataStr.append(element);
                sbDataStr.append(' ');
            }
            sb.append(sbDataStr.toString());
            sb.append('\n');
        } else if (this.type.equals(ATTRIBUTE_FLT)) {
            double[] dataFlt;
            StringBuffer sbDataStr = new StringBuffer();
            for (double element : dataFlt = (double[])this.data) {
                sbDataStr.append(element);
                sbDataStr.append(' ');
            }
            sb.append(sbDataStr.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private Object parseData(String dataStr) {
        if (this.type.equals(ATTRIBUTE_STR)) {
            int startIndex = dataStr.indexOf(39);
            int endIndex = dataStr.indexOf(126);
            if (startIndex != -1 && endIndex != -1) {
                return dataStr.substring(startIndex + 1, endIndex);
            }
            return dataStr;
        }
        if (this.type.equals(ATTRIBUTE_INT)) {
            int[] dataInt = new int[this.count];
            StringTokenizer tokenizer = new StringTokenizer(dataStr);
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                dataInt[index++] = Integer.parseInt(token);
            }
            return dataInt;
        }
        if (this.type.equals(ATTRIBUTE_FLT)) {
            double[] datadouble = new double[this.count];
            StringTokenizer tokenizer = new StringTokenizer(dataStr);
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                datadouble[index++] = Double.parseDouble(token);
            }
            return datadouble;
        }
        return null;
    }
}

