/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import Jama.Matrix;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Bookmark;
import edu.uthscsa.ric.volume.ClusterFilter;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageIntent;
import edu.uthscsa.ric.volume.ImageListener;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.LabelList;
import edu.uthscsa.ric.volume.LabelListener;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Metadata;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.SimpleTransform;
import edu.uthscsa.ric.volume.TimepointUser;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.VolumeUser;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.VoxelValue;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.afni.AFNI;
import edu.uthscsa.ric.volume.formats.analyze.AVW;
import edu.uthscsa.ric.volume.formats.cti.CTI;
import edu.uthscsa.ric.volume.formats.dicom.DICOM;
import edu.uthscsa.ric.volume.formats.dicom.ExportableSOPClassMR;
import edu.uthscsa.ric.volume.formats.dicom.ExportableSOPClassPET;
import edu.uthscsa.ric.volume.formats.dicom.ExportableSOPClassSC;
import edu.uthscsa.ric.volume.formats.dicom.Series;
import edu.uthscsa.ric.volume.formats.micropet.MicroPET;
import edu.uthscsa.ric.volume.formats.minc.MINC1;
import edu.uthscsa.ric.volume.formats.minc.MINC2;
import edu.uthscsa.ric.volume.formats.nema.NEMA;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI2;
import edu.uthscsa.ric.volume.formats.stimulate.Stimulate;
import edu.uthscsa.ric.volume.formats.tiff.TIFF;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.range.SeriesRangeOp;
import edu.uthscsa.ric.volume.operations.range.VolumeRangeOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public final class Volume
implements ImageListener,
ImageVolume,
TimepointUser,
LabelManager {
    private Header header;
    private Image image;
    private LabelList labels;
    private LabelListener labelListener;
    private Orientation orientation;
    private ProgressBarListener pbListener;
    private String title;
    private Transform transform;
    private Transform transformOrientation;
    private Transform transformWorld;
    private VolumeUser user;
    private VoxelValue voxelValue;
    private boolean binary;
    private boolean cannotBeOverwritten;
    private boolean forceDisplayIndex;
    private boolean forceDisplayWorld;
    private boolean forceLoadInThread;
    private boolean headerIsDirty;
    private boolean imageIsDirty;
    private boolean initialized;
    private boolean operationInProgress;
    private boolean orientationChanged;
    private boolean readOnly;
    private boolean usingTransform;
    private boolean hadInvalidOrigin;
    private byte[] extension;
    private int coordSpaceIndex;
    private int currentTimepoint;
    private int loadedVolumes;
    private int numTimepoints;
    private int seriesOffset;
    private int seriesOffsetOriginalRange;
    private int seriesOffsetRange;
    private int volumeSizeVoxels;
    private int bookmarkIndex;
    private final List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    private final List<VolumeListener> listeners = new ArrayList<VolumeListener>();
    private static boolean loadedExtendedFormats;
    public static final int NO_LOADED_VOLUMES_RECORDED = -1;

    public static void addReadableHeader(ReadableHeader rh) {
        Header.addReadableHeader(rh);
    }

    public static void addWritableHeader(WritableHeader wh) {
        Header.addWritableHeader(wh);
    }

    public static double[] findDisplayRange(double max) {
        double rangeMax = max - max * 0.25;
        double rangeMin = max - max * 0.75;
        if (!(rangeMin < 1.0 && rangeMin > -1.0 && rangeMax < 1.0 && rangeMax > -1.0)) {
            rangeMin = (int)Math.round(rangeMin);
            rangeMax = (int)Math.round(rangeMax);
        }
        return new double[]{rangeMin, rangeMax};
    }

    public static synchronized void loadFormats() {
        if (!loadedExtendedFormats) {
            loadedExtendedFormats = true;
            Volume.addReadableHeader((ReadableHeader)new ExportableSOPClassSC());
            Volume.addReadableHeader((ReadableHeader)new ExportableSOPClassPET());
            Volume.addReadableHeader((ReadableHeader)new ExportableSOPClassMR());
            Volume.addReadableHeader((ReadableHeader)new Series());
            Volume.addReadableHeader(new NIFTI());
            Volume.addReadableHeader(new NIFTI2());
            Volume.addReadableHeader(new AVW());
            Volume.addReadableHeader(new NEMA());
            Volume.addReadableHeader(new CTI());
            Volume.addReadableHeader((ReadableHeader)new Stimulate());
            Volume.addReadableHeader(new TIFF());
            Volume.addReadableHeader(new MicroPET());
            Volume.addReadableHeader(new AFNI());
            Volume.addReadableHeader(new MINC1());
            Volume.addReadableHeader(new MINC2());
            Volume.addWritableHeader(new AVW());
            Volume.addWritableHeader(new NEMA());
            Volume.addWritableHeader((WritableHeader)new ExportableSOPClassSC());
            Volume.addWritableHeader((WritableHeader)new ExportableSOPClassPET());
            Volume.addWritableHeader((WritableHeader)new ExportableSOPClassMR());
            Volume.addWritableHeader(new NIFTI());
            Volume.addWritableHeader(new NIFTI2());
            Volume.addWritableHeader(new Stimulate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readTransformFile(File transformFile) {
        double[] matParams = new double[16];
        int count = 0;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(transformFile));
            String line = reader.readLine();
            while (line != null && count < 16) {
                String[] nums = line.split("[ \t]");
                for (int ctr = 0; ctr < nums.length; ++ctr) {
                    if (nums[ctr] != null) {
                        nums[ctr] = nums[ctr].trim();
                    }
                    if (nums[ctr].length() == 0) continue;
                    matParams[count] = Double.parseDouble(nums[ctr]);
                    ++count;
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            matParams = null;
        }
        catch (NumberFormatException ex) {
            AppLogger.error((Throwable)ex);
            matParams = null;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return matParams;
    }

    private static void updateHeaderOrientationContingentInfo(String orientationString, String oldOrientationString, ImageDimensions id, VoxelDimensions vd) {
        double oldSliceSize;
        double oldRowSize;
        double oldColSize;
        int oldSlices;
        int oldRows;
        int oldCols;
        ImageDimensions idOld = id;
        int cols = oldCols = idOld.getCols();
        int rows = oldRows = idOld.getRows();
        int slices = oldSlices = idOld.getSlices();
        if (orientationString.charAt(0) != oldOrientationString.charAt(0)) {
            if (orientationString.charAt(0) == oldOrientationString.charAt(1)) {
                cols = oldRows;
            } else if (orientationString.charAt(0) == oldOrientationString.charAt(2)) {
                cols = oldSlices;
            }
        }
        if (orientationString.charAt(1) != oldOrientationString.charAt(1)) {
            if (orientationString.charAt(1) == oldOrientationString.charAt(0)) {
                rows = oldCols;
            } else if (orientationString.charAt(1) == oldOrientationString.charAt(2)) {
                rows = oldSlices;
            }
        }
        if (orientationString.charAt(2) != oldOrientationString.charAt(2)) {
            if (orientationString.charAt(2) == oldOrientationString.charAt(0)) {
                slices = oldCols;
            } else if (orientationString.charAt(2) == oldOrientationString.charAt(1)) {
                slices = oldRows;
            }
        }
        ImageDimensions idNew = new ImageDimensions(cols, rows, slices, idOld.getTimepoints());
        idNew.setImageOffset(idOld.getImageOffset());
        idOld.setValues(idNew, false);
        VoxelDimensions vdOld = vd;
        double colSize = oldColSize = vdOld.getColSize(false);
        double rowSize = oldRowSize = vdOld.getRowSize(false);
        double sliceSize = oldSliceSize = vdOld.getSliceThickness(false);
        if (orientationString.charAt(0) != oldOrientationString.charAt(0)) {
            if (orientationString.charAt(0) == oldOrientationString.charAt(1)) {
                colSize = oldRowSize;
            } else if (orientationString.charAt(0) == oldOrientationString.charAt(2)) {
                colSize = oldSliceSize;
            }
        }
        if (orientationString.charAt(1) != oldOrientationString.charAt(1)) {
            if (orientationString.charAt(1) == oldOrientationString.charAt(0)) {
                rowSize = oldColSize;
            } else if (orientationString.charAt(1) == oldOrientationString.charAt(2)) {
                rowSize = oldSliceSize;
            }
        }
        if (orientationString.charAt(2) != oldOrientationString.charAt(2)) {
            if (orientationString.charAt(2) == oldOrientationString.charAt(0)) {
                sliceSize = oldColSize;
            } else if (orientationString.charAt(2) == oldOrientationString.charAt(1)) {
                sliceSize = oldRowSize;
            }
        }
        VoxelDimensions vdNew = new VoxelDimensions(colSize, rowSize, sliceSize, vdOld.getTR());
        vdNew.setSpatialUnit(vdOld.getSpatialUnit());
        vdNew.setTemporalUnit(vdOld.getTemporalUnit());
        vdNew.setTE1(vdOld.getTE1());
        vdNew.setTE2(vdOld.getTE2());
        vdOld.setValues(vdNew, false);
    }

    public Volume() {
        this.header = new Header();
        this.image = new Image();
        this.image.setUser(this);
        this.loadedVolumes = -1;
    }

    public Volume(File file) throws InvalidHeaderException, VolumeIOException {
        this(file.toURI());
    }

    public Volume(Header header, boolean compression, ByteBuffer[] buffer) throws InvalidHeaderException {
        this.loadedVolumes = -1;
        this.setHeader(header, compression, buffer);
    }

    public Volume(URI uri) throws InvalidHeaderException, VolumeIOException {
        this();
        this.readFiles(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(VolumeListener listener) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void anonymize() {
        this.header.anonymize();
    }

    public boolean cannotBeOverwritten() {
        return this.cannotBeOverwritten;
    }

    public void clear(boolean force) {
        if (force || this.listeners.size() == 0) {
            this.initialized = false;
            if (this.image != null) {
                this.image.clear();
                this.image = null;
            }
            if (this.header != null) {
                this.header.clear();
                this.header = null;
            }
            if (this.voxelValue != null) {
                this.voxelValue.clear();
                this.voxelValue = null;
            }
            if (this.orientation != null) {
                this.orientation.clear();
                this.orientation = null;
            }
            if (this.transform != null) {
                this.transform.clear();
                this.transform = null;
            }
            if (this.transformOrientation != null) {
                this.transformOrientation.clear();
                this.transformOrientation = null;
            }
            if (this.transformWorld != null) {
                this.transformWorld.clear();
                this.transformWorld = null;
            }
            this.pbListener = null;
            this.user = null;
            this.labels = null;
            this.labelListener = null;
            this.extension = null;
            this.cannotBeOverwritten = false;
            this.forceDisplayIndex = false;
            this.forceDisplayWorld = false;
            this.setHeaderDirty(false);
            this.setImageDirty(false);
            this.operationInProgress = false;
            this.orientationChanged = false;
            this.forceLoadInThread = false;
            this.coordSpaceIndex = 0;
            this.currentTimepoint = 0;
            this.seriesOffset = 0;
            this.seriesOffsetRange = 0;
            this.seriesOffsetOriginalRange = 0;
            this.loadedVolumes = 0;
            this.numTimepoints = 0;
            this.volumeSizeVoxels = 0;
        }
    }

    public void clearImage() {
        if (this.image != null) {
            this.image.clear();
        }
    }

    public double[][] convertFromCoordinateTransform(double[][] mat, boolean useOrigin, boolean useCurrent, Object obj) {
        int ctrIn;
        int ctrOut;
        int sagittalPos;
        int coronalPos;
        int axialPos;
        int xDim = this.getXDim();
        int yDim = this.getYDim();
        int zDim = this.getZDim();
        double xSize = this.getXSize();
        double ySize = this.getYSize();
        double zSize = this.getZSize();
        if (useOrigin) {
            Coordinate origin = this.getOrigin();
            axialPos = (int)Math.round(origin.zDbl);
            coronalPos = (int)Math.round(origin.yDbl);
            sagittalPos = (int)Math.round(origin.xDbl);
        } else if (useCurrent) {
            Coordinate coor = (Coordinate)obj;
            axialPos = (int)Math.round(coor.zDbl);
            coronalPos = (int)Math.round(coor.yDbl);
            sagittalPos = (int)Math.round(coor.xDbl);
        } else {
            axialPos = zDim / 2;
            coronalPos = yDim / 2;
            sagittalPos = xDim / 2;
        }
        double[][] center = new double[4][4];
        double[][] centerInverse = new double[4][4];
        center[3][3] = 1.0;
        center[2][2] = 1.0;
        center[1][1] = 1.0;
        center[0][0] = 1.0;
        center[0][3] = (double)(-1 * sagittalPos) * xSize;
        center[1][3] = (double)(-1 * coronalPos) * ySize;
        center[2][3] = (double)(-1 * axialPos) * zSize;
        centerInverse[3][3] = 1.0;
        centerInverse[2][2] = 1.0;
        centerInverse[1][1] = 1.0;
        centerInverse[0][0] = 1.0;
        centerInverse[0][3] = (double)sagittalPos * xSize;
        centerInverse[1][3] = (double)coronalPos * ySize;
        centerInverse[2][3] = (double)axialPos * zSize;
        double[][] size = new double[4][4];
        double[][] sizeInverse = new double[4][4];
        size[0][0] = xSize;
        size[1][1] = ySize;
        size[2][2] = zSize;
        size[3][3] = 1.0;
        sizeInverse[0][0] = 1.0 / xSize;
        sizeInverse[1][1] = 1.0 / ySize;
        sizeInverse[2][2] = 1.0 / zSize;
        sizeInverse[3][3] = 1.0;
        double[][] transformTemp = new double[4][4];
        double[][] transformTemp2 = new double[4][4];
        double[][] finalTransform = new double[4][4];
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                transformTemp[ctrOut][ctrIn] = sizeInverse[ctrOut][0] * centerInverse[0][ctrIn] + sizeInverse[ctrOut][1] * centerInverse[1][ctrIn] + sizeInverse[ctrOut][2] * centerInverse[2][ctrIn] + sizeInverse[ctrOut][3] * centerInverse[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                transformTemp2[ctrOut][ctrIn] = transformTemp[ctrOut][0] * mat[0][ctrIn] + transformTemp[ctrOut][1] * mat[1][ctrIn] + transformTemp[ctrOut][2] * mat[2][ctrIn] + transformTemp[ctrOut][3] * mat[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                transformTemp[ctrOut][ctrIn] = transformTemp2[ctrOut][0] * center[0][ctrIn] + transformTemp2[ctrOut][1] * center[1][ctrIn] + transformTemp2[ctrOut][2] * center[2][ctrIn] + transformTemp2[ctrOut][3] * center[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                finalTransform[ctrOut][ctrIn] = transformTemp[ctrOut][0] * size[0][ctrIn] + transformTemp[ctrOut][1] * size[1][ctrIn] + transformTemp[ctrOut][2] * size[2][ctrIn] + transformTemp[ctrOut][3] * size[3][ctrIn];
            }
        }
        return finalTransform;
    }

    public long convertIndexToOffset(int xLoc, int yLoc, int zLoc) {
        return this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc);
    }

    public double[][] convertToIndexTransform(double[][] mat) {
        int ctrIn;
        int ctrOut;
        double xSize = this.getXSize();
        double ySize = this.getYSize();
        double zSize = this.getZSize();
        double[][] size = new double[4][4];
        double[][] sizeInverse = new double[4][4];
        size[0][0] = xSize;
        size[1][1] = ySize;
        size[2][2] = zSize;
        size[3][3] = 1.0;
        sizeInverse[0][0] = 1.0 / xSize;
        sizeInverse[1][1] = 1.0 / ySize;
        sizeInverse[2][2] = 1.0 / zSize;
        sizeInverse[3][3] = 1.0;
        double[][] transformTemp = new double[4][4];
        double[][] finalTransform = new double[4][4];
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                transformTemp[ctrOut][ctrIn] = sizeInverse[ctrOut][0] * mat[0][ctrIn] + sizeInverse[ctrOut][1] * mat[1][ctrIn] + sizeInverse[ctrOut][2] * mat[2][ctrIn] + sizeInverse[ctrOut][3] * mat[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                finalTransform[ctrOut][ctrIn] = transformTemp[ctrOut][0] * size[0][ctrIn] + transformTemp[ctrOut][1] * size[1][ctrIn] + transformTemp[ctrOut][2] * size[2][ctrIn] + transformTemp[ctrOut][3] * size[3][ctrIn];
            }
        }
        return finalTransform;
    }

    public void copyDataToTempBuffer() {
        this.image.copyDataToTempBuffer(this.currentTimepoint, this.header.getImageDimensions().getNumVoxelsVolume(), this.readOnly ? this.header.getImageType().getNumBytesPerVoxel() : 4);
    }

    public ByteBuffer copyImage(File imageFile, ImageBounds ib) {
        ImageDimensions id = this.header.getImageDimensions();
        VoxelDimensions vd = this.header.getVoxelDimensions();
        ImageType it = this.header.getImageType();
        ByteBuffer buffer = this.image.doWriteWorkBufferToFile(imageFile, null, this, this.voxelValue, null, -1, false, false, false, false, this.orientation.getOrientation(), null, id, ib, vd.getXSize(), vd.getYSize(), vd.getZSize(), 1.0, 1.0, it, false, false, false, false, -1, false, true, false, false, -1.0, false, false, false, false, true, id.getImageTrailer(), false, false, false, true);
        return buffer;
    }

    public ImageTransform createTransform(Matrix mat) {
        Transform xform = new Transform(this, mat.inverse(), "", 0, this.voxelValue, this.orientation, this.header.getVoxelDimensions(), this.header.getImageDimensions());
        xform.setDisableAllNotifications();
        return xform;
    }

    public void doReadFiles() throws InvalidHeaderException, VolumeIOException {
        StringBuffer buf = new StringBuffer();
        if (!this.header.isValid(buf)) {
            throw new InvalidHeaderException(buf.toString());
        }
        if (!this.readOnly && this.header.getImageType().getNumBytesPerVoxel() == 8 && this.user != null) {
            this.user.showWarningMessage("This is a 64-bit image.  Internal data storage\nis 32-bit.  Some precision may be lost.", "Warning");
        }
        if (this.header.isMultiFileFormat()) {
            this.header.setImageFile(this.header.getMultiImageFiles()[0]);
            this.header.getImageDimensions().setImageOffset(0);
            this.cannotBeOverwritten = true;
        }
        ByteBuffer[] buffers = null;
        if (this.header.getReadable() != null) {
            if (!(this.header.getReadable() instanceof WritableHeader)) {
                this.cannotBeOverwritten = true;
            }
            try {
                buffers = this.header.getReadable().getImageBuffers();
            }
            catch (AbstractMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
            catch (NoSuchMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
            if (CollectionUtilities.isEmpty((Object)buffers) && this.header.getReadable().getImage() != null) {
                buffers = new ByteBuffer[]{this.header.getReadable().getImage()};
            }
        }
        if (this.header.isNIFTI()) {
            this.extension = this.header.getNIFTIObject().getExtension();
        }
        if (CollectionUtilities.isNotEmpty(buffers)) {
            this.image.setBuffers(buffers);
            if (this.header.getImageType().isReadOnly()) {
                this.setReadOnly(true);
            }
        } else {
            this.image.readFile(this.header, this.header.getImageFile(), this.header.getReadable() != null && !(this.header.getReadable() instanceof NIFTI) || this.forceLoadInThread, this.readOnly && (this.header.getImageType().getByteType() == 2 || this.header.getImageType().getByteType() == 3));
        }
        if (this.header.isVariableSliceSpacing()) {
            if (!Header.checkSliceSpacingAcrossTimepoints(this.header.getSliceSpacing(), this.header.getImageDimensions().getSlices(), this.header.getImageDimensions().getTimepoints())) {
                throw new InvalidHeaderException("Slice spacing varies across series points.");
            }
            this.image.fixVariableSpacing(this.header.getImageDimensions(), this.header.getVoxelDimensions(), this.header.getImageRange(), this.header.getSliceSpacing(), Header.convertSliceSpacingToRatios(this.header.getSliceSpacing(), this.header.getImageDimensions().getSlices()));
        }
        this.volumeSizeVoxels = this.header.getVolumeSizeVoxels();
        this.buildVolume();
    }

    public void updateDisplayRangeToImageRange() {
        if (this.header.getImageRange().getDisplayMax() <= this.header.getImageRange().getDisplayMin()) {
            this.header.setDisplayMaxMin(this.header.getImageRange().getImageMax(), this.header.getImageRange().getImageMin());
        }
    }

    public boolean updateDisplayRangeBasedOnImageRange(boolean negative) {
        double imageMin = this.header.getImageRange().getImageMin();
        double imageMax = this.header.getImageRange().getImageMax();
        double rangeMin = 0.0;
        double rangeMax = 0.0;
        boolean isNegative = negative | (imageMin <= 0.0 && imageMax <= 0.0 && imageMin != imageMax);
        if (isNegative) {
            rangeMax = imageMin - imageMin * 0.25;
            rangeMin = imageMin - imageMin * 0.75;
        } else {
            rangeMax = imageMax - imageMax * 0.25;
            rangeMin = imageMax - imageMax * 0.75;
        }
        if (!(rangeMin < 1.0 && rangeMin > -1.0 && rangeMax < 1.0 && rangeMax > -1.0)) {
            rangeMin = (int)Math.round(rangeMin);
            rangeMax = (int)Math.round(rangeMax);
        }
        if (!MathUtilities.essentiallyEqual((double)rangeMax, (double)rangeMin)) {
            this.header.setDisplayMaxMin(rangeMax, rangeMin);
        }
        return isNegative;
    }

    public Range findRangeSeries() {
        SeriesRangeOp op = new SeriesRangeOp(this.user, this);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.user, op);
        return builder.runSynchronously();
    }

    public Range findRangeSeriesSlowly() {
        VolumeRangeOp op = new VolumeRangeOp(this.user, this);
        return op.process(this.getImageBounds());
    }

    public Range findRangeVolume() {
        VolumeRangeOp op = new VolumeRangeOp(this.user, this);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.user, op);
        return builder.runSynchronously();
    }

    public Range findRangeInBounds(ImageBounds ib) {
        VolumeRangeOp op = new VolumeRangeOp(this.user, this);
        return op.process(ib);
    }

    public void findRangeVolumeAsync(final Object source) {
        VolumeRangeOp op = new VolumeRangeOp(this.user, this);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.user, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                Volume.this.updateMaxMin(source, (Range)result);
            }
        });
    }

    public void findRangeSeriesAsync(final Object source) {
        SeriesRangeOp op = new SeriesRangeOp(this.user, this);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.user, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                Volume.this.updateMaxMin(source, (Range)result);
            }
        });
    }

    public void findRangeInBoundsAsync(final Object source, final ImageBounds ib) {
        Thread workThread = new Thread(){

            @Override
            public void run() {
                Volume.this.updateMaxMin(source, Volume.this.findRangeInBounds(ib));
            }
        };
        workThread.start();
    }

    public void flipAP() {
        this.setOrientationChanged();
        this.orientation.flipAP();
        this.header.setOrientation(this.orientation.getOrientation());
        this.resetTransforms(true);
        this.setHeaderDirty(true);
        this.notifyListenersVolumeChange(false);
    }

    public void flipLR() {
        this.setOrientationChanged();
        this.orientation.flipLR();
        this.header.setOrientation(this.orientation.getOrientation());
        this.resetTransforms(true);
        this.setHeaderDirty(true);
        this.notifyListenersVolumeChange(false);
    }

    public void flipSI() {
        this.setOrientationChanged();
        this.orientation.flipSI();
        this.header.setOrientation(this.orientation.getOrientation());
        this.resetTransforms(true);
        this.setHeaderDirty(true);
        this.notifyListenersVolumeChange(false);
    }

    public String getAllImageID(int sliceNum) {
        return this.header.getAllImageID(sliceNum);
    }

    public String getAllImageTime(int sliceNum) {
        return this.header.getAllImageTime(sliceNum);
    }

    public double getAxialArea() {
        return this.header.getVoxelDimensions().getAxialArea();
    }

    public String[] getCoordinateSpaceTransforms() {
        String[] options = null;
        Vector<String> optionsVec = new Vector<String>();
        optionsVec.add("Default");
        if (!this.orientationChanged && this.header.isNIFTI()) {
            NIFTI nifti = this.header.getNIFTIObject();
            optionsVec.add(NIFTI.getTransformCodeLabel(nifti.getQFormCode()) + " (Q-form)");
            optionsVec.add(NIFTI.getTransformCodeLabel(nifti.getSFormCode()) + " (S-form)");
        }
        options = optionsVec.toArray(new String[optionsVec.size()]);
        return options;
    }

    public double getCoronalArea() {
        return this.header.getVoxelDimensions().getCoronalArea();
    }

    public int getCurrentIndexTransformIndex() {
        return 0;
    }

    public int getCurrentSeriesPoint() {
        return this.getCurrentTimepoint();
    }

    @Override
    public int getCurrentTimepoint() {
        return this.currentTimepoint;
    }

    public int getCurrentWorldTransformIndex() {
        return 0;
    }

    public double getDisplayMax() {
        return this.header.getDisplayMax();
    }

    public double getDisplayMin() {
        return this.header.getDisplayMin();
    }

    public byte[] getExtension() {
        return this.extension;
    }

    public String getFormatSpecificInfo() {
        return this.header.toString();
    }

    public float getGlobalDataIntercept() {
        return this.header.getImageRange().getDataScaleIntercepts()[0];
    }

    public float getGlobalDataScale() {
        return this.header.getImageRange().getDataScaleSlopes()[0];
    }

    public Header getHeaderCopy() {
        return this.header.copy();
    }

    public Header getHeaderCopyAndReplace(ImageType it, ImageRange ir) {
        return this.header.copyAndReplace(it, ir);
    }

    public ImageBounds getImageBounds() {
        ImageBounds ib = new ImageBounds(0, this.getXDim() - 1, 0, this.getYDim() - 1, 0, this.getZDim() - 1);
        ib.setRangeT(0, this.getNumTimepoints() - 1);
        return ib;
    }

    public ImageDescription getImageDescription() {
        ImageDescription id = null;
        try {
            id = (ImageDescription)this.header.getImageDescription().clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return id;
    }

    public String getImageDescription(int sliceNum) {
        return this.header.getImageDescription(sliceNum);
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions id = null;
        try {
            id = (ImageDimensions)this.header.getImageDimensions().clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return id;
    }

    public URI getImageFile() {
        return this.header.getImageFile();
    }

    public String getImageFilename() {
        return this.header.getImageFilename();
    }

    public String getTitle() {
        String titleValid;
        String title = this.header.getImageDescription().getTitle();
        if (StringUtils.isNotBlank((CharSequence)title) && StringUtils.isBlank((CharSequence)(titleValid = title.replace("UNKNOWN", "")))) {
            title = null;
        }
        return title;
    }

    public ImageIntent getImageIntent() {
        return this.header.getImageIntent();
    }

    public double getImageMax() {
        return this.header.getImageRange().getImageMax();
    }

    public double getImageMin() {
        return this.header.getImageRange().getImageMin();
    }

    public ImageRange getImageRange() {
        ImageRange ir = null;
        try {
            ir = (ImageRange)this.header.getImageRange().clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return ir;
    }

    public ImageTransform getImageTransform() {
        return this.transform;
    }

    public ImageType getImageType() {
        ImageType it = null;
        try {
            it = (ImageType)this.header.getImageType().clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return it;
    }

    public ImageTransform getIndexImageTransform(int num) {
        return this.getIndexTransform(num);
    }

    public Transform getIndexTransform(int num) {
        return this.transform;
    }

    public String getLabel(int index) {
        return this.getLabel(index, null);
    }

    public String getLabel(int index, String defaultStr) {
        String label = null;
        if (this.labels != null) {
            label = this.labels.getLabel(index);
        }
        if (StringUtils.isBlank(label)) {
            return defaultStr;
        }
        return label;
    }

    public byte[] getLabelData() {
        return this.labels.getData();
    }

    public String[] getLabelModel() {
        return this.labels.getLabelModel();
    }

    public String getLoadedHeaderType() {
        return this.header.getLoadedHeaderType();
    }

    public double getMaxImageDiskValue() {
        long offset = this.header.getImageRange().getImageMaxOffset();
        float value = (float)this.header.getImageRange().getImageMax();
        if (offset >= 0L) {
            return this.voxelValue.unformatValue(offset, value);
        }
        return this.voxelValue.unformatValue(value);
    }

    public double getMinImageDiskValue() {
        long offset = this.header.getImageRange().getImageMinOffset();
        float value = (float)this.header.getImageRange().getImageMin();
        if (offset >= 0L) {
            return this.voxelValue.unformatValue(offset, value);
        }
        return this.voxelValue.unformatValue(value);
    }

    public URI[] getMultiImageFiles() {
        return this.header.getMultiImageFiles();
    }

    public long getNativeIntegerValueAtIndex(int xLoc, int yLoc, int zLoc, int seriesIndex) {
        return this.voxelValue.getNativeIntegerValueAt(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc), seriesIndex);
    }

    public NIFTI getNIFTIObject() {
        return this.header.getNIFTIObject();
    }

    @Deprecated
    public int getNumIndexTransforms() {
        return 1;
    }

    public int getNumLoadedVolumes() {
        if (this.loadedVolumes == -1) {
            return this.getNumTimepoints();
        }
        return this.loadedVolumes + 1;
    }

    public int getNumSlices() {
        return this.header.getImageDimensions().getSlices();
    }

    public int getNumTimepoints() {
        return this.numTimepoints;
    }

    public int getNumVoxelsInVolume() {
        return this.header.getImageDimensions().getNumVoxelsVolume();
    }

    @Deprecated
    public int getNumWorldTransforms() {
        return 1;
    }

    public int getOrientationCertainty() {
        return this.header.getOrientationCertainty();
    }

    public String getOrientationDescription() {
        if (this.isWorldSpaceOnly()) {
            return "Data order not specified.";
        }
        return this.orientation.getOrientationDescription();
    }

    public String getOrientationString() {
        return this.orientation.getOrientation();
    }

    public double[][] getOrientMatrix() {
        return this.orientation.getOrientMat();
    }

    public int getOrientXIncrement() {
        return this.orientation.getXIncrement();
    }

    public int getOrientYIncrement() {
        return this.orientation.getYIncrement();
    }

    public int getOrientZIncrement() {
        return this.orientation.getZIncrement();
    }

    public Coordinate getOrigin() {
        Coordinate origin = new Coordinate();
        origin.setValues(this.orientation.convertCoordinate(this.header.getOrigin()));
        return origin;
    }

    public Coordinate getOriginNative() {
        return new Coordinate(this.header.getOrigin());
    }

    public Coordinate getOriginNativeOffsets() {
        if (this.header.isNIFTI()) {
            NIFTI nifti = this.header.getNIFTIObject();
            if (nifti.getSFormCode() > 0) {
                return new Coordinate(nifti.getSFormMatArray()[0][3], nifti.getSFormMatArray()[1][3], nifti.getSFormMatArray()[2][3]);
            }
            return new Coordinate(nifti.getOffsetX(), nifti.getOffsetY(), nifti.getOffsetZ());
        }
        return this.getOrigin();
    }

    public Coordinate getOriginOriginal() {
        Coordinate origin = new Coordinate();
        origin.setValues(this.orientation.convertCoordinate(this.header.getOriginOriginal()));
        return origin;
    }

    public ProgressBarListener getProgressBarListener() {
        return this.pbListener;
    }

    public double getRawVoxelValueAtIndex(int xLoc, int yLoc, int zLoc) {
        return this.getVoxelValueAtIndexDataScaleOption(xLoc, yLoc, zLoc, this.currentTimepoint, false);
    }

    public double getRawVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc) {
        return this.getVoxelValueAtIndexDataScaleOption(xLoc, yLoc, zLoc, tLoc, false);
    }

    public double getRawVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                return ((Transform)transform).getValueAt(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, true);
            }
            return this.voxelValue.getRawValueForOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels);
        }
        return 0.0;
    }

    public double getRawVoxelValueForOffset(long offset) {
        return this.voxelValue.getRawValueForOffset(offset);
    }

    public ReadableHeader getReadableHeader() {
        return this.header.getReadable();
    }

    public double getRealTimeAcrossVolumes() {
        return Header.getRealTimeAcrossVolumes(this.header.getVolumeTiming());
    }

    public double getRealTimeOffset(int volIndex) {
        return this.header.getRealTimeOffset(volIndex);
    }

    public double getSagittalArea() {
        return this.header.getVoxelDimensions().getSagittalArea();
    }

    public int getSelectedCoordinateSpaceCode() {
        if (this.header.isNIFTI()) {
            if (this.coordSpaceIndex == 1) {
                NIFTI nifti = this.header.getNIFTIObject();
                return nifti.getQFormCode();
            }
            if (this.coordSpaceIndex == 2) {
                NIFTI nifti = this.header.getNIFTIObject();
                return nifti.getSFormCode();
            }
            return 0;
        }
        return 0;
    }

    public int getSelectedCoordinateSpaceTransform() {
        return this.coordSpaceIndex;
    }

    public int getSeriesLength() {
        return this.numTimepoints;
    }

    public int getSeriesOffset() {
        return this.seriesOffset;
    }

    public int getSeriesOffsetOriginalRange() {
        return this.seriesOffsetOriginalRange;
    }

    public int getSeriesOffsetRange() {
        return this.seriesOffsetRange;
    }

    public double getTimeframe() {
        return this.header.getVoxelDimensions().getTR() * this.header.getVoxelDimensions().getTemporalUnitMultiplier();
    }

    public String getTimeUnitString() {
        return this.header.getTimeUnitString();
    }

    public double getTR() {
        return this.header.getVoxelDimensions().getTR();
    }

    public VolumeUser getUser() {
        return this.user;
    }

    public double getVolumeIntercept() {
        return (0.0f - this.header.getImageRange().getDataScaleIntercepts()[0]) / this.header.getImageRange().getDataScaleSlopes()[0];
    }

    public double getVolumeInterceptScreen() {
        return this.header.getImageRange().getDataScaleIntercepts()[0] / this.header.getImageRange().getDataScaleSlopes()[0];
    }

    public float[] getVolumeTiming() {
        return this.header.getVolumeTiming();
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions vd = null;
        try {
            vd = (VoxelDimensions)this.header.getVoxelDimensions().clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        return vd;
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc) {
        return this.getVoxelValueAtCoordinate(xLoc, yLoc, zLoc, this.currentTimepoint, false, true);
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, boolean useTransform) {
        return this.getVoxelValueAtCoordinate(xLoc, yLoc, zLoc, this.currentTimepoint, useTransform, true);
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc) {
        return this.getVoxelValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, false, true);
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, boolean useTransform) {
        return this.getVoxelValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, useTransform, true);
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, boolean useTransform, boolean useDataScale) {
        if (tLoc < this.numTimepoints) {
            if (useTransform) {
                return this.transform.getValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, useDataScale);
            }
            return this.transformWorld.getValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, useDataScale);
        }
        return 0.0;
    }

    public double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                return ((Transform)transform).getValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, true);
            }
            return this.getVoxelValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, false, true);
        }
        return 0.0;
    }

    public double getVoxelValueAtCoordinateNN(double xLoc, double yLoc, double zLoc) {
        return this.getVoxelValueAtCoordinateNN(xLoc, yLoc, zLoc, 0);
    }

    public double getVoxelValueAtCoordinateTemp(double xLoc, double yLoc, double zLoc, boolean useTransform, boolean useDataScale) {
        if (useTransform) {
            return this.transform.getValueAtCoordinate(xLoc, yLoc, zLoc, 0, useDataScale, false, false, false, true);
        }
        return this.transformWorld.getValueAtCoordinate(xLoc, yLoc, zLoc, 0, useDataScale, false, false, false, true);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc) {
        return this.getVoxelValueAtIndexDataScaleOption(xLoc, yLoc, zLoc, this.currentTimepoint, true);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, boolean useTransform) {
        return this.getVoxelValueAtIndex(xLoc, yLoc, zLoc, this.currentTimepoint, useTransform, true);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc) {
        return this.getVoxelValueAtIndexDataScaleOption(xLoc, yLoc, zLoc, tLoc, true);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, boolean useTransform) {
        return this.getVoxelValueAtIndex(xLoc, yLoc, zLoc, tLoc, useTransform, true);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                return ((Transform)transform).getValueAt(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, true);
            }
            return this.voxelValue.getValueForOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels);
        }
        return 0.0;
    }

    public double getVoxelValueAtIndexTemp(int xLoc, int yLoc, int zLoc, boolean useDataScales) {
        if (useDataScales) {
            return this.voxelValue.getValueAtOffsetTemp(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc));
        }
        return this.voxelValue.getRawValueAtOffsetTemp(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc));
    }

    public double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc) {
        return this.getVoxelValueAtMM2(xLoc, yLoc, zLoc, this.currentTimepoint, true, false);
    }

    public double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, boolean useTransform, int transformNum) {
        return this.getVoxelValueAtMM2(xLoc, yLoc, zLoc, this.currentTimepoint, true, useTransform);
    }

    public double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, int tLoc) {
        return this.getVoxelValueAtMM2(xLoc, yLoc, zLoc, tLoc, true, false);
    }

    public double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, int tLoc, boolean useTransform, boolean useDataScale) {
        return this.getVoxelValueAtMM2(xLoc, yLoc, zLoc, tLoc, useDataScale, useTransform);
    }

    public double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, int tLoc, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                return ((Transform)transform).getValueAtMM(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, true);
            }
            return this.transformWorld.getValueAtMM(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, true);
        }
        return 0.0;
    }

    public double getVoxelValueAtMMTemp(double xLoc, double yLoc, double zLoc, boolean useDataScale) {
        return this.getVoxelValueAtMMTemp(xLoc, yLoc, zLoc, useDataScale, false);
    }

    public double getVoxelValueAtMMTemp(double xLoc, double yLoc, double zLoc, boolean useDataScale, boolean useTransform) {
        if (useTransform) {
            return this.transform.getValueAtMM(xLoc, yLoc, zLoc, 0, useDataScale, false, false, false, true);
        }
        return this.transformWorld.getValueAtMM(xLoc, yLoc, zLoc, 0, useDataScale, false, false, false, true);
    }

    public double getVoxelValueForOffset(long offset) {
        return this.voxelValue.getValueForOffset(offset);
    }

    public double getVoxelVolume() {
        return this.header.getVoxelDimensions().getVolume();
    }

    @Deprecated
    public ByteBuffer getWorkBuffer() {
        return this.image.getWorkBuffers()[0];
    }

    public ByteBuffer[] getWorkBuffers() {
        return this.image.getWorkBuffers();
    }

    public ImageTransform getWorldImageTransform(int num) {
        return this.getWorldTransform(num);
    }

    public Transform getWorldTransform(int num) {
        return this.transform;
    }

    public int getXDim() {
        return this.orientation.getXDim();
    }

    public double getXSize() {
        return this.orientation.getXSize();
    }

    public int getYDim() {
        return this.orientation.getYDim();
    }

    public double getYSize() {
        return this.orientation.getYSize();
    }

    public int getZDim() {
        return this.orientation.getZDim();
    }

    public double getZSize() {
        return this.orientation.getZSize();
    }

    public boolean hasDefaultDataScales() {
        return this.header.getImageRange().hasDefaultDataScaleIntercept() && this.header.getImageRange().hasDefaultDataScaleSlope();
    }

    public boolean hasDirtyHeader() {
        return this.headerIsDirty;
    }

    public boolean hasDirtyImage() {
        return this.imageIsDirty;
    }

    public boolean hasGlobalDataScale() {
        return this.header.getImageRange().hasGlobalDataScaleSlope() && this.header.getImageRange().hasGlobalDataScaleIntercept();
    }

    public boolean hasLabels() {
        return this.labels.hasData();
    }

    @Override
    public void imageRevertedToSaved(boolean success) {
        if (success) {
            this.volumeSizeVoxels = this.header.getVolumeSizeVoxels();
            this.buildVolume();
            this.resetTransforms(true);
            this.setHeaderDirty(true);
            this.setHeaderDirty(false);
            this.setImageDirty(false);
        }
        this.notifyListenersReverted(success);
        this.notifyListenersVolumeChange(false);
    }

    @Override
    public void imageSaved(boolean success, boolean reload, ProgressBar pb, Volume overlayToClear, boolean isCopy, boolean sameThread) {
        this.reconcile();
        this.notifyListenersSaved(this, success, reload, pb, overlayToClear, isCopy, sameThread);
        this.notifyListenersVolumeChange(false);
    }

    public boolean isBackgroundLoading() {
        return this.image.isBackgroundLoading();
    }

    public boolean isDirty() {
        return this.headerIsDirty && this.header.canBeSaved() || this.imageIsDirty;
    }

    public boolean isForceDisplayIndex() {
        return this.forceDisplayIndex;
    }

    public boolean isForceDisplayWorld() {
        return this.forceDisplayWorld;
    }

    public boolean isIdentityTransform() {
        return this.transform.isIdentity();
    }

    public boolean isImageDirty() {
        return this.imageIsDirty;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isLoadedHeadertypeWritable() {
        return this.header.isLoadedHeadertypeWritable();
    }

    public boolean isLoadedSeriesAsSinglePoint() {
        return this.seriesOffsetRange == 1;
    }

    public boolean isLoadedSeriesAsSubset() {
        return this.seriesOffsetRange > 1;
    }

    public boolean isMNIToTalairachTransform() {
        return this.transform.isMNIToTalairach();
    }

    public boolean isNIFTI() {
        return this.header.isNIFTI();
    }

    public boolean isOperationInProgress() {
        return this.operationInProgress;
    }

    public boolean isTalairachToMNITransform() {
        return this.transform.isTalairachToMNI();
    }

    public boolean isVariableSliceSpacing() {
        return this.header.isVariableSliceSpacing();
    }

    public boolean isVariableVolumeTiming() {
        return this.header.isVariableVolumeTiming();
    }

    public boolean isWritable(File headerFile) {
        if (headerFile != null && this.header != null && this.header.getImageFilename() != null) {
            URI uri = this.header.getImageFile();
            if (!FileUtilities.uriIsFile((URI)uri)) {
                return false;
            }
            File imageFile = new File(uri);
            return headerFile.canWrite() && imageFile.canWrite();
        }
        return false;
    }

    public void labelChanged() {
        if (this.labelListener != null) {
            this.labelListener.labelChanged();
        }
        this.setHeaderAsDirty();
    }

    public void loadTransform(Matrix mat, int preferredOrigin, Coordinate coor) {
        this.transform.updateTransform(mat.inverse());
        this.transform.setPreferredLabelType(0);
        this.transform.setPreferredPointOfRotation(preferredOrigin);
        if (coor != null) {
            this.transform.setPreferredPointOfRotationCoordinate(coor.xDbl, coor.yDbl, coor.zDbl);
        }
        this.notifyListenersTransformLoaded();
    }

    public ByteBuffer makeTempBuffer() {
        if (!this.image.hasTempBuffer()) {
            this.voxelValue.setTempBuffer(this.image.makeTempBuffer(this.header.getImageDimensions().getNumVoxelsVolume(), this.readOnly ? this.header.getImageType().getNumBytesPerVoxel() : 4));
        }
        return this.image.getTempBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersOperationCompleted(boolean success, Volume volume) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeOperationCompleted(success, volume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersVolumeChange(boolean forceUpdate) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeChanged(this, forceUpdate);
            }
        }
    }

    public void preload() {
        this.title = null;
        this.header = new Header();
        this.image = new Image();
        this.image.setUser(this);
        this.loadedVolumes = -1;
        JVMUtilities.clearGarbage();
    }

    public void putRawVoxelValueAtIndexTemp(int xLoc, int yLoc, int zLoc, double value) {
        this.voxelValue.putRawValueAtOffsetTemp(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + 0, value);
    }

    @Deprecated
    public void putVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, double value) {
        this.putVoxelValueAtCoordinate(xLoc, yLoc, zLoc, value, false);
    }

    @Deprecated
    public void putVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, double value) {
        this.putVoxelValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, value, false);
    }

    @Deprecated
    public void putVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, double value, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                ((Transform)transform).putValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            } else {
                this.transformWorld.putValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            }
        }
    }

    public void putVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, double value) {
        this.putVoxelValueAtIndex(xLoc, yLoc, zLoc, value, false);
    }

    public void putVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, double value) {
        this.putVoxelValueAtIndex(xLoc, yLoc, zLoc, tLoc, value, false);
    }

    @Deprecated
    public void putVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, double value, boolean useTransform) {
        if (tLoc < this.numTimepoints) {
            if (useTransform) {
                this.transform.putValueAt(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            } else {
                this.voxelValue.putValueAtOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels, value);
            }
        }
    }

    @Deprecated
    public void putVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, double value, ImageTransform transform) {
        if (tLoc < this.numTimepoints) {
            if (transform != null) {
                ((Transform)transform).putValueAt(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            } else {
                this.voxelValue.putValueAtOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels, value);
            }
        }
    }

    public void putVoxelValueAtOffset(int offset, double value) {
        this.voxelValue.putValueAtOffset(offset, value);
    }

    public void readDICOM(DICOM[] dicoms) throws InvalidHeaderException, IOException {
        this.header.createFromDICOMHeaders(dicoms);
        this.doReadFiles();
    }

    public void readDICOMFiles(URI[] dicoms) throws InvalidHeaderException, IOException {
        this.header.createFromDICOMFiles(dicoms);
        this.doReadFiles();
    }

    @Deprecated
    public File readFiles(File headerFile) throws InvalidHeaderException, VolumeIOException {
        return new File(this.readFiles(headerFile.toURI()));
    }

    public URI readFiles(URI headerFile) throws InvalidHeaderException, VolumeIOException {
        File tempDir = null;
        if (this.user != null) {
            tempDir = this.user.getTempDir();
        }
        URI readFile = this.header.readFile(headerFile, tempDir);
        this.doReadFiles();
        return readFile;
    }

    public URI readFiles(URI headerFile, boolean readOnly) throws InvalidHeaderException, VolumeIOException {
        this.readOnly = readOnly;
        return this.readFiles(headerFile);
    }

    public URI readHeader(URI headerFile) throws InvalidHeaderException {
        File tempDir = null;
        if (this.user != null) {
            tempDir = this.user.getTempDir();
        }
        URI readFile = this.header.readFile(headerFile, tempDir);
        this.numTimepoints = this.header.getImageDimensions().getTimepoints();
        return readFile;
    }

    public void readLabelData() throws UnsupportedEncodingException {
        byte[] ext = this.getExtension();
        if (ext != null && ext.length > 0) {
            int extHeaderSize = 8;
            int extSize = ext.length - 8;
            byte[] labelData = new byte[extSize];
            System.arraycopy(ext, 8, labelData, 0, labelData.length);
            try {
                Metadata.readMetadata(this, new String(labelData, "utf-8"));
            }
            catch (ParserConfigurationException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (SAXException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(VolumeListener aListener) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    public void saveLabelData(String version) throws UnsupportedEncodingException, ParserConfigurationException, TransformerException {
        if (this.labels.hasData() || this.bookmarks.size() > 0) {
            boolean isLittleEndian = this.getImageType().isLittleEndian();
            byte[] labelData = Metadata.writeMetadata(version, this).getBytes("utf-8");
            int extSize = 0;
            if (labelData != null) {
                extSize += labelData.length;
                int diffIntegral = 16 - (extSize += 8) % 16;
                byte[] extensionData = null;
                if ((extSize += diffIntegral) > 0) {
                    extensionData = new byte[extSize];
                    ByteBuffer extensionBuf = ByteBuffer.wrap(extensionData);
                    extensionBuf.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    extensionBuf.putInt(extSize);
                    extensionBuf.putInt(0);
                    extensionBuf.put(labelData);
                }
                this.setExtension(extensionData);
            }
        }
    }

    public void setAsNativeIntegerBuffer() {
        this.voxelValue.setAsNativeIntegerType();
        this.image.setAsNativeIntegerType();
    }

    @Deprecated
    public void setCurrentIndexTransform(int num) {
    }

    public void setCurrentSeriesPoint(int point) {
        this.setCurrentTimepoint(point);
    }

    public boolean isCompressed() {
        return this.header.getImageType().isCompressed();
    }

    public void setCurrentTimepoint(double seconds) {
        int index = (int)Math.round(seconds / this.header.getVoxelDimensions().getTemporalUnitMultiplier() / this.header.getVoxelDimensions().getTR());
        if (index < 0) {
            index = 0;
        } else if (index >= this.header.getImageDimensions().getTimepoints()) {
            index = this.header.getImageDimensions().getTimepoints() - 1;
        }
        this.setCurrentTimepoint(index);
    }

    public void setCurrentTimepoint(int value) {
        if (value >= 0 && value < this.getNumTimepoints()) {
            this.currentTimepoint = value;
            this.notifyListenersTimepointChange();
        }
    }

    @Deprecated
    public void setCurrentWorldTransform(int num) {
        this.setCurrentIndexTransform(num);
    }

    public void setDisplayValues(double max, double min) {
        this.header.setDisplayMaxMin(max, min);
    }

    public void setExtension(byte[] ext) {
        this.extension = ext;
    }

    public void setForceDisplayIndex(boolean forceDisplayIndex) {
        this.forceDisplayIndex = forceDisplayIndex;
    }

    public void setForceDisplayWorld(boolean forceDisplayWorld) {
        this.forceDisplayWorld = forceDisplayWorld;
    }

    public void setForceLoadInThead(boolean forceLoadInThread) {
        this.forceLoadInThread = forceLoadInThread;
    }

    public void setHeader(Header header, boolean compression, ByteBuffer[] buffer) throws InvalidHeaderException {
        this.header = header;
        this.image = new Image();
        this.image.setUser(this);
        header.getImageType().setCompressionType(header.getImageType().isCompressed() || compression ? 1 : 0);
        this.volumeSizeVoxels = header.getVolumeSizeVoxels();
        if (buffer != null) {
            this.image.setBuffers(buffer);
        } else {
            ByteBuffer[] buffers = new ByteBuffer[header.getImageDimensions().getTimepoints()];
            for (int ctr = 0; ctr < buffers.length; ++ctr) {
                buffers[ctr] = Image.makeBuffer(this.volumeSizeVoxels * (this.readOnly ? header.getImageType().getNumBytesPerVoxel() : 4));
            }
            this.image.setBuffers(buffers);
        }
        this.buildVolume();
    }

    public String toString() {
        if (this.title == null) {
            URI uri;
            this.title = this.header.getImageDescription().getTitle();
            if (StringUtils.isBlank((CharSequence)this.title) && (uri = this.header.getImageDescription().getFile()) != null) {
                this.title = FileUtilities.removeExtension((String)FileUtilities.getName((URI)uri));
            }
            if (StringUtils.isBlank((CharSequence)this.title) && (uri = this.header.getImageFile()) != null) {
                this.title = FileUtilities.removeExtension((String)FileUtilities.getName((URI)uri));
            }
            if (StringUtils.isBlank((CharSequence)this.title)) {
                this.title = "Volume";
            }
        }
        return this.title;
    }

    public void setHeaderAsDirty() {
        this.setHeaderDirty(true);
    }

    public void setImageAsDirty() {
        this.setImageDirty(true);
    }

    public void setImageDescription(String text) {
        this.header.setImageDescription(text);
        this.setHeaderDirty(true);
    }

    public void setImageDirty(boolean dirty) {
        this.imageIsDirty = dirty;
        if (this.initialized) {
            this.notifyListenersChange();
        }
    }

    public void setImageFileName(String string) {
        this.header.setImageFile(new File(new File(this.header.getImageFile()).getParent(), string));
    }

    public void setImageOffset(int val) {
        this.header.getImageDimensions().setImageOffset(val);
    }

    public void setLabel(int index, String label) {
        this.setLabel(index, label, true);
    }

    public void setLabel(int index, String label, boolean notify) {
        this.labels.setLabel(index, label);
        if (notify) {
            this.labelChanged();
        }
    }

    public void setLabelData(byte[] data) {
        this.labels.setData(data);
        this.labelChanged();
    }

    public void setLabelListener(LabelListener labelListener) {
        this.labelListener = labelListener;
    }

    public void setOperationInProgress(boolean operationInProgress) {
        this.operationInProgress = operationInProgress;
    }

    public void setOrigin(Coordinate coor) {
        Coordinate origin = this.header.getOrigin();
        origin.setValues(this.orientation.convertCoordinateInverse(coor));
        this.resetTransforms(false);
        this.setHeaderDirty(true);
    }

    public void setProgressBarListener(ProgressBarListener aListener) {
        this.pbListener = aListener;
        this.image.setProgressBarListener(aListener);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setSelectedCoordinateSpaceTransform(int val) {
        if (this.header.isNIFTI()) {
            ImageTransform[] xforms;
            this.coordSpaceIndex = val;
            double[][] xform = null;
            NIFTI nifti = this.header.getNIFTIObject();
            if (this.coordSpaceIndex == 0) {
                Coordinate originalOrigin = this.header.getOriginOriginal();
                if (originalOrigin != null) {
                    this.header.getOrigin().setValues(originalOrigin);
                }
                Coordinate origin = this.getOriginNative();
                VoxelDimensions vd = this.header.getVoxelDimensions();
                xform = Orientation.convertNEMAToNiftiSForm(this.getOrientationString(), origin.xDbl, origin.yDbl, origin.zDbl, (float)vd.getColSize(true), (float)vd.getRowSize(true), (float)vd.getSliceThickness(true));
            } else if (this.coordSpaceIndex == 1) {
                xforms = nifti.getTransforms();
                xform = xforms[0].getMatrixCopy();
                this.header.getOrigin().setValues(((SimpleTransform)xforms[0]).getOrigin());
            } else if (this.coordSpaceIndex == 2) {
                xforms = nifti.getTransforms();
                xform = xforms[1].getMatrixCopy();
                this.header.getOrigin().setValues(((SimpleTransform)xforms[1]).getOrigin());
            }
            Matrix mat = new Matrix(xform);
            try {
                mat = mat.inverse();
            }
            catch (Exception ex) {
                AppLogger.info((Throwable)ex);
                mat = new Matrix(Transform.IDENTITY.getArrayCopy());
            }
            this.updateOrientationTransform(mat);
            this.updateWorldMat();
        }
    }

    public void setTemporaryForceNearestNeighbor(boolean bool) {
        this.transform.setTemporaryForceNearestNeighbor(bool);
        this.transformWorld.setTemporaryForceNearestNeighbor(bool);
    }

    public void setTimeseriesToMultipleVolumes(int minIndex, int maxIndex, int fullRange) {
        this.seriesOffset = minIndex;
        this.seriesOffsetRange = maxIndex - minIndex + 1;
        this.seriesOffsetOriginalRange = fullRange;
        ImageType it = this.header.getImageType();
        int numBytesPerVoxel = it.getNumBytesPerVoxel();
        ImageDimensions id = this.header.getImageDimensions();
        id.setTimepoints(maxIndex - minIndex + 1);
        int offset = id.getImageOffset();
        int volOffset = minIndex * id.getNumVoxelsVolume() * numBytesPerVoxel;
        id.setImageOffset(offset + volOffset);
        ImageRange ir = this.header.getImageRange();
        ir.setImageMax(0.0);
        ir.setImageMin(0.0);
    }

    public void setTimeseriesToSingleVolume(int volIndexToRead, int fullRange) {
        this.seriesOffset = volIndexToRead;
        this.seriesOffsetRange = 1;
        this.seriesOffsetOriginalRange = fullRange;
        ImageType it = this.header.getImageType();
        int numBytesPerVoxel = it.getNumBytesPerVoxel();
        ImageDimensions id = this.header.getImageDimensions();
        id.setTimepoints(1);
        int offset = id.getImageOffset();
        int volOffset = volIndexToRead * id.getNumVoxelsVolume() * numBytesPerVoxel;
        id.setImageOffset(offset + volOffset);
        ImageRange ir = this.header.getImageRange();
        ir.setImageMax(0.0);
        ir.setImageMin(0.0);
    }

    public void setUser(VolumeUser user) {
        this.user = user;
        this.image.setUser(this);
    }

    public void stopBackgroundLoading() {
        if (this.image != null) {
            this.image.setBackgroundLoading(false);
        }
    }

    public boolean supportsTimeseriesSelection() {
        return this.header.isNIFTI() || this.header.isAVW();
    }

    public void updateMaxMin(Range range) {
        this.header.setImageMaxMin(range.getMax(), range.getMin());
        this.header.setImageMaxMinOffsets(range.getMaxOffset(), range.getMinOffset());
        this.binary = range.isBinary();
    }

    public void updateMaxMin(Object source, Range range, boolean sameThread) {
        this.updateMaxMin(range);
        if (source != null) {
            this.notifyListenersRangeUpdate(source, sameThread);
        }
    }

    public void updateMaxMin(Object source, Range range) {
        this.updateMaxMin(source, range, false);
    }

    public void updateMaxMin(double imageMax, double imageMin) {
        this.header.setImageMaxMin(imageMax, imageMin);
    }

    @Override
    public void volumeDataLoaded(int volIndex) {
        this.loadedVolumes = volIndex;
        this.notifyListenersDataLoaded(volIndex);
    }

    public void volumeOperationCompleted() {
        this.volumeOperationCompleted(null);
    }

    public void volumeOperationCompleted(String des) {
        this.setImageDirty(true);
        this.notifyListenersVolumeChange(false);
        this.notifyListenersOperationCompleted(true, this);
    }

    public void writeAsNiftiFast(File file, boolean smallImage) throws VolumeIOException, IOException, InvalidHeaderException, CloneNotSupportedException {
        NIFTI nifti = new NIFTI();
        ImageType itOld = (ImageType)this.getImageType().clone();
        ImageType it = null;
        it = smallImage && itOld.getNumBytesPerVoxel() > 1 ? new ImageType(1, 3, 8, true) : (ImageType)this.getImageType().clone();
        Range op = this.findRangeSeries();
        boolean hasGlobalDataScales = this.hasGlobalDataScale();
        boolean applyDataScales = !hasGlobalDataScales;
        boolean fitPrecision = !hasGlobalDataScales && it.getByteType() != 4 || !itOld.equals((Object)it);
        ImageDimensions id = (ImageDimensions)this.getImageDimensions().clone();
        id.setImageOffset(352);
        VoxelDimensions vd = (VoxelDimensions)this.getVoxelDimensions().clone();
        ImageRange ir = (ImageRange)this.getImageRange().clone();
        if (applyDataScales) {
            ir.setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), 1.0f);
            ir.setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), 0.0f);
        }
        if (fitPrecision) {
            this.doFitPrecision(false, false, it, id, op.getMax(), op.getMin(), ir);
        }
        ImageDescription in = (ImageDescription)this.getImageDescription().clone();
        byte[] headerData = nifti.writeHeader(id, vd, it, ir, in, true, this.header.getOrigin(), this.orientation.getOrientation(), null, file, file, null, null);
        this.image.doWriteWorkBufferToFile(file, headerData, this, this.voxelValue, null, -1, false, false, false, false, this.getOrientationString(), null, id, this.getImageBounds(), this.getXSize(), this.getYSize(), this.getZSize(), 1.0, this.getTR(), it, true, applyDataScales, false, false, -1, false, false, false, false, -1.0, false, fitPrecision, false, false, false, 0, false, true, true, true);
    }

    public void writeFiles(File headerFile, boolean sameThread) throws InvalidHeaderException, VolumeIOException {
        WritableHeader writableHeader = null;
        if (this.header.getReadable() instanceof WritableHeader) {
            writableHeader = (WritableHeader)this.header.getReadable();
        }
        if (writableHeader == null) {
            throw new InvalidHeaderException("This header format cannot be written!");
        }
        this.findRangeSeries();
        if (this.needsFitPrecision()) {
            this.writeFilesAs(headerFile, this.getImageType(), 0, this.getOrientationString(), this.getOrigin(), true, writableHeader.getPluginName(), true, false, null, false, -1, false, true, false, false, -1.0, false, true, false, this.getImageBounds(), this.getXSize(), this.getYSize(), this.getZSize(), 1.0, true);
        } else {
            boolean writeImage;
            File imageFile = new File(this.header.getImageFile());
            byte[] headerArray = null;
            this.updateHeaderTransformData(false, false);
            int totalHeaderSize = 0;
            if (this.extension != null && this.getReadableHeader() instanceof NIFTI) {
                totalHeaderSize = ((NIFTI)writableHeader).getHeaderSize() + this.extension.length;
                this.header.getImageDimensions().setImageOffset(totalHeaderSize);
            }
            try {
                headerArray = writableHeader.writeHeader(this.header.getImageDimensions(), this.header.getVoxelDimensions(), this.header.getImageType(), this.header.getImageRange(), this.header.getImageDescription(), this.header.getImageType().isCompressed(), this.header.getOrigin(), this.header.getOrientationString(), null, headerFile, imageFile, this.image.getWorkBuffers(), this.user != null ? this.user.getTempDir() : null);
            }
            catch (Exception ex) {
                throw new VolumeIOException(ex);
            }
            boolean bl = writeImage = this.imageIsDirty || headerArray != null;
            if (writeImage) {
                if (this.extension != null && this.getReadableHeader() instanceof NIFTI) {
                    headerArray = NIFTI.setNiftiHeaderExtensionFlag(headerArray);
                    byte[] headerArrayNew = new byte[totalHeaderSize];
                    System.arraycopy(headerArray, 0, headerArrayNew, 0, headerArray.length);
                    System.arraycopy(this.extension, 0, headerArrayNew, headerArray.length, this.extension.length);
                    headerArray = headerArrayNew;
                }
                this.image.writeWorkBufferToFile(imageFile, this.voxelValue, this.header.getImageDimensions(), this.header.getImageType(), headerArray, true, sameThread);
                if (this.header.isMultiFileFormat()) {
                    URI[] multiFile;
                    for (URI element : multiFile = this.header.getMultiImageFiles()) {
                        if (!FileUtilities.uriIsFile((URI)element)) continue;
                        FileUtilities.delete((File)new File(element));
                    }
                    this.header.unsetMultiFileFormat();
                }
            } else {
                this.notifyListenersSaved(this, true, false, null, null, false, sameThread);
            }
            this.setHeaderDirty(false);
            this.setImageDirty(false);
        }
    }

    public void writeFilesAs(File headerFile, ImageType itNew, int transformIndex, String orientationStringVal, Coordinate worldOrigin, boolean overwrite, String otherFormatName, boolean applyDataScalesVal, boolean worldMode, ClusterFilter clusterFilter, boolean mmMode, int overlayTransform, boolean nearestNeighbor, boolean trilinear, boolean sync, boolean useThreshold, double threshold, boolean useMix, boolean fitPrecision, boolean maintainZero, ImageBounds ib, double resliceX, double resliceY, double resliceZ, double resliceT, boolean sameThread) throws InvalidHeaderException, VolumeIOException {
        boolean fixPrecision;
        String orientationString;
        WritableHeader writableHeader = this.header.getWritableHeader(otherFormatName);
        if (writableHeader == null) {
            throw new InvalidHeaderException("Could not find that format!");
        }
        boolean isNIFTI = otherFormatName.equals("NIFTI");
        boolean isNIFTI2 = otherFormatName.equals("NIFTI-2");
        boolean isWorldMode = worldMode;
        boolean isOverlayMode = clusterFilter != null;
        File imageFile = writableHeader.formatImageFile(headerFile);
        if (isNIFTI || isNIFTI2) {
            imageFile = new File(headerFile.getParent(), headerFile.getName());
        }
        if ((orientationString = orientationStringVal) == null) {
            orientationString = this.getOrientationString();
        }
        boolean orientationChanged = !orientationString.equals(this.header.getOrientationString());
        this.header.setOrientation(orientationString);
        this.resetTransforms(false);
        ImageDimensions id = this.header.getImageDimensions();
        ImageDimensions idOld = null;
        try {
            idOld = (ImageDimensions)id.clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        VoxelDimensions vd = this.header.getVoxelDimensions();
        ImageType it = this.header.getImageType();
        this.header.setImageFile(imageFile);
        this.updateHeaderOrigin(orientationString, id, ib, this.getXSize() / resliceX, this.getYSize() / resliceY, this.getZSize() / resliceZ);
        this.orientation.setImageByXYZ(ib.getMaxX() - ib.getMinX() + 1, ib.getMaxY() - ib.getMinY() + 1, ib.getMaxZ() - ib.getMinZ() + 1);
        this.orientation.setVoxelByXYZ(resliceX, resliceY, resliceZ);
        this.updateHeaderOrientationContingentInfo(orientationString, id, vd);
        id.setImageOffset(0);
        ImageType itOld = null;
        try {
            itOld = (ImageType)it.clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
        }
        it.setValues(itNew);
        it.setCompressionType(itNew.getCompressionType());
        double oldTR = vd.getTR();
        if (oldTR == 0.0) {
            oldTR = 1.0;
        }
        vd.setTR(resliceT * oldTR);
        this.volumeSizeVoxels = this.header.getVolumeSizeVoxels();
        int timepoints = ib.getMaxT() - ib.getMinT() + 1;
        if (timepoints < 1) {
            timepoints = 1;
            ib.setRangeT(0, 0);
        }
        id.setTimepoints(timepoints);
        boolean applyDataScales = applyDataScalesVal;
        if (!(!orientationChanged || this.header.getImageRange().hasGlobalDataScaleSlope() && this.header.getImageRange().hasGlobalDataScaleIntercept())) {
            applyDataScales = true;
        }
        boolean bl = fixPrecision = !applyDataScales && itOld.isInteger() && itNew.isInteger() && itNew.getNumBytesPerVoxel() == itOld.getNumBytesPerVoxel() && itOld.getNumBytesPerVoxel() < 4;
        if (applyDataScales) {
            this.header.setGlobalDefaultDataScales(id.getSlices() * id.getTimepoints());
        }
        if (fitPrecision) {
            this.doFitPrecision(maintainZero, fixPrecision, itNew, id, this.getImageMax(), this.getImageMin(), this.header.getImageRange());
        }
        if (isOverlayMode) {
            if (useMix) {
                if (it.getNumBytesPerVoxel() == 1) {
                    this.header.setDisplayMaxMin(127.0, 0.0);
                } else if (it.getNumBytesPerVoxel() == 2) {
                    this.header.setDisplayMaxMin(32767.0, 0.0);
                } else if (it.getNumBytesPerVoxel() == 4) {
                    this.header.setDisplayMaxMin(2.147483647E9, 0.0);
                }
            } else {
                this.header.setDisplayMaxMin(0.0, 0.0);
            }
            this.header.getImageRange().setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), 1.0f);
            this.header.getImageRange().setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), 0.0f);
        }
        this.updateHeaderTransformData(isNIFTI || isNIFTI2, isWorldMode);
        int totalHeaderSize = 0;
        if (this.extension != null && (isNIFTI || isNIFTI2)) {
            totalHeaderSize = ((NIFTI)writableHeader).getHeaderSize() + this.extension.length;
        }
        this.header.getImageDimensions().setImageOffset(totalHeaderSize);
        byte[][] seriesArray = null;
        try {
            seriesArray = writableHeader.writeSeriesHeaders(this.header.getImageDimensions(), this.header.getVoxelDimensions(), this.header.getImageType(), this.header.getImageRange(), this.header.getImageDescription(), itNew.isCompressed(), this.header.getOrigin(), this.header.getOrientationString(), null, headerFile, imageFile, this.image.getWorkBuffers(), this.user != null ? this.user.getTempDir() : null);
        }
        catch (AbstractMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (NoSuchMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            throw new VolumeIOException(ex);
        }
        byte[] headerArray = null;
        if (CollectionUtilities.isEmpty((Object)seriesArray)) {
            try {
                headerArray = writableHeader.writeHeader(this.header.getImageDimensions(), this.header.getVoxelDimensions(), this.header.getImageType(), this.header.getImageRange(), this.header.getImageDescription(), itNew.isCompressed(), this.header.getOrigin(), this.header.getOrientationString(), null, headerFile, imageFile, this.image.getWorkBuffers(), this.user != null ? this.user.getTempDir() : null);
            }
            catch (Exception ex) {
                throw new VolumeIOException(ex);
            }
        }
        boolean isUsingTransform = transformIndex != 0;
        boolean isInverseTransform = transformIndex < 0;
        boolean isOverlayMMmode = isOverlayMode && mmMode;
        int overlayMMtransform = overlayTransform;
        double tr = resliceT * oldTR;
        boolean pluginWillWriteImageFile = writableHeader.willWriteImage();
        if (pluginWillWriteImageFile) {
            if (this.user != null) {
                this.notifyListenersSaved(this, true, true, null, null, false, false);
            }
        } else if (CollectionUtilities.isNotEmpty((Object)seriesArray)) {
            if (sameThread) {
                this.doWriteSeries(imageFile, seriesArray, ib, clusterFilter, transformIndex, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, id.getImageTrailer());
                this.imageSaved(true, true, null, clusterFilter != null ? clusterFilter.getVolume() : null, false, sameThread);
            } else {
                this.writeSeries(imageFile, seriesArray, ib, clusterFilter, transformIndex, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, id.getImageTrailer());
            }
        } else {
            this.voxelValue.setVariableTimingSize((float)tr);
            if (this.extension != null && (isNIFTI || isNIFTI2)) {
                headerArray = NIFTI.setNiftiHeaderExtensionFlag(headerArray);
                byte[] headerArrayNew = new byte[totalHeaderSize];
                System.arraycopy(headerArray, 0, headerArrayNew, 0, headerArray.length);
                System.arraycopy(this.extension, 0, headerArrayNew, headerArray.length, this.extension.length);
                headerArray = headerArrayNew;
            }
            if (sameThread) {
                this.image.doWriteWorkBufferToFile(imageFile, headerArray, this, this.voxelValue, clusterFilter, transformIndex - 1, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, ib, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, false, id.getImageTrailer(), false, false, false, sameThread);
            } else {
                this.image.writeWorkBufferToFile(imageFile, headerArray, this, this.voxelValue, clusterFilter, transformIndex - 1, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, ib, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, id.getImageTrailer());
            }
        }
        this.setHeaderDirty(false);
        this.setImageDirty(false);
    }

    @Deprecated
    public void writeFilesAs(File headerFile, int headerType, String otherFormatName, ImageType it, boolean applyDataScales, boolean fitPrecision) throws InvalidHeaderException, VolumeIOException {
        String formatName = null;
        formatName = headerType == 1 ? "Analyze" : (headerType == 8 ? "DES" : (headerType == 3 ? "NIFTI" : (headerType == 1024 ? otherFormatName : "NIFTI")));
        this.writeFilesAs(headerFile, formatName, it, this.getOrientationString(), applyDataScales, fitPrecision, false);
    }

    public void writeFilesAs(File headerFile, String formatName, ImageType it, String orientation, boolean applyDataScales, boolean fitPrecision) throws InvalidHeaderException, VolumeIOException {
        this.writeFilesAs(headerFile, formatName, it, orientation, applyDataScales, fitPrecision, false);
    }

    public void writeFilesAs(File headerFile, String otherFormatName, ImageType it, String orientation, boolean applyDataScales, boolean fitPrecision, boolean useTransform) throws InvalidHeaderException, VolumeIOException {
        if (useTransform) {
            this.writeFilesAs(headerFile, it, this.getCurrentIndexTransformIndex() + 1, orientation, this.getOrigin(), true, otherFormatName, applyDataScales, false, null, false, -1, false, true, false, false, 0.0, false, fitPrecision, false, this.getImageBounds(), this.getXSize(), this.getYSize(), this.getZSize(), 1.0, true);
        } else {
            this.writeFilesAs(headerFile, it, 0, orientation, this.getOrigin(), true, otherFormatName, applyDataScales, false, null, false, -1, false, true, false, false, 0.0, false, fitPrecision, false, this.getImageBounds(), this.getXSize(), this.getYSize(), this.getZSize(), 1.0, true);
        }
    }

    protected long getNativeIntegerValueAtCoordinate(double xLoc, double yLoc, double zLoc, int seriesIndex) {
        return this.transformWorld.getNativeIntegerValueAtCoordinate(xLoc, yLoc, zLoc, seriesIndex);
    }

    protected long getNativeIntegerValueAtMM(double xLoc, double yLoc, double zLoc, int seriesIndex) {
        return this.transformWorld.getNativeIntegerValueAtMM(xLoc, yLoc, zLoc, seriesIndex);
    }

    protected double getVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, double tLoc, int transformNum, boolean useTransform, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync) {
        if (tLoc < (double)this.numTimepoints) {
            if (useTransform) {
                return this.transform.getValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, useDataScale, forceNN, forceTrilinear, forceSync);
            }
            return this.transformWorld.getValueAtCoordinate(xLoc, yLoc, zLoc, tLoc, useDataScale, forceNN, forceTrilinear, forceSync);
        }
        return 0.0;
    }

    protected double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, double tLoc, boolean useDataScale, boolean useTransform, int transformNum, boolean nearestNeighbor, boolean trilinear, boolean sync) {
        if (tLoc < (double)this.numTimepoints) {
            if (useTransform) {
                return this.transform.getValueAtMM(xLoc, yLoc, zLoc, tLoc, useDataScale, nearestNeighbor, trilinear, sync);
            }
            return this.transformWorld.getValueAtMM(xLoc, yLoc, zLoc, tLoc, useDataScale, nearestNeighbor, trilinear, sync);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersTransformChange() {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeTransformChanged(this);
            }
        }
    }

    private void buildVolume() {
        this.clearOrientationChanged();
        this.orientation = new Orientation(this.header.getOrientationString(), this.header.getImageDimensions(), this.header.getVoxelDimensions(), this.header.getOrigin());
        this.header.setOrientation(this.orientation.getOrientation());
        this.voxelValue = new VoxelValue(this.image, this.header.getImageType(), this.header.getImageRange(), this.header.getImageDimensions(), this.orientation);
        if (this.header.isVariableVolumeTiming()) {
            this.voxelValue.setCumulativeTimes(this.header.getCumulativeTimes());
            this.voxelValue.setVolumeTimes(this.header.getVolumeTiming());
        }
        this.resetTransforms(true);
        this.setSelectedCoordinateSpaceTransform(this.findDefaultCoordinateSpaceTransform());
        this.validateOrigin();
        if (!this.header.getImageDimensions().inRange(this.getOrigin()) && this.getOrientationCertainty() == 2) {
            this.header.setOrientationCertainty(1);
        }
        this.numTimepoints = this.header.getImageDimensions().getTimepoints();
        this.labels = new LabelList(this.numTimepoints, true);
        this.initialized = true;
    }

    public boolean needsWorldMode() {
        if (this.hadInvalidOrigin) {
            return false;
        }
        if (this.header.isNIFTI()) {
            NIFTI nifti = this.header.getNIFTIObject();
            if (nifti.getQFormCode() > 0) {
                return true;
            }
            if (nifti.getSFormCode() > 0) {
                return true;
            }
        }
        return false;
    }

    private void clearOrientationChanged() {
        this.orientationChanged = false;
    }

    private void doFitPrecision(boolean maintainZero, boolean fixPrecision, ImageType itNew, ImageDimensions id, double imageMax, double imageMin, ImageRange ir) {
        double typeUnsignedMax = itNew.getTypeMax(true);
        double typeUnsignedMin = itNew.getTypeMin(true);
        if (maintainZero) {
            double imagePositive = 0.0;
            double imageNegative = 0.0;
            double imageRange = 0.0;
            if (imageMax > 0.0) {
                imagePositive = imageMax;
            }
            if (imageMin < 0.0) {
                imageNegative = Math.abs(imageMin);
            }
            imageRange = imagePositive > imageNegative ? imagePositive * 2.0 : Math.abs(imageNegative) * 2.0;
            double typeRange = typeUnsignedMax - typeUnsignedMin;
            double dataScale = imageRange / typeRange;
            ir.setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), (float)dataScale);
            ir.setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), 0.0f);
        } else if (fixPrecision) {
            int slices = id.getSlices() * id.getTimepoints();
            float[] intercepts = new float[slices];
            for (int ctr = 0; ctr < slices; ++ctr) {
                double dataIntercept = ir.getDataScaleIntercepts()[ctr];
                if (itNew.getByteType() == 2) {
                    dataIntercept += -1.0 * (itNew.getTypeMin(false, true) * (double)ir.getDataScaleSlopes()[ctr]);
                } else if (itNew.getByteType() == 3) {
                    dataIntercept += itNew.getTypeMin(false, true) * (double)ir.getDataScaleSlopes()[ctr];
                }
                intercepts[ctr] = (float)dataIntercept;
            }
            ir.setDataScaleIntercepts(intercepts);
        } else {
            double typeRealMin = itNew.getTypeMin(false);
            double imageRange = imageMax - imageMin;
            double typeRange = typeUnsignedMax - typeUnsignedMin;
            double dataScale = imageRange / typeRange;
            double dataIntercept = -1.0 * (typeRealMin * dataScale - imageMin);
            ir.setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), (float)dataScale);
            ir.setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), (float)dataIntercept);
        }
    }

    private void doWriteSeries(File imageFile, byte[][] seriesArray, ImageBounds ib, ClusterFilter overlay, int transformIndex, boolean isUsingTransform, boolean isWorldMode, boolean isInverseTransform, boolean orientationChanged, String orientationString, Coordinate worldOrigin, ImageDimensions idOld, double resliceX, double resliceY, double resliceZ, double resliceT, double tr, ImageType it, boolean overwrite, boolean applyDataScales, boolean isOverlayMode, boolean isOverlayMMmode, int overlayMMtransform, boolean nearestNeighbor, boolean trilinear, boolean sync, boolean useThreshold, double threshold, boolean useMix, boolean fitPrecision, boolean maintainZero, boolean fixPrecision, int imageTrailer) {
        int startSeriesPoint = ib.getMinT();
        String dir = imageFile.getParent();
        String basename = imageFile.getName();
        String ext = "";
        if (basename.indexOf(46) != -1) {
            ext = basename.substring(basename.indexOf(46));
            basename = basename.substring(0, basename.indexOf(46));
        }
        for (int ctr = 0; ctr < seriesArray.length; ++ctr) {
            ImageBounds ibCurrent = new ImageBounds(ib);
            ibCurrent.setRangeT(startSeriesPoint + ctr, startSeriesPoint + ctr);
            File seriesFile = null;
            seriesFile = ctr > 0 ? new File(dir, basename + "-" + (ctr + 1) + ext) : new File(dir, basename + ext);
            this.image.doWriteWorkBufferToFile(seriesFile, seriesArray[ctr], this, this.voxelValue, overlay, transformIndex - 1, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, ibCurrent, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, false, imageTrailer, true, false, false, true);
        }
    }

    private int findDefaultCoordinateSpaceTransform() {
        int index = 0;
        if (this.header.isNIFTI()) {
            NIFTI nifti = this.header.getNIFTIObject();
            if (nifti.getQFormCode() > 0) {
                index = 1;
            }
            if (nifti.getSFormCode() > nifti.getQFormCode()) {
                index = 2;
            }
        }
        return index;
    }

    public boolean isWorldSpaceOnly() {
        if (this.header.isNIFTI()) {
            boolean foundOrthogonal = false;
            NIFTI nifti = this.header.getNIFTIObject();
            if (nifti.getQFormCode() > 0) {
                foundOrthogonal |= !Transform.isNonOrthogonal(nifti.getTransforms()[0].getMatrixCopy());
            }
            if (nifti.getSFormCode() > 0) {
                foundOrthogonal |= !Transform.isNonOrthogonal(nifti.getTransforms()[1].getMatrixCopy());
            }
            return !foundOrthogonal && (nifti.getQFormCode() > 0 || nifti.getSFormCode() > 0);
        }
        return false;
    }

    public double applyDataScale(long offset, int timepoint, double value) {
        return this.voxelValue.formatValue(offset, timepoint, value);
    }

    private double getVoxelValueAtCoordinateNN(double xLoc, double yLoc, double zLoc, int timeOffset) {
        return this.transformWorld.getValueAtCoordinate(xLoc, yLoc, zLoc, timeOffset, false, true, false, false);
    }

    public double getVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, int tLoc, boolean useTransform, boolean useDataScale) {
        if (tLoc < this.numTimepoints) {
            if (useTransform) {
                return this.transform.getValueAt(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, useDataScale);
            }
            if (useDataScale) {
                return this.voxelValue.getValueForOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels);
            }
            return this.voxelValue.getRawValueForOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + tLoc * this.volumeSizeVoxels);
        }
        return 0.0;
    }

    private double getVoxelValueAtIndexDataScaleOption(int xLoc, int yLoc, int zLoc, int tLoc, boolean useDataScale) {
        return this.getVoxelValueAtIndex(xLoc, yLoc, zLoc, tLoc, false, useDataScale);
    }

    private double getVoxelValueAtMM(double xLoc, double yLoc, double zLoc, int tLoc, boolean useDataScale, boolean useTransform, boolean nearestNeighbor, boolean trilinear, boolean sync) {
        if (tLoc < this.numTimepoints) {
            if (useTransform) {
                return this.transform.getValueAtMM(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, useDataScale, nearestNeighbor, trilinear, sync);
            }
            return this.transformWorld.getValueAtMM(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, useDataScale, nearestNeighbor, trilinear, sync);
        }
        return 0.0;
    }

    private double getVoxelValueAtMM2(double xLoc, double yLoc, double zLoc, int tLoc, boolean useDataScale, boolean useTransform) {
        return this.getVoxelValueAtMM(xLoc, yLoc, zLoc, tLoc, useDataScale, useTransform, false, false, false);
    }

    private boolean isCoordinateSpaceOrthogonalOrientation() {
        if (this.header.isNIFTI()) {
            NIFTI nifti = this.header.getNIFTIObject();
            if (this.coordSpaceIndex == 0) {
                return true;
            }
            if (this.coordSpaceIndex == 1) {
                return !Transform.isNonOrthogonal(nifti.getTransforms()[0].getMatrixCopy());
            }
            if (this.coordSpaceIndex == 2) {
                return !Transform.isNonOrthogonal(nifti.getTransforms()[1].getMatrixCopy());
            }
        }
        return true;
    }

    private void makeTransform() {
        this.transform = new Transform(this, Transform.IDENTITY, "", 0, this.voxelValue, this.orientation, this.header.getVoxelDimensions(), this.header.getImageDimensions());
        this.transform.setPreferredLabelType(0);
        this.transform.setWorldMatFixed(this.transformOrientation.getMatrixCopy());
    }

    private void makeTransformOrientation() {
        String string = this.orientation.getOrientation();
        String xyz = string.substring(0, 3).toUpperCase();
        String sense = string.substring(3);
        int xIndex = xyz.indexOf(88);
        int yIndex = xyz.indexOf(89);
        int zIndex = xyz.indexOf(90);
        char[] senseChars = sense.toCharArray();
        String orientWorldMat = "XYZ" + senseChars[xIndex] + senseChars[yIndex] + senseChars[zIndex];
        Coordinate origin = this.getOriginNative();
        Matrix worldMat = new Matrix(Orientation.convertNEMAToNiftiSForm(orientWorldMat, origin.xDbl, origin.yDbl, origin.zDbl, this.orientation.getXSize(), this.orientation.getYSize(), this.orientation.getZSize()));
        this.transformOrientation = new Transform(this, worldMat.inverse(), "World Coordinates", 1, this.voxelValue, this.orientation, this.header.getVoxelDimensions(), this.header.getImageDimensions());
    }

    private void makeTransformWorld() {
        this.transformWorld = new Transform(this, Transform.IDENTITY, "", 0, this.voxelValue, this.orientation, this.header.getVoxelDimensions(), this.header.getImageDimensions());
        this.transformWorld.setPreferredLabelType(0);
        this.transformWorld.setWorldMatFixed(this.transformOrientation.getMatrixCopy());
    }

    private boolean needsFitPrecision() {
        double typeRange;
        ImageType it = this.header.getImageType();
        double typeMax = it.getTypeMax(false);
        double typeMin = it.getTypeMin(false);
        double imageMin = this.getMinImageDiskValue();
        double imageMax = this.getMaxImageDiskValue();
        double imageRange = imageMax - imageMin;
        return (imageRange > (typeRange = typeMax - typeMin) || imageMin < typeMin || imageMax > typeMax) && it.getByteType() != 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersChange() {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersDataLoaded(int volIndex) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeDataLoaded(volIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersRangeUpdate(Object source, boolean sameThread) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeRangeChanged(this, source, sameThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersReverted(boolean success) {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeRevertedToSaved(success);
            }
        }
    }

    private void notifyListenersSaved(Volume vol, boolean success, boolean reload, ProgressBar pb, Volume overlayToClear, boolean isCopy, boolean sameThread) {
        ArrayList<VolumeListener> list = new ArrayList<VolumeListener>(this.listeners);
        for (VolumeListener listener : list) {
            listener.volumeSaved(vol, success, reload, pb, overlayToClear, isCopy, sameThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersTimepointChange() {
        List<VolumeListener> list = this.listeners;
        synchronized (list) {
            for (VolumeListener listener : this.listeners) {
                listener.volumeTimepointChanged(this);
            }
        }
    }

    private void notifyListenersTransformLoaded() {
        for (VolumeListener listener : this.listeners) {
            listener.volumeTransformLoaded();
        }
    }

    @Deprecated
    private void putVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, double value, boolean useTransform) {
        this.putVoxelValueAtCoordinate(xLoc, yLoc, zLoc, this.currentTimepoint, value, useTransform);
    }

    @Deprecated
    private void putVoxelValueAtCoordinate(double xLoc, double yLoc, double zLoc, int tLoc, double value, boolean useTransform) {
        if (tLoc < this.numTimepoints) {
            if (useTransform) {
                this.transform.putValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            } else {
                this.transformWorld.putValueAtCoordinate(xLoc, yLoc, zLoc, tLoc * this.volumeSizeVoxels, value);
            }
        }
    }

    private void putVoxelValueAtIndex(int xLoc, int yLoc, int zLoc, double value, boolean useTransform) {
        if (useTransform) {
            this.transform.putValueAt(xLoc, yLoc, zLoc, this.currentTimepoint * this.volumeSizeVoxels, value);
        } else {
            this.voxelValue.putValueAtOffset(this.orientation.convertIndexToOffset(xLoc, yLoc, zLoc) + this.currentTimepoint * this.volumeSizeVoxels, value);
        }
    }

    private void reconcile() {
        this.voxelValue.reconcile();
        this.orientation.reconcile();
    }

    public void resetTransforms(boolean resetTransform) {
        this.makeTransformOrientation();
        this.makeTransformWorld();
        if (resetTransform || this.transform == null) {
            this.makeTransform();
        } else {
            this.transform.setWorldMatFixed(this.transformOrientation.getMatrixCopy());
            this.transform.updateTransform();
        }
        this.updateWorldMat();
    }

    private void setHeaderDirty(boolean dirty) {
        this.headerIsDirty = dirty;
        if (this.initialized) {
            this.notifyListenersChange();
        }
    }

    private void setOrientationChanged() {
        this.orientationChanged = true;
        this.coordSpaceIndex = 0;
    }

    private void updateHeaderOrientationContingentInfo(String orientationString, ImageDimensions id, VoxelDimensions vd) {
        Volume.updateHeaderOrientationContingentInfo(orientationString, this.orientation.getOrientation(), id, vd);
    }

    private void updateHeaderOrigin(String orientationString, ImageDimensions id, ImageBounds ib, double xRatio, double yRatio, double zRatio) {
        Coordinate origin = this.header.getOrigin();
        String oldOrientationString = this.orientation.getOrientation();
        double zOrigin = 0.0;
        double yOrigin = 0.0;
        double xOrigin = 0.0;
        boolean negX = orientationString.charAt(orientationString.indexOf(88) + 3) == '-';
        boolean negY = orientationString.charAt(orientationString.indexOf(89) + 3) == '-';
        boolean negZ = orientationString.charAt(orientationString.indexOf(90) + 3) == '-';
        boolean flipX = orientationString.charAt(orientationString.indexOf(88) + 3) != oldOrientationString.charAt(oldOrientationString.indexOf(88) + 3);
        boolean flipY = orientationString.charAt(orientationString.indexOf(89) + 3) != oldOrientationString.charAt(oldOrientationString.indexOf(89) + 3);
        boolean flipZ = orientationString.charAt(orientationString.indexOf(90) + 3) != oldOrientationString.charAt(oldOrientationString.indexOf(90) + 3);
        xOrigin = flipX ? (double)id.getX() - origin.xDbl - 1.0 : origin.xDbl;
        yOrigin = flipY ? (double)id.getY() - origin.yDbl - 1.0 : origin.yDbl;
        zOrigin = flipZ ? (double)id.getZ() - origin.zDbl - 1.0 : origin.zDbl;
        xOrigin = negX ? (xOrigin -= (double)id.getX() - (double)ib.getMaxX() / xRatio - 1.0) : (xOrigin -= (double)ib.getMinX() / xRatio);
        yOrigin = negY ? (yOrigin -= (double)ib.getMinY() / yRatio) : (yOrigin -= (double)id.getY() - (double)ib.getMaxY() / yRatio - 1.0);
        zOrigin = negZ ? (zOrigin -= (double)ib.getMinZ() / zRatio) : (zOrigin -= (double)id.getZ() - (double)ib.getMaxZ() / zRatio - 1.0);
        origin.setValuesRound(xOrigin * xRatio, yOrigin * yRatio, zOrigin * zRatio);
    }

    private void updateHeaderTransformData(boolean isNifti, boolean isWorldMode) {
        if (isWorldMode && isNifti && this.header.isNIFTI()) {
            this.header.getNIFTIObject().clearTransforms();
        }
    }

    private void updateOrientationTransform(Matrix mat) {
        this.transformOrientation.updateTransform(mat);
    }

    private void updateWorldMat() {
        if (this.isCoordinateSpaceOrthogonalOrientation()) {
            this.transform.setWorldMatFixed(null);
            this.transformWorld.setWorldMatFixed(null);
        } else {
            this.transform.setWorldMatFixed(this.transformOrientation.getMatrixCopy());
            this.transformWorld.setWorldMatFixed(this.transformOrientation.getMatrixCopy());
        }
    }

    private void validateOrigin() {
        Coordinate origin = this.getOriginNative();
        ImageDimensions id = this.header.getImageDimensions();
        if (origin.xInt >= id.getX() - 1 || origin.xInt <= 0 || origin.yInt >= id.getY() - 1 || origin.yInt <= 0 || origin.zInt >= id.getZ() - 1 || origin.zInt <= 0) {
            this.hadInvalidOrigin = true;
            Coordinate originNew = new Coordinate((double)this.getXDim() / 2.0, (double)this.getYDim() / 2.0, (double)this.getZDim() / 2.0);
            this.setOrigin(originNew);
            this.setHeaderDirty(false);
        }
    }

    private void writeSeries(final File imageFile, final byte[][] seriesArray, final ImageBounds ib, final ClusterFilter overlay, final int transformIndex, final boolean isUsingTransform, final boolean isWorldMode, final boolean isInverseTransform, final boolean orientationChanged, final String orientationString, final Coordinate worldOrigin, final ImageDimensions idOld, final double resliceX, final double resliceY, final double resliceZ, final double resliceT, final double tr, final ImageType it, final boolean overwrite, final boolean applyDataScales, final boolean isOverlayMode, final boolean isOverlayMMmode, final int overlayMMtransform, final boolean nearestNeighbor, final boolean trilinear, final boolean sync, final boolean useThreshold, final double threshold, final boolean useMix, final boolean fitPrecision, final boolean maintainZero, final boolean fixPrecision, final int imageTrailer) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressBar pb = new ProgressBar(Volume.this.pbListener, "Writing file");
                pb.init(0, 0, 100);
                pb.setIndeterminateMode(true);
                Volume.this.doWriteSeries(imageFile, seriesArray, ib, overlay, transformIndex, isUsingTransform, isWorldMode, isInverseTransform, orientationChanged, orientationString, worldOrigin, idOld, resliceX, resliceY, resliceZ, resliceT, tr, it, overwrite, applyDataScales, isOverlayMode, isOverlayMMmode, overlayMMtransform, nearestNeighbor, trilinear, sync, useThreshold, threshold, useMix, fitPrecision, maintainZero, fixPrecision, imageTrailer);
                Volume.this.imageSaved(true, true, pb, overlay != null ? overlay.getVolume() : null, false, false);
            }
        }, "Volume.writeSeries() Thread");
        workThread.start();
    }

    public Coordinate getCenter() {
        return new Coordinate((double)((int)Math.floor((double)this.getXDim() / 2.0)), (double)((int)Math.floor((double)this.getYDim() / 2.0)), (double)((int)Math.floor((double)this.getZDim() / 2.0)));
    }

    public boolean isUsingTransform() {
        return this.usingTransform;
    }

    public void setUsingTransform(boolean usingTransform) {
        this.usingTransform = usingTransform;
    }

    public static boolean isDisableRGB() {
        return false;
    }

    public static void setDisableRGB(boolean disbleRGB) {
    }

    public boolean isNativeRGB() {
        return this.header.isRGB();
    }

    public boolean isRGB() {
        return this.header.getImageType().isRGBMode();
    }

    public boolean isARGB() {
        return this.header.getImageType().isRGBMode() && this.header.getImageType().getNumBytesPerVoxel() == 4;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return this.header.getSliceMetadata(slice, seriesPoint);
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return this.header.getSliceAnnotation(slice, seriesPoint);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isAllowsLinearInterpolation() {
        return !this.transform.isNearestNeighbor();
    }

    public void setAllowsLinearInterpolation(boolean allows) {
        this.transform.setNearestNeighbor(!allows);
    }

    public void setNativeDataTypeSaveMask(long nativeDataTypeSaveMask) {
        this.image.setNativeDataTypeSaveMask(nativeDataTypeSaveMask);
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void addBookmark(Coordinate coord, String label) {
        this.bookmarks.add(new Bookmark(coord, label));
        this.setHeaderAsDirty();
    }

    public void clearLoggedPoints() {
        if (this.bookmarks.size() > 0) {
            this.setHeaderAsDirty();
        }
        this.bookmarks.clear();
    }

    public Coordinate findLoggedPointByHash(int hash) {
        for (Bookmark bookmark : this.bookmarks) {
            if (bookmark.hashCode() != hash) continue;
            return bookmark.getCoordinate();
        }
        return null;
    }

    public String findLoggedLabelByCoordinate(Coordinate coord) {
        for (Bookmark bookmark : this.bookmarks) {
            if (!coord.equals((Object)bookmark.getCoordinate())) continue;
            return bookmark.getLabel();
        }
        return null;
    }

    public boolean removeBookmarkAtCoordinate(Coordinate coord) {
        Bookmark remove = null;
        for (Bookmark bookmark : this.bookmarks) {
            if (!coord.equals((Object)bookmark.getCoordinate())) continue;
            remove = bookmark;
        }
        if (remove != null) {
            this.bookmarks.remove(remove);
            this.setHeaderAsDirty();
            return true;
        }
        return false;
    }

    public Bookmark getNextBookmark() {
        Bookmark bookmark = null;
        if (this.bookmarkIndex < this.bookmarks.size()) {
            bookmark = this.bookmarks.get(this.bookmarkIndex);
        } else if (this.bookmarks.size() > 0) {
            bookmark = this.bookmarks.get(0);
        }
        if (bookmark != null) {
            ++this.bookmarkIndex;
            this.bookmarkIndex %= this.bookmarks.size();
        }
        return bookmark;
    }

    public Coordinate convertToNativeCoordinate(Coordinate coor) {
        return this.orientation.convertCoordinate(coor, true);
    }

    static {
        Volume.loadFormats();
    }
}

