/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import Jama.Matrix;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.VoxelValue;
import java.util.List;

public final class Transform
implements ImageTransform {
    private Coordinate preferredPointOfRotationCoordinate;
    private boolean disableAllNotifications;
    private boolean temporaryDisableNotify;
    private boolean temporaryForceNN;
    private boolean isNearestNeighbor;
    private final double volIntercept;
    Matrix mat;
    String title;
    Volume volume;
    VoxelValue voxelValue;
    double xSize;
    double ySize;
    double zSize;
    double[][] indexMat;
    double[][] matParams;
    double[][] matParamsInverse;
    double[][] mmMat;
    double[][] orientMat;
    double[][] originMat;
    double[][] sizeMat;
    double[][] sizeMatInverse;
    double[][] tempMat2;
    double[][] tempMat;
    double[][] worldMat;
    double[][] worldMatFixed;
    int numVoxelsVolume;
    int preferredLabelType;
    int preferredPointOfRotation;
    int type;
    int xDim;
    int xIncrement;
    int yDim;
    int yIncrement;
    int zDim;
    int zIncrement;
    public static final Matrix IDENTITY = new Matrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
    public static final Matrix MNI2TAL = new Matrix(new double[][]{{0.9357, 0.0029, -0.0072, 0.0}, {-0.0065, 0.9396, -0.0726, 0.0}, {0.0103, 0.0752, 0.8967, 0.0}, {0.0, 0.0, 0.0, 1.0}});
    public static final String PREFERRED_EXTENSION = "xform";
    public static final List<String> COMMON_EXTENSIONS = CollectionUtilities.immutable((String[])new String[]{"xform", "mat", "txt"});
    public static final double EPSILON = 1.0E-5;
    public static final int TYPE_INDEX = 0;
    public static final int TYPE_WORLD = 1;
    static boolean isGlobalNearestNeighbor;

    public static boolean isNonOrthogonal(double[][] affine) {
        if (affine != null) {
            double[] decomp = Transform.decompose(affine);
            double epsilon = 0.01;
            double rotX = Math.abs(1.0 - Math.abs(decomp[3]) / 90.0) % 1.0;
            double rotY = Math.abs(1.0 - Math.abs(decomp[4]) / 90.0) % 1.0;
            double rotZ = Math.abs(1.0 - Math.abs(decomp[5]) / 90.0) % 1.0;
            return rotX > 0.01 || rotY > 0.01 || rotZ > 0.01;
        }
        return false;
    }

    public static void setGlobalNearestNeighborState(boolean bool) {
        isGlobalNearestNeighbor = bool;
    }

    public static double[] decompose(double[][] matTemp) {
        double[] decomposedParams = new double[12];
        double xTrans = Transform.validateNum(matTemp[0][3]);
        double yTrans = Transform.validateNum(matTemp[1][3]);
        double zTrans = Transform.validateNum(matTemp[2][3]);
        double xRot = Transform.validateNum(Math.atan(matTemp[2][1] / matTemp[2][2]));
        double yRot = 0.0;
        yRot = xRot == 0.0 ? Transform.validateNum(Math.atan(-1.0 * Math.cos(xRot) * (matTemp[2][0] / matTemp[2][2]))) : Transform.validateNum(Math.atan(-1.0 * Math.sin(xRot) * (matTemp[2][0] / matTemp[2][1])));
        if (yRot == 0.0) {
            yRot = 1.0E-5;
        }
        double zScale = Transform.validateScale(matTemp[2][2] / (Math.cos(yRot) * Math.cos(xRot)));
        double tempK1 = Math.cos(xRot);
        double tempK2 = Math.sin(xRot) * Math.sin(yRot) + Math.sin(xRot) * (Math.cos(yRot) / Math.tan(yRot));
        double tempK3 = matTemp[1][0] * (Math.sin(xRot) / Math.tan(yRot)) + matTemp[1][1];
        double tempK4 = -1.0 * Math.sin(xRot);
        double tempK5 = Math.cos(xRot) * Math.sin(yRot) + Math.cos(xRot) * (Math.cos(yRot) / Math.tan(yRot));
        double tempK6 = matTemp[1][0] * (Math.cos(xRot) / Math.tan(yRot)) + matTemp[1][2];
        double zRot = Transform.validateNum(Math.atan((tempK1 * tempK6 - tempK3 * tempK4) / (tempK3 * tempK5 - tempK2 * tempK6)));
        double yScale = Transform.validateScale(tempK3 / (Math.cos(zRot) * tempK1 + Math.sin(zRot) * tempK2));
        double xSkew = Transform.validateNum((yScale * Math.sin(zRot) * Math.cos(yRot) - matTemp[1][0]) / (zScale * Math.sin(yRot)));
        double tempM1 = Math.cos(yRot) * Math.cos(zRot);
        double tempM2 = yScale * Math.cos(yRot) * Math.sin(zRot);
        double tempM3 = -1.0 * zScale * Math.sin(yRot);
        double tempM4 = Math.sin(xRot) * Math.sin(yRot) * Math.cos(zRot) - Math.cos(xRot) * Math.sin(zRot);
        double tempM5 = Math.sin(xRot) * Math.sin(yRot) * Math.sin(zRot) + Math.cos(xRot) * Math.cos(zRot);
        double tempM6 = zScale * Math.sin(xRot) * Math.cos(yRot);
        double tempM7 = Math.cos(xRot) * Math.sin(yRot) * Math.cos(zRot) + Math.sin(xRot) * Math.sin(zRot);
        double tempM8 = Math.cos(xRot) * Math.sin(yRot) * Math.sin(zRot) - Math.sin(xRot) * Math.cos(zRot);
        double tempM9 = zScale * Math.cos(xRot) * Math.cos(yRot);
        double tempN1 = tempM2 * tempM4 - tempM1 * tempM5;
        double tempN2 = tempM3 * tempM4 - tempM1 * tempM6;
        double tempN3 = tempM4 * matTemp[0][0] - tempM1 * matTemp[0][1];
        double tempN4 = tempM2 * tempM7 - tempM1 * tempM8;
        double tempN5 = tempM3 * tempM7 - tempM1 * tempM9;
        double tempN6 = tempM7 * matTemp[0][0] - tempM1 * matTemp[0][2];
        double ySkew = Transform.validateNum((tempN4 * tempN3 - tempN6 * tempN1) / (tempN2 * tempN4 - tempN1 * tempN5));
        double zSkew = Transform.validateNum((tempN3 * tempN5 - tempN2 * tempN6) / (tempN1 * tempN5 - tempN2 * tempN4));
        double xScale = Transform.validateScale((matTemp[0][0] - zSkew * tempM2 - ySkew * tempM3) / tempM1);
        if (MathUtilities.essentiallyEqual((double)yRot, (double)1.0E-5)) {
            yRot = 0.0;
        }
        xRot *= 57.29577951308232;
        yRot *= 57.29577951308232;
        zRot *= 57.29577951308232;
        decomposedParams[0] = Transform.validateZero(xTrans);
        decomposedParams[1] = Transform.validateZero(yTrans);
        decomposedParams[2] = Transform.validateZero(zTrans);
        decomposedParams[3] = Transform.validateZero(xRot);
        decomposedParams[4] = Transform.validateZero(yRot);
        decomposedParams[5] = Transform.validateZero(zRot);
        decomposedParams[6] = xScale;
        decomposedParams[7] = yScale;
        decomposedParams[8] = zScale;
        decomposedParams[9] = Transform.validateZero(xSkew);
        decomposedParams[10] = Transform.validateZero(ySkew);
        decomposedParams[11] = Transform.validateZero(zSkew);
        return decomposedParams;
    }

    public static boolean isIdentity(double[][] aMatParams) {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut == ctrIn && Math.abs(aMatParams[ctrOut][ctrIn]) != 1.0) {
                    return false;
                }
                if (ctrOut == ctrIn || aMatParams[ctrOut][ctrIn] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isIdentity(Matrix aMat) {
        return Transform.isIdentity(aMat.getArray());
    }

    private static boolean isSingular(Matrix aMat) {
        boolean isSingular = false;
        try {
            aMat.inverse();
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            isSingular = true;
        }
        return isSingular;
    }

    private static Coordinate transform(Coordinate coor, double[][] xform, boolean round) {
        double xTrans = (double)coor.xInt * xform[0][0] + (double)coor.yInt * xform[0][1] + (double)coor.zInt * xform[0][2] + xform[0][3];
        double yTrans = (double)coor.xInt * xform[1][0] + (double)coor.yInt * xform[1][1] + (double)coor.zInt * xform[1][2] + xform[1][3];
        double zTrans = (double)coor.xInt * xform[2][0] + (double)coor.yInt * xform[2][1] + (double)coor.zInt * xform[2][2] + xform[2][3];
        if (round) {
            coor.setValuesRound(xTrans, yTrans, zTrans);
        } else {
            coor.setValues(xTrans, yTrans, zTrans);
        }
        return coor;
    }

    private static double validateNum(double num) {
        if (Double.isInfinite(num)) {
            return 0.0;
        }
        if (Double.isNaN(num)) {
            return 0.0;
        }
        if (num == 0.0) {
            return 0.0;
        }
        return num;
    }

    private static double validateScale(double num) {
        if (Double.isInfinite(num)) {
            return 1.0;
        }
        if (Double.isNaN(num)) {
            return 1.0;
        }
        return num;
    }

    private static double validateZero(double num) {
        if (Math.abs(num) < 1.0E-5) {
            return 0.0;
        }
        return num;
    }

    protected Transform(Volume volume, Matrix mat, String title, int type, VoxelValue voxelValue, Orientation orientation, VoxelDimensions voxelDims, ImageDimensions imageDims) {
        this.volume = volume;
        this.title = title;
        this.type = type;
        this.xDim = imageDims.getX();
        this.yDim = imageDims.getY();
        this.zDim = imageDims.getZ();
        this.numVoxelsVolume = this.xDim * this.yDim * this.zDim;
        this.xSize = voxelDims.getXSize();
        this.ySize = voxelDims.getYSize();
        this.zSize = voxelDims.getZSize();
        this.indexMat = new double[4][4];
        this.sizeMat = new double[4][4];
        this.sizeMatInverse = new double[4][4];
        this.mmMat = new double[4][4];
        this.worldMat = new double[4][4];
        this.originMat = new double[4][4];
        this.tempMat = new double[4][4];
        this.tempMat2 = new double[4][4];
        this.sizeMat[0][0] = this.xSize;
        this.sizeMat[1][1] = this.ySize;
        this.sizeMat[2][2] = this.zSize;
        this.sizeMat[3][3] = 1.0;
        this.sizeMatInverse[0][0] = 1.0 / this.xSize;
        this.sizeMatInverse[1][1] = 1.0 / this.ySize;
        this.sizeMatInverse[2][2] = 1.0 / this.zSize;
        this.sizeMatInverse[3][3] = 1.0;
        this.updateOrientationContingentInfo(orientation, voxelValue);
        this.updateTransform(mat);
        this.volIntercept = volume.getVolumeIntercept();
    }

    public double[][] getMatrixCopy() {
        double[][] matrixVals = new double[4][4];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                matrixVals[ctrOut][ctrIn] = this.matParams[ctrOut][ctrIn];
            }
        }
        return matrixVals;
    }

    public double[][] getMatrixCopyInverse() {
        double[][] matrixVals = new double[4][4];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                matrixVals[ctrOut][ctrIn] = this.matParamsInverse[ctrOut][ctrIn];
            }
        }
        return matrixVals;
    }

    public double[] getMatrixCopySingle() {
        double[] matrixVals = new double[16];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                matrixVals[ctrOut * 4 + ctrIn] = this.matParams[ctrOut][ctrIn];
            }
        }
        return matrixVals;
    }

    public double[] getMatrixCopySingleInverse() {
        double[] matrixVals = new double[16];
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                matrixVals[ctrOut * 4 + ctrIn] = this.matParamsInverse[ctrOut][ctrIn];
            }
        }
        return matrixVals;
    }

    public int getPreferredLabelType() {
        return this.preferredLabelType;
    }

    public int getPreferredPointOfRotation() {
        return this.preferredPointOfRotation;
    }

    public Coordinate getPreferredPointOfRotationCoordinate() {
        return this.preferredPointOfRotationCoordinate;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isIdentity() {
        return Transform.isIdentity(this.mat);
    }

    public boolean isMNIToTalairach() {
        double[][] mni2talArray = MNI2TAL.getArray();
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut != ctrIn || !(Math.abs(mni2talArray[ctrOut][ctrIn] - this.matParamsInverse[ctrOut][ctrIn]) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular() {
        return Transform.isSingular(this.mat);
    }

    public boolean isTalairachToMNI() {
        double[][] mni2talArray = MNI2TAL.inverse().getArray();
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut != ctrIn || !(Math.abs(mni2talArray[ctrOut][ctrIn] - this.matParamsInverse[ctrOut][ctrIn]) > 1.0E-5)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTemporaryDisableNotify() {
        return this.temporaryDisableNotify;
    }

    public void loadTransform(double[][] matNew, int preferredOrigin, Coordinate coor) {
        this.volume.loadTransform(new Matrix(matNew), preferredOrigin, coor);
    }

    public void setPreferredLabelType(int val) {
        this.preferredLabelType = val;
    }

    public void setPreferredPointOfRotation(int val) {
        this.preferredPointOfRotation = val;
    }

    public void setPreferredPointOfRotationCoordinate(double xVal, double yVal, double zVal) {
        this.preferredPointOfRotationCoordinate = new Coordinate(xVal, yVal, zVal);
    }

    public void setTemporaryDisableNotify(boolean temporaryDisableNotify) {
        this.temporaryDisableNotify = temporaryDisableNotify;
    }

    public void setTemporaryForceNearestNeighbor(boolean bool) {
        this.temporaryForceNN = bool;
    }

    public void setWorldMatFixed(double[][] temp) {
        this.worldMatFixed = temp;
        this.updateWorldMat();
    }

    public Coordinate transform(Coordinate coor) {
        return Transform.transform(coor, this.indexMat, false);
    }

    public Coordinate transformNative(Coordinate coor) {
        return Transform.transform(coor, this.matParams, false);
    }

    public void updateTransform(double[][] matNew) {
        this.updateTransform(new Matrix(matNew));
    }

    protected void clear() {
        this.volume = null;
        this.voxelValue = null;
        this.mat = null;
        this.title = null;
    }

    protected long getNativeIntegerValueAtCoordinate(double xLoc, double yLoc, double zLoc, int seriesIndex) {
        double xTrans = xLoc * this.worldMat[0][0] + yLoc * this.worldMat[0][1] + zLoc * this.worldMat[0][2] + this.worldMat[0][3];
        double yTrans = xLoc * this.worldMat[1][0] + yLoc * this.worldMat[1][1] + zLoc * this.worldMat[1][2] + this.worldMat[1][3];
        double zTrans = xLoc * this.worldMat[2][0] + yLoc * this.worldMat[2][1] + zLoc * this.worldMat[2][2] + this.worldMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            yTrans += 0.5;
            zTrans += 0.5;
            if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                return 0L;
            }
            return this.voxelValue.getNativeIntegerValueAt((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement, seriesIndex);
        }
        return 0L;
    }

    protected long getNativeIntegerValueAtMM(double xLoc, double yLoc, double zLoc, int seriesIndex) {
        double xTrans = xLoc * this.mmMat[0][0] + yLoc * this.mmMat[0][1] + zLoc * this.mmMat[0][2] + this.mmMat[0][3];
        double yTrans = xLoc * this.mmMat[1][0] + yLoc * this.mmMat[1][1] + zLoc * this.mmMat[1][2] + this.mmMat[1][3];
        double zTrans = xLoc * this.mmMat[2][0] + yLoc * this.mmMat[2][1] + zLoc * this.mmMat[2][2] + this.mmMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            yTrans += 0.5;
            zTrans += 0.5;
            if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                return 0L;
            }
            return this.voxelValue.getNativeIntegerValueAt((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement, seriesIndex);
        }
        return 0L;
    }

    protected double getValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale) {
        return this.getValueAt(xLoc, yLoc, zLoc, timeOffset, useDataScale, false, false, false, false);
    }

    protected double getValueAtCoordinate(double xLoc, double yLoc, double zLoc, double tLoc, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync) {
        double xTrans = xLoc * this.worldMat[0][0] + yLoc * this.worldMat[0][1] + zLoc * this.worldMat[0][2] + this.worldMat[0][3];
        double yTrans = xLoc * this.worldMat[1][0] + yLoc * this.worldMat[1][1] + zLoc * this.worldMat[1][2] + this.worldMat[1][3];
        double zTrans = xLoc * this.worldMat[2][0] + yLoc * this.worldMat[2][1] + zLoc * this.worldMat[2][2] + this.worldMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            if (forceNN || this.temporaryForceNN || this.isNearestNeighbor || !forceNN && !forceTrilinear && !forceSync && (isGlobalNearestNeighbor || this.isNearestNeighbor)) {
                yTrans += 0.5;
                zTrans += 0.5;
                if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                    if (useDataScale) {
                        return 0.0;
                    }
                    return this.volIntercept;
                }
                if (useDataScale) {
                    return this.voxelValue.getValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)(tLoc + 0.5) * (long)this.numVoxelsVolume);
                }
                return this.voxelValue.getRawValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)(tLoc + 0.5) * (long)this.numVoxelsVolume);
            }
            if (forceTrilinear || !forceNN && !forceTrilinear && !forceSync && !isGlobalNearestNeighbor && !this.isNearestNeighbor) {
                if (useDataScale) {
                    return this.voxelValue.getValueAt(xTrans, yTrans, zTrans, tLoc);
                }
                return this.voxelValue.getRawValueAt(xTrans, yTrans, zTrans, tLoc);
            }
            if (forceSync) {
                return this.voxelValue.getSincValueAt(xTrans, yTrans, zTrans, tLoc, useDataScale);
            }
            if (useDataScale) {
                return 0.0;
            }
            return this.volIntercept;
        }
        if (useDataScale) {
            return 0.0;
        }
        return this.volIntercept;
    }

    protected double getValueAtCoordinate(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale) {
        return this.getValueAtCoordinate(xLoc, yLoc, zLoc, timeOffset, useDataScale, false, false, false);
    }

    protected double getValueAtCoordinate(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync) {
        return this.getValueAtCoordinate(xLoc, yLoc, zLoc, timeOffset, useDataScale, forceNN, forceTrilinear, forceSync, false);
    }

    protected double getValueAtCoordinate(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync, boolean useTemp) {
        double xTrans = xLoc * this.worldMat[0][0] + yLoc * this.worldMat[0][1] + zLoc * this.worldMat[0][2] + this.worldMat[0][3];
        double yTrans = xLoc * this.worldMat[1][0] + yLoc * this.worldMat[1][1] + zLoc * this.worldMat[1][2] + this.worldMat[1][3];
        double zTrans = xLoc * this.worldMat[2][0] + yLoc * this.worldMat[2][1] + zLoc * this.worldMat[2][2] + this.worldMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            if (forceNN || this.temporaryForceNN || this.isNearestNeighbor || !forceNN && !forceTrilinear && !forceSync && (isGlobalNearestNeighbor || this.isNearestNeighbor)) {
                yTrans += 0.5;
                zTrans += 0.5;
                if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                    if (useDataScale) {
                        return 0.0;
                    }
                    return this.volIntercept;
                }
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                    }
                    return this.voxelValue.getRawValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
                }
                return this.voxelValue.getRawValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
            }
            if (forceTrilinear || !forceNN && !forceTrilinear && !forceSync && !isGlobalNearestNeighbor && !this.isNearestNeighbor) {
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getTempValueAt(xTrans, yTrans, zTrans, timeOffset);
                    }
                    return this.voxelValue.getTempRawValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                return this.voxelValue.getRawValueAt(xTrans, yTrans, zTrans, timeOffset);
            }
            if (forceSync) {
                return this.voxelValue.getSincValueAt(xTrans, yTrans, zTrans, timeOffset, useDataScale);
            }
            if (useDataScale) {
                return 0.0;
            }
            return this.volIntercept;
        }
        if (useDataScale) {
            return 0.0;
        }
        return this.volIntercept;
    }

    protected double getValueAtMM(double xLoc, double yLoc, double zLoc, double tLoc, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync) {
        double xTrans = xLoc * this.mmMat[0][0] + yLoc * this.mmMat[0][1] + zLoc * this.mmMat[0][2] + this.mmMat[0][3];
        double yTrans = xLoc * this.mmMat[1][0] + yLoc * this.mmMat[1][1] + zLoc * this.mmMat[1][2] + this.mmMat[1][3];
        double zTrans = xLoc * this.mmMat[2][0] + yLoc * this.mmMat[2][1] + zLoc * this.mmMat[2][2] + this.mmMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            if (forceNN || this.temporaryForceNN || this.isNearestNeighbor || !forceNN && !forceTrilinear && !forceSync && (isGlobalNearestNeighbor || this.isNearestNeighbor)) {
                yTrans += 0.5;
                zTrans += 0.5;
                if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                    if (useDataScale) {
                        return 0.0;
                    }
                    return this.volIntercept;
                }
                if (useDataScale) {
                    return this.voxelValue.getValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)(tLoc + 0.5) * (long)this.numVoxelsVolume);
                }
                return this.voxelValue.getRawValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)(tLoc + 0.5) * (long)this.numVoxelsVolume);
            }
            if (forceTrilinear || !forceNN && !forceTrilinear && !forceSync && !isGlobalNearestNeighbor && !this.isNearestNeighbor) {
                if (useDataScale) {
                    return this.voxelValue.getValueAt(xTrans, yTrans, zTrans, tLoc);
                }
                return this.voxelValue.getRawValueAt(xTrans, yTrans, zTrans, tLoc);
            }
            if (forceSync) {
                return this.voxelValue.getSincValueAt(xTrans, yTrans, zTrans, tLoc, useDataScale);
            }
            if (useDataScale) {
                return 0.0;
            }
            return this.volIntercept;
        }
        if (useDataScale) {
            return 0.0;
        }
        return this.volIntercept;
    }

    protected double getValueAtMM(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale) {
        return this.getValueAtMM(xLoc, yLoc, zLoc, timeOffset, useDataScale, false, false, false);
    }

    protected double getValueAtMM(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync) {
        return this.getValueAtMM(xLoc, yLoc, zLoc, timeOffset, useDataScale, forceNN, forceTrilinear, forceSync, false);
    }

    protected double getValueAtMM(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSync, boolean useTemp) {
        double xTrans = xLoc * this.mmMat[0][0] + yLoc * this.mmMat[0][1] + zLoc * this.mmMat[0][2] + this.mmMat[0][3];
        double yTrans = xLoc * this.mmMat[1][0] + yLoc * this.mmMat[1][1] + zLoc * this.mmMat[1][2] + this.mmMat[1][3];
        double zTrans = xLoc * this.mmMat[2][0] + yLoc * this.mmMat[2][1] + zLoc * this.mmMat[2][2] + this.mmMat[2][3];
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            if (forceNN || this.temporaryForceNN || this.isNearestNeighbor || !forceNN && !forceTrilinear && !forceSync && (isGlobalNearestNeighbor || this.isNearestNeighbor)) {
                yTrans += 0.5;
                zTrans += 0.5;
                if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                    if (useDataScale) {
                        return 0.0;
                    }
                    return this.volIntercept;
                }
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                    }
                    return this.voxelValue.getRawValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
                }
                return this.voxelValue.getRawValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
            }
            if (forceTrilinear || !forceNN && !forceTrilinear && !forceSync && !isGlobalNearestNeighbor && !this.isNearestNeighbor) {
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getTempValueAt(xTrans, yTrans, zTrans, timeOffset);
                    }
                    return this.voxelValue.getTempRawValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                return this.voxelValue.getRawValueAt(xTrans, yTrans, zTrans, timeOffset);
            }
            if (forceSync) {
                return this.voxelValue.getSincValueAt(xTrans, yTrans, zTrans, timeOffset, useDataScale);
            }
            if (useDataScale) {
                return 0.0;
            }
            return this.volIntercept;
        }
        if (useDataScale) {
            return 0.0;
        }
        return this.volIntercept;
    }

    protected void putValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, double value) {
        double xTrans = xLoc * this.indexMat[0][0] + yLoc * this.indexMat[0][1] + zLoc * this.indexMat[0][2] + this.indexMat[0][3];
        double yTrans = xLoc * this.indexMat[1][0] + yLoc * this.indexMat[1][1] + zLoc * this.indexMat[1][2] + this.indexMat[1][3];
        double zTrans = xLoc * this.indexMat[2][0] + yLoc * this.indexMat[2][1] + zLoc * this.indexMat[2][2] + this.indexMat[2][3];
        int xInt = (int)(xTrans + 0.5);
        int yInt = (int)(yTrans + 0.5);
        int zInt = (int)(zTrans + 0.5);
        if (xInt >= 0 && yInt >= 0 && zInt >= 0 && xInt < this.xDim && yInt < this.yDim && zInt < this.zDim) {
            this.voxelValue.putValueAtOffset(xInt * this.xIncrement + yInt * this.yIncrement + zInt * this.zIncrement + timeOffset, value);
        }
    }

    protected void putValueAtCoordinate(double xLoc, double yLoc, double zLoc, int timeOffset, double value) {
        double xTrans = xLoc * this.worldMat[0][0] + yLoc * this.worldMat[0][1] + zLoc * this.worldMat[0][2] + this.worldMat[0][3];
        double yTrans = xLoc * this.worldMat[1][0] + yLoc * this.worldMat[1][1] + zLoc * this.worldMat[1][2] + this.worldMat[1][3];
        double zTrans = xLoc * this.worldMat[2][0] + yLoc * this.worldMat[2][1] + zLoc * this.worldMat[2][2] + this.worldMat[2][3];
        int xInt = (int)(xTrans + 0.5);
        int yInt = (int)(yTrans + 0.5);
        int zInt = (int)(zTrans + 0.5);
        if (xInt >= 0 && yInt >= 0 && zInt >= 0 && xInt < this.xDim && yInt < this.yDim && zInt < this.zDim) {
            this.voxelValue.putValueAtOffset(xInt * this.xIncrement + yInt * this.yIncrement + zInt * this.zIncrement + timeOffset, value);
        }
    }

    protected void setDisableAllNotifications() {
        this.disableAllNotifications = true;
    }

    protected void updateTransform() {
        int ctrIn;
        int ctrOut;
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.indexMat[ctrOut][ctrIn] = this.orientMat[ctrOut][0] * this.matParams[0][ctrIn] + this.orientMat[ctrOut][1] * this.matParams[1][ctrIn] + this.orientMat[ctrOut][2] * this.matParams[2][ctrIn] + this.orientMat[ctrOut][3] * this.matParams[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.mmMat[ctrOut][ctrIn] = this.indexMat[ctrOut][0] * this.sizeMatInverse[0][ctrIn] + this.indexMat[ctrOut][1] * this.sizeMatInverse[1][ctrIn] + this.indexMat[ctrOut][2] * this.sizeMatInverse[2][ctrIn] + this.indexMat[ctrOut][3] * this.sizeMatInverse[3][ctrIn];
            }
        }
        this.updateWorldMat();
        if (!this.disableAllNotifications) {
            this.volume.notifyListenersVolumeChange(true);
            if (!this.temporaryForceNN && !this.temporaryDisableNotify) {
                this.volume.notifyListenersTransformChange();
            }
        }
    }

    protected void updateTransform(Matrix matNew) {
        if (matNew != null) {
            this.mat = matNew;
            this.matParams = matNew.getArray();
            this.matParamsInverse = matNew.inverse().getArray();
        }
        this.updateTransform();
    }

    private double checkRoundOffError(double val) {
        double roundedVal = Math.rint(val);
        if (Math.abs(roundedVal - val) < 1.0E-5) {
            return roundedVal;
        }
        return val;
    }

    private double getValueAt(double xLoc, double yLoc, double zLoc, int timeOffset, boolean useDataScale, boolean forceNN, boolean forceTrilinear, boolean forceSinc, boolean useTemp) {
        double zTrans;
        double yTrans;
        double xTrans;
        if (this.type == 0) {
            xTrans = xLoc * this.indexMat[0][0] + yLoc * this.indexMat[0][1] + zLoc * this.indexMat[0][2] + this.indexMat[0][3];
            yTrans = xLoc * this.indexMat[1][0] + yLoc * this.indexMat[1][1] + zLoc * this.indexMat[1][2] + this.indexMat[1][3];
            zTrans = xLoc * this.indexMat[2][0] + yLoc * this.indexMat[2][1] + zLoc * this.indexMat[2][2] + this.indexMat[2][3];
        } else {
            xTrans = xLoc * this.matParams[0][0] + yLoc * this.matParams[0][1] + zLoc * this.matParams[0][2] + this.matParams[0][3];
            yTrans = xLoc * this.matParams[1][0] + yLoc * this.matParams[1][1] + zLoc * this.matParams[1][2] + this.matParams[1][3];
            zTrans = xLoc * this.matParams[2][0] + yLoc * this.matParams[2][1] + zLoc * this.matParams[2][2] + this.matParams[2][3];
        }
        if (xTrans < 0.0 || xTrans >= (double)this.xDim) {
            xTrans = this.checkRoundOffError(xTrans);
        }
        if (yTrans < 0.0 || yTrans >= (double)this.yDim) {
            yTrans = this.checkRoundOffError(yTrans);
        }
        if (zTrans < 0.0 || zTrans >= (double)this.zDim) {
            zTrans = this.checkRoundOffError(zTrans);
        }
        if (xTrans >= 0.0 && yTrans >= 0.0 && zTrans >= 0.0 && xTrans < (double)this.xDim && yTrans < (double)this.yDim && zTrans < (double)this.zDim) {
            if (forceNN || this.temporaryForceNN || this.isNearestNeighbor || !forceNN && !forceTrilinear && !forceSinc && (isGlobalNearestNeighbor || this.isNearestNeighbor)) {
                yTrans += 0.5;
                zTrans += 0.5;
                if ((xTrans += 0.5) >= (double)this.xDim || yTrans >= (double)this.yDim || zTrans >= (double)this.zDim) {
                    if (useDataScale) {
                        return 0.0;
                    }
                    return this.volIntercept;
                }
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                    }
                    return this.voxelValue.getRawValueAtOffsetTemp((int)xTrans * this.xIncrement + (int)yTrans * this.yIncrement + (int)zTrans * this.zIncrement + timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
                }
                return this.voxelValue.getRawValueForOffset((long)xTrans * (long)this.xIncrement + (long)yTrans * (long)this.yIncrement + (long)zTrans * (long)this.zIncrement + (long)timeOffset);
            }
            if (forceTrilinear || !forceNN && !forceTrilinear && !forceSinc && !isGlobalNearestNeighbor && !this.isNearestNeighbor) {
                if (useTemp) {
                    if (useDataScale) {
                        return this.voxelValue.getTempValueAt(xTrans, yTrans, zTrans, timeOffset);
                    }
                    return this.voxelValue.getTempRawValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                if (useDataScale) {
                    return this.voxelValue.getValueAt(xTrans, yTrans, zTrans, timeOffset);
                }
                return this.voxelValue.getRawValueAt(xTrans, yTrans, zTrans, timeOffset);
            }
            if (forceSinc) {
                return this.voxelValue.getSincValueAt(xTrans, yTrans, zTrans, timeOffset, useDataScale);
            }
            if (useDataScale) {
                return 0.0;
            }
            return this.volIntercept;
        }
        if (useDataScale) {
            return 0.0;
        }
        return this.volIntercept;
    }

    private void updateOrientationContingentInfo(Orientation orientation, VoxelValue aVoxelValue) {
        this.xIncrement = orientation.getXIncrement();
        this.yIncrement = orientation.getYIncrement();
        this.zIncrement = orientation.getZIncrement();
        this.orientMat = orientation.getOrientMat();
        this.voxelValue = aVoxelValue;
        this.updateWorldMat();
    }

    private void updateWorldMat() {
        if (this.worldMatFixed != null) {
            int ctrIn;
            int ctrOut;
            Coordinate origin = this.volume.getOrigin();
            double[][] flipMat = new double[][]{{-1.0, 0.0, 0.0, this.xDim - 1}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
            this.originMat[0][0] = -1.0;
            this.originMat[1][1] = -1.0;
            this.originMat[2][2] = -1.0;
            this.originMat[3][3] = 1.0;
            this.originMat[0][3] = origin.xDbl;
            this.originMat[1][3] = origin.yDbl;
            this.originMat[2][3] = origin.zDbl;
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat[ctrOut][ctrIn] = this.sizeMat[ctrOut][0] * this.originMat[0][ctrIn] + this.sizeMat[ctrOut][1] * this.originMat[1][ctrIn] + this.sizeMat[ctrOut][2] * this.originMat[2][ctrIn] + this.sizeMat[ctrOut][3] * this.originMat[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat2[ctrOut][ctrIn] = this.tempMat[ctrOut][0] * flipMat[0][ctrIn] + this.tempMat[ctrOut][1] * flipMat[1][ctrIn] + this.tempMat[ctrOut][2] * flipMat[2][ctrIn] + this.tempMat[ctrOut][3] * flipMat[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat[ctrOut][ctrIn] = this.tempMat2[ctrOut][0] * this.matParams[0][ctrIn] + this.tempMat2[ctrOut][1] * this.matParams[1][ctrIn] + this.tempMat2[ctrOut][2] * this.matParams[2][ctrIn] + this.tempMat2[ctrOut][3] * this.matParams[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat2[ctrOut][ctrIn] = this.tempMat[ctrOut][0] * flipMat[0][ctrIn] + this.tempMat[ctrOut][1] * flipMat[1][ctrIn] + this.tempMat[ctrOut][2] * flipMat[2][ctrIn] + this.tempMat[ctrOut][3] * flipMat[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat[ctrOut][ctrIn] = this.tempMat2[ctrOut][0] * this.originMat[0][ctrIn] + this.tempMat2[ctrOut][1] * this.originMat[1][ctrIn] + this.tempMat2[ctrOut][2] * this.originMat[2][ctrIn] + this.tempMat2[ctrOut][3] * this.originMat[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat2[ctrOut][ctrIn] = this.tempMat[ctrOut][0] * this.sizeMatInverse[0][ctrIn] + this.tempMat[ctrOut][1] * this.sizeMatInverse[1][ctrIn] + this.tempMat[ctrOut][2] * this.sizeMatInverse[2][ctrIn] + this.tempMat[ctrOut][3] * this.sizeMatInverse[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.worldMat[ctrOut][ctrIn] = this.worldMatFixed[ctrOut][0] * this.tempMat2[0][ctrIn] + this.worldMatFixed[ctrOut][1] * this.tempMat2[1][ctrIn] + this.worldMatFixed[ctrOut][2] * this.tempMat2[2][ctrIn] + this.worldMatFixed[ctrOut][3] * this.tempMat2[3][ctrIn];
                }
            }
        } else {
            int ctrIn;
            int ctrOut;
            Coordinate origin = this.volume.getOrigin();
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.originMat[ctrOut][ctrIn] = 0.0;
                }
            }
            this.originMat[0][0] = 1.0;
            this.originMat[1][1] = -1.0;
            this.originMat[2][2] = -1.0;
            this.originMat[3][3] = 1.0;
            this.originMat[0][3] = origin.xInt * 1;
            this.originMat[1][3] = origin.yInt * 1;
            this.originMat[2][3] = origin.zInt * 1;
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.tempMat[ctrOut][ctrIn] = this.indexMat[ctrOut][0] * this.originMat[0][ctrIn] + this.indexMat[ctrOut][1] * this.originMat[1][ctrIn] + this.indexMat[ctrOut][2] * this.originMat[2][ctrIn] + this.indexMat[ctrOut][3] * this.originMat[3][ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.worldMat[ctrOut][ctrIn] = this.tempMat[ctrOut][0] * this.sizeMatInverse[0][ctrIn] + this.tempMat[ctrOut][1] * this.sizeMatInverse[1][ctrIn] + this.tempMat[ctrOut][2] * this.sizeMatInverse[2][ctrIn] + this.tempMat[ctrOut][3] * this.sizeMatInverse[3][ctrIn];
                }
            }
        }
    }

    public boolean isNearestNeighbor() {
        return this.isNearestNeighbor;
    }

    public void setNearestNeighbor(boolean isNearestNeighbor) {
        this.isNearestNeighbor = isNearestNeighbor;
    }
}

