/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import Jama.Matrix;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.VoxelDimensions;

public class Orientation {
    private ImageDimensions imageDimensions;
    private String orientation;
    private VoxelDimensions voxelDimensions;
    private boolean colOrientation;
    private boolean colOrientationFlip;
    private boolean rowOrientation;
    private boolean rowOrientationFlip;
    private boolean sliceOrientation;
    private boolean sliceOrientationFlip;
    private double colSize;
    private double rowSize;
    private double sliceThickness;
    private double[][] orientInverseMat;
    private int numCols;
    private int numRows;
    private int numSlices;
    private int sliceSize;
    private int xIncrement;
    private int yIncrement;
    private int zIncrement;
    private final Coordinate origin;
    private final double[][] orientMat;
    public static final String DEFAULT_ORIENTATION = "XYZ+--";
    public static final String XYZ = "XYZ";
    public static final String XZY = "XZY";
    public static final String YZX = "YZX";

    public static int convertNEMAtoAVW(String anOrientationVal) {
        String anOrientation = anOrientationVal;
        if (!Orientation.isValidOrientationString(anOrientation = anOrientation.toUpperCase())) {
            return -1;
        }
        if (anOrientation.indexOf("XYZ+++") != -1) {
            return 0;
        }
        if (anOrientation.indexOf("XZY+++") != -1) {
            return 1;
        }
        if (anOrientation.indexOf("YZX+++") != -1) {
            return 2;
        }
        if (anOrientation.indexOf("XYZ+-+") != -1) {
            return 3;
        }
        if (anOrientation.indexOf("XZY+-+") != -1) {
            return 4;
        }
        if (anOrientation.indexOf("YZX+-+") != -1) {
            return 5;
        }
        if (anOrientation.indexOf(XYZ) != -1) {
            return 0;
        }
        if (anOrientation.indexOf(XZY) != -1) {
            return 1;
        }
        if (anOrientation.indexOf(YZX) != -1) {
            return 2;
        }
        return 0;
    }

    public static int convertNEMAtoAVW(String anOrientationVal, boolean[] negVals) {
        int returnVal;
        String anOrientation = anOrientationVal;
        if (!Orientation.isValidOrientationString(anOrientation) || negVals.length != 3) {
            return -1;
        }
        anOrientation = anOrientation.toUpperCase();
        negVals[0] = true;
        negVals[1] = true;
        negVals[2] = true;
        if (anOrientation.indexOf("XYZ+++") != -1) {
            return 0;
        }
        if (anOrientation.indexOf("XZY+++") != -1) {
            return 1;
        }
        if (anOrientation.indexOf("YZX+++") != -1) {
            return 2;
        }
        if (anOrientation.indexOf("XYZ+-+") != -1) {
            return 3;
        }
        if (anOrientation.indexOf("XZY+-+") != -1) {
            return 4;
        }
        if (anOrientation.indexOf("YZX+-+") != -1) {
            return 5;
        }
        if (anOrientation.indexOf(XYZ) != -1) {
            returnVal = 0;
        } else if (anOrientation.indexOf(XZY) != -1) {
            returnVal = 1;
        } else if (anOrientation.indexOf(YZX) != -1) {
            returnVal = 2;
        } else {
            return -1;
        }
        negVals[0] = anOrientation.charAt(3) != '-';
        negVals[1] = anOrientation.charAt(4) != '-';
        negVals[2] = anOrientation.charAt(5) != '-';
        return returnVal;
    }

    public static double[][] convertNEMAToNiftiSForm(String string, double xOrigin, double yOrigin, double zOrigin, double xDim, double yDim, double zDim) {
        double[][] affine = new double[4][4];
        if (!Orientation.isValidOrientationString(string)) {
            for (int ctr = 0; ctr < 4; ++ctr) {
                affine[ctr][ctr] = 1.0;
            }
        } else {
            String xyz = string.substring(0, 3).toUpperCase();
            String sense = string.substring(3);
            int xIndex = xyz.indexOf(88);
            int yIndex = xyz.indexOf(89);
            int zIndex = xyz.indexOf(90);
            double[] dims = new double[]{xDim, yDim, zDim};
            boolean xFlip = sense.charAt(xIndex) == '-';
            boolean yFlip = sense.charAt(yIndex) == '-';
            boolean zFlip = sense.charAt(zIndex) == '-';
            affine[0][xIndex] = dims[xIndex] * (double)(xFlip ? -1 : 1);
            affine[1][yIndex] = dims[yIndex] * (double)(yFlip ? -1 : 1);
            affine[2][zIndex] = dims[zIndex] * (double)(zFlip ? -1 : 1);
            affine[0][3] = xOrigin * dims[xIndex] * (double)(xFlip ? 1 : -1);
            affine[1][3] = yOrigin * dims[yIndex] * (double)(yFlip ? 1 : -1);
            affine[2][3] = zOrigin * dims[zIndex] * (double)(zFlip ? 1 : -1);
            affine[3][3] = 1.0;
        }
        return affine;
    }

    public static double[][] convertNEMAToNiftiSForm2(String string, double xOrigin, double yOrigin, double zOrigin, double xSize, double ySize, double zSize) {
        double[][] affine = new double[4][4];
        if (!Orientation.isValidOrientationString(string)) {
            for (int ctr = 0; ctr < 4; ++ctr) {
                affine[ctr][ctr] = 1.0;
            }
        } else {
            String xyz = string.substring(0, 3).toUpperCase();
            String sense = string.substring(3);
            int xIndex = xyz.indexOf(88);
            int yIndex = xyz.indexOf(89);
            int zIndex = xyz.indexOf(90);
            boolean xFlip = sense.charAt(xIndex) == '-';
            boolean yFlip = sense.charAt(yIndex) == '-';
            boolean zFlip = sense.charAt(zIndex) == '-';
            affine[0][xIndex] = xSize * (double)(xFlip ? -1 : 1);
            affine[1][yIndex] = ySize * (double)(yFlip ? -1 : 1);
            affine[2][zIndex] = zSize * (double)(zFlip ? -1 : 1);
            affine[0][3] = xOrigin * xSize * (double)(xFlip ? 1 : -1);
            affine[1][3] = yOrigin * ySize * (double)(yFlip ? 1 : -1);
            affine[2][3] = zOrigin * zSize * (double)(zFlip ? 1 : -1);
            affine[3][3] = 1.0;
        }
        return affine;
    }

    public static double[][] convertNiftiQFormToNiftiSForm(double qb, double qc, double qd, double qx, double qy, double qz, double dx, double dy, double dz, double qfac) {
        double zd;
        double[][] r = new double[4][4];
        double b = qb;
        double c = qc;
        double d = qd;
        r[3][2] = 0.0;
        r[3][1] = 0.0;
        r[3][0] = 0.0;
        r[3][3] = 1.0;
        double a = 1.0 - (b * b + c * c + d * d);
        if (a < 1.0E-7) {
            a = 1.0 / Math.sqrt(b * b + c * c + d * d);
            b *= a;
            c *= a;
            d *= a;
            a = 0.0;
        } else {
            a = Math.sqrt(a);
        }
        double xd = dx > 0.0 ? dx : 1.0;
        double yd = dy > 0.0 ? dy : 1.0;
        double d2 = zd = dz > 0.0 ? dz : 1.0;
        if (qfac < 0.0) {
            zd = -zd;
        }
        r[0][0] = (a * a + b * b - c * c - d * d) * xd;
        r[0][1] = 2.0 * (b * c - a * d) * yd;
        r[0][2] = 2.0 * (b * d + a * c) * zd;
        r[1][0] = 2.0 * (b * c + a * d) * xd;
        r[1][1] = (a * a + c * c - b * b - d * d) * yd;
        r[1][2] = 2.0 * (c * d - a * b) * zd;
        r[2][0] = 2.0 * (b * d - a * c) * xd;
        r[2][1] = 2.0 * (c * d + a * b) * yd;
        r[2][2] = (a * a + d * d - c * c - b * b) * zd;
        r[0][3] = qx;
        r[1][3] = qy;
        r[2][3] = qz;
        return r;
    }

    public static String convertNiftiSFormToNEMA(double[][] r1) {
        double[][] q1 = new double[3][3];
        double[][] p1 = new double[3][3];
        double xi = r1[0][0];
        double xj = r1[0][1];
        double xk = r1[0][2];
        double yi = r1[1][0];
        double yj = r1[1][1];
        double yk = r1[1][2];
        double zi = r1[2][0];
        double zj = r1[2][1];
        double zk = r1[2][2];
        double val = Math.sqrt(xi * xi + yi * yi + zi * zi);
        if (val == 0.0) {
            return null;
        }
        xi /= val;
        yi /= val;
        zi /= val;
        val = Math.sqrt(xj * xj + yj * yj + zj * zj);
        if (val == 0.0) {
            return null;
        }
        if (Math.abs(val = xi * (xj /= val) + yi * (yj /= val) + zi * (zj /= val)) > 1.0E-4) {
            if ((val = Math.sqrt((xj -= val * xi) * xj + (yj -= val * yi) * yj + (zj -= val * zi) * zj)) == 0.0) {
                return null;
            }
            xj /= val;
            yj /= val;
            zj /= val;
        }
        if ((val = Math.sqrt(xk * xk + yk * yk + zk * zk)) == 0.0) {
            xk = yi * zj - zi * yj;
            yk = zi * xj - zj * xi;
            zk = xi * yj - yi * xj;
        } else {
            xk /= val;
            yk /= val;
            zk /= val;
        }
        val = xi * xk + yi * yk + zi * zk;
        if (Math.abs(val) > 1.0E-4) {
            if ((val = Math.sqrt((xk -= val * xi) * xk + (yk -= val * yi) * yk + (zk -= val * zi) * zk)) == 0.0) {
                return null;
            }
            xk /= val;
            yk /= val;
            zk /= val;
        }
        if (Math.abs(val = xj * xk + yj * yk + zj * zk) > 1.0E-4) {
            if ((val = Math.sqrt((xk -= val * xj) * xk + (yk -= val * yj) * yk + (zk -= val * zj) * zk)) == 0.0) {
                return null;
            }
            xk /= val;
            yk /= val;
            zk /= val;
        }
        q1[0][0] = xi;
        q1[0][1] = xj;
        q1[0][2] = xk;
        q1[1][0] = yi;
        q1[1][1] = yj;
        q1[1][2] = yk;
        q1[2][0] = zi;
        q1[2][1] = zj;
        q1[2][2] = zk;
        double detQ = Orientation.niftimat33determ(q1);
        if (detQ == 0.0) {
            return null;
        }
        int k = 0;
        double vbest = -666.0;
        int rbest = 1;
        int qbest = 1;
        int pbest = 1;
        int ibest = 1;
        int jbest = 2;
        int kbest = 3;
        for (int i = 1; i <= 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                if (i == j) continue;
                for (k = 1; k <= 3; ++k) {
                    if (i == k || j == k) continue;
                    p1[2][2] = 0.0;
                    p1[2][1] = 0.0;
                    p1[2][0] = 0.0;
                    p1[1][2] = 0.0;
                    p1[1][1] = 0.0;
                    p1[1][0] = 0.0;
                    p1[0][2] = 0.0;
                    p1[0][1] = 0.0;
                    p1[0][0] = 0.0;
                    for (int p = -1; p <= 1; p += 2) {
                        for (int q = -1; q <= 1; q += 2) {
                            for (int r = -1; r <= 1; r += 2) {
                                double[][] m1;
                                p1[0][i - 1] = p;
                                p1[1][j - 1] = q;
                                p1[2][k - 1] = r;
                                double detP = Orientation.niftimat33determ(p1);
                                if (detP * detQ <= 0.0 || !((val = (m1 = Orientation.niftimat33mul(p1, q1))[0][0] + m1[1][1] + m1[2][2]) > vbest)) continue;
                                vbest = val;
                                ibest = i;
                                jbest = j;
                                kbest = k;
                                pbest = p;
                                qbest = q;
                                rbest = r;
                            }
                        }
                    }
                }
            }
        }
        char kSense = '\u0000';
        char jSense = '\u0000';
        char iSense = '\u0000';
        char kChar = '\u0000';
        char jChar = '\u0000';
        char iChar = '\u0000';
        switch (ibest * pbest) {
            case 1: {
                iChar = 'X';
                iSense = '+';
                break;
            }
            case -1: {
                iChar = 'X';
                iSense = '-';
                break;
            }
            case 2: {
                iChar = 'Y';
                iSense = '+';
                break;
            }
            case -2: {
                iChar = 'Y';
                iSense = '-';
                break;
            }
            case 3: {
                iChar = 'Z';
                iSense = '+';
                break;
            }
            case -3: {
                iChar = 'Z';
                iSense = '-';
                break;
            }
        }
        switch (jbest * qbest) {
            case 1: {
                jChar = 'X';
                jSense = '+';
                break;
            }
            case -1: {
                jChar = 'X';
                jSense = '-';
                break;
            }
            case 2: {
                jChar = 'Y';
                jSense = '+';
                break;
            }
            case -2: {
                jChar = 'Y';
                jSense = '-';
                break;
            }
            case 3: {
                jChar = 'Z';
                jSense = '+';
                break;
            }
            case -3: {
                jChar = 'Z';
                jSense = '-';
                break;
            }
        }
        switch (kbest * rbest) {
            case 1: {
                kChar = 'X';
                kSense = '+';
                break;
            }
            case -1: {
                kChar = 'X';
                kSense = '-';
                break;
            }
            case 2: {
                kChar = 'Y';
                kSense = '+';
                break;
            }
            case -2: {
                kChar = 'Y';
                kSense = '-';
                break;
            }
            case 3: {
                kChar = 'Z';
                kSense = '+';
                break;
            }
            case -3: {
                kChar = 'Z';
                kSense = '-';
                break;
            }
        }
        return String.valueOf(iChar) + jChar + kChar + iSense + jSense + kSense;
    }

    public static double convertNiftiSFormToNiftiQForm(double[][] mat44, double[] quaterns, double[] offsets) {
        double d;
        double c;
        double b;
        double qfac;
        double[][] mat33Q = new double[3][3];
        offsets[0] = mat44[0][3];
        offsets[1] = mat44[1][3];
        offsets[2] = mat44[2][3];
        double r11 = mat44[0][0];
        double r12 = mat44[0][1];
        double r13 = mat44[0][2];
        double r21 = mat44[1][0];
        double r22 = mat44[1][1];
        double r23 = mat44[1][2];
        double r31 = mat44[2][0];
        double r32 = mat44[2][1];
        double r33 = mat44[2][2];
        double xd = Math.sqrt(r11 * r11 + r21 * r21 + r31 * r31);
        double yd = Math.sqrt(r12 * r12 + r22 * r22 + r32 * r32);
        double zd = Math.sqrt(r13 * r13 + r23 * r23 + r33 * r33);
        if (xd == 0.0) {
            r11 = 1.0;
            r31 = 0.0;
            r21 = 0.0;
            xd = 1.0;
        }
        if (yd == 0.0) {
            r22 = 1.0;
            r32 = 0.0;
            r12 = 0.0;
            yd = 1.0;
        }
        if (zd == 0.0) {
            r33 = 1.0;
            r23 = 0.0;
            r13 = 0.0;
            zd = 1.0;
        }
        r11 /= xd;
        r21 /= xd;
        r31 /= xd;
        r12 /= yd;
        r22 /= yd;
        r32 /= yd;
        r23 /= zd;
        r33 /= zd;
        mat33Q[0][0] = r11;
        mat33Q[0][1] = r12;
        mat33Q[0][2] = r13 /= zd;
        mat33Q[1][0] = r21;
        mat33Q[1][1] = r22;
        mat33Q[1][2] = r23;
        mat33Q[2][0] = r31;
        mat33Q[2][1] = r32;
        mat33Q[2][2] = r33;
        double[][] mat33P = Orientation.niftimat33polar(mat33Q);
        r11 = mat33P[0][0];
        zd = r11 * (r22 = mat33P[1][1]) * (r33 = mat33P[2][2]) - r11 * (r32 = mat33P[2][1]) * (r23 = mat33P[1][2]) - (r21 = mat33P[1][0]) * (r12 = mat33P[0][1]) * r33 + r21 * r32 * (r13 = mat33P[0][2]) + (r31 = mat33P[2][0]) * r12 * r23 - r31 * r22 * r13;
        if (zd > 0.0) {
            qfac = 1.0;
        } else {
            qfac = -1.0;
            r13 = -r13;
            r23 = -r23;
            r33 = -r33;
        }
        double a = r11 + r22 + r33 + 1.0;
        if (a > 0.5) {
            a = 0.5 * Math.sqrt(a);
            b = 0.25 * (r32 - r23) / a;
            c = 0.25 * (r13 - r31) / a;
            d = 0.25 * (r21 - r12) / a;
        } else {
            xd = 1.0 + r11 - (r22 + r33);
            yd = 1.0 + r22 - (r11 + r33);
            zd = 1.0 + r33 - (r11 + r22);
            if (xd > 1.0) {
                b = 0.5 * Math.sqrt(xd);
                c = 0.25 * (r12 + r21) / b;
                d = 0.25 * (r13 + r31) / b;
                a = 0.25 * (r32 - r23) / b;
            } else if (yd > 1.0) {
                c = 0.5 * Math.sqrt(yd);
                b = 0.25 * (r12 + r21) / c;
                d = 0.25 * (r23 + r32) / c;
                a = 0.25 * (r13 - r31) / c;
            } else {
                d = 0.5 * Math.sqrt(zd);
                b = 0.25 * (r13 + r31) / d;
                c = 0.25 * (r23 + r32) / d;
                a = 0.25 * (r21 - r12) / d;
            }
            if (a < 0.0) {
                b = -b;
                c = -c;
                d = -d;
                a = -a;
            }
        }
        quaterns[0] = b;
        quaterns[1] = c;
        quaterns[2] = d;
        return qfac;
    }

    public static String getDefaultOrientation(String string) {
        if ("NIFTI".equals(string)) {
            return "XYZ-++";
        }
        if ("AVW".equals(string)) {
            return "XYZ+++";
        }
        return DEFAULT_ORIENTATION;
    }

    public static String getOrientationDescription(String string) {
        String des = "(Unknown)";
        if (string != null && string.length() > 0) {
            char[] chars = string.toCharArray();
            des = "Cols (" + chars[0] + chars[3] + "), Rows (" + chars[1] + chars[4] + "), Slices (" + chars[2] + chars[5] + ")";
        }
        return des;
    }

    public static boolean isValidOrientationString(String string) {
        if (string == null || string.length() != 6) {
            return false;
        }
        int temp = string.toUpperCase().indexOf("X");
        if (temp == -1 || temp > 2 || string.toUpperCase().lastIndexOf("X") != temp) {
            return false;
        }
        temp = string.toUpperCase().indexOf("Y");
        if (temp == -1 || temp > 2 || string.toUpperCase().lastIndexOf("Y") != temp) {
            return false;
        }
        temp = string.toUpperCase().indexOf("Z");
        if (temp == -1 || temp > 2 || string.toUpperCase().lastIndexOf("Z") != temp) {
            return false;
        }
        if (string.charAt(3) != '+' && string.charAt(3) != '-') {
            return false;
        }
        if (string.charAt(4) != '+' && string.charAt(4) != '-') {
            return false;
        }
        return string.charAt(5) == '+' || string.charAt(5) == '-';
    }

    private static String createOrientationDescription(String str, boolean colFlip, boolean rowFlip, boolean sliceFlip, boolean small) {
        char[] chars = str.toCharArray();
        Orientation.createOrientationDescriptionFlip(chars, colFlip, rowFlip, sliceFlip);
        if (small) {
            return "Cols (" + chars[0] + chars[3] + "), Rows (" + chars[1] + chars[4] + "), Slices (" + chars[2] + chars[5] + ")";
        }
        return "Columns (" + chars[0] + chars[3] + "), Rows (" + chars[1] + chars[4] + "), Slices (" + chars[2] + chars[5] + ")";
    }

    private static void createOrientationDescriptionFlip(char[] chars, boolean colFlip, boolean rowFlip, boolean sliceFlip) {
        if (colFlip) {
            chars[3] = chars[3] == '+' ? 45 : 43;
        }
        if (rowFlip) {
            chars[4] = chars[4] == '+' ? 45 : 43;
        }
        if (sliceFlip) {
            chars[5] = chars[5] == '+' ? 45 : 43;
        }
    }

    private static double niftimat33colnorm(double[][] a) {
        double r1 = Math.abs(a[0][0]) + Math.abs(a[1][0]) + Math.abs(a[2][0]);
        double r2 = Math.abs(a[0][1]) + Math.abs(a[1][1]) + Math.abs(a[2][1]);
        double r3 = Math.abs(a[0][2]) + Math.abs(a[1][2]) + Math.abs(a[2][2]);
        if (r1 < r2) {
            r1 = r2;
        }
        if (r1 < r3) {
            r1 = r3;
        }
        return r1;
    }

    private static double niftimat33determ(double[][] r) {
        double r11 = r[0][0];
        double r12 = r[0][1];
        double r13 = r[0][2];
        double r21 = r[1][0];
        double r22 = r[1][1];
        double r23 = r[1][2];
        double r31 = r[2][0];
        double r32 = r[2][1];
        double r33 = r[2][2];
        return r11 * r22 * r33 - r11 * r32 * r23 - r21 * r12 * r33 + r21 * r32 * r13 + r31 * r12 * r23 - r31 * r22 * r13;
    }

    private static double[][] niftimat33inverse(double[][] r) {
        double[][] q = new double[3][3];
        double r11 = r[0][0];
        double r22 = r[1][1];
        double r33 = r[2][2];
        double r32 = r[2][1];
        double r23 = r[1][2];
        double r21 = r[1][0];
        double r12 = r[0][1];
        double r13 = r[0][2];
        double r31 = r[2][0];
        double deti = r11 * r22 * r33 - r11 * r32 * r23 - r21 * r12 * r33 + r21 * r32 * r13 + r31 * r12 * r23 - r31 * r22 * r13;
        if (deti != 0.0) {
            deti = 1.0 / deti;
        }
        q[0][0] = deti * (r22 * r33 - r32 * r23);
        q[0][1] = deti * (-r12 * r33 + r32 * r13);
        q[0][2] = deti * (r12 * r23 - r22 * r13);
        q[1][0] = deti * (-r21 * r33 + r31 * r23);
        q[1][1] = deti * (r11 * r33 - r31 * r13);
        q[1][2] = deti * (-r11 * r23 + r21 * r13);
        q[2][0] = deti * (r21 * r32 - r31 * r22);
        q[2][1] = deti * (-r11 * r32 + r31 * r12);
        q[2][2] = deti * (r11 * r22 - r21 * r12);
        return q;
    }

    private static double[][] niftimat33mul(double[][] a, double[][] b) {
        double[][] c = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = a[i][0] * b[0][j] + a[i][1] * b[1][j] + a[i][2] * b[2][j];
            }
        }
        return c;
    }

    private static double[][] niftimat33polar(double[][] a) {
        double dif = 1.0;
        int k = 0;
        double[][] x = a;
        double[][] z = new double[3][3];
        double gam = Orientation.niftimat33determ(x);
        while (gam == 0.0) {
            gam = 1.0E-5 * (0.001 + Orientation.niftimat33rownorm(x));
            double[] dArray = x[0];
            dArray[0] = dArray[0] + gam;
            double[] dArray2 = x[1];
            dArray2[1] = dArray2[1] + gam;
            double[] dArray3 = x[2];
            dArray3[2] = dArray3[2] + gam;
            gam = Orientation.niftimat33determ(x);
        }
        while (true) {
            double gmi;
            double[][] y = Orientation.niftimat33inverse(x);
            if (dif > 0.3) {
                double alp = Math.sqrt(Orientation.niftimat33rownorm(x) * Orientation.niftimat33colnorm(x));
                double bet = Math.sqrt(Orientation.niftimat33rownorm(y) * Orientation.niftimat33colnorm(y));
                gam = Math.sqrt(bet / alp);
                gmi = 1.0 / gam;
            } else {
                gmi = 1.0;
                gam = 1.0;
            }
            z[0][0] = 0.5 * (gam * x[0][0] + gmi * y[0][0]);
            z[0][1] = 0.5 * (gam * x[0][1] + gmi * y[1][0]);
            z[0][2] = 0.5 * (gam * x[0][2] + gmi * y[2][0]);
            z[1][0] = 0.5 * (gam * x[1][0] + gmi * y[0][1]);
            z[1][1] = 0.5 * (gam * x[1][1] + gmi * y[1][1]);
            z[1][2] = 0.5 * (gam * x[1][2] + gmi * y[2][1]);
            z[2][0] = 0.5 * (gam * x[2][0] + gmi * y[0][2]);
            z[2][1] = 0.5 * (gam * x[2][1] + gmi * y[1][2]);
            z[2][2] = 0.5 * (gam * x[2][2] + gmi * y[2][2]);
            dif = Math.abs(z[0][0] - x[0][0]) + Math.abs(z[0][1] - x[0][1]) + Math.abs(z[0][2] - x[0][2]) + Math.abs(z[1][0] - x[1][0]) + Math.abs(z[1][1] - x[1][1]) + Math.abs(z[1][2] - x[1][2]) + Math.abs(z[2][0] - x[2][0]) + Math.abs(z[2][1] - x[2][1]) + Math.abs(z[2][2] - x[2][2]);
            if (++k > 100 || dif < 3.0E-6) break;
            x = z;
        }
        return z;
    }

    private static double niftimat33rownorm(double[][] a) {
        double r1 = Math.abs(a[0][0]) + Math.abs(a[0][1]) + Math.abs(a[0][2]);
        double r2 = Math.abs(a[1][0]) + Math.abs(a[1][1]) + Math.abs(a[1][2]);
        double r3 = Math.abs(a[2][0]) + Math.abs(a[2][1]) + Math.abs(a[2][2]);
        if (r1 < r2) {
            r1 = r2;
        }
        if (r1 < r3) {
            r1 = r3;
        }
        return r1;
    }

    public Orientation(String orientation, ImageDimensions imageDimensions, VoxelDimensions voxelDimensions, Coordinate origin) {
        this.orientation = orientation;
        this.imageDimensions = imageDimensions;
        this.voxelDimensions = voxelDimensions;
        this.origin = origin;
        this.orientMat = new double[4][4];
        this.reconcile();
    }

    public Coordinate convertCoordinate(Coordinate coor) {
        return this.convertCoordinate(coor, false);
    }

    public String getOrientation() {
        return this.getOrientation(true);
    }

    public String getOrientationDescription() {
        return this.getOrientationDescription(false);
    }

    public double[][] getOrientMat() {
        return this.orientMat;
    }

    public int getXDim() {
        return this.imageDimensions.getX();
    }

    public int getXIncrement() {
        return this.xIncrement;
    }

    public double getXSize() {
        return this.voxelDimensions.getXSize();
    }

    public int getYDim() {
        return this.imageDimensions.getY();
    }

    public int getYIncrement() {
        return this.yIncrement;
    }

    public double getYSize() {
        return this.voxelDimensions.getYSize();
    }

    public int getZDim() {
        return this.imageDimensions.getZ();
    }

    public int getZIncrement() {
        return this.zIncrement;
    }

    public double getZSize() {
        return this.voxelDimensions.getZSize();
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    private final void checkForNegativeVoxelSize() {
        if (this.voxelDimensions.getRowSize(false) < 0.0) {
            this.rowOrientationFlip = true;
        }
        if (this.voxelDimensions.getColSize(false) < 0.0) {
            this.colOrientationFlip = true;
        }
        if (this.voxelDimensions.getSliceThickness(false) < 0.0) {
            this.sliceOrientationFlip = true;
        }
    }

    public Coordinate convertCoordinate(Coordinate coor, boolean inverse) {
        double[][] mat = inverse ? this.orientInverseMat : this.orientMat;
        double xLoc = (double)coor.xInt * mat[0][0] + (double)coor.yInt * mat[0][1] + (double)coor.zInt * mat[0][2] + mat[0][3];
        double yLoc = (double)coor.xInt * mat[1][0] + (double)coor.yInt * mat[1][1] + (double)coor.zInt * mat[1][2] + mat[1][3];
        double zLoc = (double)coor.xInt * mat[2][0] + (double)coor.yInt * mat[2][1] + (double)coor.zInt * mat[2][2] + mat[2][3];
        return new Coordinate(xLoc, yLoc, zLoc);
    }

    private int convertIndexToOffset(int locX, int locY, int locZ, boolean useTransform) {
        int xLoc = locX;
        int yLoc = locY;
        int zLoc = locZ;
        if (useTransform) {
            xLoc = (int)((double)locX * this.orientMat[0][0] + (double)locY * this.orientMat[0][1] + (double)locZ * this.orientMat[0][2] + this.orientMat[0][3]);
            yLoc = (int)((double)locX * this.orientMat[1][0] + (double)locY * this.orientMat[1][1] + (double)locZ * this.orientMat[1][2] + this.orientMat[1][3]);
            zLoc = (int)((double)locX * this.orientMat[2][0] + (double)locY * this.orientMat[2][1] + (double)locZ * this.orientMat[2][2] + this.orientMat[2][3]);
        }
        return xLoc * this.xIncrement + yLoc * this.yIncrement + zLoc * this.zIncrement;
    }

    private void createOrientationInfo() {
        int zSubtract;
        int zMultiply;
        int ySubtract;
        int yMultiply;
        int xSubtract;
        int xMultiply;
        this.colOrientation = this.orientation.charAt(3) == '+';
        this.rowOrientation = this.orientation.charAt(4) == '+';
        this.sliceOrientation = this.orientation.charAt(5) == '+';
        if (this.rowOrientationFlip) {
            boolean bl = this.rowOrientation = !this.rowOrientation;
        }
        if (this.colOrientationFlip) {
            boolean bl = this.colOrientation = !this.colOrientation;
        }
        if (this.sliceOrientationFlip) {
            boolean bl = this.sliceOrientation = !this.sliceOrientation;
        }
        if (this.orientation.toUpperCase().startsWith(XYZ)) {
            this.imageDimensions.setX(this.numCols);
            this.imageDimensions.setY(this.numRows);
            this.imageDimensions.setZ(this.numSlices);
            this.voxelDimensions.setXSize(this.colSize);
            this.voxelDimensions.setYSize(this.rowSize);
            this.voxelDimensions.setZSize(this.sliceThickness);
            this.xIncrement = 1;
            this.yIncrement = this.numCols;
            this.zIncrement = this.sliceSize;
            if (this.colOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numCols - 1;
            }
            if (this.rowOrientation) {
                yMultiply = -1;
                ySubtract = this.numRows - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
            if (this.sliceOrientation) {
                zMultiply = -1;
                zSubtract = this.numSlices - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
        } else if (this.orientation.toUpperCase().startsWith(XZY)) {
            this.imageDimensions.setX(this.numCols);
            this.imageDimensions.setY(this.numSlices);
            this.imageDimensions.setZ(this.numRows);
            this.voxelDimensions.setXSize(this.colSize);
            this.voxelDimensions.setYSize(this.sliceThickness);
            this.voxelDimensions.setZSize(this.rowSize);
            this.xIncrement = 1;
            this.yIncrement = this.sliceSize;
            this.zIncrement = this.numCols;
            if (this.colOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numCols - 1;
            }
            if (this.rowOrientation) {
                zMultiply = -1;
                zSubtract = this.numRows - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
            if (this.sliceOrientation) {
                yMultiply = -1;
                ySubtract = this.numSlices - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
        } else if (this.orientation.toUpperCase().startsWith("YXZ")) {
            this.imageDimensions.setX(this.numRows);
            this.imageDimensions.setY(this.numCols);
            this.imageDimensions.setZ(this.numSlices);
            this.voxelDimensions.setXSize(this.rowSize);
            this.voxelDimensions.setYSize(this.colSize);
            this.voxelDimensions.setZSize(this.sliceThickness);
            this.xIncrement = this.numCols;
            this.yIncrement = 1;
            this.zIncrement = this.sliceSize;
            if (this.colOrientation) {
                yMultiply = -1;
                ySubtract = this.numCols - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
            if (this.rowOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numRows - 1;
            }
            if (this.sliceOrientation) {
                zMultiply = -1;
                zSubtract = this.numSlices - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
        } else if (this.orientation.toUpperCase().startsWith(YZX)) {
            this.imageDimensions.setX(this.numSlices);
            this.imageDimensions.setY(this.numCols);
            this.imageDimensions.setZ(this.numRows);
            this.voxelDimensions.setXSize(this.sliceThickness);
            this.voxelDimensions.setYSize(this.colSize);
            this.voxelDimensions.setZSize(this.rowSize);
            this.xIncrement = this.sliceSize;
            this.yIncrement = 1;
            this.zIncrement = this.numCols;
            if (this.colOrientation) {
                yMultiply = -1;
                ySubtract = this.numCols - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
            if (this.rowOrientation) {
                zMultiply = -1;
                zSubtract = this.numRows - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
            if (this.sliceOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numSlices - 1;
            }
        } else if (this.orientation.toUpperCase().startsWith("ZXY")) {
            this.imageDimensions.setX(this.numRows);
            this.imageDimensions.setY(this.numSlices);
            this.imageDimensions.setZ(this.numCols);
            this.voxelDimensions.setXSize(this.rowSize);
            this.voxelDimensions.setYSize(this.sliceThickness);
            this.voxelDimensions.setZSize(this.colSize);
            this.xIncrement = this.numCols;
            this.yIncrement = this.sliceSize;
            this.zIncrement = 1;
            if (this.colOrientation) {
                zMultiply = -1;
                zSubtract = this.numCols - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
            if (this.rowOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numRows - 1;
            }
            if (this.sliceOrientation) {
                yMultiply = -1;
                ySubtract = this.numSlices - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
        } else {
            this.imageDimensions.setX(this.numSlices);
            this.imageDimensions.setY(this.numRows);
            this.imageDimensions.setZ(this.numCols);
            this.voxelDimensions.setXSize(this.sliceThickness);
            this.voxelDimensions.setYSize(this.rowSize);
            this.voxelDimensions.setZSize(this.colSize);
            this.xIncrement = this.sliceSize;
            this.yIncrement = this.numCols;
            this.zIncrement = 1;
            if (this.colOrientation) {
                zMultiply = -1;
                zSubtract = this.numCols - 1;
            } else {
                zMultiply = 1;
                zSubtract = 0;
            }
            if (this.rowOrientation) {
                yMultiply = -1;
                ySubtract = this.numRows - 1;
            } else {
                yMultiply = 1;
                ySubtract = 0;
            }
            if (this.sliceOrientation) {
                xMultiply = 1;
                xSubtract = 0;
            } else {
                xMultiply = -1;
                xSubtract = this.numSlices - 1;
            }
        }
        this.orientMat[0][0] = xMultiply;
        this.orientMat[0][1] = 0.0;
        this.orientMat[0][2] = 0.0;
        this.orientMat[0][3] = xSubtract;
        this.orientMat[1][0] = 0.0;
        this.orientMat[1][1] = yMultiply;
        this.orientMat[1][2] = 0.0;
        this.orientMat[1][3] = ySubtract;
        this.orientMat[2][0] = 0.0;
        this.orientMat[2][1] = 0.0;
        this.orientMat[2][2] = zMultiply;
        this.orientMat[2][3] = zSubtract;
        this.orientMat[3][0] = 0.0;
        this.orientMat[3][1] = 0.0;
        this.orientMat[3][2] = 0.0;
        this.orientMat[3][3] = 1.0;
        Matrix mat = new Matrix(this.orientMat);
        Matrix inverse = mat.inverse();
        this.orientInverseMat = inverse.getArray();
    }

    private void flip(char dim) {
        char[] chars = this.orientation.toCharArray();
        chars[this.orientation.indexOf((int)dim) + 3] = chars[this.orientation.indexOf(dim) + 3] == '+' ? 45 : 43;
        this.orientation = new String(chars);
        this.createOrientationInfo();
    }

    private String getOrientation(boolean withNegVoxSize) {
        String string = null;
        if (withNegVoxSize) {
            char[] chars = this.orientation.toCharArray();
            if (this.colOrientationFlip) {
                chars[3] = chars[3] == '+' ? 45 : 43;
            }
            if (this.rowOrientationFlip) {
                chars[4] = chars[4] == '+' ? 45 : 43;
            }
            if (this.sliceOrientationFlip) {
                chars[5] = chars[5] == '+' ? 45 : 43;
            }
            string = new String(chars);
        } else {
            string = this.orientation;
        }
        return string;
    }

    private String getOrientationDescription(boolean small) {
        return Orientation.createOrientationDescription(this.orientation, this.colOrientationFlip, this.rowOrientationFlip, this.sliceOrientationFlip, small);
    }

    protected void clear() {
        this.orientation = null;
        this.imageDimensions = null;
        this.voxelDimensions = null;
    }

    protected Coordinate convertCoordinateInverse(Coordinate coor) {
        return this.convertCoordinate(coor, true);
    }

    protected int convertIndexToOffset(int xLoc, int yLoc, int zLoc) {
        return this.convertIndexToOffset(xLoc, yLoc, zLoc, true);
    }

    protected void flipAP() {
        this.flip('Y');
        Coordinate originNew = new Coordinate((double)this.origin.xInt, (double)(this.imageDimensions.getY() - this.origin.yInt - 1), (double)this.origin.zInt);
        this.origin.setValues(originNew);
    }

    protected void flipLR() {
        this.flip('X');
        Coordinate originNew = new Coordinate((double)(this.imageDimensions.getX() - this.origin.xInt - 1), (double)this.origin.yInt, (double)this.origin.zInt);
        this.origin.setValues(originNew);
    }

    protected void flipSI() {
        this.flip('Z');
        Coordinate originNew = new Coordinate((double)this.origin.xInt, (double)this.origin.yInt, (double)(this.imageDimensions.getZ() - this.origin.zInt - 1));
        this.origin.setValues(originNew);
    }

    protected final void reconcile() {
        this.numCols = this.imageDimensions.getCols();
        this.numRows = this.imageDimensions.getRows();
        this.numSlices = this.imageDimensions.getSlices();
        this.sliceSize = this.imageDimensions.getNumVoxelsSlice();
        this.colSize = this.voxelDimensions.getColSize(true);
        this.rowSize = this.voxelDimensions.getRowSize(true);
        this.sliceThickness = this.voxelDimensions.getSliceThickness(true);
        if (!Orientation.isValidOrientationString(this.orientation)) {
            this.orientation = DEFAULT_ORIENTATION;
        }
        this.checkForNegativeVoxelSize();
        this.createOrientationInfo();
    }

    protected void setImageByXYZ(int valX, int valY, int valZ) {
        if (this.orientation.toUpperCase().startsWith(XYZ)) {
            this.imageDimensions.setValues(new ImageDimensions(valX, valY, valZ, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valX);
            this.imageDimensions.setY(valY);
            this.imageDimensions.setZ(valZ);
        } else if (this.orientation.toUpperCase().startsWith(XZY)) {
            this.imageDimensions.setValues(new ImageDimensions(valX, valZ, valY, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valX);
            this.imageDimensions.setY(valZ);
            this.imageDimensions.setZ(valY);
        } else if (this.orientation.toUpperCase().startsWith("YXZ")) {
            this.imageDimensions.setValues(new ImageDimensions(valY, valX, valZ, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valY);
            this.imageDimensions.setY(valX);
            this.imageDimensions.setZ(valZ);
        } else if (this.orientation.toUpperCase().startsWith(YZX)) {
            this.imageDimensions.setValues(new ImageDimensions(valY, valZ, valX, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valY);
            this.imageDimensions.setY(valZ);
            this.imageDimensions.setZ(valX);
        } else if (this.orientation.toUpperCase().startsWith("ZXY")) {
            this.imageDimensions.setValues(new ImageDimensions(valZ, valX, valY, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valZ);
            this.imageDimensions.setY(valX);
            this.imageDimensions.setZ(valY);
        } else {
            this.imageDimensions.setValues(new ImageDimensions(valZ, valY, valX, this.imageDimensions.getTimepoints()), false);
            this.imageDimensions.setX(valZ);
            this.imageDimensions.setY(valY);
            this.imageDimensions.setZ(valX);
        }
    }

    protected void setVoxelByXYZ(double valX, double valY, double valZ) {
        if (this.orientation.toUpperCase().startsWith(XYZ)) {
            this.voxelDimensions.setColSize(valX);
            this.voxelDimensions.setRowSize(valY);
            this.voxelDimensions.setSliceThickness(valZ);
            this.voxelDimensions.setXSize(valX);
            this.voxelDimensions.setYSize(valY);
            this.voxelDimensions.setZSize(valZ);
        } else if (this.orientation.toUpperCase().startsWith(XZY)) {
            this.voxelDimensions.setColSize(valX);
            this.voxelDimensions.setRowSize(valZ);
            this.voxelDimensions.setSliceThickness(valY);
            this.voxelDimensions.setXSize(valX);
            this.voxelDimensions.setYSize(valZ);
            this.voxelDimensions.setZSize(valY);
        } else if (this.orientation.toUpperCase().startsWith("YXZ")) {
            this.voxelDimensions.setColSize(valY);
            this.voxelDimensions.setRowSize(valX);
            this.voxelDimensions.setSliceThickness(valZ);
            this.voxelDimensions.setXSize(valY);
            this.voxelDimensions.setYSize(valX);
            this.voxelDimensions.setZSize(valZ);
        } else if (this.orientation.toUpperCase().startsWith(YZX)) {
            this.voxelDimensions.setColSize(valY);
            this.voxelDimensions.setRowSize(valZ);
            this.voxelDimensions.setSliceThickness(valX);
            this.voxelDimensions.setXSize(valY);
            this.voxelDimensions.setYSize(valZ);
            this.voxelDimensions.setZSize(valX);
        } else if (this.orientation.toUpperCase().startsWith("ZXY")) {
            this.voxelDimensions.setColSize(valZ);
            this.voxelDimensions.setRowSize(valX);
            this.voxelDimensions.setSliceThickness(valY);
            this.voxelDimensions.setXSize(valZ);
            this.voxelDimensions.setYSize(valX);
            this.voxelDimensions.setZSize(valY);
        } else {
            this.voxelDimensions.setColSize(valZ);
            this.voxelDimensions.setRowSize(valY);
            this.voxelDimensions.setSliceThickness(valX);
            this.voxelDimensions.setXSize(valZ);
            this.voxelDimensions.setYSize(valY);
            this.voxelDimensions.setZSize(valX);
        }
    }
}

