/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Bookmark;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Metadata {
    public static final String DTD_FILENAME = "mangovolume.dtd";
    public static final String DTD_FILE_PATH = "http://rii.uthscsa.edu/mango/mangovolume.dtd";
    public static final String NAME2 = "name";
    public static final String ROOT_TAG = "MangoVolume";

    private Metadata() {
    }

    protected static void readMetadata(Volume volume, String data) throws ParserConfigurationException, SAXException, IOException {
        Node bookmarksListNode;
        NodeList bookmarksList;
        Node seriesListNode;
        if (data.indexOf(ROOT_TAG) == -1) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputStream in = Volume.class.getResourceAsStream(Metadata.DTD_FILENAME);
                BufferedReader input = new BufferedReader(new InputStreamReader(in));
                return new InputSource(input);
            }
        });
        InputSource is = new InputSource(new StringReader(data.trim()));
        Document doc = builder.parse(is);
        int seriesOffset = volume.getSeriesOffset();
        int seriesRange = volume.getSeriesOffsetRange();
        NodeList seriesList = doc.getElementsByTagName("Series");
        if (seriesList != null && seriesList.getLength() == 1 && (seriesListNode = seriesList.item(0)).getNodeType() == 1) {
            Element series = (Element)seriesListNode;
            NodeList pointList = series.getElementsByTagName("Point");
            int numPoints = pointList.getLength();
            for (int ctr = 0; ctr < numPoints; ++ctr) {
                Node pointNode = pointList.item(ctr);
                if (pointNode.getNodeType() != 1) continue;
                Element pointElem = (Element)pointNode;
                try {
                    int index = Integer.parseInt(pointElem.getAttribute("index"));
                    if ((index -= seriesOffset) < 0 || seriesRange != 0 && index >= seriesRange) continue;
                    String name = pointElem.getAttribute(NAME2);
                    volume.setLabel(index, name, false);
                    continue;
                }
                catch (NumberFormatException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        if ((bookmarksList = doc.getElementsByTagName("Bookmarks")) != null && bookmarksList.getLength() == 1 && (bookmarksListNode = bookmarksList.item(0)).getNodeType() == 1) {
            Element bookmarks = (Element)bookmarksListNode;
            NodeList bookmarkList = bookmarks.getElementsByTagName("Bookmark");
            int numBookmarks = bookmarkList.getLength();
            for (int ctr = 0; ctr < numBookmarks; ++ctr) {
                Node bookmarkNode = bookmarkList.item(ctr);
                if (bookmarkNode.getNodeType() != 1) continue;
                Element bookmarkElem = (Element)bookmarkNode;
                try {
                    int x = Integer.parseInt(bookmarkElem.getAttribute("x"));
                    int y = Integer.parseInt(bookmarkElem.getAttribute("y"));
                    int z = Integer.parseInt(bookmarkElem.getAttribute("z"));
                    String name = bookmarkElem.getAttribute(NAME2);
                    volume.addBookmark(new Coordinate((double)x, (double)y, (double)z), name);
                    continue;
                }
                catch (NumberFormatException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    protected static String writeMetadata(String version, Volume volume) throws ParserConfigurationException, TransformerException {
        int numTimepoints = volume.getNumTimepoints();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement(ROOT_TAG);
        doc.appendChild(rootElement);
        rootElement.setAttribute("version", version);
        if (volume.hasLabels()) {
            Element series = doc.createElement("Series");
            series.setAttribute("length", String.valueOf(numTimepoints));
            rootElement.appendChild(series);
            for (int ctr = 0; ctr < numTimepoints; ++ctr) {
                String name = volume.getLabel(ctr, null);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                Element seriesPoint = doc.createElement("Point");
                seriesPoint.setAttribute("index", String.valueOf(ctr));
                seriesPoint.setAttribute(NAME2, name);
                series.appendChild(seriesPoint);
            }
        }
        if (volume.getBookmarks().size() > 0) {
            List<Bookmark> bookmarksList = volume.getBookmarks();
            int bookmarksListSize = bookmarksList.size();
            Element bookmarks = doc.createElement("Bookmarks");
            bookmarks.setAttribute("length", String.valueOf(bookmarksListSize));
            rootElement.appendChild(bookmarks);
            for (Bookmark bookmark : bookmarksList) {
                Element bookmarkElem = doc.createElement("Bookmark");
                bookmarkElem.setAttribute(NAME2, bookmark.getLabel());
                bookmarkElem.setAttribute("x", String.valueOf(bookmark.getCoordinate().xInt));
                bookmarkElem.setAttribute("y", String.valueOf(bookmark.getCoordinate().yInt));
                bookmarkElem.setAttribute("z", String.valueOf(bookmark.getCoordinate().zInt));
                bookmarks.appendChild(bookmarkElem);
            }
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("doctype-system", DTD_FILE_PATH);
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String data = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return data;
    }
}

