/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class LabelList {
    private String[] labels;
    private boolean isSeries;
    public static final String DELIM = "|";
    public static final int LABELS_HEADER_SIZE = 4;
    public static final int PER_LABEL_HEADER = -9591;
    public static final int PER_LABEL_HEADER_OLD = -9991;
    public static final int PER_LABEL_HEADER_SIZE = 12;
    public static final int PER_LABEL_HEADER_SIZE_OLD = 4;
    public static final int SERIES_CODE = 9999;

    public LabelList(int length, boolean isSeries) {
        this.labels = new String[length];
        this.isSeries = isSeries;
        this.fillWithEmptyStrings();
    }

    public byte[] getData() {
        byte[] dataArray = null;
        for (int ctr = 0; ctr < this.labels.length; ++ctr) {
            if (!StringUtils.isNotBlank((CharSequence)this.labels[ctr])) continue;
            this.labels[ctr] = this.labels[ctr].replace(DELIM, " ");
        }
        String joined = StringUtils.join((Object[])this.labels, (String)DELIM);
        try {
            dataArray = joined.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex1) {
            AppLogger.error((Throwable)ex1);
        }
        ByteBuffer buffer = ByteBuffer.allocate(12 + dataArray.length);
        buffer.putInt(-9591);
        buffer.putInt(this.isSeries ? 9999 : 0);
        buffer.putInt(dataArray.length);
        buffer.put(dataArray);
        return buffer.array();
    }

    public String getLabel(int index) {
        if (index < this.labels.length && index >= 0) {
            if (StringUtils.isBlank((CharSequence)this.labels[index])) {
                return null;
            }
            return this.labels[index];
        }
        return null;
    }

    public String[] getLabelModel() {
        return this.labels;
    }

    public String[] getLabelModelCopy() {
        String[] copy = new String[this.labels.length];
        System.arraycopy(this.labels, 0, copy, 0, this.labels.length);
        return copy;
    }

    public int getLength() {
        return this.labels.length;
    }

    public boolean hasData() {
        for (String label : this.labels) {
            if (!StringUtils.isNotBlank((CharSequence)label)) continue;
            return true;
        }
        return false;
    }

    public void increaseSize(int size) {
        String[] labelsNew = new String[size];
        for (int ctr = 0; ctr < this.labels.length; ++ctr) {
            labelsNew[ctr] = this.labels[ctr];
        }
        this.labels = labelsNew;
    }

    public int setData(byte[] data) {
        return this.setData(data, 0);
    }

    public void setLabel(int index, String label) {
        if (index < this.labels.length) {
            this.labels[index] = StringUtils.isBlank((CharSequence)label) ? null : label;
        }
    }

    public String toString() {
        return "LabelList [labels=" + Arrays.toString(this.labels) + ", isSeries=" + this.isSeries + "]";
    }

    private void fillWithEmptyStrings() {
        for (int ctr = 0; ctr < this.labels.length; ++ctr) {
            this.labels[ctr] = "";
        }
    }

    private int setData(byte[] data, int offset) {
        int bytesRead = 0;
        ObjectInputStream objIn = null;
        Vector dataVec = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            byte[] versionBytes = new byte[4];
            bais.read(versionBytes);
            int version = ByteBuffer.wrap(versionBytes).getInt();
            bytesRead += 4;
            if (version == -9991) {
                bais.reset();
                FileUtilities.skipFully((InputStream)bais, (int)4);
                objIn = new ObjectInputStream(bais);
                dataVec = (Vector)objIn.readObject();
                if (dataVec != null) {
                    Iterator it = dataVec.iterator();
                    int index = 0;
                    while (it.hasNext()) {
                        String label = (String)it.next();
                        if (StringUtils.isNotBlank((CharSequence)label)) {
                            this.setLabel(index, label);
                        }
                        ++index;
                    }
                }
            } else {
                byte[] colorBytes = new byte[4];
                bais.read(colorBytes);
                this.isSeries = ByteBuffer.wrap(colorBytes).getInt() == 9999;
                bytesRead += 4;
                byte[] lengthBytes = new byte[4];
                bais.read(lengthBytes);
                int length = ByteBuffer.wrap(lengthBytes).getInt();
                bytesRead += 4;
                byte[] dataArray = new byte[length];
                bais.read(dataArray);
                String str = new String(dataArray, "UTF-8");
                String[] someLabels = StringUtils.splitPreserveAllTokens((String)str, (String)DELIM);
                bytesRead += length;
                this.labels = new String[someLabels.length];
                for (int ctr = 0; ctr < someLabels.length; ++ctr) {
                    this.labels[ctr] = someLabels[ctr];
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        return bytesRead;
    }

    public static int countLabels(byte[] data, int offset) {
        ObjectInputStream objIn = null;
        Vector dataVec = null;
        int count = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            byte[] versionBytes = new byte[4];
            bais.read(versionBytes);
            int version = ByteBuffer.wrap(versionBytes).getInt();
            if (version == -9991) {
                bais.reset();
                FileUtilities.skipFully((InputStream)bais, (int)4);
                objIn = new ObjectInputStream(bais);
                dataVec = (Vector)objIn.readObject();
                if (dataVec != null) {
                    Iterator it = dataVec.iterator();
                    while (it.hasNext()) {
                        it.next();
                        ++count;
                    }
                }
            } else {
                byte[] colorBytes = new byte[4];
                bais.read(colorBytes);
                byte[] lengthBytes = new byte[4];
                bais.read(lengthBytes);
                int length = ByteBuffer.wrap(lengthBytes).getInt();
                byte[] dataArray = new byte[length];
                bais.read(dataArray);
                String str = new String(dataArray, "UTF-8");
                String[] someLabels = StringUtils.splitPreserveAllTokens((String)str, (String)DELIM);
                count = someLabels.length;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        return count;
    }
}

