/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume;

import edu.uthscsa.ric.utilities.AppLogger;

public class ImageIntent
implements Cloneable {
    public static final String TEXT_SCALE = "scale";
    private static final String TEXT_DOF = "DOF";
    public static final String TEXT_LOCATION = "location";
    private String description;
    private String name;
    private String p1Name;
    private String p2Name;
    private String p3Name;
    private double p1;
    private double p2;
    private double p3;
    public static final String CODE_NOT_USED = "Not Used";
    public static final String CODE_UNKNOWN = "Unknown";
    private static final String[][] CODES = new String[][]{{"Unknown", "Not Used", "Not Used", "Not Used"}, {"Unknown", "Not Used", "Not Used", "Not Used"}, {"Correlation", "DOF", "Not Used", "Not Used"}, {"t-statistic", "DOF", "Not Used", "Not Used"}, {"F-statistic", "numerator DOF", "denominator DOF", "Not Used"}, {"Standard Normal", "numerator DOF", "denominator DOF", "Not Used"}, {"Chi-squared", "DOF", "Not Used", "Not Used"}, {"Beta", "a", "b", "Not Used"}, {"Binomial", "number of trials", "prob. per trial", "Not Used"}, {"Gamma", "shape", "scale", "Not Used"}, {"Poisson", "mean", "Not Used", "Not Used"}, {"Normal", "mean", "standard deviation", "Not Used"}, {"Noncentral F-statistic", "numerator DOF", "denominator DOF", "noncentrality"}, {"Noncentral Chi-squared", "DOF", "noncentrality", "Not Used"}, {"Logistic", "location", "scale", "Not Used"}, {"Laplace", "location", "scale", "Not Used"}, {"Uniform", "lower bound", "upper bound", "Not Used"}, {"Noncentral t-statistic", "DOF", "noncentrality", "Not Used"}, {"Weibull", "location", "scale", "power"}, {"Chi distribution", "DOF", "Not Used", "Not Used"}, {"Inverse Gaussian", "mu", "Not Used", "Not Used"}, {"Extreme Value I", "location", "scale", "Not Used"}, {"p-value", "Not Used", "Not Used", "Not Used"}, {"Log p-value", "Not Used", "Not Used", "Not Used"}, {"Log10 p-value", "Not Used", "Not Used", "Not Used"}};
    private static final String[][] CODES_1000 = new String[][]{{"Unknown", "Not Used", "Not Used", "Not Used"}, {"Parameter Estimate", "Not Used", "Not Used", "Not Used"}, {"Label", "Not Used", "Not Used", "Not Used"}, {"NeuroName", "Not Used", "Not Used", "Not Used"}, {"MxN Matrix", "Not Used", "Not Used", "Not Used"}, {"Symmetric Matrix", "Not Used", "Not Used", "Not Used"}, {"Displacement Vector", "Not Used", "Not Used", "Not Used"}, {"Vector", "Not Used", "Not Used", "Not Used"}, {"Coordinate", "Not Used", "Not Used", "Not Used"}, {"Triangle", "Not Used", "Not Used", "Not Used"}, {"Quaternion", "Not Used", "Not Used", "Not Used"}, {"Dimensionless Parameter", "Not Used", "Not Used", "Not Used"}};

    public ImageIntent() {
        this(CODE_UNKNOWN, "", CODE_NOT_USED, 0.0, CODE_NOT_USED, 0.0, CODE_NOT_USED, 0.0);
    }

    public ImageIntent(int codeVal, String des, double val1, double val2, double val3) {
        int code = codeVal;
        if (!(code >= 0 && code < CODES.length || code >= 1000 && code < 1000 + CODES_1000.length)) {
            code = 0;
        }
        if (code >= 0 && code < CODES.length) {
            this.createMe(CODES[code][0], des, CODES[code][1], val1, CODES[code][2], val2, CODES[code][3], val3);
        } else {
            this.createMe(CODES_1000[code -= 1000][0], des, CODES_1000[code][1], val1, CODES_1000[code][2], val2, CODES_1000[code][3], val3);
        }
    }

    private ImageIntent(String aName, String des, String val1Name, double val1, String val2Name, double val2, String val3Name, double val3) {
        this.createMe(aName, des, val1Name, val1, val2Name, val2, val3Name, val3);
    }

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public double getParameter1() {
        return this.p1;
    }

    public String getParameter1Name() {
        return this.p1Name;
    }

    public double getParameter2() {
        return this.p2;
    }

    public String getParameter2Name() {
        return this.p2Name;
    }

    public double getParameter3() {
        return this.p3;
    }

    public String getParameter3Name() {
        return this.p3Name;
    }

    private void createMe(String aName, String des, String val1Name, double val1, String val2Name, double val2, String val3Name, double val3) {
        this.name = aName;
        this.description = des;
        this.p1Name = val1Name;
        this.p2Name = val2Name;
        this.p3Name = val3Name;
        this.p1 = val1;
        this.p2 = val2;
        this.p3 = val3;
        if (this.name == null) {
            this.name = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        if (this.p1Name == null) {
            this.p1Name = "";
        }
        if (this.p2Name == null) {
            this.p2Name = "";
        }
        if (this.p3Name == null) {
            this.p3Name = "";
        }
    }
}

