/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.utilities;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBar
extends JPanel
implements ProgressMeter {
    private JProgressBar progressBar;
    private ProgressBarListener listener;
    private String description;
    private boolean finished;
    private boolean forceStart;
    private boolean notified;
    private boolean started;
    private int current;
    private int max;
    private int min;
    private long timeStarted;
    private static final long serialVersionUID = 1L;
    public static final double SHOW_PROGRESS_AFTER_DELAY_THRESH = 0.5;
    public static final long DELAY = 250L;

    public ProgressBar(ProgressBarListener listener, String description) {
        this.listener = listener;
        this.description = description;
        if (description == null) {
            description = "";
        }
        this.progressBar = new JProgressBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getString() {
                return String.valueOf(ProgressBar.this.description) + " " + super.getString();
            }
        };
        if (listener != null) {
            this.setBackground(listener.getProgressBarBackgroundColor());
            this.progressBar.setPreferredSize(listener.getProgressBarDimensions());
        }
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "Center");
    }

    public int getCurrent() {
        return this.current;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void init(int min, int current, int max) {
        this.min = min;
        this.current = current;
        this.max = max;
        this.notified = false;
        this.started = false;
        this.finished = false;
        this.progressBar.setMinimum(min);
        this.progressBar.setValue(current);
        this.progressBar.setMaximum(max);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        if (this.description == null) {
            this.description = "";
        }
    }

    public void setForceStart() {
        this.forceStart = true;
    }

    public void setIndeterminateMode(boolean bool) {
        this.progressBar.setIndeterminate(bool);
        if (bool) {
            if (!this.notified) {
                this.listener.progressBarStarted(this);
            }
            this.notified = true;
            this.started = true;
        }
        this.progressBar.setStringPainted(!bool);
    }

    public void setStringPainted(boolean bool) {
        this.progressBar.setStringPainted(bool);
    }

    public void setValue(final int num) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long timeDiff;
                ProgressBar.this.current = num;
                ProgressBar.this.progressBar.setValue(ProgressBar.this.current);
                if (!ProgressBar.this.started) {
                    ProgressBar.this.timeStarted = new Date().getTime();
                    ProgressBar.this.started = true;
                    if (ProgressBar.this.forceStart) {
                        ProgressBar.this.listener.progressBarStarted(ProgressBar.this);
                        ProgressBar.this.notified = true;
                    }
                } else if (!ProgressBar.this.notified && (timeDiff = new Date().getTime() - ProgressBar.this.timeStarted) > 250L && (double)ProgressBar.this.current < (double)(ProgressBar.this.max - ProgressBar.this.min) * 0.5 + (double)ProgressBar.this.min) {
                    ProgressBar.this.listener.progressBarStarted(ProgressBar.this);
                    ProgressBar.this.notified = true;
                }
                if (ProgressBar.this.current >= ProgressBar.this.max) {
                    if (ProgressBar.this.listener != null && !ProgressBar.this.finished && ProgressBar.this.started && ProgressBar.this.notified) {
                        ProgressBar.this.listener.progressBarFinished(ProgressBar.this);
                    }
                    ProgressBar.this.finished = true;
                }
            }
        });
    }

    public void start(int min, int current, int max) {
        this.init(min, current, max);
    }

    public void start(int min, int current, int max, boolean forceStart) {
        if (forceStart) {
            this.setForceStart();
        }
        this.init(min, current, max);
    }
}

