/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.display;

import edu.uthscsa.ric.roi.ROICalculator;
import edu.uthscsa.ric.roi.mask.display.ROIPathIterator;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ROIShape
implements Shape {
    private AffineTransform invShape;
    private AffineTransform inverse;
    private AffineTransform transform;
    private Point current;
    private Point previous;
    private ROIPathIterator lastIterator;
    private byte[] maskData;
    private int xDim;
    private int yDim;
    private final AffineTransform screenTransform;
    private final AffineTransform shapeTransform;
    private final Point2D.Double clickCenter;
    private final Point2D.Double clickCurrent;
    private final Point2D.Double dest;
    private final Point2D.Double original;
    private final ROICalculator calculator;
    private final int id;
    public static final byte DOWN = -128;
    public static final byte MASK = 16;
    public static final byte RECENT = 8;
    public static final byte RIGHT = 64;

    public ROIShape(int id) {
        this.id = id;
        this.previous = new Point();
        this.current = new Point();
        this.screenTransform = new AffineTransform();
        this.shapeTransform = new AffineTransform();
        this.transform = new AffineTransform();
        this.inverse = new AffineTransform();
        this.original = new Point2D.Double();
        this.dest = new Point2D.Double();
        this.clickCenter = new Point2D.Double();
        this.clickCurrent = new Point2D.Double();
        this.calculator = new ROICalculator();
        this.invShape = new AffineTransform();
    }

    public void clear() {
        this.maskData = null;
        this.transform = null;
        this.current = null;
        this.previous = null;
    }

    @Override
    public boolean contains(double xLoc, double yLoc) {
        int xInt = (int)xLoc;
        int yInt = (int)yLoc;
        if (xInt >= 0 && xInt < this.xDim - 1 && yInt >= 0 && yInt < this.yDim - 1) {
            return (this.maskData[xInt + yInt * this.xDim] & 0x10) != 0;
        }
        return false;
    }

    @Override
    public boolean contains(double xLoc, double yLoc, double width, double height) {
        for (int ctrH = 0; ctrH < (int)height; ++ctrH) {
            for (int ctrW = 0; ctrW < (int)width; ++ctrW) {
                if (this.contains(xLoc + (double)ctrW, yLoc + (double)ctrH)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean contains(Rectangle2D rec) {
        return this.contains(rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
    }

    public boolean doClick(Point structElemCenter, int structElemHalfSize) {
        int offset = structElemCenter.x + structElemCenter.y * this.xDim;
        boolean fill = structElemCenter.x >= 0 && structElemCenter.x < this.xDim && structElemCenter.y >= 0 && structElemCenter.y < this.yDim ? (this.maskData[offset] & 0x10) == 16 : false;
        this.doClick(structElemCenter, structElemHalfSize, fill);
        return fill;
    }

    public void doClick(Point structElemCenter, int structElemHalfSize, boolean fill) {
        int startX = Math.max(structElemCenter.x - structElemHalfSize, 0);
        int startY = Math.max(structElemCenter.y - structElemHalfSize, 0);
        int endX = Math.min(structElemCenter.x + structElemHalfSize, this.xDim - 2);
        int endY = Math.min(structElemCenter.y + structElemHalfSize, this.yDim - 2);
        int fillValue = fill ? 16 : 0;
        byte filler = (byte)(fillValue | 8);
        for (int ctrY = startY; ctrY <= endY; ++ctrY) {
            int offsetY = this.xDim * ctrY;
            for (int ctrX = startX; ctrX <= endX; ++ctrX) {
                int offset = ctrX + offsetY;
                this.maskData[offset] = filler;
                if (ctrX == startX) {
                    if (startX == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                    } else if ((this.maskData[offset - 1] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                }
                if (ctrX == endX) {
                    if ((this.maskData[offset + 1] & 0x10) != fillValue) {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                }
                if (ctrY == startY) {
                    if (startY == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                        }
                    } else if ((this.maskData[offset - this.xDim] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    } else {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    }
                }
                if (ctrY != endY) continue;
                if ((this.maskData[offset + this.xDim] & 0x10) != fillValue) {
                    int n = offset + this.xDim;
                    this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    continue;
                }
                int n = offset + this.xDim;
                this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
            }
        }
        this.previous.setLocation(structElemCenter);
    }

    public boolean doClickCircle(Point structElemCenter, int structElemHalfSize) {
        int offset = structElemCenter.x + structElemCenter.y * this.xDim;
        boolean fill = structElemCenter.x >= 0 && structElemCenter.x < this.xDim && structElemCenter.y >= 0 && structElemCenter.y < this.yDim ? (this.maskData[offset] & 0x10) == 16 : false;
        this.doClickCircle(structElemCenter, structElemHalfSize, fill, true);
        return fill;
    }

    public void doClickCircle(Point structElemCenter, int structElemHalfSize, boolean fill) {
        this.doClickCircle(structElemCenter, structElemHalfSize, fill, true);
    }

    public void doDrag(Point destination, int structElemHalfSize, boolean fill) {
        this.current.setLocation(this.previous);
        int fillValue = fill ? 16 : 0;
        byte filler = (byte)(fillValue | 8);
        int previousX = -1;
        int previousY = -1;
        int distanceX = Math.abs(destination.x - this.previous.x);
        int distanceY = Math.abs(destination.y - this.previous.y);
        double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
        double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
        int incrementX = destination.x - this.previous.x > 0 ? 1 : -1;
        int incrementY = destination.y - this.previous.y > 0 ? 1 : -1;
        int structElemOffsetX = structElemHalfSize * incrementX;
        int structElemOffsetY = structElemHalfSize * incrementY;
        if (distanceX > 0 && distanceX >= distanceY) {
            for (int ctr = 0; ctr <= distanceX; ++ctr) {
                int offset;
                int yPos;
                this.current.setLocation(ctr * incrementX + this.previous.x, (int)((double)this.previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                int offsetX = this.current.x + structElemOffsetX;
                int offsetY = this.xDim * (this.current.y + structElemOffsetY);
                int xPos = this.current.x + structElemOffsetX;
                for (int ctrY = structElemHalfSize * -1; ctrY <= structElemHalfSize; ++ctrY) {
                    yPos = this.current.y + ctrY;
                    if (xPos >= this.xDim - 1 || xPos < 0 || yPos >= this.yDim - 1 || yPos < 0) continue;
                    offset = offsetX + this.xDim * (this.current.y + ctrY);
                    this.maskData[offset] = filler;
                    if (fill && xPos == this.xDim - 2) {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else if ((this.maskData[offset + 1] & 0x10) != fillValue) {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                    if (xPos == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                    } else if ((this.maskData[offset - 1] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                    if (fill && yPos == this.yDim - 2) {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    } else if ((this.maskData[offset + this.xDim] & 0x10) != fillValue) {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    } else {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    }
                    if (yPos == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                            continue;
                        }
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                        continue;
                    }
                    if ((this.maskData[offset - this.xDim] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        continue;
                    }
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                }
                if (this.current.y != previousY) {
                    yPos = this.current.y + structElemOffsetY;
                    for (int ctrX = structElemHalfSize * -1; ctrX <= structElemHalfSize; ++ctrX) {
                        xPos = this.current.x + ctrX;
                        if (xPos >= this.xDim - 1 || xPos < 0 || yPos >= this.yDim - 1 || yPos < 0) continue;
                        offset = offsetY + (this.current.x + ctrX);
                        this.maskData[offset] = filler;
                        if (fill && xPos == this.xDim - 2) {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else if ((this.maskData[offset + 1] & 0x10) != fillValue) {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                        if (xPos == 0) {
                            if (fill) {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                            } else {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                            }
                        } else if ((this.maskData[offset - 1] & 0x10) != fillValue) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                        if (fill && yPos == this.yDim - 2) {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        } else if ((this.maskData[offset + this.xDim] & 0x10) != fillValue) {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        } else {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                        }
                        if (yPos == 0) {
                            if (fill) {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                                continue;
                            }
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                            continue;
                        }
                        if ((this.maskData[offset - this.xDim] & 0x10) != fillValue) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                            continue;
                        }
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    }
                }
                previousY = this.current.y;
            }
        } else if (distanceY > 0 && distanceY > distanceX) {
            for (int ctr = 0; ctr <= distanceY; ++ctr) {
                int offset;
                int xPos;
                this.current.setLocation((int)((double)this.previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + this.previous.y);
                int offsetY = this.xDim * (this.current.y + structElemOffsetY);
                int offsetX = this.current.x + structElemOffsetX;
                int yPos = this.current.y + structElemOffsetY;
                for (int ctrX = structElemHalfSize * -1; ctrX <= structElemHalfSize; ++ctrX) {
                    xPos = this.current.x + ctrX;
                    if (xPos >= this.xDim - 1 || xPos < 0 || yPos >= this.yDim - 1 || yPos < 0) continue;
                    offset = offsetY + (this.current.x + ctrX);
                    this.maskData[offset] = filler;
                    if (fill && xPos == this.xDim - 2) {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else if ((this.maskData[offset + 1] & 0x10) != fillValue) {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset + 1;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                    if (xPos == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                    } else if ((this.maskData[offset - 1] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                    if (fill && yPos == this.yDim - 2) {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    } else if ((this.maskData[offset + this.xDim] & 0x10) != fillValue) {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    } else {
                        int n = offset + this.xDim;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    }
                    if (yPos == 0) {
                        if (fill) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                            continue;
                        }
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                        continue;
                    }
                    if ((this.maskData[offset - this.xDim] & 0x10) != fillValue) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        continue;
                    }
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                }
                if (this.current.x != previousX) {
                    xPos = this.current.x + structElemOffsetX;
                    for (int ctrY = structElemHalfSize * -1; ctrY <= structElemHalfSize; ++ctrY) {
                        yPos = this.current.y + ctrY;
                        if (xPos >= this.xDim - 1 || xPos < 0 || yPos >= this.yDim - 1 || yPos < 0) continue;
                        offset = offsetX + this.xDim * (this.current.y + ctrY);
                        this.maskData[offset] = filler;
                        if (fill && xPos == this.xDim - 2) {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else if ((this.maskData[offset + 1] & 0x10) != fillValue) {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset + 1;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                        if (xPos == 0) {
                            if (fill) {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                            } else {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                            }
                        } else if ((this.maskData[offset - 1] & 0x10) != fillValue) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                        } else {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                        }
                        if (fill && yPos == this.yDim - 2) {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        } else if ((this.maskData[offset + this.xDim] & 0x10) != fillValue) {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        } else {
                            int n = offset + this.xDim;
                            this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                        }
                        if (yPos == 0) {
                            if (fill) {
                                int n = offset;
                                this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                                continue;
                            }
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                            continue;
                        }
                        if ((this.maskData[offset - this.xDim] & 0x10) != fillValue) {
                            int n = offset;
                            this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                            continue;
                        }
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    }
                }
                previousX = this.current.x;
            }
        }
        this.previous.setLocation(destination);
    }

    public void doDragCircle(Point destination, int structElemHalfSize, boolean fill) {
        int incrementY;
        this.current.setLocation(this.previous);
        int distanceX = Math.abs(destination.x - this.previous.x);
        int distanceY = Math.abs(destination.y - this.previous.y);
        double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
        double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
        int incrementX = destination.x - this.previous.x > 0 ? 1 : -1;
        int n = incrementY = destination.y - this.previous.y > 0 ? 1 : -1;
        if (distanceX > 0 && distanceX >= distanceY) {
            for (int ctr = 0; ctr <= distanceX; ++ctr) {
                this.current.setLocation(ctr * incrementX + this.previous.x, (int)((double)this.previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                this.doClickCircle(this.current, structElemHalfSize, fill, false);
            }
        } else if (distanceY > 0 && distanceY > distanceX) {
            for (int ctr = 0; ctr <= distanceY; ++ctr) {
                this.current.setLocation((int)((double)this.previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + this.previous.y);
                this.doClickCircle(this.current, structElemHalfSize, fill, false);
            }
        }
        this.previous.setLocation(destination);
    }

    public double getArea() {
        return this.calculator.getArea();
    }

    @Override
    public Rectangle getBounds() {
        int xMin = this.xDim - 1;
        int xMax = 0;
        int yMin = this.yDim - 1;
        int yMax = 0;
        for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
            for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                if ((this.maskData[ctrX + this.xDim * ctrY] & 0x10) == 0) continue;
                if (yMin > ctrY) {
                    yMin = ctrY;
                }
                if (yMax < ctrY) {
                    yMax = ctrY;
                }
                if (xMin > ctrX) {
                    xMin = ctrX;
                }
                if (xMax >= ctrX) continue;
                xMax = ctrX;
            }
        }
        if (xMax - xMin < 0) {
            return new Rectangle();
        }
        return new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public double getCentroidX() {
        return this.calculator.getCentroidX();
    }

    public double getCentroidY() {
        return this.calculator.getCentroidY();
    }

    public int getID() {
        return this.id;
    }

    public AffineTransform getInverseTransform() {
        return this.inverse;
    }

    public PathIterator getPathIterator() {
        return new ROIPathIterator(this.xDim, this.yDim, this.maskData, new AffineTransform(), this.calculator);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform xform) {
        AffineTransform at = xform;
        if (at != null) {
            at.concatenate(this.transform);
        } else {
            at = this.transform;
        }
        this.lastIterator = new ROIPathIterator(this.xDim, this.yDim, this.maskData, at, this.calculator);
        return this.lastIterator;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public boolean intersects(double xLoc, double yLoc, double width, double height) {
        for (int ctrH = 0; ctrH < (int)height; ++ctrH) {
            for (int ctrW = 0; ctrW < (int)width; ++ctrW) {
                if (!this.contains(xLoc + (double)ctrW, yLoc + (double)ctrH)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rec) {
        return this.intersects(rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
    }

    public void setData(int dimX, int dimY, byte[] aMaskData) {
        this.xDim = dimX;
        this.yDim = dimY;
        this.maskData = aMaskData;
    }

    public void setScreenTransform(AffineTransform transform) {
        if (transform != null) {
            this.screenTransform.setTransform(transform);
            this.updateFinalTransform();
            this.updateInverseTransforms();
        }
    }

    public void setShapeTransform(AffineTransform aTransform) {
        this.shapeTransform.setTransform(aTransform);
        this.updateFinalTransform();
        this.updateInverseTransforms();
    }

    public void shapeWillChange() {
        if (this.lastIterator != null && !this.lastIterator.isDone()) {
            this.lastIterator.forceClose();
        }
    }

    public boolean transformedShapeContains(double xLoc, double yLoc) {
        this.original.setLocation(xLoc, yLoc);
        this.invShape.transform(this.original, this.dest);
        return this.contains(this.dest);
    }

    private void doClickCircle(Point structElemCenter, int structElemHalfSizeVal, boolean fill, boolean setPrevious) {
        int structElemHalfSize = structElemHalfSizeVal;
        int startX = Math.max(structElemCenter.x - ++structElemHalfSize - 1, 0);
        int startY = Math.max(structElemCenter.y - structElemHalfSize - 1, 0);
        int endX = Math.min(structElemCenter.x + structElemHalfSize + 1, this.xDim - 1);
        int endY = Math.min(structElemCenter.y + structElemHalfSize + 1, this.yDim - 1);
        double radius = structElemHalfSize;
        int fillValue = fill ? 16 : 0;
        byte filler = (byte)(fillValue | 8);
        this.clickCenter.setLocation(structElemCenter.x, structElemCenter.y);
        for (int ctrY = startY; ctrY <= endY; ++ctrY) {
            int offsetY = this.xDim * ctrY;
            for (int ctrX = startX; ctrX <= endX; ++ctrX) {
                this.clickCurrent.setLocation(ctrX, ctrY);
                int offset = ctrX + offsetY;
                if (this.clickCurrent.distance(this.clickCenter) < radius && ctrX < this.xDim - 1 && ctrY < this.yDim - 1) {
                    this.maskData[offset] = filler;
                }
                if (ctrX == 0) {
                    if ((this.maskData[offset] & 0x10) == 16) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                    } else {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                    }
                } else if ((this.maskData[offset - 1] & 0x10) != (this.maskData[offset] & 0x10)) {
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] | 0xFFFFFF80);
                } else {
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] & 0x7F);
                }
                if (ctrY == 0) {
                    if ((this.maskData[offset] & 0x10) == 16) {
                        int n = offset;
                        this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                        continue;
                    }
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
                    continue;
                }
                if ((this.maskData[offset - this.xDim] & 0x10) != (this.maskData[offset] & 0x10)) {
                    int n = offset;
                    this.maskData[n] = (byte)(this.maskData[n] | 0x40);
                    continue;
                }
                int n = offset;
                this.maskData[n] = (byte)(this.maskData[n] & 0xFFFFFFBF);
            }
        }
        if (setPrevious) {
            this.previous.setLocation(structElemCenter);
        }
    }

    private void updateFinalTransform() {
        this.transform.setTransform(this.screenTransform);
        this.transform.concatenate(this.shapeTransform);
    }

    private void updateInverseTransforms() {
        try {
            this.invShape = this.shapeTransform.createInverse();
            this.inverse = this.transform.createInverse();
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
    }

    public byte[] getMaskData() {
        return this.maskData;
    }

    public int getX() {
        return this.xDim;
    }

    public int getY() {
        return this.yDim;
    }
}

