/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.clipboard;

import edu.uthscsa.ric.roi.mask.clipboard.AbstractROIClipboardHelper;
import edu.uthscsa.ric.roi.mask.clipboard.ROIByteClipboardHelper;
import edu.uthscsa.ric.roi.mask.clipboard.ROIClipboardUser;
import edu.uthscsa.ric.roi.mask.clipboard.ROIIntClipboardHelper;
import edu.uthscsa.ric.roi.mask.clipboard.ROILongClipboardHelper;
import edu.uthscsa.ric.roi.mask.clipboard.ROIShortClipboardHelper;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Coordinate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ROIClipboard {
    public static final String ERROR_MESSAGE_NOT_INITIALIZED = "Clipboard was not initialized!";
    public static final String ERROR_MESSAGE = "Problem using ROI clipboard!";
    private ByteArrayInputStream reader;
    private final ByteArrayOutputStream writer = new ByteArrayOutputStream(){

        @Override
        public byte[] toByteArray() {
            return this.buf;
        }
    };
    private ByteBuffer pasteBuffer;
    private Coordinate origin;
    private GZIPInputStream input;
    private GZIPOutputStream output;
    private AbstractROIClipboardHelper helper;
    private ROIClipboardUser currentUser;
    private String[] labels;
    private boolean getInitialized;
    private boolean hasContents;
    private boolean putInitialized;
    private byte[] pasteBufferBytes;
    private double xSize;
    private double ySize;
    private double zSize;
    private int bytesRead;
    private int copyMaskMaxColors;
    private int copyType;
    private int sizeOfContents;
    private int tDim;
    private int xDim;
    private int yDim;
    private int zDim;
    private long copyMask = -1L;
    public static final int TYPE_SERIES = 2;
    public static final int TYPE_SLICE = 0;
    public static final int TYPE_VOLUME = 1;

    public ROIClipboard() {
        this.makeHelper(8);
    }

    public boolean canPaste() {
        return this.sizeOfContents > 0;
    }

    public void cleanUp() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public void finishGetting() {
        block3: {
            try {
                this.input.close();
                this.getInitialized = false;
                if (this.currentUser != null) {
                    this.currentUser.pasteCompleted(true, "Paste successful!");
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.getInitialized = false;
                if (this.currentUser == null) break block3;
                this.currentUser.pasteCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public void finishPutting() {
        block4: {
            try {
                if (this.helper.bufCtr != 0) {
                    this.output.write(this.helper.buffer, 0, this.helper.bufCtr);
                }
                this.output.close();
                this.putInitialized = false;
                this.sizeOfContents = this.helper.totalBytesCtr;
                this.hasContents = true;
                if (this.currentUser != null) {
                    this.currentUser.copyCompleted(true, "Copy successful!");
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.putInitialized = false;
                if (this.currentUser == null) break block4;
                this.currentUser.copyCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public long get() {
        try {
            if (!this.getInitialized) {
                throw new IllegalStateException(ERROR_MESSAGE_NOT_INITIALIZED);
            }
            if (this.helper.bufCtr == this.bytesRead || this.helper.bufCtr >= this.helper.buffer.length) {
                this.bytesRead = this.input.read(this.helper.buffer);
                while (this.bytesRead % this.helper.getNumBytes() != 0) {
                    this.bytesRead += this.input.read(this.helper.buffer, this.bytesRead, this.helper.getNumBytes() - this.bytesRead % this.helper.getNumBytes());
                }
                this.helper.bufCtr = 0;
            }
            long data = this.helper.getData();
            this.helper.increment();
            return data;
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            this.getInitialized = false;
            if (this.currentUser != null) {
                this.currentUser.pasteCompleted(false, ERROR_MESSAGE);
            }
            return 0L;
        }
    }

    public int get(byte[] data) {
        try {
            int bytesReadCurrent;
            if (!this.getInitialized) {
                throw new IllegalStateException(ERROR_MESSAGE_NOT_INITIALIZED);
            }
            this.bytesRead = this.input.read(data, 0, data.length);
            while (this.bytesRead < data.length && (bytesReadCurrent = this.input.read(data, this.bytesRead, data.length - this.bytesRead)) != -1) {
                this.bytesRead += bytesReadCurrent;
            }
            this.helper.totalBytesCtr += this.bytesRead;
            return this.bytesRead;
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            this.getInitialized = false;
            if (this.currentUser != null) {
                this.currentUser.pasteCompleted(false, ERROR_MESSAGE);
            }
            return 0;
        }
    }

    public long getCopyMask() {
        return this.copyMask;
    }

    public int getCopyMaskMaxColors() {
        return this.copyMaskMaxColors;
    }

    public int getCopyType() {
        return this.copyType;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Coordinate getOrigin() {
        return this.origin;
    }

    public long getPasteValue(int offset) {
        if (this.copyMaskMaxColors == 8) {
            return (long)this.pasteBuffer.get(offset) & 0xFFL;
        }
        if (this.copyMaskMaxColors == 16) {
            return (long)this.pasteBuffer.getShort(offset * 2) & 0xFFFFL;
        }
        if (this.copyMaskMaxColors == 32) {
            return (long)this.pasteBuffer.getInt(offset * 4) & 0xFFFFFFFFL;
        }
        return this.pasteBuffer.getLong(offset * 8);
    }

    public int getSizeOfContents() {
        return this.sizeOfContents;
    }

    public int getT() {
        return this.tDim;
    }

    public int getX() {
        return this.xDim;
    }

    public double getXSize() {
        return this.xSize;
    }

    public int getY() {
        return this.yDim;
    }

    public double getYSize() {
        return this.ySize;
    }

    public int getZ() {
        return this.zDim;
    }

    public double getZSize() {
        return this.zSize;
    }

    public boolean hasContents() {
        return this.hasContents;
    }

    public void initializeGetting() {
        block2: {
            try {
                this.reader = new ByteArrayInputStream(this.writer.toByteArray());
                this.input = new GZIPInputStream(this.reader);
                this.getInitialized = true;
                this.helper.bufCtr = this.helper.buffer.length;
                this.helper.totalBytesCtr = 0;
                this.bytesRead = 0;
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.getInitialized = false;
                if (this.currentUser == null) break block2;
                this.currentUser.pasteCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public void initializePutting() {
        block2: {
            try {
                this.writer.reset();
                this.output = new GZIPOutputStream(this.writer);
                this.putInitialized = true;
                this.helper.bufCtr = 0;
                this.helper.totalBytesCtr = 0;
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.putInitialized = false;
                if (this.currentUser == null) break block2;
                this.currentUser.copyCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public boolean isMultiSelectionCopied() {
        int count = 0;
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((this.copyMask >> ctr & 1L) != 1L) continue;
            ++count;
        }
        return count > 1;
    }

    public boolean isSameDim(int dimX, int dimY, int dimZ) {
        return dimX == this.xDim && dimY == this.yDim && dimZ == this.zDim;
    }

    public boolean isSameSize(double sizeX, double sizeY, double sizeZ) {
        return sizeX == this.xSize && sizeY == this.ySize && sizeZ == this.zSize;
    }

    public boolean isSeriesCopy() {
        return this.copyType == 2;
    }

    public boolean isSliceCopy() {
        return this.copyType == 0;
    }

    public boolean isVolumeCopy() {
        return this.copyType == 1;
    }

    public void makeHelper(int maxColors) {
        if (this.helper == null || this.helper.getMaxColors() < maxColors) {
            if (maxColors == 8) {
                this.helper = new ROIByteClipboardHelper();
            } else if (maxColors == 16) {
                this.helper = new ROIShortClipboardHelper();
            } else if (maxColors == 32) {
                this.helper = new ROIIntClipboardHelper();
            } else if (maxColors == 64) {
                this.helper = new ROILongClipboardHelper();
            }
            this.reset();
        }
    }

    public byte[] makePasteBuffer(int size) {
        if (this.copyMaskMaxColors == 8) {
            this.pasteBufferBytes = new byte[size * 1];
        } else if (this.copyMaskMaxColors == 16) {
            this.pasteBufferBytes = new byte[size * 2];
        } else if (this.copyMaskMaxColors == 32) {
            this.pasteBufferBytes = new byte[size * 4];
        } else if (this.copyMaskMaxColors == 64) {
            this.pasteBufferBytes = new byte[size * 8];
        }
        this.pasteBuffer = ByteBuffer.wrap(this.pasteBufferBytes).order(ByteOrder.nativeOrder());
        return this.pasteBufferBytes;
    }

    public void put(byte[] data, int numBytes) {
        block3: {
            this.helper.bufCtr = numBytes;
            try {
                if (!this.putInitialized) {
                    throw new IllegalStateException(ERROR_MESSAGE_NOT_INITIALIZED);
                }
                this.output.write(data, 0, this.helper.bufCtr);
                this.helper.totalBytesCtr += this.helper.bufCtr;
                this.helper.bufCtr = 0;
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.putInitialized = false;
                if (this.currentUser == null) break block3;
                this.currentUser.copyCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public void put(long data) {
        block4: {
            try {
                if (!this.putInitialized) {
                    throw new IllegalStateException(ERROR_MESSAGE_NOT_INITIALIZED);
                }
                this.helper.putData(data);
                this.helper.increment();
                if (this.helper.bufCtr == this.helper.buffer.length) {
                    this.output.write(this.helper.buffer);
                    this.helper.bufCtr = 0;
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.putInitialized = false;
                if (this.currentUser == null) break block4;
                this.currentUser.copyCompleted(false, ERROR_MESSAGE);
            }
        }
    }

    public void reset() {
        this.hasContents = false;
        this.sizeOfContents = 0;
        this.labels = null;
    }

    public void setCopyMask(long copyMask, int copyMaskMaxColors) {
        this.copyMask = copyMask;
        this.copyMaskMaxColors = copyMaskMaxColors;
    }

    public void setCopyType(int copyType) {
        this.copyType = copyType;
    }

    public void setCurrentUser(ROIClipboardUser aUser) {
        this.currentUser = aUser;
    }

    public void setDimensions(int dimX, int dimY, double sizeX, double sizeY) {
        this.setDimensions(dimX, dimY, 0, 0, sizeX, sizeY, 0.0, null);
    }

    public void setDimensions(int dimX, int dimY, int dimZ, int dimT, double sizeX, double sizeY, double sizeZ) {
        this.setDimensions(dimX, dimY, dimZ, dimT, sizeX, sizeY, sizeZ, null);
    }

    public void setDimensions(int dimX, int dimY, int dimZ, int dimT, double sizeX, double sizeY, double sizeZ, Coordinate origin) {
        this.xDim = dimX;
        this.yDim = dimY;
        this.zDim = dimZ;
        this.tDim = dimT;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.zSize = sizeZ;
        this.origin = origin;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }
}

