/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask.buffers;

import edu.uthscsa.ric.roi.mask.ROIMaskBuffer;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.VolumeROI;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class AbstractROIBuffer
implements ROIMaskBuffer,
VolumeROI {
    private long highlighted;
    private long inited;
    private long selected;
    private long used;
    protected final int xDim;
    protected final int yDim;
    protected final int zDim;
    public static final int DEFAULT_COLORS = 8;
    public static final int MAX_COLORS = 64;
    public static final long ALL_BITS_ON = -1L;
    static final long[] MASKS = new long[64];

    protected AbstractROIBuffer(int xDim, int yDim, int zDim) {
        this.xDim = xDim;
        this.yDim = yDim;
        this.zDim = zDim;
    }

    public void addHighlighted(long mask) {
        this.highlighted |= mask;
    }

    public void addInited(long mask) {
        this.inited |= mask;
    }

    public void addSelected(long mask) {
        this.selected |= mask;
    }

    public void addUsed(long mask) {
        this.used |= mask;
    }

    public abstract void clear();

    public abstract void clearCopyBuffer();

    public void clearSelected() {
        this.selected = 0L;
    }

    public abstract long findMaxBitValue();

    @Override
    public abstract long get(int var1, int var2);

    public abstract ByteBuffer[] getByteBuffers();

    public abstract long getCopy(int var1);

    @Override
    public abstract long getCurrent(int var1);

    public long getHighlighted() {
        return this.highlighted;
    }

    public long getInited() {
        return this.inited;
    }

    @Override
    public abstract int getMaximumColors();

    public abstract byte[] getNextSlice(int var1);

    public abstract byte[] getNextSliceCurrent();

    public abstract ImageBounds getROIBounds(long var1, int var3);

    public abstract ImageBounds getROIBoundsCurrent(long var1);

    public long getSelected() {
        return this.selected;
    }

    public abstract int getSeriesIndex();

    @Override
    public abstract int getSeriesLength();

    public long getUsed() {
        return this.used;
    }

    public int getX() {
        return this.xDim;
    }

    public int getY() {
        return this.yDim;
    }

    public int getZ() {
        return this.zDim;
    }

    public abstract boolean hasBuffer();

    public abstract boolean isEmpty();

    public abstract boolean isEmptyOf(int var1);

    public abstract long isEmptyOf(long var1);

    public abstract void makeBuffer(int var1, int var2);

    public abstract void makeBufferSeries(int var1, int var2, int var3);

    public abstract void makeCopyBuffer(int var1);

    public abstract void put(int var1, int var2, long var3);

    public abstract void putCopy(int var1, long var2);

    public abstract void putCurrent(int var1, long var2);

    public void removeHighlighted(long mask) {
        this.highlighted &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void removeSelected(long mask) {
        this.selected &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public abstract void rewind();

    public void selectAll() {
        this.selected = this.used;
    }

    public void setHighlighted(long mask) {
        this.highlighted = mask;
    }

    public void setInited(long mask) {
        this.inited = mask;
    }

    public void setSelected(long mask) {
        this.selected = mask;
    }

    public abstract void setSeriesIndex(int var1);

    public void setUsed(long mask) {
        this.used = mask;
    }

    public static long[] getMasks() {
        return Arrays.copyOf(MASKS, MASKS.length);
    }

    static {
        for (int ctr = 0; ctr < 64; ++ctr) {
            AbstractROIBuffer.MASKS[ctr] = 1L << ctr;
        }
    }
}

