/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.mask;

import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatROIOp;
import java.util.ArrayList;
import java.util.Map;

public class Mask
implements ROI {
    private final ROIManager roiManager;
    private final int color;

    public Mask(ROIManager roiManager, int color) {
        this.roiManager = roiManager;
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public String getLabel(boolean canUseDefault) {
        if (canUseDefault) {
            return this.roiManager.getLabel(this.color, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(this.color, this.roiManager.getBuffer().getMaximumColors()));
        }
        return this.roiManager.getLabel(this.color, "");
    }

    public ImageBounds getROIBounds(boolean useSeries) {
        return this.roiManager.getROIBounds(1L << this.color);
    }

    public void doConvexHull() {
        this.roiManager.runConvexHull(0.0, 0.0, true, true, 1L << this.color, this.color, false, false, false);
    }

    public AnalysisImpl getStats() {
        return this.getStats(this.roiManager.getUser().getCurrentVolume().getCurrentSeriesPoint());
    }

    public AnalysisImpl getStats(int timepoint) {
        VolumeStatROIOp op = new VolumeStatROIOp(this.roiManager.getUser(), (Volume)this.roiManager.getUser().getCurrentVolume(), this.roiManager.getBuffer(), 1L << this.color, this.roiManager);
        op.setSeriesPoint(timepoint);
        OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this.roiManager.getUser(), op);
        Map<Long, Analysis> results = builder.runSynchronously();
        return (AnalysisImpl)new ArrayList<Analysis>(results.values()).get(0);
    }

    public void setHighlighted(boolean bool) {
        this.roiManager.setHighlighted(bool, this.color);
    }

    public String toString() {
        return this.getLabel(true);
    }
}

