/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.operations;

import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Vector;

public class ConvexHullOperations {
    private Point eastPoint;
    private Point endPoint;
    private Point northPoint;
    private Point southPoint;
    private Point startPoint;
    private Point westPoint;
    private Point[] points;
    private boolean closed;
    private final Vector<Point> convexShape = new Vector();

    private double calculateAngle(Point currentPoint, Point nextPoint, String direction) {
        boolean isWE = false;
        boolean isEW = false;
        boolean isSN = false;
        boolean isNS = false;
        boolean isSE = false;
        boolean isSW = false;
        boolean isNE = false;
        boolean isNW = false;
        if (direction.equals("NW")) {
            isNW = true;
        } else if (direction.equals("NE")) {
            isNE = true;
        } else if (direction.equals("SW")) {
            isSW = true;
        } else if (direction.equals("SE")) {
            isSE = true;
        } else if (direction.equals("NS")) {
            isNS = true;
        } else if (direction.equals("SN")) {
            isSN = true;
        } else if (direction.equals("EW")) {
            isEW = true;
        } else if (direction.equals("WE")) {
            isWE = true;
        }
        double angle = 0.0;
        if (isSE) {
            double opp = nextPoint.x - currentPoint.x;
            double adj = nextPoint.y - currentPoint.y;
            double hyp = Math.sqrt(opp * opp + adj * adj);
            angle = Math.asin(opp / hyp);
        } else if (isSW) {
            double opp = currentPoint.x - nextPoint.x;
            double adj = nextPoint.y - currentPoint.y;
            double hyp = Math.sqrt(opp * opp + adj * adj);
            angle = Math.asin(opp / hyp) * -1.0;
        } else if (isNE) {
            double opp = nextPoint.x - currentPoint.x;
            double adj = currentPoint.y - nextPoint.y;
            double hyp = Math.sqrt(opp * opp + adj * adj);
            angle = Math.asin(opp / hyp) * -1.0;
        } else if (isNW) {
            double opp = currentPoint.x - nextPoint.x;
            double adj = currentPoint.y - nextPoint.y;
            double hyp = Math.sqrt(opp * opp + adj * adj);
            angle = Math.asin(opp / hyp);
        } else if (isNS) {
            angle = 0.0;
        } else if (isSN) {
            angle = 0.0;
        } else if (isEW) {
            angle = 1.5707963267948966;
        } else if (isWE) {
            angle = 1.5707963267948966;
        }
        return angle;
    }

    private boolean doConvexHull() {
        boolean success = true;
        try {
            this.findExtremePoints();
            this.initializeConvexShape();
            if (this.isCW()) {
                this.reverseOrder();
                this.findExtremePoints();
                this.initializeConvexShape();
            }
            Point currentPoint = this.convexShape.elementAt(0);
            Point nextPoint = this.getNextPoint(currentPoint);
            boolean found = false;
            while (true) {
                found |= this.updateConvexShape(currentPoint);
                currentPoint = nextPoint;
                if ((nextPoint = this.getNextPoint(currentPoint)) == null) {
                    nextPoint = this.startPoint;
                }
                if (currentPoint != this.startPoint) continue;
                if (found) {
                    found = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            success = false;
        }
        return success;
    }

    public void doOperation(LOIShape shape) {
        if (shape.isClosed()) {
            this.initialize(shape.getPathIterator(null));
            if (this.doConvexHull()) {
                shape.setPath(this.makeShape().getPathIterator(null));
            }
        } else {
            throw new IllegalArgumentException("Shape is not closed!");
        }
    }

    private String findDirection(Point currentPoint, Point nextPoint) {
        boolean isWE = false;
        boolean isEW = false;
        boolean isSN = false;
        boolean isNS = false;
        boolean isSE = false;
        boolean isSW = false;
        boolean isNE = false;
        boolean isNW = false;
        if (nextPoint.x > currentPoint.x) {
            if (nextPoint.y > currentPoint.y) {
                isSE = true;
            } else if (nextPoint.y < currentPoint.y) {
                isNE = true;
            } else {
                isWE = true;
            }
        } else if (nextPoint.x < currentPoint.x) {
            if (nextPoint.y > currentPoint.y) {
                isSW = true;
            } else if (nextPoint.y < currentPoint.y) {
                isNW = true;
            } else {
                isEW = true;
            }
        } else if (nextPoint.y > currentPoint.y) {
            isNS = true;
        } else if (nextPoint.y < currentPoint.y) {
            isSN = true;
        }
        if (isNW) {
            return "NW";
        }
        if (isNE) {
            return "NE";
        }
        if (isSW) {
            return "SW";
        }
        if (isSE) {
            return "SE";
        }
        if (isNS) {
            return "NS";
        }
        if (isSN) {
            return "SN";
        }
        if (isEW) {
            return "EW";
        }
        if (isWE) {
            return "WE";
        }
        return null;
    }

    private void findExtremePoints() {
        for (int ctr = 0; ctr < this.points.length; ++ctr) {
            if (!this.closed && ctr == 0) {
                this.startPoint = this.points[ctr];
            } else if (!this.closed && ctr == this.points.length - 1) {
                this.endPoint = this.points[ctr];
            }
            if (ctr == 0) {
                this.eastPoint = this.westPoint = this.points[ctr];
                this.southPoint = this.westPoint;
                this.northPoint = this.westPoint;
                continue;
            }
            if (this.points[ctr].y < this.northPoint.y) {
                this.northPoint = this.points[ctr];
            }
            if (this.points[ctr].y > this.southPoint.y) {
                this.southPoint = this.points[ctr];
            }
            if (this.points[ctr].x > this.eastPoint.x) {
                this.eastPoint = this.points[ctr];
            }
            if (this.points[ctr].x >= this.westPoint.x) continue;
            this.westPoint = this.points[ctr];
        }
        if (this.closed) {
            this.startPoint = this.northPoint;
            this.endPoint = this.eastPoint;
        }
    }

    private Point getNextPoint(Point currentPoint) {
        int size;
        int index = this.convexShape.indexOf(currentPoint);
        if (index < (size = this.convexShape.size()) - 1) {
            return this.convexShape.elementAt(index + 1);
        }
        return this.convexShape.firstElement();
    }

    private void initialize(PathIterator it) {
        this.closed = false;
        Vector<Point> allPoints = new Vector<Point>();
        double[] segment = new double[4];
        int lastSegY = -1;
        int lastSegX = -1;
        int currentSegY = -1;
        int currentSegX = -1;
        while (!it.isDone() && !this.closed) {
            boolean close = it.currentSegment(segment) == 4;
            currentSegX = (int)segment[0];
            currentSegY = (int)segment[1];
            if (close) {
                this.closed = true;
            } else if (lastSegX != currentSegX || lastSegY != currentSegY) {
                allPoints.add(new Point(currentSegX, currentSegY));
            }
            lastSegX = currentSegX;
            lastSegY = currentSegY;
            it.next();
        }
        int num = allPoints.size();
        this.points = new Point[num];
        for (int ctr = 0; ctr < num; ++ctr) {
            this.points[ctr] = (Point)allPoints.elementAt(ctr);
        }
    }

    private void initializeConvexShape() {
        this.convexShape.clear();
        if (!this.closed) {
            this.convexShape.add(this.startPoint);
            for (Point point : this.points) {
                if (point == this.northPoint && point != this.startPoint && point != this.endPoint) {
                    this.convexShape.add(this.northPoint);
                    continue;
                }
                if (point == this.southPoint && point != this.startPoint && point != this.endPoint) {
                    this.convexShape.add(this.southPoint);
                    continue;
                }
                if (point == this.eastPoint && point != this.startPoint && point != this.endPoint) {
                    this.convexShape.add(this.eastPoint);
                    continue;
                }
                if (point != this.westPoint || point == this.startPoint || point == this.endPoint) continue;
                this.convexShape.add(this.westPoint);
            }
            this.convexShape.add(this.endPoint);
        } else {
            for (Point point : this.points) {
                if (point == this.northPoint) {
                    this.convexShape.add(this.northPoint);
                    continue;
                }
                if (point == this.southPoint) {
                    this.convexShape.add(this.southPoint);
                    continue;
                }
                if (point == this.eastPoint) {
                    this.convexShape.add(this.eastPoint);
                    continue;
                }
                if (point != this.westPoint) continue;
                this.convexShape.add(this.westPoint);
            }
        }
    }

    private boolean isCW() {
        int startNum = this.startPoint == this.northPoint || this.startPoint == this.eastPoint || this.startPoint == this.westPoint || this.startPoint == this.southPoint ? 0 : 1;
        Point firstPoint = this.convexShape.elementAt(startNum);
        Point secondPoint = this.convexShape.elementAt(startNum + 1);
        if (firstPoint == this.northPoint && secondPoint == this.eastPoint) {
            return true;
        }
        if (firstPoint == this.eastPoint && secondPoint == this.southPoint) {
            return true;
        }
        if (firstPoint == this.southPoint && secondPoint == this.westPoint) {
            return true;
        }
        return firstPoint == this.westPoint && secondPoint == this.northPoint;
    }

    private Shape makeShape() {
        GeneralPath path = new GeneralPath();
        Enumeration<Point> en = this.convexShape.elements();
        Point current = null;
        if (en.hasMoreElements()) {
            current = en.nextElement();
            path.moveTo(current.x, current.y);
            while (en.hasMoreElements()) {
                current = en.nextElement();
                path.lineTo(current.x, current.y);
            }
            if (this.closed) {
                path.closePath();
            }
        }
        return path;
    }

    private void reverseOrder() {
        Point temp = null;
        for (int ctr = 0; ctr < this.points.length / 2; ++ctr) {
            int index = this.points.length - 1 - ctr;
            temp = this.points[ctr];
            this.points[ctr] = this.points[index];
            this.points[index] = temp;
        }
    }

    private boolean updateConvexShape(Point currentPoint) {
        Point nextPoint = this.getNextPoint(currentPoint);
        if (nextPoint == null) {
            return false;
        }
        boolean searchLeft = false;
        String direction = this.findDirection(currentPoint, nextPoint);
        double angle = 0.0;
        if (direction.equals("NW")) {
            searchLeft = false;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("NE")) {
            searchLeft = false;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("SW")) {
            searchLeft = true;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("SE")) {
            searchLeft = true;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("NS")) {
            searchLeft = true;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("SN")) {
            searchLeft = false;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("EW")) {
            searchLeft = false;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        } else if (direction.equals("WE")) {
            searchLeft = true;
            angle = this.calculateAngle(currentPoint, nextPoint, direction);
        }
        boolean primed = false;
        boolean finished = false;
        AffineTransform transform = new AffineTransform();
        transform.setToRotation(angle);
        Point2D.Double rotatedConvexPoint = new Point2D.Double();
        Point2D.Double rotatedShapePoint = new Point2D.Double();
        Point convexPointNew = null;
        Point2D.Double convexPointNewRotated = new Point2D.Double();
        int ctr = 0;
        while (!finished) {
            if (ctr == this.points.length) {
                ctr = 0;
            }
            if (this.points[ctr] == currentPoint) {
                primed = true;
            } else if (primed && this.points[ctr] == nextPoint) {
                finished = true;
            } else if (primed) {
                double newVal;
                double oldVal;
                transform.transform(currentPoint, rotatedConvexPoint);
                transform.transform(this.points[ctr], rotatedShapePoint);
                if (searchLeft) {
                    if (rotatedShapePoint.getX() < rotatedConvexPoint.getX()) {
                        if (convexPointNew == null) {
                            convexPointNew = this.points[ctr];
                        } else {
                            transform.transform(convexPointNew, convexPointNewRotated);
                            oldVal = rotatedConvexPoint.getX() - convexPointNewRotated.getX();
                            newVal = rotatedConvexPoint.getX() - rotatedShapePoint.getX();
                            if (newVal > oldVal) {
                                convexPointNew = this.points[ctr];
                            }
                        }
                    }
                } else if (rotatedShapePoint.getX() > rotatedConvexPoint.getX()) {
                    if (convexPointNew == null) {
                        convexPointNew = this.points[ctr];
                    } else {
                        transform.transform(convexPointNew, convexPointNewRotated);
                        oldVal = convexPointNewRotated.getX() - rotatedConvexPoint.getX();
                        newVal = rotatedShapePoint.getX() - rotatedConvexPoint.getX();
                        if (newVal > oldVal) {
                            convexPointNew = this.points[ctr];
                        }
                    }
                }
            }
            ++ctr;
        }
        int currentIndex = this.convexShape.indexOf(currentPoint);
        if (convexPointNew != null) {
            this.convexShape.insertElementAt(convexPointNew, currentIndex + 1);
        }
        return convexPointNew != null;
    }
}

