/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.display;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIPathIterator;
import edu.uthscsa.ric.roi.lines.display.LOIPathLabel;
import edu.uthscsa.ric.roi.lines.operations.ConvexHullOperations;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import edu.uthscsa.ric.volume.operations.stats.LineStatROIOp;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class LOIShape
implements Line,
ROI,
Shape {
    private Color specialColor;
    private Graphics2D g2d;
    private LOIShape next;
    private LineListener listener;
    private LineUser user;
    private String name;
    private Stroke specialStroke;
    private boolean closed;
    private boolean isHighlighted;
    private boolean isImmutable;
    private boolean isPOI;
    private boolean isPermanent;
    private boolean isSpecial;
    private boolean selected;
    private boolean showAngle;
    private boolean showLength;
    private int color;
    private int sliceDirection;
    private int sliceNum;
    private VolumeData volData;
    private final Point touchPoint = new Point();
    private final Vector<LOIPathLabel> angleLabels = new Vector();
    private final Vector<LOIPathLabel> lengthLabels = new Vector();
    private final Vector<LOIPathLabel> nameLabels = new Vector();
    private final Vector<Point2D> allPoints = new Vector();
    private final Vector<Point> points = new Vector();
    public static final Color COLOR_HIGHLIGHT = new Color(0xD9D919);
    public static final Font FONT = new Font("Arial", 1, 12);
    public static final Font FONT_NAME = new Font("SansSerif", 1, 16);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter();

    public LOIShape(LOIShape aLOI) {
        int size = aLOI.points.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            this.points.add((Point)aLOI.points.elementAt(ctr).clone());
        }
        this.sliceNum = aLOI.sliceNum;
        this.sliceDirection = aLOI.sliceDirection;
        this.color = aLOI.color;
        this.isPOI = aLOI.isPOI;
        this.setListenerAndUser(aLOI.user, aLOI.listener);
        this.closed = aLOI.closed;
        this.isImmutable = aLOI.isImmutable;
        this.selected = false;
        this.next = null;
    }

    public LOIShape(LOIShape aLOI, double ratioX, double ratioY) {
        int size = aLOI.points.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            Point aPoint = (Point)aLOI.points.elementAt(ctr).clone();
            aPoint.x = (int)((double)aPoint.x * ratioX);
            aPoint.y = (int)((double)aPoint.y * ratioY);
            this.points.add(aPoint);
        }
        this.sliceNum = aLOI.sliceNum;
        this.sliceDirection = aLOI.sliceDirection;
        this.color = aLOI.color;
        this.isPOI = aLOI.isPOI;
        this.setListenerAndUser(aLOI.user, aLOI.listener);
        this.closed = aLOI.closed;
        this.isImmutable = aLOI.isImmutable;
        this.selected = false;
        this.next = null;
    }

    public LOIShape(PathIterator it, int sliceNum, int color, LineListener listener, LineUser user) {
        this.sliceNum = sliceNum;
        this.color = color;
        this.setListenerAndUser(user, listener);
        this.setPath(it);
    }

    public void breakClosedShape(Point breakPoint) {
        if (this.closed) {
            int ctr2;
            int ctr;
            Vector<Point> pointsCopy = new Vector<Point>();
            int size = this.points.size();
            for (ctr = 0; ctr < size; ++ctr) {
                pointsCopy.add((Point)this.points.elementAt(ctr).clone());
            }
            this.points.remove(this.points.firstElement());
            for (ctr = 0; ctr < size && !((Point)pointsCopy.elementAt(ctr)).equals(breakPoint); ++ctr) {
            }
            int pointsCtr = 0;
            for (ctr2 = ctr + 1; ctr2 < size; ++ctr2) {
                this.points.elementAt(pointsCtr++).setLocation((Point)pointsCopy.elementAt(ctr2));
            }
            for (ctr2 = 0; ctr2 < ctr; ++ctr2) {
                this.points.elementAt(pointsCtr++).setLocation((Point)pointsCopy.elementAt(ctr2));
            }
        }
        this.closed = false;
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
    }

    public Vector<Point2D> makeInterpolatedPoints() {
        this.allPoints.clear();
        Point destination = new Point();
        Point previous = new Point();
        Point current = new Point();
        double[] segment = new double[4];
        PathIterator it = this.getPathIterator(null);
        it.currentSegment(segment);
        previous.setLocation((int)segment[0], (int)segment[1]);
        it.next();
        current.setLocation(previous);
        this.allPoints.add(new Point(current));
        while (!it.isDone()) {
            int ctr;
            int incrementY;
            it.currentSegment(segment);
            destination.setLocation((int)segment[0], (int)segment[1]);
            int distanceX = Math.abs(destination.x - previous.x);
            int distanceY = Math.abs(destination.y - previous.y);
            double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
            double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
            int incrementX = destination.x - previous.x > 0 ? 1 : -1;
            int n = incrementY = destination.y - previous.y > 0 ? 1 : -1;
            if (distanceX > 0 && distanceX >= distanceY) {
                for (ctr = 1; ctr < distanceX; ++ctr) {
                    current.setLocation(ctr * incrementX + previous.x, (int)((double)previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                    this.allPoints.add(new Point(current));
                }
            } else if (distanceY > 0 && distanceY > distanceX) {
                for (ctr = 1; ctr < distanceY; ++ctr) {
                    current.setLocation((int)((double)previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + previous.y);
                    this.allPoints.add(new Point(current));
                }
            }
            current.setLocation(destination);
            this.allPoints.add(new Point(current));
            previous.setLocation(destination);
            it.next();
        }
        return this.allPoints;
    }

    public Vector<Point2D> makeInterpolatedPointsMM(double multiplier) {
        this.allPoints.clear();
        Point2D.Double destination = new Point2D.Double();
        Point2D.Double previous = new Point2D.Double();
        Point2D.Double current = new Point2D.Double();
        double[] segment = new double[4];
        double xSize = this.user.getXSize(this.sliceDirection);
        double ySize = this.user.getYSize(this.sliceDirection);
        PathIterator it = this.getPathIterator(null);
        it.currentSegment(segment);
        previous.setLocation(segment[0] * xSize, segment[1] * ySize);
        it.next();
        current.setLocation(previous);
        this.allPoints.add(new Point2D.Double(current.getX(), current.getY()));
        while (!it.isDone()) {
            int incrementY;
            it.currentSegment(segment);
            destination.setLocation(segment[0] * xSize, segment[1] * ySize);
            double distanceX = Math.abs(destination.x - previous.x);
            double distanceY = Math.abs(destination.y - previous.y);
            double slopeY = distanceX == 0.0 ? 0.0 : distanceY / distanceX;
            int incrementX = destination.x - previous.x > 0.0 ? 1 : -1;
            int n = incrementY = destination.y - previous.y > 0.0 ? 1 : -1;
            if (distanceY == 0.0) {
                while (current.distance(destination) > multiplier) {
                    current.setLocation(current.x + multiplier * (double)incrementX, current.y);
                    this.allPoints.add(new Point2D.Double(current.getX(), current.getY()));
                }
            } else if (distanceX == 0.0) {
                while (current.distance(destination) > multiplier) {
                    current.setLocation(current.x, current.y + multiplier * (double)incrementY);
                    this.allPoints.add(new Point2D.Double(current.getX(), current.getY()));
                }
            } else {
                double hyp = Math.sqrt(1.0 + MathUtilities.pow((double)slopeY, (double)2.0));
                double theta = Math.asin(slopeY / hyp);
                double disAlongX = Math.cos(theta) * multiplier;
                double disAlongY = Math.sin(theta) * multiplier;
                while (current.distance(destination) > multiplier) {
                    current.setLocation(current.x + disAlongX * (double)incrementX, current.y + disAlongY * (double)incrementY);
                    this.allPoints.add(new Point2D.Double(current.getX(), current.getY()));
                }
            }
            current.setLocation(destination);
            this.allPoints.add(new Point2D.Double(current.getX(), current.getY()));
            previous.setLocation(destination);
            it.next();
        }
        return this.allPoints;
    }

    public void connect(LOIShape connectingShape, Point connectionPoint) {
        if (!this.closed) {
            double[] segment = new double[4];
            if (connectionPoint.equals(this.getEndPoint())) {
                int lastSegX = this.getEndPoint().x;
                int lastSegY = this.getEndPoint().y;
                PathIterator it = connectingShape.getPathIterator(null);
                it.next();
                while (!it.isDone()) {
                    it.currentSegment(segment);
                    int currentSegX = (int)segment[0];
                    int currentSegY = (int)segment[1];
                    if (lastSegX != currentSegX || lastSegY != currentSegY) {
                        this.points.add(new Point(currentSegX, currentSegY));
                    }
                    lastSegX = currentSegX;
                    lastSegY = currentSegY;
                    it.next();
                }
                if (this.points.lastElement().distance(this.points.firstElement()) < 4.0) {
                    this.closed = true;
                }
            } else if (connectionPoint.equals(this.getStartPoint())) {
                int lastSegX = this.getEndPoint().x;
                int lastSegY = this.getEndPoint().y;
                PathIterator it = connectingShape.getPathIterator(null);
                it.next();
                while (!it.isDone()) {
                    it.currentSegment(segment);
                    int currentSegX = (int)segment[0];
                    int currentSegY = (int)segment[1];
                    if (lastSegX != currentSegX || lastSegY != currentSegY) {
                        this.points.insertElementAt(new Point(currentSegX, currentSegY), 0);
                    }
                    lastSegX = currentSegX;
                    lastSegY = currentSegY;
                    it.next();
                }
                if (this.points.lastElement().distance(this.points.firstElement()) < 4.0) {
                    this.closed = true;
                }
            }
            this.decimate();
        }
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
    }

    @Override
    public boolean contains(double x, double y) {
        int crossings = 0;
        int size = this.points.size();
        Point previous = null;
        Point current = null;
        double slope = 0.0;
        previous = this.points.elementAt(size - 1);
        for (int ctr = 0; ctr < size; ++ctr) {
            boolean isIntersection = true;
            current = this.points.elementAt(ctr);
            if ((double)previous.y < y || (double)current.y < y) {
                if ((double)previous.x <= x && (double)current.x > x) {
                    double xDiff;
                    int lowerY;
                    if ((double)previous.x == x) {
                        Point direction = previous;
                        int dirIndex = ctr - 2;
                        while ((double)direction.x == x) {
                            if (dirIndex < 0) {
                                dirIndex = size - 1;
                            }
                            direction = this.points.elementAt(dirIndex);
                            if ((double)direction.x != x) {
                                isIntersection = direction.x < previous.x;
                            }
                            --dirIndex;
                        }
                    }
                    if (isIntersection && (double)(lowerY = previous.y < current.y ? previous.y : current.y) + (slope = Math.abs((double)(previous.y - current.y) / (double)(previous.x - current.x))) * (xDiff = Math.abs(previous.y < current.y ? (double)previous.x - x : (double)current.x - x)) < y) {
                        ++crossings;
                    }
                } else if ((double)previous.x > x && (double)current.x <= x) {
                    double xDiff;
                    int lowerY;
                    if ((double)current.x == x) {
                        Point direction = current;
                        int dirIndex = ctr + 1;
                        while ((double)direction.x == x) {
                            if (dirIndex >= size) {
                                dirIndex = 0;
                            }
                            direction = this.points.elementAt(dirIndex);
                            if ((double)direction.x != x) {
                                isIntersection = direction.x < current.x;
                            }
                            ++dirIndex;
                        }
                    }
                    if (isIntersection && (double)(lowerY = previous.y < current.y ? previous.y : current.y) + (slope = Math.abs((double)(previous.y - current.y) / (double)(previous.x - current.x))) * (xDiff = Math.abs(previous.y < current.y ? (double)previous.x - x : (double)current.x - x)) < y) {
                        ++crossings;
                    }
                }
            }
            previous = current;
        }
        return crossings % 2 != 0;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    public void convexHull() {
        ConvexHullOperations op = new ConvexHullOperations();
        op.doOperation(this);
    }

    public void deletePoint(Point aPoint) {
        this.points.remove(aPoint);
        if (this.getNumPoints() < 3) {
            this.closed = false;
        }
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
    }

    public void drawLabels() {
        LOIPathLabel pl;
        Enumeration<LOIPathLabel> en = this.lengthLabels.elements();
        while (en.hasMoreElements()) {
            pl = en.nextElement();
            this.g2d.setFont(FONT);
            this.g2d.setColor(ROIColor.getColor(this.color));
            this.g2d.fillRoundRect(pl.xLoc - 2, pl.yLoc - pl.ySize - 2, pl.xSize + 4, pl.ySize + 4, 8, 8);
            this.g2d.setColor(Color.DARK_GRAY);
            this.g2d.drawString(pl.label, pl.xLoc, pl.yLoc);
        }
        en = this.angleLabels.elements();
        while (en.hasMoreElements()) {
            pl = en.nextElement();
            this.g2d.setFont(FONT);
            this.g2d.setColor(ROIColor.getColor(this.color));
            this.g2d.fillRoundRect(pl.xLoc - 2, pl.yLoc - pl.ySize - 2 + 8, pl.xSize + 4, pl.ySize + 4, 8, 8);
            this.g2d.setColor(Color.DARK_GRAY);
            this.g2d.drawString(pl.label, pl.xLoc, pl.yLoc + 8);
        }
    }

    public void drawName() {
        Enumeration<LOIPathLabel> en = this.nameLabels.elements();
        while (en.hasMoreElements()) {
            LOIPathLabel pl = en.nextElement();
            this.g2d.setFont(FONT_NAME);
            if (this.isSelected()) {
                this.g2d.setColor(Color.WHITE);
                this.g2d.drawString(pl.label, pl.xLoc - 1, pl.yLoc);
            }
            this.g2d.setColor(ROIColor.getColor(this.color));
            this.g2d.drawString(pl.label, pl.xLoc, pl.yLoc);
        }
    }

    public Point editLineAt(Point aPoint, int targetTouchSize) {
        return this.editLineAt(aPoint, targetTouchSize, true);
    }

    public Point editLineAt(Point aPoint, int targetTouchSize, boolean allowInsert) {
        this.touchPoint.x = aPoint.x;
        this.touchPoint.y = aPoint.y;
        Point previous = null;
        Point temp = null;
        Point closest = null;
        double closestDistance = 0.0;
        double distance = 0.0;
        if (this.closed) {
            previous = this.points.elementAt(this.points.size() - 1);
        }
        Enumeration<Point> en = this.points.elements();
        while (en.hasMoreElements()) {
            temp = en.nextElement();
            distance = this.touchPoint.distance(temp);
            if (closest != null && !(distance < closestDistance)) continue;
            closest = temp;
            closestDistance = distance;
        }
        if (closestDistance < (double)targetTouchSize) {
            return closest;
        }
        if (!allowInsert) {
            return null;
        }
        en = this.points.elements();
        Point destination = null;
        Point current = new Point();
        while (en.hasMoreElements()) {
            destination = en.nextElement();
            if (previous != null) {
                int ctr;
                int incrementY;
                int distanceX = Math.abs(destination.x - previous.x);
                int distanceY = Math.abs(destination.y - previous.y);
                double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
                double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
                int incrementX = destination.x - previous.x > 0 ? 1 : -1;
                int n = incrementY = destination.y - previous.y > 0 ? 1 : -1;
                if (distanceX > 0 && distanceX >= distanceY) {
                    for (ctr = 1; ctr < distanceX; ++ctr) {
                        current.setLocation(ctr * incrementX + previous.x, (int)((double)previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                        if (!(this.touchPoint.distance(current) < (double)targetTouchSize)) continue;
                        Point editingPoint = new Point(this.touchPoint);
                        this.points.insertElementAt(editingPoint, this.points.indexOf(destination));
                        return editingPoint;
                    }
                } else if (distanceY > 0 && distanceY > distanceX) {
                    for (ctr = 1; ctr < distanceY; ++ctr) {
                        current.setLocation((int)((double)previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + previous.y);
                        if (!(this.touchPoint.distance(current) < (double)targetTouchSize)) continue;
                        Point editingPoint = new Point(this.touchPoint);
                        this.points.insertElementAt(editingPoint, this.points.indexOf(destination));
                        return editingPoint;
                    }
                }
            }
            previous = destination;
        }
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        int xMin = Integer.MAX_VALUE;
        int xMax = 0;
        int yMin = Integer.MAX_VALUE;
        int yMax = 0;
        Enumeration<Point> en = this.points.elements();
        while (en.hasMoreElements()) {
            Point aPoint = en.nextElement();
            if (yMin > aPoint.y) {
                yMin = aPoint.y;
            }
            if (yMax < aPoint.y) {
                yMax = aPoint.y;
            }
            if (xMin > aPoint.x) {
                xMin = aPoint.x;
            }
            if (xMax >= aPoint.x) continue;
            xMax = aPoint.x;
        }
        return new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public int getColor() {
        return this.color;
    }

    public String getDefaultLabel() {
        int zLoc;
        int yLoc;
        int xLoc;
        Coordinate coor = new Coordinate();
        boolean isWorldMode = this.user.isWorldMode();
        Point currentPoint = this.points.firstElement();
        if (this.sliceDirection == 0) {
            xLoc = currentPoint.x;
            yLoc = currentPoint.y;
            zLoc = this.sliceNum;
        } else if (this.sliceDirection == 1) {
            xLoc = currentPoint.x;
            yLoc = this.sliceNum;
            zLoc = currentPoint.y;
        } else {
            xLoc = this.sliceNum;
            yLoc = currentPoint.x;
            zLoc = currentPoint.y;
        }
        coor.setValues((double)xLoc, (double)yLoc, (double)zLoc);
        if (isWorldMode) {
            this.volData.convertIndexToWorldCoordinate(coor);
        }
        return "Line (" + FORMATTER.format(coor.xDbl) + ", " + FORMATTER.format(coor.yDbl) + ", " + FORMATTER.format(coor.zDbl) + ")";
    }

    public Point getEndPoint() {
        if (this.closed) {
            return null;
        }
        return this.points.elementAt(this.points.size() - 1);
    }

    public String getLabel(boolean canUseDefault) {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name;
        }
        if (canUseDefault) {
            return this.getDefaultLabel();
        }
        return "";
    }

    public double getLength(double xSize, double ySize) {
        Enumeration<Point> en = this.points.elements();
        Point tempPoint = null;
        Point currentPoint = new Point(-1, -1);
        Point previousPoint = new Point(-1, -1);
        double distance = 0.0;
        while (en.hasMoreElements()) {
            tempPoint = en.nextElement();
            currentPoint.setLocation((double)tempPoint.x * xSize, (double)tempPoint.y * ySize);
            if (previousPoint.x != -1 || previousPoint.y != -1) {
                distance += currentPoint.distance(previousPoint);
            }
            previousPoint.setLocation(currentPoint);
        }
        if (this.closed) {
            tempPoint = this.points.firstElement();
            currentPoint.setLocation((double)tempPoint.x * xSize, (double)tempPoint.y * ySize);
            tempPoint = this.points.lastElement();
            previousPoint.setLocation((double)tempPoint.x * xSize, (double)tempPoint.y * ySize);
            distance += currentPoint.distance(previousPoint);
        }
        return distance;
    }

    public String getName() {
        return this.name;
    }

    public LOIShape getNext() {
        return this.next;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        Object[] copyPoints = new Point[this.points.size()];
        this.points.copyInto(copyPoints);
        this.lengthLabels.clear();
        this.angleLabels.clear();
        this.nameLabels.clear();
        if (this.listener != null) {
            return new LOIPathIterator((Point[])copyPoints, at, this.closed, this.selected, this.isSpecial, this.isHighlighted, this.isImmutable, this.isPermanent, this.user.isActive(), this.user.getXSize(this.sliceDirection), this.user.getYSize(this.sliceDirection), this.showLength, this.showAngle, this.lengthLabels, this.angleLabels, this.nameLabels, this.name, this.g2d);
        }
        return new LOIPathIterator((Point[])copyPoints, at, this.closed, this.selected, this.isSpecial, this.isHighlighted, this.isImmutable, this.isPermanent, false, 1.0, 1.0, this.showLength, this.showAngle, this.lengthLabels, this.angleLabels, this.nameLabels, this.name, this.g2d);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public Vector<Point> getPoints() {
        return this.points;
    }

    public Vector<Point> getPointsCopy() {
        Vector<Point> pointsCopy = new Vector<Point>();
        int size = this.points.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            pointsCopy.add((Point)this.points.elementAt(ctr).clone());
        }
        return pointsCopy;
    }

    public ImageBounds getROIBounds(boolean useSeries) {
        if (this.sliceDirection == 0) {
            return new ImageBounds(-1, -1, -1, -1, this.sliceNum, this.sliceNum);
        }
        if (this.sliceDirection == 1) {
            return new ImageBounds(-1, -1, this.sliceNum, this.sliceNum, -1, -1);
        }
        return new ImageBounds(this.sliceNum, this.sliceNum, -1, -1, -1, -1);
    }

    public int getSliceDirection() {
        return this.sliceDirection;
    }

    public int getSliceNum() {
        return this.sliceNum;
    }

    public Color getSpecialColor() {
        return this.specialColor;
    }

    public Stroke getSpecialStroke() {
        return this.specialStroke;
    }

    public Point getStartPoint() {
        return this.points.elementAt(0);
    }

    public AnalysisImpl getStats() {
        return this.getStats(0);
    }

    public AnalysisImpl getStats(int timepoint) {
        LineStatROIOp op = new LineStatROIOp(this.user, (Volume)this.user.getCurrentVolume(), this.user.getROIManager().getBuffer());
        return (AnalysisImpl)op.process(this, this.sliceDirection, timepoint);
    }

    public LineListener getUser() {
        return this.listener;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        int xMin = (int)x;
        int yMin = (int)y;
        int xMax = (int)(x + w);
        int yMax = (int)(y + h);
        Point previous = new Point();
        Enumeration<Point> en = this.points.elements();
        previous.setLocation(en.nextElement());
        if (previous.x >= xMin && previous.x <= xMax && previous.y >= yMin && previous.y <= yMax) {
            return true;
        }
        Point current = new Point();
        Point destination = new Point();
        while (en.hasMoreElements()) {
            int ctr;
            int incrementY;
            destination.setLocation(en.nextElement());
            int distanceX = Math.abs(destination.x - previous.x);
            int distanceY = Math.abs(destination.y - previous.y);
            double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
            double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
            int incrementX = destination.x - previous.x > 0 ? 1 : -1;
            int n = incrementY = destination.y - previous.y > 0 ? 1 : -1;
            if (distanceX > 0 && distanceX >= distanceY) {
                for (ctr = 1; ctr < distanceX; ++ctr) {
                    current.setLocation(ctr * incrementX + previous.x, (int)((double)previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                    if (current.x < xMin || current.x > xMax || current.y < yMin || current.y > yMax) continue;
                    return true;
                }
            } else if (distanceY > 0 && distanceY > distanceX) {
                for (ctr = 1; ctr < distanceY; ++ctr) {
                    current.setLocation((int)((double)previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + previous.y);
                    if (current.x < xMin || current.x > xMax || current.y < yMin || current.y > yMax) continue;
                    return true;
                }
            }
            current.setLocation(destination);
            if (current.x >= xMin && current.x <= xMax && current.y >= yMin && current.y <= yMax) {
                return true;
            }
            previous.setLocation(destination);
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public boolean isPOI() {
        return this.isPOI;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public void setColor(int aColor) {
        this.color = aColor;
    }

    public void setGraphics(Graphics2D ag2d) {
        this.g2d = ag2d;
    }

    public void setHighlighted(boolean bool) {
        this.isHighlighted = bool;
    }

    public void setImmutable(boolean bool) {
        this.isImmutable = bool;
    }

    public void setName(String name) {
        this.name = name;
        if (this.listener != null) {
            this.listener.shapeLabelChanged(this);
        }
    }

    public void setNext(LOIShape aShape) {
        this.next = aShape;
    }

    public final void setPath(PathIterator it) {
        this.points.clear();
        this.closed = false;
        double[] segment = new double[6];
        int lastSegY = -1;
        int lastSegX = -1;
        int currentSegY = -1;
        int currentSegX = -1;
        while (!it.isDone() && !this.closed) {
            boolean close = it.currentSegment(segment) == 4;
            currentSegX = (int)segment[0];
            currentSegY = (int)segment[1];
            if (close) {
                this.closed = true;
            } else if (lastSegX != currentSegX || lastSegY != currentSegY) {
                this.points.add(new Point(currentSegX, currentSegY));
            }
            lastSegX = currentSegX;
            lastSegY = currentSegY;
            it.next();
        }
        this.decimate();
    }

    public void setPermanent(boolean bool) {
        this.isPermanent = bool;
    }

    public void setSelectedState(boolean bool) {
        this.selected = bool;
    }

    public void setShowAngle(boolean bool) {
        this.showAngle = bool;
    }

    public void setShowLength(boolean bool) {
        this.showLength = bool;
    }

    public void setSlice(int num) {
        this.sliceNum = num;
    }

    public void setSliceDirection(int val) {
        this.sliceDirection = val;
    }

    public void setSpecialColor(Color aColor) {
        this.specialColor = aColor;
    }

    public void setSpecialState(boolean bool) {
        this.isSpecial = bool;
    }

    public void setSpecialStroke(Stroke aStroke) {
        this.specialStroke = aStroke;
    }

    public final void setListenerAndUser(LineUser user, LineListener listener) {
        this.listener = listener;
        this.user = user;
        this.volData = new VolumeData(user);
    }

    public void smooth() {
        this.smoothRightAngles();
        Vector<Point> pointsCopy = new Vector<Point>();
        int size = this.points.size();
        for (int ctr = 0; ctr < size; ++ctr) {
            pointsCopy.add((Point)this.points.elementAt(ctr).clone());
        }
        Point current = null;
        Point oneBack = null;
        Point twoBack = null;
        if (this.closed) {
            twoBack = this.points.elementAt(size - 2);
            oneBack = this.points.elementAt(size - 1);
        }
        for (int ctr = 0; ctr < size; ++ctr) {
            current = this.points.elementAt(ctr);
            if (twoBack != null && oneBack != null) {
                int avgX = (int)Math.round((double)(twoBack.x + 2 * oneBack.x + current.x) / 4.0);
                int avgY = (int)Math.round((double)(twoBack.y + 2 * oneBack.y + current.y) / 4.0);
                ((Point)pointsCopy.elementAt(this.points.indexOf(oneBack))).setLocation(avgX, avgY);
            }
            twoBack = oneBack;
            oneBack = current;
        }
        Point copyPoint = null;
        for (int ctr = 0; ctr < size; ++ctr) {
            copyPoint = (Point)pointsCopy.elementAt(ctr);
            this.points.elementAt(ctr).setLocation(copyPoint);
        }
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
    }

    public void toggleSelectedState() {
        this.selected = !this.selected;
    }

    public void translate(int transX, int transY) {
        Enumeration<Point> en = this.points.elements();
        while (en.hasMoreElements()) {
            Point aPoint = en.nextElement();
            aPoint.setLocation(aPoint.x + transX, aPoint.y + transY);
        }
    }

    private void decimate() {
        int pointsSize;
        int ctr;
        double slope = 0.0;
        double previousSlope = 0.0;
        boolean slopeInitialized = false;
        Point currentPoint = null;
        Point previousPoint = null;
        if (this.closed) {
            previousPoint = this.points.elementAt(this.points.size() - 1);
            Point previousPreviousPoint = this.points.elementAt(this.points.size() - 2);
            previousSlope = (double)(previousPoint.y - previousPreviousPoint.y) / (double)(previousPoint.x - previousPreviousPoint.x);
        }
        for (ctr = 0; ctr < this.points.size(); ++ctr) {
            currentPoint = this.points.elementAt(ctr);
            if (previousPoint != null) {
                slope = (double)(currentPoint.y - previousPoint.y) / (double)(currentPoint.x - previousPoint.x);
                if (slopeInitialized) {
                    if (MathUtilities.essentiallyEqual((double)slope, (double)previousSlope)) {
                        this.points.remove(previousPoint);
                        --ctr;
                    }
                } else {
                    slopeInitialized = true;
                }
            }
            previousPoint = currentPoint;
            previousSlope = slope;
        }
        if (this.closed) {
            for (ctr = 0; ctr < 2; ++ctr) {
                currentPoint = this.points.elementAt(ctr);
                slope = (double)(currentPoint.y - previousPoint.y) / (double)(currentPoint.x - previousPoint.x);
                if (MathUtilities.essentiallyEqual((double)slope, (double)previousSlope)) {
                    this.points.remove(previousPoint);
                    --ctr;
                }
                previousPoint = currentPoint;
                previousSlope = slope;
            }
        }
        if ((pointsSize = this.points.size()) > 2) {
            previousPoint = this.points.elementAt(this.points.size() - 1);
            for (int ctr2 = 0; ctr2 < this.points.size(); ++ctr2) {
                currentPoint = this.points.elementAt(ctr2);
                if (previousPoint.x == currentPoint.x && previousPoint.y == currentPoint.y) {
                    this.points.remove(previousPoint);
                    --ctr2;
                }
                previousPoint = currentPoint;
            }
        } else if (pointsSize == 2) {
            previousPoint = this.points.elementAt(0);
            currentPoint = this.points.elementAt(1);
            if (previousPoint.x == currentPoint.x && previousPoint.y == currentPoint.y) {
                this.points.remove(previousPoint);
            }
        }
        if (this.listener != null) {
            this.listener.shapeChanged(this);
        }
    }

    private void smoothRightAngles() {
        Point twoBack = null;
        Point oneBack = null;
        Point currentPoint = null;
        double previousSlope = 0.0;
        double slope = 0.0;
        boolean removed = false;
        int size = this.points.size();
        if (this.closed) {
            twoBack = this.points.elementAt(size - 2);
            oneBack = this.points.elementAt(size - 1);
        }
        for (int ctr = 0; ctr < this.points.size(); ++ctr) {
            currentPoint = this.points.elementAt(ctr);
            removed = false;
            if (oneBack != null) {
                int index;
                slope = (double)(currentPoint.y - oneBack.y) / (double)(currentPoint.x - oneBack.x);
                if (twoBack != null && (slope == 0.0 && Double.isInfinite(previousSlope) || previousSlope == 0.0 && Double.isInfinite(slope)) && (Math.abs(twoBack.x - oneBack.x) + Math.abs(twoBack.y - oneBack.y) == 1 || Math.abs(currentPoint.x - oneBack.x) + Math.abs(currentPoint.y - oneBack.y) == 1) && (index = this.points.indexOf(currentPoint) - 1) >= 0 && index < this.points.size()) {
                    this.points.remove(index);
                    --ctr;
                    removed = true;
                    slope = 1.0;
                }
            }
            if (!removed) {
                twoBack = oneBack;
            }
            oneBack = currentPoint;
            previousSlope = slope;
        }
    }

    public String toString() {
        return this.getLabel(true);
    }
}

