/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.display;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.roi.lines.display.LOIPathLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class LOIPathIterator
implements PathIterator {
    private AffineTransform transform;
    private Color selectedColor;
    private boolean isClosed;
    private boolean moved;
    private int counter;
    private final Ellipse2D.Double endPoint = new Ellipse2D.Double();
    private final Ellipse2D.Double handleBigger = new Ellipse2D.Double();
    private final Ellipse2D.Double handleRegular = new Ellipse2D.Double();
    private final Ellipse2D.Double handleSmaller = new Ellipse2D.Double();
    private final Graphics2D g2d;
    private final MangoNumberFormatter formatter = new MangoNumberFormatter(0);
    private final Point[] points;
    private final Point2D.Double currentPoint;
    private final Point2D.Double currentTransformedPoint;
    private final Point2D.Double previousPoint;
    private final Point2D.Double previousPreviousPoint;
    private final Point2D.Double previousPreviousTransformedPoint;
    private final Point2D.Double previousTransformedPoint;
    private final Point2D.Double tempTransformedPoint;
    private final Point2D.Double transformedPoint;
    private final String name;
    private final Vector<LOIPathLabel> angleLabels;
    private final Vector<LOIPathLabel> lengthLabels;
    private final Vector<LOIPathLabel> nameLabels;
    private final boolean isCloseable;
    private final boolean isHighlighted;
    private final boolean isImmutable;
    private final boolean isSelected;
    private final boolean isSpecial;
    private final boolean isStatic;
    private final boolean showAngle;
    private final boolean showLength;
    private final double xSize;
    private final double ySize;
    private final float[] tempFlt = new float[2];
    public static final AffineTransform IDENTITY = new AffineTransform();
    public static final Color INACTIVE_COLOR = Color.DARK_GRAY;
    public static final Font FONT = new Font("Arial", 1, 12);
    public static final Font FONT_ANGLE = new Font("Arial", 3, 12);

    protected LOIPathIterator(Point[] somePoints, AffineTransform aTransform, boolean closeable, boolean selected, boolean special, boolean highlighted, boolean immutable, boolean aStatic, boolean active, double sizeX, double sizeY, boolean boolLength, boolean boolAngle, Vector<LOIPathLabel> aLengthLabels, Vector<LOIPathLabel> aAngleLabels, Vector<LOIPathLabel> nameLabels, String name, Graphics2D ag2d) {
        this.points = somePoints;
        this.transform = aTransform;
        this.isCloseable = closeable;
        this.isSelected = selected;
        this.isSpecial = special;
        this.isHighlighted = highlighted;
        this.isImmutable = immutable;
        this.showLength = boolLength;
        this.showAngle = boolAngle;
        boolean isActive = active;
        this.isStatic = aStatic;
        this.name = name;
        this.g2d = ag2d;
        this.selectedColor = isActive || this.isHighlighted || this.isSpecial && !this.isImmutable ? Color.WHITE : INACTIVE_COLOR;
        this.angleLabels = aAngleLabels;
        this.lengthLabels = aLengthLabels;
        this.nameLabels = nameLabels;
        this.xSize = sizeX;
        this.ySize = sizeY;
        if (this.transform == null) {
            this.transform = IDENTITY;
        }
        this.transformedPoint = new Point2D.Double();
        this.tempTransformedPoint = new Point2D.Double();
        this.currentPoint = new Point2D.Double(0.0, 0.0);
        this.previousPoint = new Point2D.Double(-1.0, -1.0);
        this.previousPreviousPoint = new Point2D.Double(-1.0, -1.0);
        this.currentTransformedPoint = new Point2D.Double(0.0, 0.0);
        this.previousTransformedPoint = new Point2D.Double(-1.0, -1.0);
        this.previousPreviousTransformedPoint = new Point2D.Double(-1.0, -1.0);
    }

    @Override
    public int currentSegment(double[] coords) {
        int type = this.currentSegment(this.tempFlt);
        coords[0] = this.tempFlt[0];
        coords[1] = this.tempFlt[1];
        return type;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.counter == this.points.length && this.isCloseable) {
            this.tempTransformedPoint.setLocation((double)this.points[0].x + 0.5, (double)this.points[0].y + 0.5);
            this.transform.transform(this.tempTransformedPoint, this.transformedPoint);
            this.currentPoint.setLocation((double)this.points[0].x * this.xSize, (double)this.points[0].y * this.ySize);
            this.currentTransformedPoint.setLocation(this.transformedPoint);
            if (this.showLength && this.previousPoint.x != -1.0 && this.previousPoint.y != -1.0 && this.g2d != null) {
                double dis = this.currentPoint.distance(this.previousPoint);
                String string = this.formatter.format(dis);
                TextLayout textLayout = new TextLayout(string, FONT, this.g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int textLayoutHeight = (int)textLayout.getBounds().getHeight();
                int startX = (int)(this.currentTransformedPoint.x - (this.currentTransformedPoint.x - this.previousTransformedPoint.x) / 2.0 - (double)textLayoutWidth / 2.0);
                int startY = (int)(this.currentTransformedPoint.y - (this.currentTransformedPoint.y - this.previousTransformedPoint.y) / 2.0 + (double)textLayoutHeight / 2.0);
                this.lengthLabels.add(new LOIPathLabel(string, startX, startY, textLayoutWidth, textLayoutHeight));
            }
            if (this.showAngle && this.previousPreviousPoint.x != -1.0 && this.previousPreviousPoint.y != -1.0 && this.g2d != null) {
                double disA = this.previousPreviousPoint.distance(this.previousPoint);
                double disB = this.previousPoint.distance(this.currentPoint);
                double disC = this.currentPoint.distance(this.previousPreviousPoint);
                double angleC = Math.acos((disA * disA + disB * disB - disC * disC) / (2.0 * disA * disB)) * 180.0 / Math.PI;
                String string = this.formatter.format(angleC) + "\u00b0";
                TextLayout textLayout = new TextLayout(string, FONT_ANGLE, this.g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int textLayoutHeight = (int)textLayout.getBounds().getHeight();
                int startX = (int)(this.previousTransformedPoint.x - (double)textLayoutWidth / 2.0);
                int startY = (int)(this.previousTransformedPoint.y + (double)textLayoutHeight / 1.0 + 4.0);
                this.angleLabels.add(new LOIPathLabel(string, startX, startY, textLayoutWidth, textLayoutHeight));
                this.previousPreviousPoint.setLocation(this.previousPoint);
                this.previousPreviousTransformedPoint.setLocation(this.previousPreviousPoint);
                this.previousPoint.setLocation(this.currentPoint);
                this.previousTransformedPoint.setLocation(this.currentTransformedPoint);
                this.tempTransformedPoint.setLocation((double)this.points[1].x + 0.5, (double)this.points[1].y + 0.5);
                this.transform.transform(this.tempTransformedPoint, this.transformedPoint);
                this.currentPoint.setLocation((double)this.points[1].x * this.xSize, (double)this.points[1].y * this.ySize);
                this.currentTransformedPoint.setLocation(this.transformedPoint);
                disA = this.previousPreviousPoint.distance(this.previousPoint);
                disB = this.previousPoint.distance(this.currentPoint);
                disC = this.currentPoint.distance(this.previousPreviousPoint);
                angleC = Math.acos((disA * disA + disB * disB - disC * disC) / (2.0 * disA * disB)) * 180.0 / Math.PI;
                string = this.formatter.format(angleC) + "\u00b0";
                textLayout = new TextLayout(string, FONT_ANGLE, this.g2d.getFontRenderContext());
                textLayoutWidth = (int)textLayout.getBounds().getWidth();
                textLayoutHeight = (int)textLayout.getBounds().getHeight();
                startX = (int)(this.previousTransformedPoint.x - (double)textLayoutWidth / 2.0);
                startY = (int)(this.previousTransformedPoint.y + (double)textLayoutHeight / 1.0 + 4.0);
                this.angleLabels.add(new LOIPathLabel(string, startX, startY, textLayoutWidth, textLayoutHeight));
            }
            this.isClosed = true;
            return 4;
        }
        this.tempTransformedPoint.setLocation((double)this.points[this.counter].x + 0.5, (double)this.points[this.counter].y + 0.5);
        this.transform.transform(this.tempTransformedPoint, this.transformedPoint);
        this.handleBigger.setFrame((int)this.transformedPoint.x - 4, (int)this.transformedPoint.y - 4, 9.0, 9.0);
        this.handleRegular.setFrame((int)this.transformedPoint.x - 3, (int)this.transformedPoint.y - 3, 7.0, 7.0);
        this.handleSmaller.setFrame((int)this.transformedPoint.x - 2, (int)this.transformedPoint.y - 2, 5.0, 5.0);
        coords[0] = (float)this.transformedPoint.getX();
        coords[1] = (float)this.transformedPoint.getY();
        if (this.g2d != null) {
            Color oldColor;
            this.endPoint.setFrame((int)this.transformedPoint.x - 2, (int)this.transformedPoint.y - 2, 5.0, 5.0);
            if (this.counter == 0) {
                if (!this.isImmutable) {
                    this.g2d.fill(this.endPoint);
                }
                oldColor = this.g2d.getColor();
                if (this.isSpecial) {
                    if (this.isHighlighted) {
                        if (!this.isStatic) {
                            if (this.isImmutable) {
                                this.g2d.fill(this.handleRegular);
                            } else {
                                this.g2d.draw(this.handleRegular);
                            }
                        }
                        this.g2d.setColor(this.selectedColor);
                        this.g2d.draw(this.handleBigger);
                    } else {
                        if (!this.isStatic) {
                            this.g2d.fill(this.handleRegular);
                        }
                        if (!this.isImmutable) {
                            this.g2d.setColor(this.selectedColor);
                            this.g2d.draw(this.handleBigger);
                        }
                    }
                } else if (this.isSelected) {
                    this.g2d.setColor(this.selectedColor);
                    this.g2d.draw(this.handleBigger);
                }
                this.g2d.setColor(oldColor);
            } else if (!this.isCloseable && this.counter == this.points.length - 1) {
                this.endPoint.setFrame((int)this.transformedPoint.x - 2, (int)this.transformedPoint.y - 2, 5.0, 5.0);
                if (!this.isImmutable) {
                    this.g2d.fill(this.endPoint);
                }
                oldColor = this.g2d.getColor();
                if (this.isSpecial) {
                    if (this.isHighlighted) {
                        if (!this.isStatic) {
                            if (this.isImmutable) {
                                this.g2d.fill(this.handleSmaller);
                            } else {
                                this.g2d.draw(this.handleSmaller);
                            }
                        }
                        this.g2d.setColor(this.selectedColor);
                        this.g2d.draw(this.handleRegular);
                    } else {
                        if (!this.isStatic) {
                            this.g2d.fill(this.handleSmaller);
                        }
                        if (!this.isImmutable) {
                            this.g2d.setColor(this.selectedColor);
                            this.g2d.draw(this.handleRegular);
                        }
                    }
                } else if (this.isSelected) {
                    this.g2d.setColor(this.selectedColor);
                    this.g2d.draw(this.handleRegular);
                }
                this.g2d.setColor(oldColor);
            } else if (this.showAngle) {
                this.g2d.fill(this.handleSmaller);
            }
        }
        if (!this.moved) {
            this.moved = true;
            this.currentPoint.setLocation((double)this.points[this.counter].x * this.xSize, (double)this.points[this.counter].y * this.ySize);
            this.currentTransformedPoint.setLocation(this.transformedPoint);
            this.previousPoint.setLocation(this.currentPoint);
            this.previousTransformedPoint.setLocation(this.currentTransformedPoint);
            if (this.counter == 0 && StringUtils.isNotBlank((CharSequence)this.name) && this.g2d != null) {
                TextLayout textLayout = new TextLayout(this.name, FONT, this.g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int textLayoutHeight = (int)textLayout.getBounds().getHeight();
                int startX = (int)(this.currentTransformedPoint.x - (this.currentTransformedPoint.x - this.previousTransformedPoint.x) / 2.0 - (double)textLayoutWidth / 2.0);
                this.nameLabels.add(new LOIPathLabel(this.name, startX, (int)(this.currentTransformedPoint.y + 25.0), textLayoutWidth, textLayoutHeight));
            }
            return 0;
        }
        this.currentPoint.setLocation((double)this.points[this.counter].x * this.xSize, (double)this.points[this.counter].y * this.ySize);
        this.currentTransformedPoint.setLocation(this.transformedPoint);
        if (this.showLength && this.previousPoint.x != -1.0 && this.previousPoint.y != -1.0 && this.g2d != null) {
            double dis = this.currentPoint.distance(this.previousPoint);
            String string = this.formatter.format(dis);
            TextLayout textLayout = new TextLayout(string, FONT, this.g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            int startX = (int)(this.currentTransformedPoint.x - (this.currentTransformedPoint.x - this.previousTransformedPoint.x) / 2.0 - (double)textLayoutWidth / 2.0);
            int startY = (int)(this.currentTransformedPoint.y - (this.currentTransformedPoint.y - this.previousTransformedPoint.y) / 2.0 + (double)textLayoutHeight / 2.0);
            this.lengthLabels.add(new LOIPathLabel(string, startX, startY, textLayoutWidth, textLayoutHeight));
        }
        if (this.showAngle && this.previousPreviousPoint.x != -1.0 && this.previousPreviousPoint.y != -1.0 && this.g2d != null) {
            double disA = this.previousPreviousPoint.distance(this.previousPoint);
            double disB = this.previousPoint.distance(this.currentPoint);
            double disC = this.currentPoint.distance(this.previousPreviousPoint);
            double angleC = Math.acos((disA * disA + disB * disB - disC * disC) / (2.0 * disA * disB)) * 180.0 / Math.PI;
            String string = this.formatter.format(angleC) + "\u00b0";
            TextLayout textLayout = new TextLayout(string, FONT_ANGLE, this.g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            int startX = (int)(this.previousTransformedPoint.x - (double)textLayoutWidth / 2.0);
            int startY = (int)(this.previousTransformedPoint.y + (double)textLayoutHeight / 1.0 + 4.0);
            this.angleLabels.add(new LOIPathLabel(string, startX, startY, textLayoutWidth, textLayoutHeight));
        }
        this.previousPreviousPoint.setLocation(this.previousPoint);
        this.previousPreviousTransformedPoint.setLocation(this.previousPreviousPoint);
        this.previousPoint.setLocation(this.currentPoint);
        this.previousTransformedPoint.setLocation(this.currentTransformedPoint);
        return 1;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        if (this.counter >= this.points.length) {
            if (this.isCloseable) {
                return this.isClosed;
            }
            return true;
        }
        return false;
    }

    @Override
    public void next() {
        ++this.counter;
    }
}

