/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi.lines.clipboard;

import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;

public class LOIClipboard {
    private LOIManager axialManagerCopied;
    private LOIManager coronalManagerCopied;
    private LOIManager sagittalManagerCopied;
    private LOIShape[] axialShapes;
    private LOIShape[] coronalShapes;
    private LOIShape[] sagittalShapes;
    private boolean isVOIMode;
    private int copiedSliceDirection;
    private int copiedSliceNum;
    private int pasteColor;

    private static void pasteShapes(LOIShape shapes, LOIManager pastingManager, int pastingSlice, double ratioX, double ratioY, int pasteColor) {
        if (shapes != null) {
            LOIShape pastingShapes = new LOIShape(shapes, ratioX, ratioY);
            pastingShapes.setSlice(pastingSlice);
            pastingShapes.setSelectedState(false);
            pastingShapes.setListenerAndUser(pastingManager.getUser(), pastingManager.getListener());
            if (pasteColor >= 0) {
                pastingShapes.setColor(pasteColor);
            }
            LOIShape pastingShapesCurrent = pastingShapes;
            LOIShape currentLOI = shapes;
            while (currentLOI.getNext() != null) {
                LOIShape tempLOI = new LOIShape(currentLOI.getNext(), ratioX, ratioY);
                tempLOI.setSlice(pastingSlice);
                tempLOI.setSelectedState(true);
                tempLOI.setListenerAndUser(pastingManager.getUser(), pastingManager.getListener());
                pastingShapesCurrent.setNext(tempLOI);
                pastingShapesCurrent = pastingShapesCurrent.getNext();
                if (pasteColor >= 0) {
                    pastingShapesCurrent.setColor(pasteColor);
                }
                currentLOI = currentLOI.getNext();
            }
            pastingManager.addLOI(pastingShapes);
        }
    }

    public boolean canPaste() {
        return this.hasContents();
    }

    public void copy(LOIManager axialManager, LOIManager coronalManager, LOIManager sagittalManager, boolean voiMode) {
        this.axialManagerCopied = axialManager;
        this.coronalManagerCopied = coronalManager;
        this.sagittalManagerCopied = sagittalManager;
        this.axialShapes = axialManager.getAllSelectedClone();
        this.coronalShapes = coronalManager.getAllSelectedClone();
        this.sagittalShapes = sagittalManager.getAllSelectedClone();
        this.copiedSliceDirection = axialManager.getMainSliceDirection();
        this.copiedSliceNum = axialManager.getMainSliceNumber();
        this.isVOIMode = voiMode;
    }

    public long getCopyMask() {
        LOIShape currentLOI;
        int n;
        int n2;
        LOIShape[] lOIShapeArray;
        long copyMask = 0L;
        if (this.axialShapes != null) {
            lOIShapeArray = this.axialShapes;
            n2 = lOIShapeArray.length;
            for (n = 0; n < n2; ++n) {
                LOIShape axialShape;
                for (currentLOI = axialShape = lOIShapeArray[n]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    copyMask |= 1L << currentLOI.getColor();
                }
            }
        }
        if (this.coronalShapes != null) {
            lOIShapeArray = this.coronalShapes;
            n2 = lOIShapeArray.length;
            for (n = 0; n < n2; ++n) {
                LOIShape coronalShape;
                for (currentLOI = coronalShape = lOIShapeArray[n]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    copyMask |= 1L << currentLOI.getColor();
                }
            }
        }
        if (this.sagittalShapes != null) {
            lOIShapeArray = this.sagittalShapes;
            n2 = lOIShapeArray.length;
            for (n = 0; n < n2; ++n) {
                LOIShape sagittalShape;
                for (currentLOI = sagittalShape = lOIShapeArray[n]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                    copyMask |= 1L << currentLOI.getColor();
                }
            }
        }
        return copyMask;
    }

    public boolean hasContents() {
        return this.axialShapes != null;
    }

    public void paste(LOIManager axialManager, LOIManager coronalManager, LOIManager sagittalManager) {
        if (this.isVOIMode) {
            int sliceToPaste;
            int ctr;
            double ratioX = this.axialManagerCopied.getXSize() / axialManager.getXSize();
            double ratioY = this.axialManagerCopied.getYSize() / axialManager.getYSize();
            double ratioZ = this.coronalManagerCopied.getYSize() / coronalManager.getYSize();
            for (ctr = 0; ctr < this.axialShapes.length; ++ctr) {
                sliceToPaste = (int)Math.round((double)ctr * ratioZ);
                if (sliceToPaste >= axialManager.getSlices()) continue;
                LOIClipboard.pasteShapes(this.axialShapes[ctr], axialManager, sliceToPaste, ratioX, ratioY, this.pasteColor);
            }
            for (ctr = 0; ctr < this.coronalShapes.length; ++ctr) {
                sliceToPaste = (int)Math.round((double)ctr * ratioY);
                if (sliceToPaste >= coronalManager.getSlices()) continue;
                LOIClipboard.pasteShapes(this.coronalShapes[ctr], coronalManager, sliceToPaste, ratioX, ratioZ, this.pasteColor);
            }
            for (ctr = 0; ctr < this.sagittalShapes.length; ++ctr) {
                sliceToPaste = (int)Math.round((double)ctr * ratioX);
                if (sliceToPaste >= sagittalManager.getSlices()) continue;
                LOIClipboard.pasteShapes(this.sagittalShapes[ctr], sagittalManager, sliceToPaste, ratioY, ratioZ, this.pasteColor);
            }
        } else {
            double pasteY;
            double pasteX;
            double copiedY;
            double copiedX;
            int pastingSliceDirection = axialManager.getMainSliceDirection();
            int pastingSliceNum = axialManager.getMainSliceNumber();
            LOIShape[] shapes = null;
            if (this.copiedSliceDirection == 0) {
                shapes = this.axialShapes;
                copiedX = this.axialManagerCopied.getXSize();
                copiedY = this.axialManagerCopied.getYSize();
            } else if (this.copiedSliceDirection == 1) {
                shapes = this.coronalShapes;
                copiedX = this.coronalManagerCopied.getXSize();
                copiedY = this.coronalManagerCopied.getYSize();
            } else {
                shapes = this.sagittalShapes;
                copiedX = this.sagittalManagerCopied.getXSize();
                copiedY = this.sagittalManagerCopied.getYSize();
            }
            LOIManager manager = null;
            if (pastingSliceDirection == 0) {
                manager = axialManager;
                pasteX = axialManager.getXSize();
                pasteY = axialManager.getYSize();
            } else if (pastingSliceDirection == 1) {
                manager = coronalManager;
                pasteX = coronalManager.getXSize();
                pasteY = coronalManager.getYSize();
            } else {
                manager = sagittalManager;
                pasteX = sagittalManager.getXSize();
                pasteY = sagittalManager.getYSize();
            }
            LOIClipboard.pasteShapes(shapes[this.copiedSliceNum], manager, pastingSliceNum, copiedX / pasteX, copiedY / pasteY, this.pasteColor);
        }
    }

    public void reset() {
        this.sagittalShapes = null;
        this.coronalShapes = null;
        this.axialShapes = null;
    }

    public void setPasteColor(int aColor) {
        this.pasteColor = aColor;
    }

    public void setPasteColorAsCopyColor() {
        this.pasteColor = -1;
    }
}

