/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ROIOperationTreeNode {
    private ROIOperationTreeNode operation1;
    private ROIOperationTreeNode operation2;
    private String operandString1;
    private String operandString2;
    private String operationOriginal;
    private String operatorType;
    private int value = -1;
    private static final long[] MASKS = AbstractROIBuffer.getMasks();

    public static int hasValidNumOperators(String string) {
        int operatorCount = 0;
        int operandCount = 0;
        for (int ctr = 0; ctr < string.length(); ++ctr) {
            char currentChar = string.charAt(ctr);
            if (currentChar != '&' && currentChar != '|' && currentChar != '^') continue;
            ++operatorCount;
        }
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(string);
        while (m.find()) {
            ++operandCount;
        }
        return operandCount - (operatorCount + 1);
    }

    public static boolean hasValidParentheses(String string) {
        int stackCtr = 0;
        for (int ctr = 0; ctr < string.length(); ++ctr) {
            char currentChar = string.charAt(ctr);
            if (currentChar == '(') {
                ++stackCtr;
                continue;
            }
            if (currentChar != ')') continue;
            --stackCtr;
        }
        return stackCtr == 0;
    }

    public static boolean isValidStartNode(ROIOperationTreeNode startNode) {
        boolean valid = false;
        try {
            boolean result = startNode.getResult(-1L);
            if (AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)("Start node result = " + result));
            }
            valid = true;
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return valid;
    }

    public static boolean isValidString(String string) {
        for (int ctr = 0; ctr < string.length(); ++ctr) {
            char currentChar = string.charAt(ctr);
            if (StringUtils.isNumeric((CharSequence)String.valueOf(currentChar)) || currentChar == '&' || currentChar == '|' || currentChar == '^' || currentChar == '~' || currentChar == '(' || currentChar == ')' || currentChar == ' ') continue;
            return false;
        }
        return true;
    }

    public static ROIOperationTreeNode makeOperationTree(String string) {
        String operation = string;
        ROIOperationTreeNode op = null;
        if (!ROIOperationTreeNode.isValidString(operation)) {
            return null;
        }
        try {
            op = new ROIOperationTreeNode(operation);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            return null;
        }
        return op;
    }

    public static String makeReplacements(String stringVal, ROIManager roiManager) {
        String string = stringVal;
        int squareBracketOpenIndex = string.indexOf(91);
        int squareBracketCloseIndex = string.indexOf(93);
        while (squareBracketOpenIndex != -1 && squareBracketCloseIndex != -1) {
            String label = string.substring(squareBracketOpenIndex, squareBracketCloseIndex + 1);
            String strippedLabel = label.substring(1, label.length() - 1);
            int index = roiManager.getIndexForLabel(strippedLabel);
            string = string.replace(label, "(" + index + ")");
            squareBracketOpenIndex = string.indexOf(91);
            squareBracketCloseIndex = string.indexOf(93);
        }
        string = string.replaceAll("and", "&");
        string = string.replaceAll("xor", "^");
        string = string.replaceAll("or", "|");
        string = string.replaceAll("not", "~");
        return string;
    }

    private static String addParentheses(String string) {
        int ctrIn;
        boolean added;
        char currentChar;
        int ctr;
        StringBuffer stringBuffer = new StringBuffer(string);
        int stackCtr = 0;
        for (ctr = stringBuffer.length() - 1; ctr >= 0; --ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '~') continue;
            stringBuffer.insert(ctr, '(');
            stackCtr = 0;
            added = false;
            for (ctrIn = ctr + 2; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '&') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '^') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        for (ctr = 0; ctr < stringBuffer.length(); ++ctr) {
            currentChar = stringBuffer.charAt(ctr);
            if (currentChar != '|') continue;
            added = false;
            for (ctrIn = ctr - 1; ctrIn >= 0 && !added; --ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == ')') {
                    ++stackCtr;
                } else if (currentChar == '(') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn, '(');
                ++ctr;
                added = true;
            }
            added = false;
            for (ctrIn = ctr + 1; ctrIn < stringBuffer.length() && !added; ++ctrIn) {
                currentChar = stringBuffer.charAt(ctrIn);
                if (currentChar == '(') {
                    ++stackCtr;
                } else if (currentChar == ')') {
                    --stackCtr;
                }
                if (stackCtr != 0) continue;
                stringBuffer.insert(ctrIn + 1, ')');
                added = true;
            }
        }
        return stringBuffer.toString();
    }

    private static String removeSpaces(String string) {
        boolean found;
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            found = false;
            for (int ctr = 0; ctr < stringBuffer.length(); ++ctr) {
                char currentChar = stringBuffer.charAt(ctr);
                if (!Character.isWhitespace(currentChar)) continue;
                stringBuffer.deleteCharAt(ctr);
                found = true;
            }
        } while (found);
        return stringBuffer.toString();
    }

    private static String trimParentheses(String stringVal) {
        boolean trimmed;
        String string = stringVal;
        do {
            trimmed = false;
            int stackCtr = 0;
            int lastFreshOpen = 0;
            for (int ctr = 0; ctr < string.length(); ++ctr) {
                char currentChar = string.charAt(ctr);
                if (currentChar == '(') {
                    if (stackCtr == 0) {
                        lastFreshOpen = ctr;
                    }
                    ++stackCtr;
                    continue;
                }
                if (currentChar != ')' || ctr != string.length() - 1 || --stackCtr != 0 || lastFreshOpen != 0) continue;
                string = string.substring(1, string.length() - 1);
                trimmed = true;
            }
        } while (trimmed);
        return string;
    }

    private ROIOperationTreeNode(String original) {
        this.parse(original);
        if (this.operatorType != null) {
            if (!this.operatorType.equals("~")) {
                this.operation1 = new ROIOperationTreeNode(this.operandString1);
            }
            this.operation2 = new ROIOperationTreeNode(this.operandString2);
        }
    }

    public String getOriginalOperation() {
        return this.operationOriginal;
    }

    public boolean getResult(long data) {
        if (this.operatorType == null) {
            return (MASKS[this.value] & data) != 0L;
        }
        if (this.operatorType.equals("&")) {
            return this.operation1.getResult(data) && this.operation2.getResult(data);
        }
        if (this.operatorType.equals("|")) {
            return this.operation1.getResult(data) || this.operation2.getResult(data);
        }
        if (this.operatorType.equals("^")) {
            return this.operation1.getResult(data) ^ this.operation2.getResult(data);
        }
        return !this.operation2.getResult(data);
    }

    public void setOriginalOperation(String string) {
        this.operationOriginal = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextValue(String str, int index) {
        try (Scanner scanner = new Scanner(str.substring(index));){
            if (scanner.hasNextInt()) {
                int n = scanner.nextInt();
                return n;
            }
            int n = -1;
            return n;
        }
    }

    private void parse(String originalVal) {
        String original = originalVal;
        original = original.trim();
        original = ROIOperationTreeNode.removeSpaces(original);
        original = ROIOperationTreeNode.addParentheses(original);
        if (StringUtils.isNumeric((CharSequence)(original = ROIOperationTreeNode.trimParentheses(original)))) {
            this.value = this.getNextValue(original, 0);
            return;
        }
        int length = original.length();
        int stackCtr = 0;
        int operatorIndex = -1;
        for (int ctr = 0; ctr < length; ++ctr) {
            char currentChar = original.charAt(ctr);
            if (currentChar == '(') {
                ++stackCtr;
                continue;
            }
            if (currentChar == ')') {
                if (--stackCtr != 0) continue;
                operatorIndex = ctr + 1;
                break;
            }
            if (stackCtr != 0) continue;
            operatorIndex = 0;
            break;
        }
        this.operandString1 = original.substring(0, operatorIndex);
        this.operatorType = original.substring(operatorIndex, operatorIndex + 1);
        this.operandString2 = original.substring(operatorIndex + 1);
    }
}

