/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import java.awt.Color;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public final class ROIColor {
    private Color color;
    private String label;
    private final int index;
    private static final Color[] COLORS = new Color[64];
    private static final Color[] COLORS_BRIGHTER = new Color[64];
    private static final Color[] COLORS_TRANSPARENT = new Color[64];
    private static final ROIColor[] ROI_COLORS;
    private static final int[] BLUE;
    private static final int[] GRAY;
    private static final int[] GREEN;
    private static final int[] MAGENTA;
    private static final int[] ORDER;
    private static final int[] RED;
    private static final int[] SALMON_BROWN;
    private static final int[] VIOLET;
    private static final int[] YELLOW_ORANGE;
    public static final int DEFAULT_ALPHA = 64;

    public static Vector<ROIColor> getColorsDisplayOrder(int numBytes) {
        Vector<ROIColor> colors = new Vector<ROIColor>();
        TreeSet<Integer> indices = new TreeSet<Integer>();
        for (int ctr = 0; ctr < numBytes; ++ctr) {
            indices.add(ORDER[ctr]);
        }
        Iterator it = indices.iterator();
        while (it.hasNext()) {
            int next = (Integer)it.next();
            int orderIndex = ROIColor.findOrderIndex(next);
            int colorIndex = 0;
            int rowIndex = orderIndex * ORDER.length;
            colors.add(new ROIColor(new Color(RED[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(GREEN[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(BLUE[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(YELLOW_ORANGE[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(SALMON_BROWN[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(MAGENTA[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(VIOLET[next]), rowIndex + colorIndex++));
            colors.add(new ROIColor(new Color(GRAY[next]), rowIndex + colorIndex++));
        }
        return colors;
    }

    private static int findOrderIndex(int value) {
        for (int ctr = 0; ctr < ORDER.length; ++ctr) {
            if (ORDER[ctr] != value) continue;
            return ctr;
        }
        return -1;
    }

    private static ROIColor[] getColorsBitPlaneOrder() {
        Vector<ROIColor> colors = new Vector<ROIColor>();
        for (int ctr = 0; ctr < ORDER.length; ++ctr) {
            int colorIndex = 0;
            colors.add(new ROIColor(new Color(RED[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(GREEN[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(BLUE[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(YELLOW_ORANGE[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(SALMON_BROWN[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(MAGENTA[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(VIOLET[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
            colors.add(new ROIColor(new Color(GRAY[ORDER[ctr]]), ctr * ORDER.length + colorIndex++));
        }
        return colors.toArray(new ROIColor[colors.size()]);
    }

    private ROIColor(Color color, int index) {
        this.color = color;
        this.index = index;
    }

    public Color getColor() {
        return this.color;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        if (this.label != null) {
            return this.label;
        }
        return "";
    }

    public static Color getColor(int index) {
        return COLORS[index];
    }

    public static Color getBrighterColor(int index) {
        return COLORS_BRIGHTER[index];
    }

    public static Color getTransparentColor(int index) {
        return COLORS_TRANSPARENT[index];
    }

    public static ROIColor[] getROIColors() {
        return (ROIColor[])ROI_COLORS.clone();
    }

    static {
        BLUE = new int[]{1644912, 255, 4286945, 2003199, 49151, 8900331, 11393254, 0xAAFFFF};
        GRAY = new int[]{0x2F4F4F, 0x494949, 0x696969, 7372944, 0x8899AA, 0xA9A9A9, 0xD0C0C0, 0xD3DFD3};
        GREEN = new int[]{24576, 0x228B22, 49152, 7048739, 9419919, 3978097, 65407, 11403055};
        MAGENTA = new int[]{10158176, 13639824, 16716947, 16738740, 0xFF00FF, 14184595, 16758465, 16770273};
        ORDER = new int[]{2, 1, 4, 6, 0, 3, 5, 7};
        RED = new int[]{0x800000, 13789470, 0xFF0000, 16729344, 16737095, 16032864, 16113331, 16770273};
        SALMON_BROWN = new int[]{0xB22222, 0xA52A2A, 0xCD5C5C, 0xF08080, 16416882, 16752762, 14537909, 16770244};
        VIOLET = new int[]{0x600060, 10040012, 9055202, 12211667, 14315734, 0xDDA0DD, 14204888, 15132410};
        YELLOW_ORANGE = new int[]{12092939, 16747520, 16753920, 16766720, 0xFFFF00, 16768685, 0xEEE8AA, 16775388};
        ROI_COLORS = ROIColor.getColorsBitPlaneOrder();
        int colorIndex = 0;
        for (int index : ORDER) {
            ROIColor.COLORS[colorIndex++] = new Color(RED[index]);
            ROIColor.COLORS[colorIndex++] = new Color(GREEN[index]);
            ROIColor.COLORS[colorIndex++] = new Color(BLUE[index]);
            ROIColor.COLORS[colorIndex++] = new Color(YELLOW_ORANGE[index]);
            ROIColor.COLORS[colorIndex++] = new Color(SALMON_BROWN[index]);
            ROIColor.COLORS[colorIndex++] = new Color(MAGENTA[index]);
            ROIColor.COLORS[colorIndex++] = new Color(VIOLET[index]);
            ROIColor.COLORS[colorIndex++] = new Color(GRAY[index]);
        }
        for (int ctr = 0; ctr < 64; ++ctr) {
            Color color = COLORS[ctr];
            ROIColor.COLORS_BRIGHTER[ctr] = color.brighter();
            ROIColor.COLORS_TRANSPARENT[ctr] = new Color(COLORS_BRIGHTER[ctr].getRed(), COLORS_BRIGHTER[ctr].getGreen(), COLORS_BRIGHTER[ctr].getBlue(), 64);
        }
    }
}

