/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import edu.uthscsa.ric.roi.MetadataUser;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Metadata {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_COLOR = "color";
    public static final String DTD_FILE_NAME = "mangoroi.dtd";
    public static final String DTD_FILE_PATH = "http://rii.uthscsa.edu/mango/mangoroi.dtd";
    public static final String ROOT_TAG = "MangoROI";

    private Metadata() {
    }

    public static int[] readMetadata(MetadataUser user, boolean singleColor, String data) throws ParserConfigurationException, SAXException, IOException {
        Node regionListNode;
        NodeList regionList;
        Node linesListNode;
        NodeList linesList;
        String name;
        int color;
        Node pointListNode;
        int[] counts = new int[3];
        if (StringUtils.isBlank((CharSequence)data) || data.indexOf(ROOT_TAG) == -1) {
            return counts;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputStream in = Metadata.class.getResourceAsStream(Metadata.DTD_FILE_NAME);
                BufferedReader input = new BufferedReader(new InputStreamReader(in));
                return new InputSource(input);
            }
        });
        InputSource is = new InputSource(new StringReader(data.trim()));
        Document doc = builder.parse(is);
        NodeList pointsList = doc.getElementsByTagName("Points");
        if (pointsList != null && pointsList.getLength() == 1 && (pointListNode = pointsList.item(0)).getNodeType() == 1) {
            Element points = (Element)pointListNode;
            NodeList poisList = points.getElementsByTagName("POI");
            int numPois = poisList.getLength();
            for (int ctr = 0; ctr < numPois; ++ctr) {
                Node poiNode = poisList.item(ctr);
                if (poiNode.getNodeType() != 1) continue;
                Element poiElem = (Element)poiNode;
                int x = Integer.parseInt(poiElem.getAttribute("x"));
                int y = Integer.parseInt(poiElem.getAttribute("y"));
                int z = Integer.parseInt(poiElem.getAttribute("z"));
                color = Integer.parseInt(poiElem.getAttribute(ATTRIBUTE_COLOR));
                name = poiElem.getAttribute(ATTRIBUTE_NAME);
                POI poi = new POI(x, y, z, color);
                poi.setName(name);
                if (user != null) {
                    user.getPOIManager().addPOI(poi, false, false);
                }
                counts[0] = counts[0] + 1;
            }
        }
        if ((linesList = doc.getElementsByTagName("Lines")) != null && linesList.getLength() == 1 && (linesListNode = linesList.item(0)).getNodeType() == 1) {
            Element lines = (Element)linesListNode;
            NodeList loisList = lines.getElementsByTagName("LOI");
            int numPois = loisList.getLength();
            for (int ctr = 0; ctr < numPois; ++ctr) {
                Node loiNode = loisList.item(ctr);
                if (loiNode.getNodeType() != 1) continue;
                Element loiElem = (Element)loiNode;
                int slice = Integer.parseInt(loiElem.getAttribute("slice"));
                int direction = Integer.parseInt(loiElem.getAttribute("direction"));
                color = Integer.parseInt(loiElem.getAttribute(ATTRIBUTE_COLOR));
                name = loiElem.getAttribute(ATTRIBUTE_NAME);
                boolean closed = Boolean.parseBoolean(loiElem.getAttribute("closed"));
                int length = Integer.parseInt(loiElem.getAttribute("length"));
                Point[] points = new Point[length];
                NodeList loiPointsList = loiElem.getElementsByTagName("Point");
                int numLOIPoints = loiPointsList.getLength();
                for (int ctrP = 0; ctrP < numLOIPoints; ++ctrP) {
                    Node pointNode = loiPointsList.item(ctrP);
                    if (pointNode.getNodeType() != 1) continue;
                    Element pointElem = (Element)pointNode;
                    int index = Integer.parseInt(pointElem.getAttribute("index"));
                    int x = Integer.parseInt(pointElem.getAttribute("x"));
                    int y = Integer.parseInt(pointElem.getAttribute("y"));
                    points[index] = new Point(x, y);
                }
                GeneralPath path = new GeneralPath();
                path.moveTo(points[0].x, points[0].y);
                for (int ctrP = 1; ctrP < points.length; ++ctrP) {
                    path.lineTo(points[ctrP].x, points[ctrP].y);
                }
                if (closed) {
                    path.closePath();
                }
                if (user != null) {
                    LOIShape loi = new LOIShape(path.getPathIterator(null), slice, color, (LineListener)((Object)user), (LineUser)((Object)user));
                    loi.setName(name);
                    if (direction == 0) {
                        user.getLOIManagerAxial().addLOI(loi, false, false);
                    } else if (direction == 1) {
                        user.getLOIManagerCoronal().addLOI(loi, false, false);
                    } else if (direction == 2) {
                        user.getLOIManagerSagittal().addLOI(loi, false, false);
                    }
                }
                counts[1] = counts[1] + 1;
            }
        }
        if ((regionList = doc.getElementsByTagName("Regions")) != null && regionList.getLength() == 1 && (regionListNode = regionList.item(0)).getNodeType() == 1) {
            int color2;
            int numROIs;
            Element regions = (Element)regionListNode;
            NodeList roisList = regions.getElementsByTagName("ROI");
            counts[2] = numROIs = roisList.getLength();
            if (singleColor && numROIs == 1) {
                Node roiNode = roisList.item(0);
                if (roiNode.getNodeType() == 1 && user != null) {
                    Element roiElem = (Element)roiNode;
                    String name2 = roiElem.getAttribute(ATTRIBUTE_NAME);
                    color2 = user.getROIManager().getCurrentROI();
                    user.getROIManager().setLabel(color2, name2, false);
                }
            } else {
                for (int ctr = 0; ctr < numROIs; ++ctr) {
                    Node roiNode = roisList.item(ctr);
                    if (roiNode.getNodeType() != 1) continue;
                    Element roiElem = (Element)roiNode;
                    color2 = Integer.parseInt(roiElem.getAttribute(ATTRIBUTE_COLOR));
                    String name3 = roiElem.getAttribute(ATTRIBUTE_NAME);
                    if (user == null) continue;
                    user.getROIManager().setLabel(color2, name3, false);
                }
            }
        }
        return counts;
    }

    public static String writeMetadata(MetadataUser user, int selectedROI) throws ParserConfigurationException, TransformerException {
        ROIManager roiManager;
        POI[] pois;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement(ROOT_TAG);
        doc.appendChild(rootElement);
        rootElement.setAttribute("version", user.getMangoVersion());
        POIManager poiManager = user.getPOIManager();
        if (poiManager != null && (pois = poiManager.getAllPOIs()) != null) {
            Element points = doc.createElement("Points");
            rootElement.appendChild(points);
            for (POI poi2 : pois) {
                Element poi = doc.createElement("POI");
                poi.setAttribute("x", String.valueOf(poi2.getX()));
                poi.setAttribute("y", String.valueOf(poi2.getY()));
                poi.setAttribute("z", String.valueOf(poi2.getZ()));
                poi.setAttribute(ATTRIBUTE_COLOR, String.valueOf(poi2.getColor()));
                String name = poi2.getName();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    poi.setAttribute(ATTRIBUTE_NAME, String.valueOf(poi2.getName()));
                }
                points.appendChild(poi);
            }
        }
        LOIManager loiManagerAxial = user.getLOIManagerAxial();
        LOIManager loiManagerCoronal = user.getLOIManagerCoronal();
        LOIManager loiManagerSagittal = user.getLOIManagerSagittal();
        if (loiManagerAxial != null && loiManagerCoronal != null && loiManagerSagittal != null) {
            boolean axialHasLines = loiManagerAxial.hasShapes();
            boolean coronalHasLines = loiManagerCoronal.hasShapes();
            boolean sagittalHasLines = loiManagerSagittal.hasShapes();
            if (axialHasLines || coronalHasLines || sagittalHasLines) {
                Element lines = doc.createElement("Lines");
                rootElement.appendChild(lines);
                if (axialHasLines) {
                    Metadata.addLines(loiManagerAxial, doc, lines);
                }
                if (coronalHasLines) {
                    Metadata.addLines(loiManagerCoronal, doc, lines);
                }
                if (sagittalHasLines) {
                    Metadata.addLines(loiManagerSagittal, doc, lines);
                }
            }
        }
        if ((roiManager = user.getROIManager()) != null) {
            Element regions = doc.createElement("Regions");
            rootElement.appendChild(regions);
            Vector<Integer> usedROIs = roiManager.getUsedIndices();
            for (int index : usedROIs) {
                if (selectedROI != -1 && selectedROI != index) continue;
                Element roi = doc.createElement("ROI");
                roi.setAttribute(ATTRIBUTE_COLOR, String.valueOf(index));
                String label = roiManager.getLabel(index, null);
                if (StringUtils.isNotBlank((CharSequence)label)) {
                    roi.setAttribute(ATTRIBUTE_NAME, label);
                }
                regions.appendChild(roi);
            }
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("doctype-system", DTD_FILE_PATH);
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String data = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return data;
    }

    private static void addLines(LOIManager manager, Document doc, Element lines) {
        LOIShape[][] lois;
        for (LOIShape[] loi2 : lois = manager.getAll()) {
            if (loi2 == null) continue;
            for (LOIShape currentLOI = loi2[0]; currentLOI != null; currentLOI = currentLOI.getNext()) {
                Element loi = doc.createElement("LOI");
                loi.setAttribute("slice", String.valueOf(currentLOI.getSliceNum()));
                loi.setAttribute("direction", String.valueOf(currentLOI.getSliceDirection()));
                loi.setAttribute(ATTRIBUTE_COLOR, String.valueOf(currentLOI.getColor()));
                loi.setAttribute("closed", String.valueOf(currentLOI.isClosed()));
                String name = currentLOI.getName();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    loi.setAttribute(ATTRIBUTE_NAME, String.valueOf(currentLOI.getName()));
                }
                Vector<Point> points = currentLOI.getPoints();
                loi.setAttribute("length", String.valueOf(points.size()));
                int pointIndex = 0;
                for (Point point : points) {
                    Element loiPoint = doc.createElement("Point");
                    loiPoint.setAttribute("index", String.valueOf(pointIndex++));
                    loiPoint.setAttribute("x", String.valueOf(point.x));
                    loiPoint.setAttribute("y", String.valueOf(point.y));
                    loi.appendChild(loiPoint);
                }
                lines.appendChild(loi);
            }
        }
    }
}

