/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.roi;

import Jama.Matrix;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.mask.manager.ROIUser;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import java.util.Vector;
import javax.vecmath.Vector4d;
import quickhull3d.Point3d;
import quickhull3d.QuickHull3D;

public class ConvexHull3D {
    private Vector4d[] planes;
    private boolean doROIMode;
    private boolean doRange;
    private boolean excludeZero;
    private boolean isSeries;
    private boolean isSliceOnly;
    private double max;
    private double min;
    private int sliceDir;
    private int sliceNum;
    private int tLoc;
    private int xDim;
    private int xMax;
    private int xMin;
    private int yDim;
    private int yMax;
    private int yMin;
    private int zDim;
    private int zMax;
    private int zMin;
    private long inputMask;
    private final VolumeData volData;
    private final ROIUser user;
    private final ROIManager roi;
    private final Volume volume;
    public static final double EPSILON = 1.0E-6;

    public ConvexHull3D(ROIManager roi, ROIUser user) {
        this.roi = roi;
        this.user = user;
        this.volume = (Volume)user.getBaseVolume();
        this.volData = new VolumeData(user);
    }

    public ImageBounds getBounds() {
        return new ImageBounds(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax);
    }

    public boolean intersects(double xLoc, double yLoc, double zLoc) {
        for (Vector4d plane : this.planes) {
            if (!(xLoc * plane.x + yLoc * plane.y + zLoc * plane.z + plane.w > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public void makeConvexHull(double min, double max, boolean doRange, boolean excludeZero, boolean doSliceOnly, int tLoc, long mask) {
        this.inputMask = mask;
        this.tLoc = tLoc == -1 ? this.volume.getCurrentTimepoint() : tLoc;
        this.doMakeConvexHull(min, max, doRange, excludeZero, doSliceOnly, tLoc);
    }

    public void makeConvexHullROI(boolean isSliceOnlyVal, boolean isSeries, int tLoc, long mask) {
        this.doROIMode = true;
        this.inputMask = mask;
        this.isSeries = isSeries;
        boolean isSliceOnly = isSliceOnlyVal;
        this.tLoc = isSeries ? tLoc : 0;
        this.doMakeConvexHull(0.0, 0.0, false, false, isSliceOnly |= this.roi.getROIBounds(this.inputMask).isSingleSlice(), tLoc);
    }

    public boolean testForEdge(int xLoc, int yLoc, int zLoc) {
        if (!this.doROIMode) {
            return this.testForEdgeImage(xLoc, yLoc, zLoc);
        }
        return this.testForEdgeROI(xLoc, yLoc, zLoc);
    }

    public boolean testForEdgeImage(int xLoc, int yLoc, int zLoc) {
        double value = this.getValue(xLoc, yLoc, zLoc);
        if (!(!(value >= this.min) || this.doRange && !(value <= this.max) || this.excludeZero && value == 0.0)) {
            for (int ctrZ = -1; ctrZ <= 1; ++ctrZ) {
                for (int ctrY = -1; ctrY <= 1; ++ctrY) {
                    for (int ctrX = -1; ctrX <= 1; ++ctrX) {
                        int xLocCurrent = xLoc + ctrX;
                        int yLocCurrent = yLoc + ctrY;
                        int zLocCurrent = zLoc + ctrZ;
                        if (xLocCurrent < 0 || xLocCurrent >= this.xDim || yLocCurrent < 0 || yLocCurrent >= this.yDim || zLocCurrent < 0 || zLocCurrent >= this.zDim) {
                            return true;
                        }
                        double edgeValue = this.getValue(xLocCurrent, yLocCurrent, zLocCurrent);
                        if (!(edgeValue < this.min || this.doRange && edgeValue > this.max) && (!this.excludeZero || edgeValue != 0.0)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean testForEdgeROI(int xLoc, int yLoc, int zLoc) {
        if ((this.getROIValue(xLoc, yLoc, zLoc) & this.inputMask) != 0L) {
            for (int ctrZ = -1; ctrZ <= 1; ++ctrZ) {
                for (int ctrY = -1; ctrY <= 1; ++ctrY) {
                    for (int ctrX = -1; ctrX <= 1; ++ctrX) {
                        int xLocCurrent = xLoc + ctrX;
                        int yLocCurrent = yLoc + ctrY;
                        int zLocCurrent = zLoc + ctrZ;
                        if (xLocCurrent < 0 || xLocCurrent >= this.xDim || yLocCurrent < 0 || yLocCurrent >= this.yDim || zLocCurrent < 0 || zLocCurrent >= this.zDim) {
                            return true;
                        }
                        if ((this.getROIValue(xLocCurrent, yLocCurrent, zLocCurrent) & this.inputMask) != 0L) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private Vector4d createPlane(Point3d p1, Point3d p2, Point3d p3, Matrix matrix) {
        double[][] mat = matrix.getArray();
        mat[0][0] = 1.0;
        mat[0][1] = p1.y;
        mat[0][2] = p1.z;
        mat[1][0] = 1.0;
        mat[1][1] = p2.y;
        mat[1][2] = p2.z;
        mat[2][0] = 1.0;
        mat[2][1] = p3.y;
        mat[2][2] = p3.z;
        double a = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = 1.0;
        mat[0][2] = p1.z;
        mat[1][0] = p2.x;
        mat[1][1] = 1.0;
        mat[1][2] = p2.z;
        mat[2][0] = p3.x;
        mat[2][1] = 1.0;
        mat[2][2] = p3.z;
        double b = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = p1.y;
        mat[0][2] = 1.0;
        mat[1][0] = p2.x;
        mat[1][1] = p2.y;
        mat[1][2] = 1.0;
        mat[2][0] = p3.x;
        mat[2][1] = p3.y;
        mat[2][2] = 1.0;
        double c = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = p1.y;
        mat[0][2] = p1.z;
        mat[1][0] = p2.x;
        mat[1][1] = p2.y;
        mat[1][2] = p2.z;
        mat[2][0] = p3.x;
        mat[2][1] = p3.y;
        mat[2][2] = p3.z;
        double d = -1.0 * matrix.det();
        return new Vector4d(a, b, c, d);
    }

    private void doMakeConvexHull(double min, double max, boolean doRange, boolean excludeZero, boolean doSliceOnly, int tLoc) {
        this.isSliceOnly = doSliceOnly;
        this.sliceDir = this.user.getSliceDirection();
        this.sliceNum = this.user.getSliceNumber();
        this.tLoc = tLoc == -1 ? this.volume.getCurrentTimepoint() : tLoc;
        ImageDimensions id = this.volume.getImageDimensions();
        this.xDim = id.getX();
        this.yDim = id.getY();
        this.zDim = id.getZ();
        this.min = min;
        this.max = max;
        this.doRange = doRange;
        this.excludeZero = excludeZero;
        int zMinSearch = 0;
        int yMinSearch = 0;
        int xMinSearch = 0;
        int xMaxSearch = this.xDim - 1;
        int yMaxSearch = this.yDim - 1;
        int zMaxSearch = this.zDim - 1;
        if (this.isSliceOnly) {
            if (this.sliceDir == 0) {
                zMinSearch = Math.max(this.sliceNum - 1, 0);
                zMaxSearch = Math.min(this.sliceNum + 1, this.zDim - 1);
            } else if (this.sliceDir == 1) {
                yMinSearch = Math.max(this.sliceNum - 1, 0);
                yMaxSearch = Math.min(this.sliceNum + 1, this.yDim - 1);
            } else {
                xMinSearch = Math.max(this.sliceNum - 1, 0);
                xMaxSearch = Math.min(this.sliceNum + 1, this.xDim - 1);
            }
        }
        Vector<Point3d> pointsVec = this.findPoints(xMinSearch, xMaxSearch, yMinSearch, yMaxSearch, zMinSearch, zMaxSearch);
        boolean isValidBounds = true;
        if (!this.isSliceOnly) {
            if (this.zMin == this.zMax) {
                isValidBounds = false;
                this.sliceDir = 0;
                this.sliceNum = this.zMin;
                zMinSearch = this.sliceNum - 1;
                zMaxSearch = this.sliceNum + 1;
            } else if (this.yMin == this.yMax) {
                isValidBounds = false;
                this.sliceDir = 1;
                this.sliceNum = this.yMin;
                yMinSearch = this.sliceNum - 1;
                yMaxSearch = this.sliceNum + 1;
            } else if (this.xMin == this.xMax) {
                isValidBounds = false;
                this.sliceDir = 2;
                this.sliceNum = this.xMin;
                xMinSearch = this.sliceNum - 1;
                xMaxSearch = this.sliceNum + 1;
            }
        }
        if (!isValidBounds) {
            this.isSliceOnly = true;
            pointsVec = this.findPoints(xMinSearch, xMaxSearch, yMinSearch, yMaxSearch, zMinSearch, zMaxSearch);
        }
        if (this.isSliceOnly) {
            if (this.sliceDir == 0) {
                this.zMin = this.zMax = this.sliceNum;
            } else if (this.sliceDir == 1) {
                this.yMin = this.yMax = this.sliceNum;
            } else {
                this.xMin = this.xMax = this.sliceNum;
            }
        }
        Point3d[] allPoints = new Point3d[pointsVec.size()];
        pointsVec.toArray(allPoints);
        QuickHull3D qh = new QuickHull3D();
        qh.build(allPoints);
        Point3d[] pointsProcessed = qh.getVertices();
        int[][] faces = qh.getFaces();
        this.planes = new Vector4d[faces.length];
        Matrix matrix = new Matrix(new double[3][3]);
        for (int ctr = 0; ctr < faces.length; ++ctr) {
            this.planes[ctr] = this.createPlane(pointsProcessed[faces[ctr][0]], pointsProcessed[faces[ctr][1]], pointsProcessed[faces[ctr][2]], matrix);
        }
    }

    private Vector<Point3d> findPoints(int xMinSearch, int xMaxSearch, int yMinSearch, int yMaxSearch, int zMinSearch, int zMaxSearch) {
        Vector<Point3d> pointsVec = new Vector<Point3d>();
        boolean boundsInitialized = false;
        for (int ctrZ = zMinSearch; ctrZ <= zMaxSearch; ++ctrZ) {
            for (int ctrY = yMinSearch; ctrY <= yMaxSearch; ++ctrY) {
                for (int ctrX = xMinSearch; ctrX <= xMaxSearch; ++ctrX) {
                    if (!this.testForEdge(ctrX, ctrY, ctrZ)) continue;
                    pointsVec.add(new Point3d((double)ctrX, (double)ctrY, (double)ctrZ));
                    if (!boundsInitialized) {
                        this.xMin = this.xMax = ctrX;
                        this.yMin = this.yMax = ctrY;
                        this.zMin = this.zMax = ctrZ;
                        boundsInitialized = true;
                        continue;
                    }
                    if (this.xMin > ctrX) {
                        this.xMin = ctrX;
                    } else if (this.xMax < ctrX) {
                        this.xMax = ctrX;
                    }
                    if (this.yMin > ctrY) {
                        this.yMin = ctrY;
                    } else if (this.yMax < ctrY) {
                        this.yMax = ctrY;
                    }
                    if (this.zMin > ctrZ) {
                        this.zMin = ctrZ;
                        continue;
                    }
                    if (this.zMax >= ctrZ) continue;
                    this.zMax = ctrZ;
                }
            }
        }
        return pointsVec;
    }

    private long getROIValue(int xLocVal, int yLocVal, int zLocVal) {
        int xLoc = xLocVal;
        int yLoc = yLocVal;
        int zLoc = zLocVal;
        if (this.isSliceOnly) {
            if (this.sliceDir == 0) {
                zLoc = this.sliceNum;
            } else if (this.sliceDir == 1) {
                yLoc = this.sliceNum;
            } else {
                xLoc = this.sliceNum;
            }
        }
        if (this.isSeries) {
            return this.roi.getMaskValue(xLoc, yLoc, zLoc, this.tLoc);
        }
        return this.roi.getMaskValue(xLoc, yLoc, zLoc);
    }

    private double getValue(int ctrXVal, int ctrYVal, int ctrZVal) {
        int ctrX = ctrXVal;
        int ctrY = ctrYVal;
        int ctrZ = ctrZVal;
        if (this.isSliceOnly) {
            if (this.sliceDir == 0) {
                ctrZ = this.sliceNum;
            } else if (this.sliceDir == 1) {
                ctrY = this.sliceNum;
            } else {
                ctrX = this.sliceNum;
            }
        }
        return this.volData.getValue(ctrX, ctrY, ctrZ, this.tLoc);
    }
}

