/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.window;

import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.window.ToolboxWindowHeaderUser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ToolboxWindowHeader
extends JPanel {
    private Dimension parentCurrentSize;
    private MouseEvent pressed;
    private Point parentCurrentLocation;
    private int farthestLeftDisplay;
    private int farthestRightDisplay;
    private final Dimension[] screenSizes;
    private final ToolboxWindowHeaderUser user;
    private final Insets[] screenInsets;
    private final Rectangle[] screenBounds;
    private static final long serialVersionUID = 1L;

    protected ToolboxWindowHeader(ToolboxWindowHeaderUser user, int size) {
        this.user = user;
        this.screenBounds = DisplayUtils.getAllDisplayBounds();
        this.screenInsets = DisplayUtils.getAllDisplayInsets();
        this.screenSizes = DisplayUtils.getAllDisplaySizes();
        for (int ctr = 0; ctr < this.screenBounds.length; ++ctr) {
            if (DisplayUtils.isFarthestLeftDisplay(ctr)) {
                this.farthestLeftDisplay = ctr;
            }
            if (!DisplayUtils.isFarthestRightDisplay(ctr)) continue;
            this.farthestRightDisplay = ctr;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ToolboxWindowHeader.this.pressed = me;
                ToolboxWindowHeader.this.user.headerPanelClicked();
                if (me.getClickCount() % 2 == 0) {
                    ToolboxWindowHeader.this.user.headerPanelDoubleClicked();
                }
                if (me.isShiftDown()) {
                    ToolboxWindowHeader.this.user.headerPanelShiftClicked();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                ToolboxWindowHeader.this.parentCurrentSize = ToolboxWindowHeader.this.user.getSize();
                ToolboxWindowHeader.this.parentCurrentLocation = ToolboxWindowHeader.this.user.getLocation(ToolboxWindowHeader.this.parentCurrentLocation);
                int x = ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentLocation.x - ToolboxWindowHeader.this.pressed.getX() + me.getX();
                int y = ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentLocation.y - ToolboxWindowHeader.this.pressed.getY() + me.getY();
                if (x < ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestLeftDisplay].x + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestLeftDisplay].left) {
                    x = ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestLeftDisplay].x + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestLeftDisplay].left;
                } else if (x > ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].x + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenSizes[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].width - ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentSize.width - ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].right) {
                    x = ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].x + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenSizes[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].width - ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentSize.width - ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[((ToolboxWindowHeader)ToolboxWindowHeader.this).farthestRightDisplay].right;
                }
                int displayIndex = 0;
                if (ToolboxWindowHeader.this.screenBounds.length > 1) {
                    for (int ctr = 0; ctr < ToolboxWindowHeader.this.screenBounds.length; ++ctr) {
                        if ((ToolboxWindowHeader.this.screenBounds[ctr].outcode(x, y) & 5) != 0) continue;
                        displayIndex = ctr;
                        break;
                    }
                }
                if (y < ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[displayIndex].y + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[displayIndex].top) {
                    y = ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[displayIndex].y + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[displayIndex].top;
                } else if (y > ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[displayIndex].y + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenSizes[displayIndex].height - ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentSize.height - ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[displayIndex].bottom) {
                    y = ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenBounds[displayIndex].y + ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenSizes[displayIndex].height - ((ToolboxWindowHeader)ToolboxWindowHeader.this).parentCurrentSize.height - ((ToolboxWindowHeader)ToolboxWindowHeader.this).screenInsets[displayIndex].bottom;
                }
                ToolboxWindowHeader.this.user.setLocation(x, y);
            }
        });
        this.setPreferredSize(new Dimension(0, size));
        this.setBackground(Color.LIGHT_GRAY);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }
}

