/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.window;

import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.ImageLoader;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoPreferences;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerListener;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.menus.MangoCheckBoxMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoMenu;
import edu.uthscsa.ric.mango.components.menus.MangoMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenu;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenuItem;
import edu.uthscsa.ric.mango.components.multithumbslider.BasicMThumbSliderUI;
import edu.uthscsa.ric.mango.components.multithumbslider.MThumbSlider;
import edu.uthscsa.ric.mango.components.multithumbslider.MThumbSliderUser;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBarListener;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySlider;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySliderUser;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.SimpleDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.ImageInfoDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ROISliceRangeDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ROISmartToolsDialog;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenSlice;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.window.AtlasComparator;
import edu.uthscsa.ric.mango.window.ToolboxAssociated;
import edu.uthscsa.ric.mango.window.ToolboxWindowHeader;
import edu.uthscsa.ric.mango.window.ToolboxWindowHeaderUser;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.ProgressBar;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class Toolbox
extends JFrame
implements ActionListener,
ColorManager,
MThumbSliderUser,
MangoColorPickerListener,
MangoColorPickerPopupManager,
MangoTransparencySliderUser,
MenuListener,
PopupMenuListener,
ProgressBarListener,
ToolboxWindowHeaderUser,
WindowListener {
    private Atlas currentAtlas;
    private BufferedImage baseImage;
    private BufferedImage baseImageFiltered;
    private BufferedImage[] overlayImages;
    private BufferedImage[] overlayImagesFiltered;
    private CardLayout cardLayout;
    private ImageIcon baseImageIcon;
    private ImageIcon[] overlayImageIcons;
    private JButton cameraButton;
    private JButton continueButton;
    private JButton coordinatesButton;
    private JButton overlayButton;
    private JButton roiEditButton;
    private JButton transformButton;
    private JButton voiButton;
    private JLabel labelsTD1;
    private JLabel labelsTD2;
    private JLabel labelsTD3;
    private JLabel labelsTD4;
    private JLabel mouseValue;
    private JLabel mouseX;
    private JLabel mouseY;
    private JLabel mouseZ;
    private JMenu helpMenu;
    private JMenu openMenu;
    private JMenu optionsMenu;
    private JMenu quitMenu;
    private JMenu windowsMenu;
    private JMenuBar menu;
    private JMenuItem addItem;
    private JMenuItem allToFront;
    private JMenuItem arrangeStack;
    private JMenuItem copyItem;
    private JMenuItem dilateItem;
    private JMenuItem drawItem;
    private JMenuItem editItem;
    private JMenuItem ellipseDrawItem;
    private JMenuItem ellipseItem;
    private JMenuItem eraseItem;
    private JMenuItem fileAddNew;
    private JMenuItem fileEditHeader;
    private JMenuItem fileOpen;
    private JMenuItem fileOpenBrowser;
    private JMenuItem fileOpenFolder;
    private JMenuItem fileOpenRaw;
    private JMenuItem fileOpenURL;
    private JMenuItem filePreviewFolder;
    private JMenuItem fileSample;
    private JMenuItem fixedTimeseries;
    private JMenuItem globalItem;
    private JMenuItem groupOverlayWindow;
    private JMenuItem lineItem;
    private JMenuItem linkedItem;
    private JMenuItem linkedZoomItem;
    private JMenuItem linkedItemMain;
    private JMenuItem linkedItemSurface;
    private JMenuItem magicWandRange;
    private JMenuItem paintItem;
    private JMenuItem pointItem;
    private JMenuItem preserveItem;
    private JMenuItem rectangleDrawItem;
    private JMenuItem rectangleItem;
    private JMenuItem removeItem;
    private JMenuItem setRangeItem2;
    private JMenuItem setRangeItem3;
    private JMenuItem setRangeItem;
    private JMenuItem showConsole;
    private JMenuItem viewResults;
    private JMenuItem windowMenuMinimizeAll;
    private JPanel cardPanel;
    private JPanel coordinatePanel;
    private JPanel labelsPanel;
    private JPanel progressBarPanel;
    private JPopupMenu popupCoordinate;
    private JPopupMenu popupOverlay;
    private JPopupMenu popupROIEdit;
    private JTextField textFieldMax;
    private JTextField textFieldMin;
    private LookupTableManager lutManagerDefault;
    private MThumbSlider slider;
    private MangoColorButton roiButton;
    private MangoSquareMenu roiSubMenuMagic;
    private MangoSquareMenu roiSubMenuPaint;
    private MangoSquareMenu roiSubMenuTrace;
    private MangoSquareMenu worldOption;
    private Popup popupROI;
    private boolean makeTextFieldMaxActive;
    private boolean makeTextFieldMinActive;
    private boolean scriptPaused;
    private boolean textFieldMaxTouched;
    private boolean textFieldMaxTouchedInitialized;
    private boolean textFieldMinTouched;
    private boolean textFieldMinTouchedInitialized;
    private double globalScreenMax;
    private double globalScreenMin;
    private double globalScreenRatio;
    private int coordinateType;
    private int mousePlane;
    private int progressBarsShowing;
    private int roiEditMode;
    private int roiMagicMode;
    private int roiPaintMode;
    private int roiTraceMode;
    private int xLoc;
    private int yLoc;
    private int zLoc;
    private int selectionMode;
    private int[] baseImageData;
    private int[] sliderImageData;
    private int[][] overlayData;
    private long popupCoordinateTimeCanceled;
    private long popupOverlayTimeCanceled;
    private long popupROIEditTimeCanceled;
    private final Coordinate currentCoor = new Coordinate();
    private final Coordinate tempCoor = new Coordinate();
    private final JPanel mainPanel;
    private final JPanel mainPanelSub;
    private final Mango mango;
    private final ToolboxWindowHeader header;
    private final Vector<Atlas> allAtlases = new Vector();
    private final Vector<Atlas> loadedAtlases = new Vector();
    private final Vector<ImageLoader> allLoaders = new Vector();
    private final Vector<ToolboxAssociated> associatedWindows = new Vector();
    private final boolean applet;
    private static final long serialVersionUID = 1L;
    protected BufferedImage sliderImage;
    protected BufferedImage sliderImageFiltered;
    protected SliceViewer currentViewer;
    protected boolean fixedRange = true;
    protected boolean global;
    protected boolean overlayGroup;
    protected boolean relative;
    protected boolean tdLabelPanelAdded;
    protected boolean voiMode = true;
    public static final Color POPUP_MENU_ITEM_COLOR = new Color(235, 235, 235);
    public static final Color SELECTION_COLOR = new Color(181, 214, 255);
    public static final Dimension BUTTON_SIZE = new Dimension(35, 35);
    public static final Dimension PROGRESS_BAR_DIMENSIONS = new Dimension(200, 20);
    public static final Dimension START_SIZE_COMPACT_LABELS = new Dimension(500, 40);
    public static final Dimension START_SIZE_TOOLBAR_BUTTONS = new Dimension(250, 35);
    public static final Dimension START_SIZE_TOOLBAR_SLIDER = new Dimension(250, 45);
    public static final Dimension START_SIZE_TOOLBAR_TOP = new Dimension(250, 42);
    public static final Font MENU_FONT = new Font("SansSerif", 0, 10);
    public static final MangoNumberFormatter FORMATTER_NUMBER = new MangoNumberFormatter();
    public static final MangoNumberFormatter FORMATTER_VALUE = new MangoNumberFormatter(1);
    static final Map<Integer, JMenuItem> FUNCTION_KEY_MAP = new TreeMap<Integer, JMenuItem>();
    static final Map<String, JMenuItem> MENU_ACTION_MAP = new TreeMap<String, JMenuItem>();
    static final Map<String, JMenuItem> MENU_NAME_MAP = new TreeMap<String, JMenuItem>();
    public static final String ACTION_GET_INFO = "Get Info ";
    public static final String ACTION_LOGICAL = "Logical";
    public static final String ACTION_SET_EXPLICIT_VALUE_RANGE = "Set Explicit Value Range...";
    public static final String ACTION_WINDOW = "Window";
    public static final String CARD_CONTINUE = "CARD_CONTINUE";
    public static final String CARD_ORIGINAL = "CARD_ORIGINAL";
    public static final String CARD_PROGRESS = "CARD_PROGRESS";
    public static final String NO_ATLAS_NAME = "None";
    public static final String TEXT_GET_VOLUME = ".getVolume(";
    public static final int EDIT_MODE_MAGIC = 3;
    public static final int EDIT_MODE_NAV = 0;
    public static final int EDIT_MODE_PAINT = 1;
    public static final int EDIT_MODE_TRACE = 2;
    public static final int ICON_SIZE = 23;
    public static final int MENU_FONT_SIZE = 11;
    public static final int NAV_MODE_DEFAULT = 0;
    public static final int NAV_MODE_SELECTION = 4;
    public static final int NAV_MODE_WINDOW = 1;
    public static final int NAV_MODE_ZOOM = 2;
    public static final int NAV_MODE_ZOOM_PAN = 3;
    public static final int SLIDER_TRACK_LENGTH = 128;

    public Toolbox(Mango parent, boolean applet) {
        this.mango = parent;
        this.applet = applet;
        this.header = new ToolboxWindowHeader(this, 15);
        this.mainPanelSub = new JPanel();
        this.mainPanel = new JPanel();
        this.roiPaintMode = 1;
        this.roiTraceMode = 7;
        this.roiMagicMode = 12;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.startsWith("coordinate space")) {
            int spaceIndex = Integer.parseInt(command.substring(17, 18));
            int screenVolumeIndex = Integer.parseInt(command.substring(19, 20));
            this.currentViewer.recordAction("setOrientationOption", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + screenVolumeIndex + ")", String.valueOf(spaceIndex)});
            Volume vol = null;
            vol = screenVolumeIndex > 0 ? this.currentViewer.getOverlayManager().getOverlay(screenVolumeIndex - 1).getVolume() : this.currentViewer.getBaseScreenVolume().getVolume();
            this.currentViewer.setSelectedCoordinateSpaceTransform(vol, spaceIndex);
            this.updateCoordinate(4);
        } else if (command.equals("coordinatesButtonToggle")) {
            long timeSinceCancel = new Date().getTime() - this.popupCoordinateTimeCanceled;
            if (timeSinceCancel > 250L) {
                this.closePopups();
                this.updateCoordinatePopupMenu();
                this.popupCoordinate.show(this.coordinatesButton, 2, 35);
            }
        } else if (command.indexOf("roiButtonChosen") != -1) {
            int roiColor = Integer.parseInt(command.substring(15));
            this.roiColorChosen(roiColor);
        } else if (command.equals("roiButtonToggle")) {
            if (this.popupROI != null) {
                this.popupROI.hide();
                this.popupROI = null;
            } else {
                this.showROIColorPicker();
            }
        } else if (command.equals("roiEditButtonToggle")) {
            long timeSinceCancel = new Date().getTime() - this.popupROIEditTimeCanceled;
            if (timeSinceCancel > 250L) {
                this.closePopups();
                this.popupROIEdit.show(this.roiEditButton, 2, 35);
            }
        } else if (command.equals("voiButtonToggle")) {
            this.setVOIMode(!this.voiMode);
        } else if (command.equals("cameraButton")) {
            this.closePopups();
            boolean isShiftDown = (ae.getModifiers() & 1) != 0;
            this.mango.recordAction("capture");
            this.mango.doCapture(isShiftDown, this.mango.getCurrentViewer());
        } else if (command.indexOf(ACTION_GET_INFO) != -1) {
            int index = Integer.parseInt(command.substring(9)) - 1;
            ScreenVolume aScreenVol = null;
            aScreenVol = index == -1 ? this.currentViewer.getBaseScreenVolume() : this.currentViewer.getOverlayManager().getOverlay(index);
            this.currentViewer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Image Info")});
            new ImageInfoDialog(this.currentViewer, aScreenVol);
        } else if (command.indexOf("Transform to Talairach") != -1) {
            int index = Integer.parseInt(command.substring(23)) - 1;
            ScreenVolume aScreenVol = null;
            if (index == -1) {
                this.currentViewer.showTransformManualPanel();
                aScreenVol = this.currentViewer.getBaseScreenVolume();
            } else {
                aScreenVol = this.currentViewer.getOverlayManager().getOverlay(index);
            }
            aScreenVol.setTransformToTalairach();
            double[][] mat = aScreenVol.getVolume().convertFromCoordinateTransform(Transform.MNI2TAL.getArrayCopy(), true, false, null);
            this.currentViewer.recordAction("transform", new String[]{null, String.valueOf(mat[0][0]), String.valueOf(mat[0][1]), String.valueOf(mat[0][2]), String.valueOf(mat[0][3]), String.valueOf(mat[1][0]), String.valueOf(mat[1][1]), String.valueOf(mat[1][2]), String.valueOf(mat[1][3]), String.valueOf(mat[2][0]), String.valueOf(mat[2][1]), String.valueOf(mat[2][2]), String.valueOf(mat[2][3]), String.valueOf(mat[3][0]), String.valueOf(mat[3][1]), String.valueOf(mat[3][2]), String.valueOf(mat[3][3])}, true);
            this.currentViewer.addTransformPost();
            this.currentViewer.updateViewer();
        } else if (command.indexOf("Transform to MNI") != -1) {
            int index = Integer.parseInt(command.substring(17)) - 1;
            ScreenVolume aScreenVol = null;
            if (index == -1) {
                this.currentViewer.showTransformManualPanel();
                aScreenVol = this.currentViewer.getBaseScreenVolume();
            } else {
                aScreenVol = this.currentViewer.getOverlayManager().getOverlay(index);
            }
            aScreenVol.setTransformToMNI();
            double[][] mat = aScreenVol.getVolume().convertFromCoordinateTransform(Transform.MNI2TAL.inverse().getArrayCopy(), true, false, null);
            this.currentViewer.recordAction("transform", new String[]{null, String.valueOf(mat[0][0]), String.valueOf(mat[0][1]), String.valueOf(mat[0][2]), String.valueOf(mat[0][3]), String.valueOf(mat[1][0]), String.valueOf(mat[1][1]), String.valueOf(mat[1][2]), String.valueOf(mat[1][3]), String.valueOf(mat[2][0]), String.valueOf(mat[2][1]), String.valueOf(mat[2][2]), String.valueOf(mat[2][3]), String.valueOf(mat[3][0]), String.valueOf(mat[3][1]), String.valueOf(mat[3][2]), String.valueOf(mat[3][3])}, true);
            this.currentViewer.addTransformPost();
            this.currentViewer.updateViewer();
        } else if (command.indexOf("Reset Transform") != -1) {
            int index = Integer.parseInt(command.substring(16)) - 1;
            ScreenVolume aScreenVol = null;
            if (index == -1) {
                this.currentViewer.showTransformManualPanel();
                aScreenVol = this.currentViewer.getBaseScreenVolume();
            } else {
                aScreenVol = this.currentViewer.getOverlayManager().getOverlay(index);
            }
            aScreenVol.setTransformToIdentity();
            double[][] mat = aScreenVol.getVolume().convertFromCoordinateTransform(Transform.IDENTITY.getArrayCopy(), true, false, null);
            this.currentViewer.recordAction("transform", new String[]{null, String.valueOf(mat[0][0]), String.valueOf(mat[0][1]), String.valueOf(mat[0][2]), String.valueOf(mat[0][3]), String.valueOf(mat[1][0]), String.valueOf(mat[1][1]), String.valueOf(mat[1][2]), String.valueOf(mat[1][3]), String.valueOf(mat[2][0]), String.valueOf(mat[2][1]), String.valueOf(mat[2][2]), String.valueOf(mat[2][3]), String.valueOf(mat[3][0]), String.valueOf(mat[3][1]), String.valueOf(mat[3][2]), String.valueOf(mat[3][3])}, true);
            this.currentViewer.addTransformPost();
            this.currentViewer.updateViewer();
        } else if (command.equals("transformButtonToggle")) {
            this.closePopups();
            this.doTransformButtonChosen();
        } else if (command.indexOf("Move Up ") != -1) {
            int index = Integer.parseInt(command.substring(8));
            ScreenVolume anOverlay = this.currentViewer.getOverlayManager().getOverlay(index - 1);
            this.currentViewer.getOverlayManager().moveOverlayUp(anOverlay);
            int indexNew = this.currentViewer.getOverlayManager().getIndex(anOverlay);
            if (indexNew != -1) {
                this.currentViewer.recordAction("setVolumeDisplayIndex", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + index + ")", String.valueOf(indexNew + 1)});
                this.currentViewer.setCurrentScreenVolume(anOverlay);
                anOverlay.setHidden(false);
                this.updateAfterOverlayIndexChange();
            }
        } else if (command.indexOf("Move Down ") != -1) {
            int index = Integer.parseInt(command.substring(10));
            ScreenVolume anOverlay = this.currentViewer.getOverlayManager().getOverlay(index - 1);
            this.currentViewer.getOverlayManager().moveOverlayDown(anOverlay);
            int indexNew = this.currentViewer.getOverlayManager().getIndex(anOverlay);
            if (indexNew != -1) {
                this.currentViewer.recordAction("setVolumeDisplayIndex", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + index + ")", String.valueOf(indexNew + 1)});
                this.currentViewer.setCurrentScreenVolume(anOverlay);
                anOverlay.setHidden(false);
                this.updateAfterOverlayIndexChange();
            }
        } else if (command.indexOf("Load Negatives ") != -1) {
            int index = Integer.parseInt(command.substring(15));
            ScreenVolume anOverlay = this.currentViewer.getOverlayManager().getOverlay(index - 1);
            this.currentViewer.loadOverlayScreenVolume(anOverlay.getVolume(), anOverlay.getURI(), "Overlay (Negatives)", null, false, true);
        } else if (command.indexOf("Interpolation ") != -1) {
            int index = Integer.parseInt(command.substring(14));
            ScreenVolume anOverlay = this.currentViewer.getOverlayManager().getOverlay(index - 1);
            anOverlay.getVolume().setAllowsLinearInterpolation(!anOverlay.getVolume().isAllowsLinearInterpolation());
            this.currentViewer.updateViewer();
        } else if (command.indexOf("Hide ") != -1) {
            int index = Integer.parseInt(command.substring(5));
            if (index > 0) {
                this.currentViewer.recordAction("setVolumeDisplayHidden", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + index + ")", ScriptUtils.convertBoolean(!this.currentViewer.getOverlayManager().getOverlay(index - 1).isHidden())});
                this.currentViewer.getOverlayManager().getOverlay(index - 1).setHidden(!this.currentViewer.getOverlayManager().getOverlay(index - 1).isHidden());
                this.updateHidden();
            }
        } else if (command.indexOf("Region") == -1 && command.indexOf("Remove ") != -1) {
            int index = Integer.parseInt(command.substring(7));
            this.currentViewer.recordAction("removeOverlay", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + index + ")"});
            this.currentViewer.removeOverlay(index - 1);
            this.updateAfterRemoveVolume();
            this.currentViewer.clearOverlayData();
            this.currentViewer.updateViewer();
            this.updateSurfaceTextures();
        } else if (command.indexOf("overlayButtonChosen") != -1) {
            this.doOverlayButtonChosen(command);
            this.updateSurfaceTextures();
        } else if (command.equals("overlayButtonToggle")) {
            long timeSinceCancel;
            if (this.currentViewer != null && (timeSinceCancel = new Date().getTime() - this.popupOverlayTimeCanceled) > 250L) {
                this.closePopups();
                this.updateOverlayPopupMenu();
                this.popupOverlay.show(this.overlayButton, 2, 35);
            }
        } else if (command.equals("linked")) {
            boolean synced = this.linkedItem.isSelected();
            this.mango.setSyncState(synced ? 2 : 0);
        } else if (command.equals("linkedzoom")) {
            boolean synced = this.linkedZoomItem.isSelected();
            this.mango.setSyncZoomState(synced);
        } else if (command.equals("linkedslice")) {
            boolean synced = this.linkedItemMain.isSelected();
            this.mango.setSyncState(synced ? 1 : 0);
        } else if (command.equals("linkedsurface")) {
            boolean synced = this.linkedItemSurface.isSelected();
            this.mango.setSurfaceSyncState(synced);
        } else if (command.equals("global")) {
            this.updateGlobal();
        } else if (command.equals("fixedtimeseries")) {
            this.fixedRange = this.fixedTimeseries.isSelected();
        } else if (command.equals("group")) {
            this.overlayGroup = this.groupOverlayWindow.isSelected();
            if (this.overlayGroup) {
                this.initializeGroupOverlay();
                this.updateOverlayButtonIcons();
                this.updateOverlayPopupMenu();
                this.updateOverlayButton();
            }
            this.mango.notifyBaseImageOverlayListeners();
            this.mango.notifyOverlayImageOverlayListeners();
            this.mango.updateSurfaces();
        } else if (command.startsWith("LUT")) {
            String action = command;
            int startParse = action.indexOf(32) + 1;
            int endParse = action.indexOf(32, startParse);
            int index = Integer.parseInt(action.substring(startParse, endParse));
            this.doOverlayButtonChosen(index);
            startParse = action.indexOf(91) + 1;
            endParse = action.indexOf(93);
            String lutName = action.substring(startParse, endParse);
            this.setLUT(lutName);
        } else if (command.startsWith("atlas")) {
            String commandAtlas = command.substring(5);
            if (commandAtlas.equals(NO_ATLAS_NAME)) {
                this.setAtlas(null);
            } else {
                this.setAtlasByName(commandAtlas);
            }
        } else if (command.equals("Navigate Mode")) {
            this.updateROIEditState(0);
        } else if (command.equals("Edit Mode")) {
            this.editItem.setSelected(true);
            this.eraseItem.setSelected(false);
            this.paintItem.setSelected(false);
            this.updateROIEditState(1);
        } else if (command.equals("Paint Mode")) {
            this.editItem.setSelected(false);
            this.eraseItem.setSelected(false);
            this.paintItem.setSelected(true);
            this.updateROIEditState(1);
        } else if (command.equals("Erase Mode")) {
            this.editItem.setSelected(false);
            this.eraseItem.setSelected(true);
            this.paintItem.setSelected(false);
            this.updateROIEditState(1);
        } else if (command.equals("Rectangle Tool")) {
            this.rectangleItem.setSelected(true);
            this.ellipseItem.setSelected(false);
            this.updateROIEditState(1);
        } else if (command.equals("Ellipse Tool")) {
            this.rectangleItem.setSelected(false);
            this.ellipseItem.setSelected(true);
            this.updateROIEditState(1);
        } else if (command.equals("Draw Region as Rectangle")) {
            this.rectangleDrawItem.setSelected(true);
            this.ellipseDrawItem.setSelected(false);
            this.drawItem.setSelected(false);
            this.lineItem.setSelected(false);
            this.pointItem.setSelected(false);
            this.updateROIEditState(2);
        } else if (command.equals("Draw Region as Ellipse")) {
            this.rectangleDrawItem.setSelected(false);
            this.ellipseDrawItem.setSelected(true);
            this.drawItem.setSelected(false);
            this.lineItem.setSelected(false);
            this.pointItem.setSelected(false);
            this.updateROIEditState(2);
        } else if (command.equals("Trace Region")) {
            this.rectangleDrawItem.setSelected(false);
            this.ellipseDrawItem.setSelected(false);
            this.drawItem.setSelected(true);
            this.lineItem.setSelected(false);
            this.pointItem.setSelected(false);
            this.updateROIEditState(2);
        } else if (command.equals("Trace Line")) {
            this.rectangleDrawItem.setSelected(false);
            this.ellipseDrawItem.setSelected(false);
            this.drawItem.setSelected(false);
            this.lineItem.setSelected(true);
            this.pointItem.setSelected(false);
            this.updateROIEditState(2);
        } else if (command.equals("Add Points")) {
            this.rectangleDrawItem.setSelected(false);
            this.ellipseDrawItem.setSelected(false);
            this.drawItem.setSelected(false);
            this.lineItem.setSelected(false);
            this.pointItem.setSelected(true);
            this.updateROIEditState(2);
        } else if (command.equals("Add Region in Value Range")) {
            this.addItem.setSelected(true);
            this.preserveItem.setSelected(false);
            this.removeItem.setSelected(false);
            this.dilateItem.setSelected(false);
            this.copyItem.setSelected(false);
            this.updateROIEditState(3);
        } else if (command.equals("Preserve Region")) {
            this.addItem.setSelected(false);
            this.preserveItem.setSelected(true);
            this.removeItem.setSelected(false);
            this.dilateItem.setSelected(false);
            this.copyItem.setSelected(false);
            this.updateROIEditState(3);
        } else if (command.equals("Remove Region")) {
            this.addItem.setSelected(false);
            this.preserveItem.setSelected(false);
            this.removeItem.setSelected(true);
            this.dilateItem.setSelected(false);
            this.copyItem.setSelected(false);
            this.updateROIEditState(3);
        } else if (command.equals("Dilate/Erode Region")) {
            this.addItem.setSelected(false);
            this.preserveItem.setSelected(false);
            this.removeItem.setSelected(false);
            this.dilateItem.setSelected(true);
            this.copyItem.setSelected(false);
            this.updateROIEditState(3);
        } else if (command.equals("Copy Region")) {
            this.addItem.setSelected(false);
            this.preserveItem.setSelected(false);
            this.removeItem.setSelected(false);
            this.dilateItem.setSelected(false);
            this.copyItem.setSelected(true);
            this.updateROIEditState(3);
        } else if (command.equals("Set Tool Slice Range...")) {
            int mainSliceDirection = this.currentViewer.getMainSliceDirection();
            ROISliceRangeDialog dialog = new ROISliceRangeDialog(this.mango.getToolSliceRangeBelow(), this.mango.getToolSliceRangeAbove(), mainSliceDirection);
            Frame frame = this.mango.getDialogParentFrame();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Set Tool Slice Range", 3, null);
            int selection = jopf.show(true);
            if (selection == 0) {
                this.mango.setToolSliceRange(dialog.getAbove(), dialog.getBelow());
            }
        } else if (command.startsWith("Set Relative Value Range...")) {
            SimpleDialog dialog = new SimpleDialog("Within", String.valueOf(this.mango.getMagicWandRange()));
            Frame frame = this.mango.getDialogParentFrame();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Set Range", 3, null);
            int selection = jopf.show(true);
            if (selection == 0) {
                double size = this.mango.getMagicWandRange();
                try {
                    size = Math.abs(Double.parseDouble(dialog.getResult()));
                }
                catch (NumberFormatException ex) {
                    AppLogger.info((Throwable)ex);
                }
                this.mango.setMagicWandRange(size);
                this.mango.recordAction("setToolRelativeRange", new String[]{String.valueOf(size)});
                this.updateAfterToolRelativeRangeChnage();
            }
        } else if (command.startsWith(ACTION_SET_EXPLICIT_VALUE_RANGE)) {
            ROISmartToolsDialog dialog = new ROISmartToolsDialog(this.mango);
            Frame frame = this.mango.getDialogParentFrame();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Set Range", -1, null);
            int selection = jopf.show(true);
            if (selection == 0) {
                double minResult = dialog.getMin();
                double maxResult = dialog.getMax();
                boolean isUsingSmartTools = !dialog.isUsingAllValues();
                boolean isUsingSmartToolsToggle = dialog.isUsingToggle();
                this.mango.setSmartToolsRangeMin(minResult);
                this.mango.setSmartToolsRangeMax(maxResult);
                this.mango.setUseSmartROITools(isUsingSmartTools);
                this.mango.setUsingSmartToolsToggle(isUsingSmartToolsToggle);
                this.mango.recordAction("setToolRange", new String[]{ScriptUtils.convertBoolean(isUsingSmartTools), String.valueOf(minResult), String.valueOf(maxResult), ScriptUtils.convertBoolean(isUsingSmartToolsToggle)});
                this.updateAfterToolRangeChange();
            }
        } else if (command.equals("Increase Tool Size")) {
            this.mango.increaseROIToolSize();
        } else if (command.equals("Decrease Tool Size") && this.mango.getROIToolSize() > 0) {
            this.mango.decreaseROIToolSize();
        }
    }

    private void updateGlobal() {
        this.global = this.globalItem.isSelected();
        if (this.global) {
            this.initializeGlobalState();
        } else {
            this.unsetGlobalState();
        }
        if (this.overlayGroup) {
            this.initializeGroupOverlay();
        }
        this.updateOverlayButtonIcons();
        this.updateOverlayPopupMenu();
        this.updateOverlayButton();
        this.mango.notifyBaseImageOverlayListeners();
        this.mango.notifyOverlayImageOverlayListeners();
        this.mango.updateSurfaces();
    }

    public void updateAfterToolRelativeRangeChnage() {
        this.addItem.setSelected(true);
        this.preserveItem.setSelected(false);
        this.removeItem.setSelected(false);
        this.dilateItem.setSelected(false);
        this.copyItem.setSelected(false);
        this.updateROIEditState(3);
        this.magicWandRange.setText("Set Relative Value Range... (" + FORMATTER_NUMBER.format(this.mango.getMagicWandRange()) + ")");
    }

    public void updateAfterToolRangeChange() {
        if (!this.mango.isUsingSmartTools()) {
            this.setRangeItem.setText(ACTION_SET_EXPLICIT_VALUE_RANGE);
            this.setRangeItem2.setText(ACTION_SET_EXPLICIT_VALUE_RANGE);
            this.setRangeItem3.setText(ACTION_SET_EXPLICIT_VALUE_RANGE);
            this.magicWandRange.setText("Set Relative Value Range... (" + FORMATTER_NUMBER.format(this.mango.getMagicWandRange()) + ")");
            this.magicWandRange.setEnabled(true);
        } else {
            this.setRangeItem.setText("Set Explicit Value Range... (" + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMin()) + " to " + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMax()) + ")");
            this.setRangeItem2.setText("Set Explicit Value Range... (" + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMin()) + " to " + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMax()) + ")");
            this.setRangeItem3.setText("Set Explicit Value Range... (" + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMin()) + " to " + FORMATTER_NUMBER.format(this.mango.getSmartToolsRangeMax()) + ")");
            this.magicWandRange.setText("Set Relative Value Range...");
            this.magicWandRange.setEnabled(false);
        }
    }

    public void setVOIMode(boolean voiMode) {
        this.mango.recordAction("setMultisliceMode", new String[]{ScriptUtils.convertBoolean(voiMode)});
        this.voiMode = voiMode;
        this.voiButton.setIcon(MangoStyle.ICON_ROI_VOI.get(voiMode ? 1 : 0));
        this.closePopups();
        this.currentViewer.updateVOIMode();
    }

    public void updateAfterOverlayIndexChange() {
        this.updateOverlayPopupMenu();
        this.updateOverlayButtonIcons();
        this.updateOverlayButton();
        this.updateSlider();
        this.updateTextFieldState();
        this.currentViewer.clearOverlayData();
        this.currentViewer.updateViewer();
        this.currentViewer.reorderSurfaceOverlays();
        this.updateSurfaceTextures();
    }

    public void addAtlas(Atlas atlas) {
        this.allAtlases.add(atlas);
        Collections.sort(this.allAtlases, new AtlasComparator());
        if (this.isVisible()) {
            this.updateCoordinatePopupMenu();
        }
    }

    public void addLoader(ImageLoader il) {
        this.allLoaders.add(il);
    }

    @Override
    public void addMoreColors() {
        this.currentViewer.doAddMoreROIColors();
    }

    public void addTextFieldMaxText(String aChar) {
        if (this.textFieldMaxTouchedInitialized) {
            this.textFieldMax.setBackground(Color.WHITE);
            this.textFieldMax.setText(aChar);
            this.textFieldMax.setCaretPosition(this.textFieldMax.getText().length());
            this.textFieldMax.getCaret().setVisible(true);
            this.textFieldMaxTouchedInitialized = false;
        } else {
            String maxText = this.textFieldMax.getText();
            int pos = this.textFieldMax.getCaretPosition();
            int len = maxText.length();
            if (pos == 0) {
                this.textFieldMax.setText(aChar + maxText);
                this.textFieldMax.setCaretPosition(1);
            } else if (pos > 0 && pos < len) {
                this.textFieldMax.setText(maxText.substring(0, pos) + aChar + maxText.substring(pos));
                this.textFieldMax.setCaretPosition(pos + 1);
            } else if (pos == len) {
                this.textFieldMax.setText(maxText + aChar);
                this.textFieldMax.setCaretPosition(this.textFieldMax.getText().length());
            }
        }
    }

    public void addTextFieldMinText(String aChar) {
        if (this.textFieldMinTouchedInitialized) {
            this.textFieldMin.setBackground(Color.WHITE);
            this.textFieldMin.setText(aChar);
            this.textFieldMin.setCaretPosition(this.textFieldMin.getText().length());
            this.textFieldMin.getCaret().setVisible(true);
            this.textFieldMinTouchedInitialized = false;
        } else {
            String minText = this.textFieldMin.getText();
            int pos = this.textFieldMin.getCaretPosition();
            int len = minText.length();
            if (pos == 0) {
                this.textFieldMin.setText(aChar + minText);
                this.textFieldMin.setCaretPosition(1);
            } else if (pos > 0 && pos < len) {
                this.textFieldMin.setText(minText.substring(0, pos) + aChar + minText.substring(pos));
                this.textFieldMin.setCaretPosition(pos + 1);
            } else if (pos == len) {
                this.textFieldMin.setText(minText + aChar);
                this.textFieldMin.setCaretPosition(this.textFieldMin.getText().length());
            }
        }
    }

    public void associateWindow(ToolboxAssociated ta) {
        if (!this.associatedWindows.contains(ta)) {
            this.associatedWindows.add(ta);
            ta.getWindow().addWindowListener(this);
        }
    }

    public void deassociateWindow(ToolboxAssociated ta) {
        this.associatedWindows.remove(ta);
        ta.getWindow().removeWindowListener(this);
    }

    public void bringToFrontAllAssociatedWindows() {
        Enumeration<ToolboxAssociated> en = this.associatedWindows.elements();
        while (en.hasMoreElements()) {
            JFrame tempWindow = en.nextElement().getWindow();
            if (tempWindow == null) continue;
            tempWindow.setState(0);
            tempWindow.toFront();
        }
    }

    @Override
    public boolean canEnable(MangoTransparencySlider slider) {
        return true;
    }

    public void clearCurrentState() {
        this.clearCurrentState(true);
    }

    public void clickFunctionKey(int keyCode) {
        JMenuItem item = FUNCTION_KEY_MAP.get(keyCode);
        if (item != null) {
            item.doClick();
        }
    }

    @Override
    public void closeColorPickerPopup() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        }
    }

    public void closePopups() {
        this.popupROIEdit.setVisible(false);
        this.popupOverlay.setVisible(false);
        this.popupCoordinate.setVisible(false);
        this.closeColorPickerPopup();
    }

    public void colorSelected(int colorNum) {
        this.roiColorChosen(colorNum);
        this.closePopups();
    }

    public void createUI() {
        this.makeMenu();
        this.mainPanelSub.setLayout(new BoxLayout(this.mainPanelSub, 1));
        this.mainPanelSub.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.mainPanelSub.add(this.menu);
        this.mainPanelSub.add(Box.createVerticalStrut(2));
        this.mainPanelSub.add(this.makeCoordinatePanel());
        this.mainPanelSub.add(this.makeButtonPanel());
        this.mainPanelSub.add(this.makeSliderPanel());
        this.mainPanelSub.setBorder(BorderFactory.createEtchedBorder());
        this.initializeComponents();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.mainPanel.add(this.header);
        this.mainPanel.add(this.mainPanelSub);
        this.setEnabledItems(false, false);
        this.setLocation(DisplayUtils.getDefaultLocation());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setTitle("Mango");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setUndecorated(true);
        this.validate();
        this.pack();
        this.updateFocusState();
        this.updateTextFieldState();
        this.createMenuItemMap();
    }

    public boolean defaultSliderValuesUsed() {
        return this.slider.getValueAt(0) == 0 && this.slider.getValueAt(2) == 255;
    }

    public void deleteTextFieldMaxText() {
        if (this.textFieldMax.getText().length() > 0) {
            if (this.textFieldMaxTouchedInitialized) {
                this.textFieldMax.setText("");
                this.textFieldMax.setCaretPosition(0);
                this.textFieldMax.getCaret().setVisible(true);
                this.textFieldMax.setBackground(Color.WHITE);
            } else {
                String maxText = this.textFieldMax.getText();
                int pos = this.textFieldMax.getCaretPosition();
                int len = maxText.length();
                if (pos == 0 && len > 0) {
                    this.textFieldMax.setText(maxText.substring(1, maxText.length()));
                    this.textFieldMax.setCaretPosition(0);
                } else if (pos > 0 && pos < len) {
                    this.textFieldMax.setText(maxText.substring(0, pos - 1) + maxText.substring(pos));
                    this.textFieldMax.setCaretPosition(pos - 1);
                } else if (pos == len && len > 0) {
                    this.textFieldMax.setText(maxText.substring(0, maxText.length() - 1));
                    this.textFieldMax.setCaretPosition(this.textFieldMax.getText().length());
                }
            }
        }
    }

    public void deleteTextFieldMinText() {
        if (this.textFieldMin.getText().length() > 0) {
            if (this.textFieldMinTouchedInitialized) {
                this.textFieldMin.setText("");
                this.textFieldMin.setCaretPosition(0);
                this.textFieldMin.getCaret().setVisible(true);
                this.textFieldMin.setBackground(Color.WHITE);
            } else {
                String minText = this.textFieldMin.getText();
                int pos = this.textFieldMin.getCaretPosition();
                int len = minText.length();
                if (pos == 0 && len > 0) {
                    this.textFieldMin.setText(minText.substring(1, minText.length()));
                    this.textFieldMin.setCaretPosition(0);
                } else if (pos > 0 && pos < len) {
                    this.textFieldMin.setText(minText.substring(0, pos - 1) + minText.substring(pos));
                    this.textFieldMin.setCaretPosition(pos - 1);
                } else if (pos == len && len > 0) {
                    this.textFieldMin.setText(minText.substring(0, minText.length() - 1));
                    this.textFieldMin.setCaretPosition(this.textFieldMin.getText().length());
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.mango.isExiting()) {
            this.mango.exitProgram();
        }
    }

    public void forceDispose() {
        super.dispose();
    }

    public void disposeAssociatedWindows() {
        Enumeration<ToolboxAssociated> en = this.associatedWindows.elements();
        while (en.hasMoreElements()) {
            JFrame tempWindow = en.nextElement().getWindow();
            tempWindow.setVisible(false);
            tempWindow.dispose();
        }
        this.associatedWindows.removeAllElements();
    }

    public void doOverlayButtonChosen(int screenVolumeIndex) {
        this.currentViewer.recordAction("setCurrentVolumeIndex", new String[]{String.valueOf(screenVolumeIndex)});
        if (!this.currentViewer.isShowingCurrentOverlay() && !this.currentViewer.isShowingAllOverlay()) {
            this.currentViewer.setViewOptionShowCurrentOverlay(true);
        }
        if (this.currentViewer.isShowingCurrentOverlay()) {
            this.currentViewer.getOverlayManager().hideAll();
        }
        if (screenVolumeIndex > 0) {
            this.currentViewer.getOverlayManager().getOverlay(screenVolumeIndex - 1).setHidden(false);
        }
        if (screenVolumeIndex > 0) {
            this.currentViewer.setCurrentScreenVolume(this.currentViewer.getOverlayManager().getOverlay(screenVolumeIndex - 1));
        } else {
            this.currentViewer.setCurrentScreenVolume(this.currentViewer.getBaseScreenVolume());
        }
        this.updateOverlayPopupMenu();
        this.updateOverlayButton();
        this.updateSlider();
        this.updateTextFieldState();
        this.currentViewer.clearOverlayData();
        this.currentViewer.updateScreenSlices();
        this.currentViewer.updateWindowTitle();
        this.currentViewer.getCurrentScreenVolume().notifyListenersOfChange(true);
        this.updateSurfaceTextures();
    }

    @Override
    public void editColorLabels() {
        this.currentViewer.showROIStaticLabelDialog();
        this.closePopups();
    }

    public void formatAtlasLabels(String[] labels) {
        if (labels != null) {
            if (labels.length > 0) {
                this.labelsTD1.setText(this.validateLabel(labels[0], 0, this.currentAtlas.getMaxReturnedLabels()));
            }
            if (labels.length > 1) {
                this.labelsTD3.setText(this.validateLabel(labels[1], 1, this.currentAtlas.getMaxReturnedLabels()));
            }
            if (labels.length > 2) {
                this.labelsTD2.setText(this.validateLabel(labels[2], 2, this.currentAtlas.getMaxReturnedLabels()));
            }
            if (labels.length > 3) {
                this.labelsTD4.setText(this.validateLabel(labels[3], 3, this.currentAtlas.getMaxReturnedLabels()));
            }
        }
    }

    public void formatLabels(double xLoc, double yLoc, double zLoc) {
        this.mouseX.setText(FORMATTER_NUMBER.format(xLoc));
        this.mouseY.setText(FORMATTER_NUMBER.format(yLoc));
        this.mouseZ.setText(FORMATTER_NUMBER.format(zLoc));
        this.mouseValue.setText("");
    }

    public void formatLabels(double xLoc, double yLoc, double zLoc, double value) {
        this.mouseX.setText(FORMATTER_NUMBER.format(xLoc));
        this.mouseY.setText(FORMATTER_NUMBER.format(yLoc));
        this.mouseZ.setText(FORMATTER_NUMBER.format(zLoc));
        if (this.currentViewer != null) {
            if (!this.currentViewer.isRGB()) {
                this.mouseValue.setText(FORMATTER_VALUE.format(value));
            } else {
                this.mouseValue.setText("RGB");
            }
        } else {
            this.mouseValue.setText("");
        }
    }

    public Atlas[] getAllAtlases() {
        return this.allAtlases.toArray(new Atlas[this.allAtlases.size()]);
    }

    public Vector<ToolboxAssociated> getAssociatedWindows() {
        return this.associatedWindows;
    }

    public Atlas getAtlas(String name) {
        Enumeration<Atlas> en = this.allAtlases.elements();
        while (en.hasMoreElements()) {
            Atlas atlas = en.nextElement();
            if (!name.equals(PluginManagerDialog.getPluginName(atlas))) continue;
            if (!this.loadedAtlases.contains(atlas)) {
                atlas.loadAtlas(Platform.getTempDir());
                this.loadedAtlases.add(atlas);
            }
            return atlas;
        }
        return null;
    }

    public String getAtlasName() {
        if (this.currentAtlas == null) {
            return NO_ATLAS_NAME;
        }
        return PluginManagerDialog.getPluginName(this.currentAtlas);
    }

    public ImageIcon getBaseImageIcon() {
        return new ImageIcon(this.baseImageFiltered);
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public Atlas getCurrentAtlas() {
        return this.currentAtlas;
    }

    public SliceViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public float getDynamicScreenMaxOf(ScreenVolume sv) {
        if (this.global && sv.isBaseImage()) {
            return (float)((double)sv.getLookupTableManager().getMaxLUT() / (255.0 / (this.globalScreenMax - this.globalScreenMin)) + this.globalScreenMin);
        }
        return (float)((double)sv.getLookupTableManager().getMaxLUT() / (255.0 / (sv.getScreenMax() - sv.getScreenMin())) + sv.getScreenMin());
    }

    public float getDynamicScreenMinOf(ScreenVolume sv) {
        if (this.global && sv.isBaseImage()) {
            return (float)((double)sv.getLookupTableManager().getMinLUT() / (255.0 / (this.globalScreenMax - this.globalScreenMin)) + this.globalScreenMin);
        }
        return (float)((double)sv.getLookupTableManager().getMinLUT() / (255.0 / (sv.getScreenMax() - sv.getScreenMin())) + sv.getScreenMin());
    }

    public double getGlobalScreenMax() {
        return this.globalScreenMax;
    }

    public double getGlobalScreenMin() {
        return this.globalScreenMin;
    }

    public double getGlobalScreenRatio() {
        return this.globalScreenRatio;
    }

    public Vector<ImageLoader> getLoaders() {
        return this.allLoaders;
    }

    public int getMaximumColors() {
        if (this.currentViewer != null && this.currentViewer.getROIManager() != null) {
            return this.currentViewer.getROIManager().getMaximumColors();
        }
        return -1;
    }

    public Point getNextAssociatedWindowLocation(Window nextWindow) {
        int rightMost = this.getLocation().x;
        int southMost = this.getLocation().y;
        if (this.associatedWindows.size() - 1 == 0) {
            return new Point(rightMost, southMost + this.getSize().height + 20);
        }
        Enumeration<ToolboxAssociated> en = this.associatedWindows.elements();
        while (en.hasMoreElements()) {
            JFrame tempWindow = en.nextElement().getWindow();
            Point loc = tempWindow.getLocation();
            if (loc.x > rightMost) {
                rightMost = loc.x;
            }
            if (loc.y <= southMost) continue;
            southMost = loc.y;
        }
        Point nextLoc = new Point(rightMost + 12, southMost + 12);
        Dimension nextDim = nextWindow.getSize();
        if (!DisplayUtils.isValidLocation(new Point(nextLoc.x + nextDim.width, nextLoc.y + nextDim.height))) {
            nextLoc = DisplayUtils.getCenterDialogLocation(this, nextDim);
        }
        return nextLoc;
    }

    public ImageIcon[] getOverlayImageIcons() {
        ScreenVolume[] allOverlays = this.currentViewer.getOverlayManager().getAllOverlays();
        ImageIcon[] overlayIconsCopy = new ImageIcon[allOverlays.length];
        for (int ctr = 0; ctr < allOverlays.length; ++ctr) {
            overlayIconsCopy[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        return overlayIconsCopy;
    }

    public Color getPopupMenuItemColor() {
        return POPUP_MENU_ITEM_COLOR;
    }

    public JPopupMenu getPopupOverlay() {
        return this.popupOverlay;
    }

    @Override
    public Color getProgressBarBackgroundColor() {
        return MangoStyle.COLOR_BACKGROUND;
    }

    @Override
    public Dimension getProgressBarDimensions() {
        return PROGRESS_BAR_DIMENSIONS;
    }

    public JPanel getProgressBarPanel() {
        return this.progressBarPanel;
    }

    public int getROIEditMode() {
        return this.roiEditMode;
    }

    public double getScreenMax() {
        if (this.global) {
            return this.globalScreenMax;
        }
        return this.currentViewer.getCurrentScreenVolume().getScreenMax();
    }

    public float getScreenMaxOf(ScreenVolume sv) {
        if (this.global && sv.isBaseImage()) {
            return (float)this.globalScreenMax;
        }
        return (float)sv.getScreenMax();
    }

    public double getScreenMin() {
        if (this.global) {
            return this.globalScreenMin;
        }
        return this.currentViewer.getCurrentScreenVolume().getScreenMin();
    }

    public float getScreenMinOf(ScreenVolume sv) {
        if (this.global && sv.isBaseImage()) {
            return (float)this.globalScreenMin;
        }
        return (float)sv.getScreenMin();
    }

    public float getTextFieldMaxValue() {
        String text = this.textFieldMax.getText();
        float max = 0.0f;
        try {
            max = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return max;
    }

    public float getTextFieldMinValue() {
        String text = this.textFieldMin.getText();
        float min = 0.0f;
        try {
            min = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return min;
    }

    @Override
    public void headerPanelClicked() {
        if (this.currentViewer != null) {
            this.currentViewer.frameToFront();
            this.toFront();
        }
    }

    @Override
    public void headerPanelDoubleClicked() {
    }

    @Override
    public void headerPanelShiftClicked() {
    }

    public void initializeComponents() {
        this.makeLabelsPanel();
        this.updateMouseLabelOutOfBounds(true);
        this.createOverlayButtons();
        this.makeROIEditPopupMenu();
        this.makeOverlayPopupMenu();
        this.makeCoordinatePopupMenu();
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isOverlayGroup() {
        return this.overlayGroup;
    }

    public boolean isProgressBarShowing() {
        return this.progressBarsShowing > 0;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isSelected(int color) {
        if (this.currentViewer != null) {
            return this.currentViewer.getROIManager().isSelected(color);
        }
        return false;
    }

    public boolean isShowingLabels() {
        return this.tdLabelPanelAdded;
    }

    public boolean isTextFieldMaxTouched() {
        return this.textFieldMaxTouched;
    }

    public boolean isTextFieldMinTouched() {
        return this.textFieldMinTouched;
    }

    public boolean isUsed(int color) {
        if (this.currentViewer != null) {
            return this.currentViewer.getROIManager().isUsed(color);
        }
        return false;
    }

    public boolean isUsingFixedTimeseriesRange() {
        return this.fixedRange;
    }

    public boolean isVOIMode() {
        return this.voiMode;
    }

    public boolean isWorldMode() {
        return (this.coordinateType & 4) != 0;
    }

    public JPanel makeButtonPanel() {
        this.coordinatesButton = new MangoSquareButton(MangoStyle.ICON_COORDINATES.get(0), this.mango);
        this.coordinatesButton.setActionCommand("coordinatesButtonToggle");
        this.coordinatesButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.coordinatesButton.setFocusable(false);
        this.coordinatesButton.addActionListener(this);
        this.coordinatesButton.setEnabled(true);
        this.coordinatesButton.setPreferredSize(BUTTON_SIZE);
        this.coordinatesButton.setMaximumSize(BUTTON_SIZE);
        this.coordinatesButton.setMinimumSize(BUTTON_SIZE);
        this.roiButton = new MangoColorButton(0, (ColorManager)this, this.mango);
        this.roiButton.setActionCommand("roiButtonToggle");
        this.roiButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.roiButton.setFocusable(false);
        this.roiButton.addActionListener(this);
        this.roiButton.setEnabled(true);
        this.roiButton.setPreferredSize(BUTTON_SIZE);
        this.roiButton.setMaximumSize(BUTTON_SIZE);
        this.roiButton.setMinimumSize(BUTTON_SIZE);
        this.roiEditButton = new MangoSquareButton(MangoStyle.ICON_EDIT_ROI.get(0), this.mango);
        this.roiEditButton.setActionCommand("roiEditButtonToggle");
        this.roiEditButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.roiEditButton.setFocusable(false);
        this.roiEditButton.addActionListener(this);
        this.roiEditButton.setEnabled(true);
        this.roiEditButton.setPreferredSize(BUTTON_SIZE);
        this.roiEditButton.setMaximumSize(BUTTON_SIZE);
        this.roiEditButton.setMinimumSize(BUTTON_SIZE);
        this.overlayButton = new MangoSquareButton(null, this.mango);
        this.overlayButton.setActionCommand("overlayButtonToggle");
        this.overlayButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.overlayButton.setFocusable(false);
        this.overlayButton.addActionListener(this);
        this.overlayButton.setEnabled(true);
        this.overlayButton.setPreferredSize(BUTTON_SIZE);
        this.overlayButton.setMaximumSize(BUTTON_SIZE);
        this.overlayButton.setMinimumSize(BUTTON_SIZE);
        this.voiButton = new MangoSquareButton(MangoStyle.ICON_ROI_VOI.get(1), this.mango);
        this.voiButton.setActionCommand("voiButtonToggle");
        this.voiButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.voiButton.setFocusable(false);
        this.voiButton.addActionListener(this);
        this.voiButton.setEnabled(true);
        this.voiButton.setPreferredSize(BUTTON_SIZE);
        this.voiButton.setMaximumSize(BUTTON_SIZE);
        this.voiButton.setMinimumSize(BUTTON_SIZE);
        this.transformButton = new MangoSquareButton(MangoStyle.ICON_TRANSFORM.get(0), this.mango);
        this.transformButton.setActionCommand("transformButtonToggle");
        this.transformButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.transformButton.setFocusable(false);
        this.transformButton.addActionListener(this);
        this.transformButton.setEnabled(true);
        this.transformButton.setPreferredSize(BUTTON_SIZE);
        this.transformButton.setMaximumSize(BUTTON_SIZE);
        this.transformButton.setMinimumSize(BUTTON_SIZE);
        this.cameraButton = new MangoSquareButton(MangoStyle.ICON_CAMERA.get(0), false, this.mango);
        this.cameraButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        this.cameraButton.setActionCommand("cameraButton");
        this.cameraButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.cameraButton.setFocusable(false);
        this.cameraButton.addActionListener(this);
        this.cameraButton.setEnabled(true);
        this.cameraButton.setPreferredSize(BUTTON_SIZE);
        this.cameraButton.setMaximumSize(BUTTON_SIZE);
        this.cameraButton.setMinimumSize(BUTTON_SIZE);
        this.cameraButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                Toolbox.this.setSelectionMode(0);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        if (!this.mango.isApplet()) {
            buttonPanel.setPreferredSize(START_SIZE_TOOLBAR_BUTTONS);
        }
        buttonPanel.add(this.overlayButton);
        buttonPanel.add(this.transformButton);
        buttonPanel.add(this.coordinatesButton);
        buttonPanel.add(this.voiButton);
        buttonPanel.add(this.roiButton);
        buttonPanel.add(this.roiEditButton);
        if (!this.mango.isApplet()) {
            buttonPanel.add(this.cameraButton);
        }
        buttonPanel.setBackground(Color.WHITE);
        return buttonPanel;
    }

    public JPanel makeCoordinatePanel() {
        SpringLayout spl = new SpringLayout();
        JPanel coordinatePanel = new JPanel(new GridLayout(1, 1));
        coordinatePanel.setPreferredSize(START_SIZE_TOOLBAR_TOP);
        coordinatePanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        coordinatePanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        JPanel coordinatePanelInner = new JPanel();
        coordinatePanelInner.setBackground(Color.BLACK);
        coordinatePanelInner.setLayout(spl);
        coordinatePanel.add(coordinatePanelInner);
        int topPanelWidth = (int)coordinatePanel.getPreferredSize().getWidth();
        int topPanelHeight = (int)coordinatePanel.getPreferredSize().getHeight();
        this.mouseX = new JLabel();
        this.mouseX.setFont(new Font("SansSerif", 1, 12));
        this.mouseY = new JLabel();
        this.mouseY.setFont(new Font("SansSerif", 1, 12));
        this.mouseZ = new JLabel();
        this.mouseZ.setFont(new Font("SansSerif", 1, 12));
        this.mouseValue = new JLabel();
        this.mouseValue.setForeground(Color.WHITE);
        this.mouseValue.setFont(new Font("SansSerif", 1, 12));
        this.mouseValue.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.updateCoordinateType(this.mango.isToolboxCoordinateCurrentSlice());
        JLabel xLabelRight = new JLabel("x");
        JLabel yLabelRight = new JLabel("y");
        JLabel zLabelRight = new JLabel("z");
        JLabel vLabelRight = new JLabel("   ");
        xLabelRight.setForeground(Color.LIGHT_GRAY);
        yLabelRight.setForeground(Color.LIGHT_GRAY);
        zLabelRight.setForeground(Color.LIGHT_GRAY);
        vLabelRight.setForeground(Color.LIGHT_GRAY);
        JPanel mousePanelX = new JPanel(new GridLayout(2, 1));
        mousePanelX.add(xLabelRight);
        mousePanelX.add(this.mouseX);
        mousePanelX.setBackground(Color.BLACK);
        mousePanelX.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 0));
        JPanel mousePanelY = new JPanel(new GridLayout(2, 1));
        mousePanelY.add(yLabelRight);
        mousePanelY.add(this.mouseY);
        mousePanelY.setBackground(Color.BLACK);
        mousePanelY.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 0));
        JPanel mousePanelZ = new JPanel(new GridLayout(2, 1));
        mousePanelZ.add(zLabelRight);
        mousePanelZ.add(this.mouseZ);
        mousePanelZ.setBackground(Color.BLACK);
        mousePanelZ.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 0));
        JPanel mousePanel = new JPanel(new GridLayout(1, 3));
        mousePanel.add(mousePanelX);
        mousePanel.add(mousePanelY);
        mousePanel.add(mousePanelZ);
        coordinatePanelInner.add(mousePanel);
        SpringLayout.Constraints mouseConstraints = spl.getConstraints(mousePanel);
        mouseConstraints.setX(Spring.constant(0));
        mouseConstraints.setY(Spring.constant(0));
        mouseConstraints.setWidth(Spring.constant(3 * topPanelWidth / 5));
        coordinatePanelInner.add(this.mouseValue);
        SpringLayout.Constraints mouseVConstraints = spl.getConstraints(this.mouseValue);
        mouseVConstraints.setX(Spring.constant(topPanelWidth / 5 * 3));
        mouseVConstraints.setY(Spring.constant((int)((double)topPanelHeight / 3.5)));
        mouseVConstraints.setWidth(Spring.constant(topPanelWidth * 2 / 5));
        this.coordinatePanel = coordinatePanel;
        return coordinatePanel;
    }

    public JPanel makeLabelsPanel() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new BorderLayout());
            this.labelsPanel.setPreferredSize(START_SIZE_TOOLBAR_TOP);
            this.labelsPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
            this.labelsPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 2, 4));
            this.labelsTD1 = new JLabel("");
            this.labelsTD1.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD1.setFont(new Font("SansSerif", 1, 11));
            this.labelsTD1.setBackground(Color.BLUE);
            this.labelsTD2 = new JLabel("");
            this.labelsTD2.setForeground(Color.WHITE);
            this.labelsTD2.setFont(new Font("SansSerif", 1, 11));
            this.labelsTD3 = new JLabel("");
            this.labelsTD3.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD3.setFont(new Font("SansSerif", 1, 11));
            this.labelsTD4 = new JLabel("");
            this.labelsTD4.setForeground(Color.WHITE);
            this.labelsTD4.setFont(new Font("SansSerif", 1, 11));
        }
        return this.labelsPanel;
    }

    public JPanel makeSliderPanel() {
        this.sliderImage = new BufferedImage(128, 10, 2);
        this.sliderImageFiltered = new BufferedImage(128, 10, 2);
        this.sliderImageData = ((DataBufferInt)this.sliderImage.getRaster().getDataBuffer()).getData();
        this.lutManagerDefault = LookupTableManager.createLookupTableManager(0, true);
        this.lutManagerDefault.initLUT();
        this.initializeSliderImage();
        this.lutManagerDefault.updateLUT();
        this.updateSliderImage();
        this.slider = new MThumbSlider(3, new int[]{0, 0, 0}, new int[]{255, 255, 255}, new int[]{0, 127, 255}, this);
        this.slider.setFocusable(false);
        this.slider.setUI(new BasicMThumbSliderUI(this.sliderImageFiltered));
        this.slider.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (Toolbox.this.currentViewer != null) {
                    Toolbox.this.updateOverlayButtonIcons();
                    Toolbox.this.updateOverlayButton();
                    if (Toolbox.this.currentViewer != null) {
                        if (Toolbox.this.global) {
                            if (Toolbox.this.currentViewer.getCurrentScreenVolume() == Toolbox.this.currentViewer.getBaseScreenVolume()) {
                                Toolbox.this.mango.notifyBaseImageOverlayListeners();
                            } else if (Toolbox.this.overlayGroup) {
                                Toolbox.this.mango.notifyOverlayImageOverlayListeners();
                            }
                        } else if (Toolbox.this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                            Toolbox.this.currentViewer.getBaseScreenVolume().notifyListenersOfChange(false);
                        } else if (Toolbox.this.overlayGroup) {
                            Toolbox.this.currentViewer.notifyOverlayListenersOfChange();
                        } else {
                            Toolbox.this.currentViewer.getCurrentScreenVolume().notifyListenersOfChange(false);
                        }
                    }
                    Toolbox.this.updateSurfaceTextures();
                }
            }
        });
        this.textFieldMin = new JTextField(4);
        this.textFieldMin.setFont(MENU_FONT);
        this.textFieldMin.setFocusable(false);
        this.textFieldMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.textFieldMinTouched();
            }
        });
        this.textFieldMax = new JTextField(4);
        this.textFieldMax.setFont(MENU_FONT);
        this.textFieldMax.setFocusable(false);
        this.textFieldMax.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.textFieldMaxTouched();
            }
        });
        JPanel textFieldMinPanel = new JPanel();
        textFieldMinPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        textFieldMinPanel.add((Component)this.textFieldMin, "Center");
        textFieldMinPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        JPanel textFieldMaxPanel = new JPanel();
        textFieldMaxPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        textFieldMaxPanel.add((Component)this.textFieldMax, "Center");
        textFieldMaxPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.slider.setPreferredSize(new Dimension(135, 30));
        this.slider.setBackground(MangoStyle.COLOR_BACKGROUND);
        JPanel firstCard = new JPanel(new BorderLayout());
        firstCard.add((Component)textFieldMinPanel, "West");
        firstCard.add((Component)this.slider, "Center");
        firstCard.add((Component)textFieldMaxPanel, "East");
        this.progressBarPanel = new JPanel();
        this.progressBarPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        JPanel continuePanel = this.makeContinuePanel();
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.cardPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.cardPanel.setPreferredSize(START_SIZE_TOOLBAR_SLIDER);
        this.cardLayout.addLayoutComponent(firstCard, CARD_ORIGINAL);
        this.cardLayout.addLayoutComponent(this.progressBarPanel, CARD_PROGRESS);
        this.cardLayout.addLayoutComponent(continuePanel, CARD_CONTINUE);
        this.cardPanel.add((Component)firstCard, CARD_ORIGINAL);
        this.cardPanel.add((Component)this.progressBarPanel, CARD_PROGRESS);
        this.cardPanel.add((Component)continuePanel, CARD_CONTINUE);
        return this.cardPanel;
    }

    @Override
    public void menuCanceled(MenuEvent me) {
    }

    @Override
    public void menuDeselected(MenuEvent me) {
    }

    @Override
    public void menuSelected(MenuEvent me) {
        this.updateMenu();
    }

    public void minimizeAllAssociatedWindows() {
        Enumeration<ToolboxAssociated> en = this.associatedWindows.elements();
        while (en.hasMoreElements()) {
            JFrame tempWindow = en.nextElement().getWindow();
            if (tempWindow == null) continue;
            tempWindow.setState(1);
        }
    }

    public void moveTextFieldMaxCursor(boolean left) {
        int pos = this.textFieldMax.getCaretPosition();
        int len = this.textFieldMax.getText().length();
        if (this.textFieldMaxTouchedInitialized) {
            this.textFieldMax.getCaret().setVisible(true);
            this.textFieldMax.setBackground(Color.WHITE);
            if (left) {
                this.textFieldMax.setCaretPosition(0);
            } else {
                this.textFieldMax.setCaretPosition(this.textFieldMax.getText().length());
            }
            this.textFieldMaxTouchedInitialized = false;
        } else if (left && pos > 0) {
            this.textFieldMax.setCaretPosition(pos - 1);
        } else if (!left && pos < len) {
            this.textFieldMax.setCaretPosition(pos + 1);
        }
    }

    public void moveTextFieldMinCursor(boolean left) {
        int pos = this.textFieldMin.getCaretPosition();
        int len = this.textFieldMin.getText().length();
        if (this.textFieldMinTouchedInitialized) {
            this.textFieldMin.getCaret().setVisible(true);
            this.textFieldMin.setBackground(Color.WHITE);
            if (left) {
                this.textFieldMin.setCaretPosition(0);
            } else {
                this.textFieldMin.setCaretPosition(this.textFieldMin.getText().length());
            }
            this.textFieldMinTouchedInitialized = false;
        } else if (left && pos > 0) {
            this.textFieldMin.setCaretPosition(pos - 1);
        } else if (!left && pos < len) {
            this.textFieldMin.setCaretPosition(pos + 1);
        }
    }

    public void pauseScriptThread() {
        if (!this.scriptPaused) {
            this.scriptPaused = true;
            this.updateBottomPanel();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popupROIEdit) {
            this.popupROIEditTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupOverlay) {
            this.popupOverlayTimeCanceled = new Date().getTime();
        } else if (pme.getSource() == this.popupCoordinate) {
            this.popupCoordinateTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        if (pme.getSource() == this.popupOverlay) {
            this.updateOverlayButtonIcons();
            this.updateOverlayButton();
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    @Override
    public void progressBarFinished(ProgressBar pb) {
        this.doProgressBarFinished(pb);
    }

    @Override
    public void progressBarFinished(edu.uthscsa.ric.mango.components.progressbar.ProgressBar progressBar) {
        this.doProgressBarFinished(progressBar);
    }

    @Override
    public void progressBarStarted(ProgressBar pb) {
        this.doProgressBarStarted(pb);
    }

    @Override
    public void progressBarStarted(edu.uthscsa.ric.mango.components.progressbar.ProgressBar progressBar) {
        this.doProgressBarStarted(progressBar);
    }

    public void reconcileTransformButton() {
        if (this.currentViewer != null && this.currentViewer.getBaseScreenVolume() != null) {
            if (this.currentViewer.getBaseScreenVolume().isUsingTransform()) {
                this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(1));
            } else {
                this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(0));
            }
        }
    }

    @Override
    public void resetSliderValues() {
        this.resetSliderValues(null, true);
    }

    public void setAlpha(ScreenVolume screenVol, double alpha) {
        screenVol.setAlpha(alpha);
        this.updateLUTInfo();
        this.updateSurfaceTextures();
        screenVol.notifyListenersOfChange(false);
    }

    public void setAtlas(Atlas atlas) {
        this.currentAtlas = atlas;
        String currentAtlasName = null;
        if (this.currentAtlas != null) {
            if (!this.loadedAtlases.contains(atlas)) {
                atlas.loadAtlas(Platform.getTempDir());
                this.loadedAtlases.add(atlas);
            }
            this.updateLabelsPanel(this.currentAtlas.getMaxReturnedLabels());
            this.updateCoordinate(12);
            currentAtlasName = PluginManagerDialog.getPluginName(atlas);
        } else {
            this.updateCoordinate(this.coordinateType & 0xFFFFFFF7);
            currentAtlasName = NO_ATLAS_NAME;
        }
        if (!this.applet) {
            MangoSquareMenu atlasMenu = this.worldOption;
            int itemCount = atlasMenu.getItemCount();
            for (int ctr = 0; ctr < itemCount; ++ctr) {
                JMenuItem mi = atlasMenu.getItem(ctr);
                mi.setSelected(mi.getText().startsWith(currentAtlasName));
            }
        }
    }

    public void setAtlasByName(String name) {
        this.mango.recordAction("setAtlas", new String[]{ScriptUtils.convertString(name)});
        Atlas atlas = null;
        if (name != null && !name.equals(NO_ATLAS_NAME)) {
            Enumeration<Atlas> en = this.allAtlases.elements();
            while (en.hasMoreElements()) {
                Atlas aAtlas = en.nextElement();
                if (!name.equals(PluginManagerDialog.getPluginName(aAtlas))) continue;
                atlas = aAtlas;
                break;
            }
        }
        this.setAtlas(atlas);
    }

    public void setCurrentViewer(SliceViewer viewer) {
        this.currentViewer = viewer;
        if (this.currentViewer != null) {
            this.closePopups();
            if (viewer.getBaseScreenVolume() != null) {
                if (this.currentViewer.getBaseScreenVolume().isUsingTransform()) {
                    this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(1));
                } else {
                    this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(0));
                }
            }
            this.updateOverlayButtonIcons();
            this.updateOverlayButton();
            this.updateTransformPopupMenu();
            this.updateBottomPanel();
            this.updateMangoColorButton();
            this.updateSlider();
            this.updateFocusState();
            this.updateTextFieldState();
            this.textFieldMaxTouched = false;
            this.textFieldMinTouched = false;
            this.textFieldMaxTouchedInitialized = false;
            this.textFieldMinTouchedInitialized = false;
            this.textFieldMin.setBackground(Color.WHITE);
            this.textFieldMax.setBackground(Color.WHITE);
            this.textFieldMin.getCaret().setVisible(false);
            this.textFieldMax.getCaret().setVisible(false);
            if (this.makeTextFieldMinActive) {
                this.makeTextFieldMaxActive = false;
                this.makeTextFieldMinActive = false;
                this.textFieldMinTouched();
            }
            if (this.makeTextFieldMaxActive) {
                this.makeTextFieldMaxActive = false;
                this.makeTextFieldMinActive = false;
                this.textFieldMaxTouched();
            }
        }
    }

    public void setEnabledItems(boolean bool, boolean isSliceViewer) {
        boolean hasCurrentViewer = this.currentViewer != null && !this.currentViewer.isClosing() && this.currentViewer.getCurrentScreenVolume() != null;
        this.coordinatesButton.setEnabled(bool && hasCurrentViewer && !this.currentViewer.isRGB());
        this.roiButton.setEnabled(bool && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.cameraButton.setEnabled(bool);
        this.continueButton.setEnabled(bool);
        this.roiEditButton.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.overlayButton.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.voiButton.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.transformButton.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.textFieldMin.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.textFieldMax.setEnabled(bool && isSliceViewer && hasCurrentViewer && !this.currentViewer.getCurrentVolume().isRGB());
        this.textFieldMin.setVisible(!hasCurrentViewer || !this.currentViewer.getCurrentVolume().isRGB());
        this.textFieldMax.setVisible(!hasCurrentViewer || !this.currentViewer.getCurrentVolume().isRGB());
        if (hasCurrentViewer && this.currentViewer.getCurrentScreenVolume().isLogical()) {
            this.slider.setEnabled(false, false);
        } else {
            this.slider.setEnabled(bool && isSliceViewer, true);
        }
    }

    public void setGlobalScreenRatio(double globalScreenRatio) {
        this.globalScreenRatio = globalScreenRatio;
    }

    public void setImageBrowserItem(boolean visible) {
        if (visible) {
            this.filePreviewFolder.setText("Hide Image Browser");
        } else {
            this.filePreviewFolder.setText("Show Image Browser");
        }
    }

    public void setLUT(String lutName) {
        this.currentViewer.recordAction("setVolumeDisplayColorTable", new String[]{this.currentViewer.getScriptObjectName() + ".currentVolume", ScriptUtils.convertString(lutName)});
        if (lutName.equals(ACTION_LOGICAL)) {
            this.currentViewer.showLogicalManager(false);
            return;
        }
        boolean isOldLogical = this.currentViewer.getCurrentScreenVolume().isLogical();
        String selectedLUT = lutName;
        this.currentViewer.getCurrentScreenVolume().getLookupTableManager().replaceKnots(LookupTableManager.getLUTKnots(selectedLUT));
        this.currentViewer.getCurrentScreenVolume().getLookupTableManager().setName(selectedLUT);
        this.currentViewer.getCurrentScreenVolume().getLookupTableManager().setExpression(LookupTableManager.getLUTExpression(selectedLUT));
        this.updateOverlayPopupMenu();
        this.updateLUTInfo();
        this.currentViewer.getCurrentScreenVolume().getLookupTableManager().updateLUT();
        this.currentViewer.updateScreenSlices();
        if (this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
            this.currentViewer.updateSurfaceColor(this.currentViewer.getCurrentScreenVolume().getLookupTableManager().getMinimumColor(), this.currentViewer.getCurrentScreenVolume().getLookupTableManager().getMaximumColor());
        }
        if (isOldLogical && lutName.indexOf(ACTION_LOGICAL) == -1) {
            this.currentViewer.getCurrentScreenVolume().setLogical(false);
            this.currentViewer.getLogicalManager().overlayRemoved(this.currentViewer.getCurrentScreenVolume());
        }
        if (!isOldLogical && this.currentViewer.getCurrentScreenVolume().isLogical()) {
            this.currentViewer.getCurrentScreenVolume().setAlpha(1.0);
            this.resetSliderValues(false);
            this.slider.setEnabled(false, false);
        } else if (isOldLogical && !this.currentViewer.getCurrentScreenVolume().isLogical()) {
            this.slider.setEnabled(true, true);
        }
        if (this.currentViewer.getLogicalManager() != null) {
            this.currentViewer.getLogicalManager().updateLogicals();
        }
        this.updateSliderImage();
        this.slider.repaint();
        this.updateSlider();
        this.updateTextFieldState();
        this.updateOverlayButtonIcons();
        this.updateOverlayButton();
        this.currentViewer.getCurrentScreenVolume().notifyListenersOfChange(false);
        this.updateSurfaceTextures();
    }

    public void setMouseLabelInfoIncrement(int sliceType, int difference) {
        if (sliceType == this.mousePlane) {
            if (sliceType == 0) {
                this.zLoc += difference;
            } else if (sliceType == 1) {
                this.yLoc += difference;
            } else if (sliceType == 2) {
                this.xLoc += difference;
            }
            this.updateCoordinateDisplay();
        } else if (sliceType == 3) {
            this.updateCoordinateDisplay();
        }
    }

    public void setROIEditMode(int val) {
        int oldMode = this.roiEditMode;
        if (val == 0) {
            this.roiEditMode = val;
        } else if (val >= 1 && val <= 6) {
            this.roiEditMode = this.roiPaintMode = val;
            this.ellipseItem.setSelected(val >= 1 && val <= 3);
            this.rectangleItem.setSelected(val >= 4 && val <= 6);
            this.editItem.setSelected(val == 1 || val == 4);
            this.eraseItem.setSelected(val == 2 || val == 5);
            this.paintItem.setSelected(val == 3 || val == 6);
            this.roiSubMenuPaint.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiPaintMode));
        } else if (val >= 7 && val <= 11) {
            this.roiEditMode = this.roiTraceMode = val;
            this.rectangleDrawItem.setSelected(val == 7);
            this.ellipseDrawItem.setSelected(val == 8);
            this.drawItem.setSelected(val == 9);
            this.lineItem.setSelected(val == 10);
            this.pointItem.setSelected(val == 11);
            this.roiSubMenuTrace.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiTraceMode));
        } else if (val >= 12 && val <= 17) {
            this.roiEditMode = this.roiMagicMode = val;
            this.addItem.setSelected(val == 12);
            this.preserveItem.setSelected(val == 13);
            this.removeItem.setSelected(val == 14);
            this.dilateItem.setSelected(val == 15);
            this.copyItem.setSelected(val == 17);
            this.roiSubMenuMagic.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiMagicMode));
        }
        this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiEditMode));
        if (oldMode != this.roiEditMode) {
            this.mango.clearActivePolylines();
            this.mango.setRecentTool(this.roiEditMode);
        }
        this.popupROIEdit.setVisible(false);
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
        if (mode == 4) {
            this.roiEditButton.setIcon(MangoStyle.ICON_NAV_CONTROLS.get(4));
        } else if (mode == 1) {
            this.roiEditButton.setIcon(MangoStyle.ICON_NAV_CONTROLS.get(1));
        } else if (mode == 2) {
            this.roiEditButton.setIcon(MangoStyle.ICON_NAV_CONTROLS.get(2));
        } else if (mode == 3) {
            this.roiEditButton.setIcon(MangoStyle.ICON_NAV_CONTROLS.get(3));
        } else {
            this.setROIEditMode(this.getROIEditMode());
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setShowLabels(boolean bool) {
        if (this.tdLabelPanelAdded != bool) {
            this.updateTDPanel();
        }
    }

    @Override
    public void setVisible(boolean bool) {
        this.closePopups();
        super.setVisible(bool);
    }

    public void showROIColorPicker() {
        this.closePopups();
        MangoColorPicker mcp = new MangoColorPicker((ColorManager)this.currentViewer.getROIManager(), this, this, this.currentViewer.getROIManager(), this.currentViewer.getROIManager().getBuffer().getMaximumColors());
        this.popupROI = PopupFactory.getSharedInstance().getPopup(this.roiButton, mcp, this.roiButton.getLocationOnScreen().x, this.roiButton.getLocationOnScreen().y + 35);
        this.popupROI.show();
    }

    @Override
    public void sliderChanged(MangoTransparencySlider slider) {
        ScreenVolume screenVol = slider.getScreenVolume();
        slider.repaint();
        screenVol.setAlpha((double)(100 - slider.getValue()) / 100.0);
        this.updateLUTInfo();
    }

    @Override
    public void sliderControlReleased(MangoTransparencySlider slider) {
        ScreenVolume screenVol = slider.getScreenVolume();
        JMenu menu = slider.getMenu();
        int index = -1;
        index = screenVol == this.currentViewer.getBaseScreenVolume() ? 0 : this.currentViewer.getOverlayManager().getIndex(screenVol) + 1;
        this.currentViewer.recordAction("setVolumeDisplayAlpha", new String[]{this.currentViewer.getScriptObjectName() + TEXT_GET_VOLUME + index + ")", String.valueOf(screenVol.getAlpha())});
        this.updateSurfaceTextures();
        screenVol.notifyListenersOfChange(false);
        menu.setPopupMenuVisible(false);
        this.getPopupOverlay().setVisible(false);
    }

    public void takePicture() {
        this.cameraButton.doClick();
    }

    public void textFieldMaxTouched() {
        if (this.currentViewer != null) {
            if (!this.currentViewer.isFrameActive() && !this.makeTextFieldMaxActive) {
                this.makeTextFieldMaxActive = true;
                this.currentViewer.frameToFront();
            }
            if (this.textFieldMaxTouchedInitialized) {
                this.textFieldMax.setBackground(Color.WHITE);
                this.textFieldMax.setCaretPosition(this.textFieldMax.getText().length());
                this.textFieldMax.getCaret().setVisible(true);
                this.textFieldMaxTouchedInitialized = false;
            } else {
                this.textFieldMax.setBackground(SELECTION_COLOR);
                this.textFieldMaxTouchedInitialized = true;
                this.textFieldMaxTouched = true;
                this.textFieldMax.getCaret().setVisible(false);
                this.textFieldMin.setBackground(Color.WHITE);
                this.textFieldMinTouchedInitialized = false;
                this.textFieldMinTouched = false;
                this.textFieldMin.getCaret().setVisible(false);
            }
        }
    }

    public void textFieldMinTouched() {
        if (this.currentViewer != null) {
            if (!this.currentViewer.isFrameActive() && !this.makeTextFieldMinActive) {
                this.makeTextFieldMinActive = true;
                this.currentViewer.frameToFront();
            }
            if (this.textFieldMinTouchedInitialized) {
                this.textFieldMin.setBackground(Color.WHITE);
                this.textFieldMin.setCaretPosition(this.textFieldMin.getText().length());
                this.textFieldMin.getCaret().setVisible(true);
                this.textFieldMinTouchedInitialized = false;
            } else {
                this.textFieldMin.setBackground(SELECTION_COLOR);
                this.textFieldMinTouchedInitialized = true;
                this.textFieldMinTouched = true;
                this.textFieldMin.getCaret().setVisible(false);
                this.textFieldMax.setBackground(Color.WHITE);
                this.textFieldMaxTouchedInitialized = false;
                this.textFieldMaxTouched = false;
                this.textFieldMax.getCaret().setVisible(false);
            }
        }
    }

    public void updateAfterRemoveVolume() {
        this.updateOverlayPopupMenu();
        this.updateOverlayButtonIcons();
        this.updateOverlayButton();
        this.updateSlider();
        this.updateTextFieldState();
    }

    public void updateAllAccelerators(String[] actions) {
        this.clearAllAccelerators();
        for (int ctr = 0; ctr < actions.length; ++ctr) {
            String actionLabel = actions[ctr];
            JMenuItem item = MENU_ACTION_MAP.get(actionLabel);
            if (item == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(MangoPreferences.FUNCTION_KEY_CODES.get(ctr), 0));
            FUNCTION_KEY_MAP.put(MangoPreferences.FUNCTION_KEY_CODES.get(ctr), item);
        }
    }

    public void updateCoordinate(int index) {
        boolean forceUpdate;
        this.mango.recordAction("setWorldMode", new String[]{ScriptUtils.convertBoolean((index & 4) != 0)});
        boolean bl = forceUpdate = (this.coordinateType & 0) != (index & 0) || (this.coordinateType & 4) != (index & 4);
        if (index == 0) {
            this.coordinatesButton.setIcon(MangoStyle.ICON_COORDINATES.get(0));
        } else if ((index & 2) != 0) {
            this.coordinatesButton.setIcon(MangoStyle.ICON_COORDINATES.get(1));
        } else if ((index & 4) != 0) {
            this.coordinatesButton.setIcon(MangoStyle.ICON_COORDINATES.get(2));
        }
        this.coordinateType = index;
        if (this.coordinateType != 0 && this.currentAtlas != null) {
            this.coordinateType |= 8;
        }
        this.setShowLabels((this.coordinateType & 8) != 0);
        this.updateTransformButton();
        this.updateTransformPopupMenu();
        this.mango.coordinateTypeSelectionChanged(forceUpdate);
        Mango.forceImageUpdate();
        this.mango.updateScreenSlices();
        this.mango.repaintAllViewers();
        Mango.updateAllViewerFrames();
        Mango.updateAllSurfaces();
    }

    public void updateCoordinateDisplay() {
        boolean isWorldMode = this.isWorldMode();
        boolean isOverlay = this.currentViewer.getCurrentScreenVolume().isOverlay();
        boolean isReloading = this.currentViewer.isVolumeWillBeReloaded();
        double value = 0.0;
        if (!isReloading) {
            if (isWorldMode) {
                this.tempCoor.setValues((double)this.xLoc, (double)this.yLoc, (double)this.zLoc);
                this.currentViewer.convertIndexToWorldCoordinate(this.tempCoor);
                value = this.currentViewer.getCurrentVolume().getVoxelValueAtCoordinate(this.tempCoor.xDbl, this.tempCoor.yDbl, this.tempCoor.zDbl, this.currentViewer.getCurrentVolume().getCurrentTimepoint(), true, true);
            } else {
                value = isOverlay ? this.currentViewer.getCurrentVolume().getVoxelValueAtMM((double)this.xLoc * this.currentViewer.getXSize(), (double)this.yLoc * this.currentViewer.getYSize(), (double)this.zLoc * this.currentViewer.getZSize(), this.currentViewer.getCurrentVolume().getCurrentTimepoint(), true, true) : this.currentViewer.getCurrentVolume().getVoxelValueAtIndex(this.xLoc, this.yLoc, this.zLoc, this.currentViewer.getCurrentVolume().getCurrentTimepoint(), true, true);
            }
        }
        if (isWorldMode) {
            this.currentCoor.setValues((double)this.xLoc, (double)this.yLoc, (double)this.zLoc);
            this.currentViewer.getCurrentCoordinate(this.currentCoor, this.currentCoor);
            double xPos = this.currentCoor.xDbl;
            double yPos = this.currentCoor.yDbl;
            double zPos = this.currentCoor.zDbl;
            this.formatLabels(xPos, yPos, zPos, value);
            if ((this.coordinateType & 8) != 0 && this.currentAtlas != null) {
                this.formatAtlasLabels(this.currentAtlas.getLabel(xPos, yPos, zPos));
            }
        } else {
            this.formatLabels(this.currentViewer.convertCoordinateOriginX(this.xLoc), this.currentViewer.convertCoordinateOriginY(this.yLoc), this.currentViewer.convertCoordinateOriginZ(this.zLoc), value);
        }
    }

    public void updateCoordinateType(boolean isSlice) {
        if (this.mouseX != null) {
            if (isSlice) {
                this.mouseX.setForeground(MangoStyle.COLOR_CROSSHAIRS_BLUE);
                this.mouseY.setForeground(MangoStyle.COLOR_CROSSHAIRS_BLUE);
                this.mouseZ.setForeground(MangoStyle.COLOR_CROSSHAIRS_BLUE);
            } else {
                this.mouseX.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
                this.mouseY.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
                this.mouseZ.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            }
        }
    }

    public void updateCurrentState() {
        if (this.currentViewer != null) {
            this.updateTransformButton();
            this.updateOverlayButtonIcons();
            this.updateOverlayButton();
            this.updateTransformPopupMenu();
            this.updateOverlayPopupMenu();
            this.updateMangoColorButton();
            this.updateCoordinatePopupMenu();
            this.updateSlider();
            this.updateTextFieldState();
        }
    }

    public void updateEnabledItems() {
        boolean hasState = this.currentViewer != null;
        this.setEnabledItems(hasState, true);
    }

    public void updateFocusState() {
        if (!this.applet) {
            if (this.getState() != 1) {
                if (Mango.hasOrthogonalViewer()) {
                    if (this.getFocusableWindowState()) {
                        this.setFocusableWindowState(false);
                        if (this.isFocusableWindow()) {
                            this.setVisible(false);
                            this.setVisible(true);
                        }
                        this.textFieldMaxTouched = false;
                        this.textFieldMinTouched = false;
                    }
                } else if (!this.getFocusableWindowState()) {
                    this.setFocusableWindowState(true);
                    if (!this.isFocusableWindow()) {
                        this.setVisible(false);
                        this.setVisible(true);
                    }
                    this.requestFocus();
                    this.toFront();
                }
            }
            this.openMenu.setForeground(Color.BLACK);
            this.helpMenu.setForeground(Color.BLACK);
            this.optionsMenu.setForeground(Color.BLACK);
            this.windowsMenu.setForeground(Color.BLACK);
            this.quitMenu.setForeground(Color.BLACK);
        }
    }

    public void updateGlobalRange() {
        if (this.currentViewer != null) {
            this.resetSliderValues();
            this.globalScreenMin = this.mango.findGlobalMin();
            this.globalScreenMax = this.mango.findGlobalMax();
            this.updateLUTInfo();
            this.mango.updateScreenRatios();
            this.mango.updateScreenSlices();
        }
    }

    public void updateGlobalState(double min, double max) {
        if (this.globalScreenMin == 0.0 && this.globalScreenMax == 0.0) {
            this.initializeGlobalState();
        }
        if (this.globalScreenMin == 0.0 && this.globalScreenMax == 0.0) {
            this.globalScreenMin = min;
            this.globalScreenMax = max;
        }
        if (this.currentViewer != null) {
            this.updateLUTInfo();
            this.mango.updateScreenRatios();
            this.mango.updateScreenSlices();
        }
    }

    public void setGlobalRange(double min, double max) {
        this.globalScreenMin = min;
        this.globalScreenMax = max;
        if (this.currentViewer != null) {
            this.updateLUTInfo();
            this.mango.updateScreenRatios();
            this.mango.updateScreenSlices();
        }
    }

    public void updateHidden() {
        this.updateOverlayPopupMenu();
        this.updateOverlayButton();
        this.updateSlider();
        this.updateTextFieldState();
        this.currentViewer.clearOverlayData();
        this.currentViewer.updateViewer();
        this.currentViewer.getCurrentScreenVolume().notifyListenersOfChange(false);
        this.updateSurfaceTextures();
    }

    public void updateImageBrowserItem() {
        if (this.mango.getImageBrowser().isVisible() && this.mango.getImageBrowser().getState() == 0) {
            this.filePreviewFolder.setText("Hide Image Browser");
        } else {
            this.filePreviewFolder.setText("Show Image Browser");
        }
    }

    @Override
    public void updateLUTInfo() {
        this.updateLUTInfo(true);
    }

    @Override
    public void updateLUTInfo(boolean repaint) {
        if (this.currentViewer != null) {
            if (this.global) {
                if (!this.currentViewer.isCurrentVolumeOverlay()) {
                    this.mango.updateLUT(this.slider.getValueAt(2), this.slider.getValueAt(0));
                } else if (this.overlayGroup) {
                    Mango.updateOverlayGroupLUT(this.slider.getValueAt(2), this.slider.getValueAt(0));
                } else {
                    this.currentViewer.getCurrentScreenVolume().getLookupTableManager().updateLUT(this.slider.getValueAt(2), this.slider.getValueAt(0));
                }
                Mango.forceImageUpdate();
                this.mango.repaintAllViewers();
            } else {
                if (this.overlayGroup && !this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                    this.currentViewer.updateOverlayGroupLUT(this.slider.getValueAt(2), this.slider.getValueAt(0));
                } else {
                    this.currentViewer.getCurrentScreenVolume().getLookupTableManager().updateLUT(this.slider.getValueAt(2), this.slider.getValueAt(0));
                }
                Mango.forceImageUpdate();
                this.currentViewer.repaint();
            }
            this.updateSliderImage();
            this.updateTextFields();
        }
        if (repaint) {
            this.slider.repaint();
        }
    }

    public void updateMouseLabelInfo() {
        if (this.currentViewer != null) {
            Coordinate currentCoor = this.currentViewer.getCurrentCoordinate(null, null, null, false, true, false);
            this.xLoc = currentCoor.xInt;
            this.yLoc = currentCoor.yInt;
            this.zLoc = currentCoor.zInt;
            this.updateCoordinateDisplay();
        }
    }

    public void updateMouseLabelInfo(ScreenSlice aScreenSlice, Point current, boolean withinBounds) {
        if (this.currentViewer != null && !this.currentViewer.isInWorkingState()) {
            if (this.mango.isToolboxCoordinateCurrentSlice()) {
                Coordinate currentCoor = this.currentViewer.getCurrentCoordinate(null, null, null, false, true, false);
                this.xLoc = currentCoor.xInt;
                this.yLoc = currentCoor.yInt;
                this.zLoc = currentCoor.zInt;
                this.updateCoordinateDisplay();
            } else if (withinBounds) {
                this.mousePlane = aScreenSlice.getSliceDirection();
                if (this.mousePlane == 0) {
                    this.xLoc = current.x;
                    this.yLoc = current.y;
                    this.zLoc = this.currentViewer.getAxialSliceNumber();
                } else if (this.mousePlane == 1) {
                    this.xLoc = current.x;
                    this.yLoc = this.currentViewer.getCoronalSliceNumber();
                    this.zLoc = current.y;
                } else {
                    this.xLoc = this.currentViewer.getSagittalSliceNumber();
                    this.yLoc = current.x;
                    this.zLoc = current.y;
                }
                this.updateCoordinateDisplay();
            } else {
                this.updateMouseLabelOutOfBounds();
            }
        }
    }

    public void updateMouseLabelOutOfBounds() {
        if (!this.mango.isToolboxCoordinateCurrentSlice()) {
            this.updateMouseLabelOutOfBounds(false);
        }
    }

    public void updateOverlayButton() {
        if (this.currentViewer != null) {
            if (this.currentViewer.isCurrentVolumeOverlay()) {
                ScreenVolume tempVol = this.currentViewer.getOverlayManager().getOverlay(this.currentViewer.getCurrentOverlayIndex());
                if (tempVol != null && tempVol.isHidden()) {
                    this.overlayButton.setIcon(MangoStyle.ICON_OVERLAY_HIDDEN);
                } else {
                    this.overlayButton.setIcon(this.overlayImageIcons[this.currentViewer.getCurrentOverlayIndex()]);
                }
            } else {
                this.overlayButton.setIcon(this.baseImageIcon);
            }
        }
    }

    public void updateOverlayPopupMenu() {
        if (this.currentViewer == null) {
            return;
        }
        this.popupOverlay.removeAll();
        int numOverlays = this.currentViewer.getNumOverlays();
        int count = numOverlays + 1;
        if (count == 1) {
            JMenuItem infoItem = new JMenuItem("Get Info");
            infoItem.setFont(MENU_FONT);
            infoItem.addActionListener(this);
            infoItem.setActionCommand("Get Info 0");
            JMenu lutMenu = new JMenu("Color Table");
            lutMenu.setFont(MENU_FONT);
            this.addLUTMenuItems(lutMenu, this.currentViewer.getBaseScreenVolume(), 0);
            JMenu spaceMenu = new JMenu("Orientation");
            spaceMenu.setFont(MENU_FONT);
            String[] spaceOptions = this.currentViewer.getBaseVolume().getCoordinateSpaceTransforms();
            if (spaceOptions != null) {
                for (int ctr = 0; ctr < spaceOptions.length; ++ctr) {
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(spaceOptions[ctr]);
                    item.setFont(MENU_FONT);
                    item.setSelected(this.currentViewer.getBaseVolume().getSelectedCoordinateSpaceTransform() == ctr);
                    item.setActionCommand("coordinate space " + ctr + "," + 0);
                    item.addActionListener(this);
                    spaceMenu.add(item);
                }
            }
            this.popupOverlay.add(infoItem);
            if (!this.currentViewer.isRGB()) {
                this.popupOverlay.add(lutMenu);
            }
            this.popupOverlay.add(spaceMenu);
        } else {
            for (int ctr = count - 1; ctr > 0; --ctr) {
                final int ctrF = ctr;
                final ScreenVolume screenVol = this.currentViewer.getOverlayManager().getOverlay(ctr - 1);
                boolean isHidden = screenVol.isHidden();
                boolean isLogical = screenVol.isLogical();
                final MangoSquareMenu mp = isHidden ? new MangoSquareMenu(MangoStyle.ICON_OVERLAY_HIDDEN) : new MangoSquareMenu(this.overlayImageIcons[ctr - 1]);
                mp.setPreferredSize(new Dimension(30, 30));
                mp.setBackground(POPUP_MENU_ITEM_COLOR);
                mp.setContentAreaFilled(true);
                mp.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent me) {
                        if (screenVol.isHidden()) {
                            mp.setIcon(Toolbox.this.overlayImageIcons[ctrF - 1]);
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent me) {
                        if (screenVol.isHidden()) {
                            mp.setIcon(MangoStyle.ICON_OVERLAY_HIDDEN);
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent me) {
                        Toolbox.this.doOverlayButtonChosen("overlayButtonChosen" + ctrF);
                        Toolbox.this.updateSurfaceTextures();
                        mp.getPopupMenu().setVisible(false);
                        Toolbox.this.popupOverlay.setVisible(false);
                    }
                });
                JMenuItem infoItem = new JMenuItem("Get Info");
                infoItem.setFont(MENU_FONT);
                infoItem.addActionListener(this);
                infoItem.setActionCommand(ACTION_GET_INFO + ctr);
                JMenuItem hideItem = new JMenuItem(isHidden ? "Show" : "Hide");
                hideItem.addActionListener(this);
                hideItem.setActionCommand("Hide " + ctr);
                hideItem.setFont(MENU_FONT);
                JMenuItem removeItem = new JMenuItem("Remove");
                removeItem.addActionListener(this);
                removeItem.setActionCommand("Remove " + ctr);
                removeItem.setFont(MENU_FONT);
                JMenuItem moveUp = new JMenuItem("Move Up");
                moveUp.addActionListener(this);
                moveUp.setActionCommand("Move Up " + ctr);
                moveUp.setFont(MENU_FONT);
                JMenuItem moveDown = new JMenuItem("Move Down");
                moveDown.addActionListener(this);
                moveDown.setActionCommand("Move Down " + ctr);
                moveDown.setFont(MENU_FONT);
                JMenu lutMenu = new JMenu("Color Table");
                lutMenu.setFont(MENU_FONT);
                this.addLUTMenuItems(lutMenu, screenVol, ctr);
                JMenu alphaMenu = new JMenu("Transparency");
                alphaMenu.setFont(MENU_FONT);
                alphaMenu.add(this.makeTransparencySlider(screenVol, alphaMenu));
                try {
                    mp.add(infoItem);
                }
                catch (Exception ex) {
                    AppLogger.error((Throwable)ex);
                }
                mp.add(new JToolBar.Separator(new Dimension(0, 4)));
                mp.add(hideItem);
                mp.add(removeItem);
                mp.add(new JToolBar.Separator(new Dimension(0, 4)));
                mp.add(lutMenu);
                if (!isLogical) {
                    mp.add(alphaMenu);
                }
                mp.add(this.getOverlayTransformMenu(ctr));
                JMenu spaceMenu = new JMenu("Orientation");
                spaceMenu.setFont(MENU_FONT);
                String[] spaceOptions = screenVol.getVolume().getCoordinateSpaceTransforms();
                if (spaceOptions != null) {
                    for (int ctr2 = 0; ctr2 < spaceOptions.length; ++ctr2) {
                        JCheckBoxMenuItem item = new JCheckBoxMenuItem(spaceOptions[ctr2]);
                        item.setFont(MENU_FONT);
                        item.setSelected(screenVol.getVolume().getSelectedCoordinateSpaceTransform() == ctr2);
                        item.setActionCommand("coordinate space " + ctr2 + "," + ctr);
                        item.addActionListener(this);
                        spaceMenu.add(item);
                    }
                }
                mp.add(spaceMenu);
                JMenuItem loadNegatives = new JMenuItem("Load Negatives");
                loadNegatives.setFont(MENU_FONT);
                loadNegatives.addActionListener(this);
                loadNegatives.setActionCommand("Load Negatives " + ctr);
                if (!screenVol.isNegative()) {
                    mp.add(loadNegatives);
                }
                JCheckBoxMenuItem useInterpolation = new JCheckBoxMenuItem("Interpolation");
                useInterpolation.setFont(MENU_FONT);
                useInterpolation.addActionListener(this);
                useInterpolation.setSelected(screenVol.getVolume().isAllowsLinearInterpolation());
                useInterpolation.setActionCommand("Interpolation " + ctr);
                mp.add(useInterpolation);
                mp.add(new JToolBar.Separator(new Dimension(0, 4)));
                mp.add(moveUp);
                mp.add(moveDown);
                this.popupOverlay.add(mp);
            }
            final MangoSquareMenu mp = new MangoSquareMenu(this.baseImageIcon);
            mp.setPreferredSize(new Dimension(30, 30));
            mp.setBackground(POPUP_MENU_ITEM_COLOR);
            mp.setContentAreaFilled(true);
            mp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    Toolbox.this.doOverlayButtonChosen("overlayButtonChosen0");
                    Toolbox.this.updateSurfaceTextures();
                    mp.getPopupMenu().setVisible(false);
                    Toolbox.this.popupOverlay.setVisible(false);
                }
            });
            JMenuItem infoItem = new JMenuItem("Get Info");
            infoItem.setFont(MENU_FONT);
            infoItem.addActionListener(this);
            infoItem.setActionCommand("Get Info 0");
            JMenu lutMenu = new JMenu("Color Table");
            lutMenu.setFont(MENU_FONT);
            this.addLUTMenuItems(lutMenu, this.currentViewer.getBaseScreenVolume(), 0);
            try {
                mp.add(infoItem);
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
            mp.add(lutMenu);
            JMenu spaceMenu = new JMenu("Orientation");
            spaceMenu.setFont(MENU_FONT);
            String[] spaceOptions = this.currentViewer.getBaseVolume().getCoordinateSpaceTransforms();
            if (spaceOptions != null) {
                for (int ctr2 = 0; ctr2 < spaceOptions.length; ++ctr2) {
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(spaceOptions[ctr2]);
                    item.setFont(MENU_FONT);
                    item.setSelected(this.currentViewer.getBaseVolume().getSelectedCoordinateSpaceTransform() == ctr2);
                    item.setActionCommand("coordinate space " + ctr2 + "," + 0);
                    item.addActionListener(this);
                    spaceMenu.add(item);
                }
            }
            mp.add(spaceMenu);
            this.popupOverlay.add(mp);
        }
    }

    public void updateSlider() {
        this.updateSlider(this.currentViewer.getCurrentScreenVolume());
    }

    public void updateSurfaceTextures() {
        if (this.global) {
            Mango.updateSurfaces(true);
        } else {
            this.currentViewer.updateSurfaceTextures(true);
            this.currentViewer.updateSurface();
        }
    }

    public void updateTextFields() {
        if (this.currentViewer != null && this.currentViewer.getCurrentScreenVolume() != null) {
            double screenMax;
            double screenMin;
            int sliderMin = this.slider.getValueAt(0);
            int sliderMax = this.slider.getValueAt(2);
            if (this.global && this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                screenMin = this.globalScreenMin;
                screenMax = this.globalScreenMax;
            } else {
                screenMin = this.currentViewer.getCurrentScreenVolume().getScreenMin();
                screenMax = this.currentViewer.getCurrentScreenVolume().getScreenMax();
            }
            this.textFieldMin.setText(FORMATTER_NUMBER.format((double)sliderMin / (255.0 / (screenMax - screenMin)) + screenMin));
            this.textFieldMin.setCaretPosition(0);
            this.textFieldMax.setText(FORMATTER_NUMBER.format((double)sliderMax / (255.0 / (screenMax - screenMin)) + screenMin));
            this.textFieldMax.setCaretPosition(0);
            this.textFieldMaxTouched = false;
            this.textFieldMinTouched = false;
            this.textFieldMaxTouchedInitialized = false;
            this.textFieldMinTouchedInitialized = false;
            this.textFieldMin.setBackground(Color.WHITE);
            this.textFieldMax.setBackground(Color.WHITE);
            this.textFieldMin.getCaret().setVisible(false);
            this.textFieldMax.getCaret().setVisible(false);
        }
    }

    public void adjustSliderValues(int brightnessChange, int contrastChange) {
        double maxValue;
        double minValue;
        int step = 2;
        if (Math.abs(contrastChange) > Math.abs(brightnessChange)) {
            minValue = (float)this.slider.getValueAt(0) + 2.0f * Math.signum(contrastChange);
            maxValue = (float)this.slider.getValueAt(2) + -2.0f * Math.signum(contrastChange);
            if (maxValue <= minValue) {
                maxValue = minValue;
            }
        } else {
            minValue = (float)this.slider.getValueAt(0) + 2.0f * Math.signum(brightnessChange);
            maxValue = (float)this.slider.getValueAt(2) + 2.0f * Math.signum(brightnessChange);
        }
        int min = Math.max(0, Math.min(255, (int)minValue));
        int max = Math.max(0, Math.min(255, (int)maxValue));
        this.slider.setValueAt(min, 0);
        this.slider.setValueAt((min + max) / 2, 1);
        this.slider.setValueAt(max, 2);
        this.updateLUTInfo();
        this.slider.updateThumbLocations();
        this.slider.repaint();
        this.updateTextFieldState();
    }

    @Override
    public void updateTextFieldValues() {
        try {
            double valMin = Double.parseDouble(this.textFieldMin.getText());
            double valMax = Double.parseDouble(this.textFieldMax.getText());
            this.currentViewer.recordAction("setVolumeDisplayRange", new String[]{this.currentViewer.getScriptObjectName() + ".currentVolume", this.textFieldMin.getText(), this.textFieldMax.getText()});
            if (Double.isNaN(valMin)) {
                valMin = 0.0;
            }
            if (Double.isNaN(valMax)) {
                valMax = 0.0;
            }
            double screenMin = 0.0;
            double screenMax = 0.0;
            if (this.global) {
                if (this.currentViewer.getCurrentScreenVolume() == this.currentViewer.getBaseScreenVolume()) {
                    this.globalScreenMin = valMin;
                    this.globalScreenMax = valMax;
                    screenMin = this.globalScreenMin;
                    screenMax = this.globalScreenMax;
                } else if (this.overlayGroup) {
                    Mango.setOverlayGroupScreenMin(valMin);
                    Mango.setOverlayGroupScreenMax(valMax);
                    screenMin = valMin;
                    screenMax = valMax;
                } else {
                    screenMin = valMin;
                    screenMax = valMax;
                    this.currentViewer.getCurrentScreenVolume().setScreenMin(valMin);
                    this.currentViewer.getCurrentScreenVolume().setScreenMax(valMax);
                }
                this.mango.updateScreenRatios();
                this.mango.updateScreenSlices();
            } else {
                if (this.overlayGroup && !this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                    this.currentViewer.setOverlayGroupScreenMin(valMin);
                    this.currentViewer.setOverlayGroupScreenMax(valMax);
                } else {
                    this.currentViewer.getCurrentScreenVolume().setScreenMin(valMin);
                    this.currentViewer.getCurrentScreenVolume().setScreenMax(valMax);
                }
                this.currentViewer.getCurrentScreenVolume().updateScreenRatio();
                this.currentViewer.updateScreenSlices();
                this.currentViewer.getCurrentScreenVolume().getVolume().setHeaderAsDirty();
                screenMin = this.currentViewer.getCurrentScreenVolume().getScreenMin();
                screenMax = this.currentViewer.getCurrentScreenVolume().getScreenMax();
            }
            this.currentViewer.getCurrentScreenVolume().setNegativeState(screenMin > screenMax);
            int screenValMin = (int)Math.round((valMin - screenMin) * (255.0 / (screenMax - screenMin)));
            int screenValMax = (int)Math.round((valMax - screenMin) * (255.0 / (screenMax - screenMin)));
            if (screenValMin > screenValMax) {
                this.slider.setValueAt(screenValMin, 0);
                this.slider.setValueAt(screenValMin, 1);
                this.slider.setValueAt(screenValMin, 2);
            } else {
                this.slider.setValueAt(screenValMin, 0);
                this.slider.setValueAt(screenValMax, 2);
                this.slider.setValueAt((this.slider.getValueAt(2) - this.slider.getValueAt(0)) / 2 + this.slider.getValueAt(0), 1);
            }
            this.updateLUTInfo();
            this.slider.updateThumbLocations();
            this.slider.repaint();
            this.updateTextFieldState();
        }
        catch (NumberFormatException ex) {
            double screenMax;
            double screenMin;
            AppLogger.info((Throwable)ex);
            int sliderMin = this.slider.getValueAt(0);
            int sliderMax = this.slider.getValueAt(2);
            if (this.global) {
                screenMin = this.globalScreenMin;
                screenMax = this.globalScreenMax;
            } else {
                screenMin = this.currentViewer.getCurrentScreenVolume().getScreenMin();
                screenMax = this.currentViewer.getCurrentScreenVolume().getScreenMax();
            }
            this.textFieldMin.setText(FORMATTER_NUMBER.format((double)sliderMin / (255.0 / (screenMax - screenMin)) + screenMin));
            this.textFieldMin.setCaretPosition(0);
            this.textFieldMax.setText(FORMATTER_NUMBER.format((double)sliderMax / (255.0 / (screenMax - screenMin)) + screenMin));
            this.textFieldMax.setCaretPosition(0);
        }
        this.textFieldMaxTouched = false;
        this.textFieldMinTouched = false;
        this.textFieldMaxTouchedInitialized = false;
        this.textFieldMinTouchedInitialized = false;
        this.textFieldMin.setBackground(Color.WHITE);
        this.textFieldMax.setBackground(Color.WHITE);
        this.textFieldMin.getCaret().setVisible(false);
        this.textFieldMax.getCaret().setVisible(false);
        this.notifyScreenVolListenersOfChange();
        this.currentViewer.clearOverlayData();
        this.currentViewer.updateViewer();
        this.updateOverlayButtonIcons();
        this.updateOverlayButton();
        this.updateSurfaceTextures();
    }

    public void updateTransformButton() {
        this.reconcileTransformButton();
    }

    public void updateTransformPopupMenu() {
    }

    public boolean usesFunctionKey(int keyCode) {
        return FUNCTION_KEY_MAP.containsKey(keyCode);
    }

    @Override
    public void wakeAllScriptThreads() {
        this.scriptPaused = false;
        this.updateBottomPanel();
        Vector<SliceViewer> viewers = this.mango.getAllViewers();
        for (SliceViewer viewer : viewers) {
            viewer.continueScript();
        }
    }

    private void addLUTMenuItems(JMenu lutMenu, ScreenVolume aScreenVol, int index) {
        String currentLUT = aScreenVol.getLookupTableManager().getName();
        boolean isBase = aScreenVol.isBaseImage();
        String[] luts = LookupTableManager.getAllLUTNames();
        for (int ctr = 0; ctr < luts.length; ++ctr) {
            String lutName = luts[ctr];
            boolean isLogical = lutName.indexOf(ACTION_LOGICAL) != -1;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(lutName);
            item.setActionCommand("LUT " + index + " [" + lutName + "]");
            item.addActionListener(this);
            item.setFont(MENU_FONT);
            item.setSelected(lutName.equals(currentLUT) && !aScreenVol.isLogical());
            if (isBase && isLogical) continue;
            if (lutName.equals("Red Overlay") || lutName.equals("Red") || lutName.equals("Spectrum")) {
                lutMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            } else if (luts.length > LookupTableManager.NAMES.size() && ctr == LookupTableManager.NAMES.size()) {
                lutMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
            }
            lutMenu.add(item);
        }
        lutMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        if (!isBase) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(ACTION_LOGICAL);
            item.setActionCommand("LUT " + index + " [" + ACTION_LOGICAL + "]");
            item.addActionListener(this);
            item.setFont(MENU_FONT);
            item.setSelected(aScreenVol.isLogical());
            lutMenu.add(item);
        }
    }

    private void clearAllAccelerators() {
        Collection<JMenuItem> items = MENU_ACTION_MAP.values();
        for (JMenuItem item : items) {
            item.setAccelerator(null);
        }
        FUNCTION_KEY_MAP.clear();
    }

    private void clearCurrentState(boolean resetGlobalState) {
        this.currentViewer = null;
        if (resetGlobalState) {
            this.coordinateType = 0;
            this.coordinatesButton.setIcon(MangoStyle.ICON_COORDINATES.get(0));
            this.setShowLabels(false);
            this.roiEditMode = 0;
            this.voiMode = true;
            this.roiButton.setColor(0, null);
            this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(0));
            this.roiEditButton.setBackground(MangoStyle.COLOR_BACKGROUND);
            this.voiButton.setIcon(MangoStyle.ICON_ROI_VOI.get(1));
            this.globalScreenMax = 0.0;
            this.globalScreenMin = 0.0;
        }
        this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(0));
        this.updateBaseImageIconLUTImage();
        this.overlayButton.setIcon(this.baseImageIcon);
        this.slider.setValueAt(0, 0);
        this.slider.setValueAt(127, 1);
        this.slider.setValueAt(255, 2);
        this.updateSliderImage();
        this.slider.updateThumbLocations();
        this.slider.repaint();
        this.updateMouseLabelOutOfBounds(true);
        this.textFieldMin.setText("");
        this.textFieldMax.setText("");
        this.closePopups();
        this.updateFocusState();
        this.updateTextFieldState();
    }

    private void createMenuItemMap() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            String text;
            if (!field.getType().isAssignableFrom(JMenuItem.class)) continue;
            JMenuItem item = null;
            try {
                item = (JMenuItem)field.get(this);
            }
            catch (IllegalArgumentException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            if (item == null) continue;
            String name = item.getName();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                MENU_ACTION_MAP.put(name, item);
            }
            if (!StringUtils.isNotBlank((CharSequence)(text = item.getText()))) continue;
            MENU_NAME_MAP.put(text, item);
        }
    }

    private void createOverlayButtons() {
        this.baseImage = new BufferedImage(23, 23, 2);
        this.baseImageFiltered = new BufferedImage(23, 23, 2);
        this.baseImageData = ((DataBufferInt)this.baseImage.getRaster().getDataBuffer()).getData();
        this.initializeBaseImageLUTImage();
        this.overlayImages = new BufferedImage[8];
        this.overlayImagesFiltered = new BufferedImage[8];
        this.overlayData = new int[8][];
        this.overlayImageIcons = new ImageIcon[8];
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImages[ctr] = new BufferedImage(23, 23, 2);
            this.overlayImagesFiltered[ctr] = new BufferedImage(23, 23, 2);
            this.overlayData[ctr] = ((DataBufferInt)this.overlayImages[ctr].getRaster().getDataBuffer()).getData();
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        this.initializeOverlayImageLUTImages();
        this.updateBaseImageIconLUTImage();
        this.baseImageIcon = new ImageIcon(this.baseImageFiltered);
        this.overlayButton.setIcon(this.baseImageIcon);
    }

    private void doOverlayButtonChosen(String command) {
        this.doOverlayButtonChosen(Integer.parseInt(command.substring(19)));
    }

    private void doProgressBarFinished(final JComponent progressBar) {
        Runnable progressBarFinishedRunnable = new Runnable(){

            @Override
            public void run() {
                Toolbox.this.progressBarsShowing--;
                Toolbox.this.updateBottomPanel();
                Toolbox.this.progressBarPanel.remove(progressBar);
                Toolbox.this.progressBarPanel.validate();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)progressBarFinishedRunnable);
    }

    private void doProgressBarStarted(final JComponent progressBar) {
        Runnable progressBarStartedRunnable = new Runnable(){

            @Override
            public void run() {
                progressBar.setBackground(Toolbox.this.slider.getBackground());
                Toolbox.this.progressBarPanel.add(progressBar);
                Toolbox.this.progressBarPanel.validate();
                Toolbox.this.progressBarsShowing++;
                Toolbox.this.updateBottomPanel();
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)progressBarStartedRunnable);
    }

    private void doTransformButtonChosen() {
        this.currentViewer.recordAction("setTransformMode", new String[]{ScriptUtils.convertBoolean(!this.currentViewer.getBaseScreenVolume().isUsingTransform())});
        this.currentViewer.getBaseScreenVolume().setUsingTransform(!this.currentViewer.getBaseScreenVolume().isUsingTransform());
        this.updateAfterTransformModeChange();
    }

    public void updateAfterTransformModeChange() {
        if (this.currentViewer.getBaseScreenVolume().isUsingTransform()) {
            this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(1));
        } else {
            this.transformButton.setIcon(MangoStyle.ICON_TRANSFORM.get(0));
        }
        this.currentViewer.updateTransformManualPanel();
        this.currentViewer.updateTransformMode();
        this.mango.updateViewers();
        Mango.updateSurfaces(true);
    }

    private JMenu getOverlayTransformMenu(int indexVal) {
        int index = indexVal;
        JMenu xformMenu = new JMenu("Transform");
        xformMenu.setFont(MENU_FONT);
        JCheckBoxMenuItem resetItem = new JCheckBoxMenuItem(NO_ATLAS_NAME);
        resetItem.setFont(MENU_FONT);
        resetItem.addActionListener(this);
        resetItem.setActionCommand("Reset Transform " + index);
        xformMenu.add(resetItem);
        JCheckBoxMenuItem talItem = new JCheckBoxMenuItem("Talairach to MNI");
        talItem.setFont(MENU_FONT);
        talItem.addActionListener(this);
        talItem.setActionCommand("Transform to Talairach " + index);
        xformMenu.add(talItem);
        JCheckBoxMenuItem mniItem = new JCheckBoxMenuItem("MNI to Talairach");
        mniItem.setFont(MENU_FONT);
        mniItem.addActionListener(this);
        mniItem.setActionCommand("Transform to MNI " + index);
        xformMenu.add(mniItem);
        ScreenVolume aScreenVol = null;
        aScreenVol = --index == -1 ? this.currentViewer.getBaseScreenVolume() : this.currentViewer.getOverlayManager().getOverlay(index);
        if (aScreenVol != null) {
            talItem.setSelected(aScreenVol.getVolume().isTalairachToMNITransform());
            mniItem.setSelected(aScreenVol.getVolume().isMNIToTalairachTransform());
            resetItem.setSelected(aScreenVol.getVolume().isIdentityTransform());
        } else {
            talItem.setSelected(false);
            mniItem.setSelected(false);
            resetItem.setSelected(false);
        }
        return xformMenu;
    }

    private void initializeBaseImageLUTImage() {
        double ratio = 11.08695652173913;
        int value = 0;
        for (int ctr = 0; ctr < 23; ++ctr) {
            for (int ctrIn = 0; ctrIn < 23; ++ctrIn) {
                value = (int)(11.08695652173913 * (double)ctrIn + 0.5);
                this.baseImageData[ctr * 23 + ctrIn] = value | value << 8 | value << 16 | value << 24;
            }
        }
    }

    private void initializeGlobalState() {
        if (this.currentViewer != null) {
            if (this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                this.resetSliderValues();
            }
            this.mango.resetBaseImageLUT();
            this.mango.updateScreenRatios();
            this.mango.updateScreenSlices();
            this.updateGlobalRange();
            this.updateSlider();
        }
    }

    private void initializeGroupOverlay() {
        if (this.global) {
            Mango.initializeGroupOverlay(this.currentViewer);
        } else {
            this.currentViewer.initializeGroupOverlay();
        }
    }

    private void initializeOverlayImageLUTImages() {
        double ratio = 11.08695652173913;
        int value = 0;
        for (int ctrOvly = 0; ctrOvly < 8; ++ctrOvly) {
            for (int ctr = 0; ctr < 23; ++ctr) {
                for (int ctrIn = 0; ctrIn < 23; ++ctrIn) {
                    value = (int)(11.08695652173913 * (double)ctrIn + 0.5);
                    this.overlayData[ctrOvly][ctr * 23 + ctrIn] = value | value << 8 | value << 16 | value << 24;
                }
            }
        }
    }

    private void initializeSliderImage() {
        double ratio = 1.9921875;
        int value = 0;
        for (int ctr = 0; ctr < 10; ++ctr) {
            for (int ctrIn = 0; ctrIn < 128; ++ctrIn) {
                value = (int)(1.9921875 * (double)ctrIn + 0.5);
                this.sliderImageData[ctr * 128 + ctrIn] = value | value << 8 | value << 16 | value << 24;
            }
        }
    }

    private JPanel makeContinuePanel() {
        JProgressBar progress = new JProgressBar(0, 1);
        progress.setIndeterminate(true);
        this.continueButton = new JButton("Continue Script");
        this.continueButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.continueButton.getModel().setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                Toolbox.this.continueButton.getModel().setPressed(false);
            }
        });
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Toolbox.this.wakeAllScriptThreads();
            }
        });
        JPanel panel = new JPanel();
        panel.add(this.continueButton);
        return panel;
    }

    private void makeCoordinatePopupMenu() {
        this.popupCoordinate = new JPopupMenu();
        this.popupCoordinate.addPopupMenuListener(this);
    }

    private void makeMenu() {
        this.openMenu = new MangoMenu("Open", 11, true);
        this.openMenu.addMenuListener(this);
        this.fileEditHeader = new MangoMenuItem(new ViewerMenuAction("Edit Header...", this.mango), "Edit Header (Toolbox)", 11, true);
        this.fileOpen = new MangoMenuItem(new ViewerMenuAction("Open Image...", this.mango), null, 11, true);
        this.fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileOpenURL = new MangoMenuItem(new ViewerMenuAction("Open Online Image...", this.mango), "Open Online Image (Toolbox)", 11, true);
        this.fileSample = new MangoMenuItem(new ViewerMenuAction("Open Sample Image", this.mango), "Open Sample Image (Toolbox)", 11, true);
        this.fileOpenBrowser = new MangoMenuItem(new ViewerMenuAction("Open Image Browser", this.mango), null, 11, true);
        this.fileOpenBrowser.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.fileOpenBrowser.setActionCommand("Force Open Image Browser");
        this.fileOpenFolder = new MangoMenuItem(new ViewerMenuAction("Open DICOM Folder...", this.mango), "Open DICOM Folder (Toolbox)", 11, true);
        this.fileOpenRaw = new MangoMenuItem(new ViewerMenuAction("Open Raw Image...", this.mango), "Open Raw Image (Toolbox)", 11, true);
        this.fileAddNew = new MangoMenuItem(new ViewerMenuAction("Add New Image...", this.mango), "Add New Image (Toolbox)", 11, true);
        this.updateOpenMenu();
        this.optionsMenu = new MangoMenu("Options", 11, true);
        this.optionsMenu.addMenuListener(this);
        MangoMenuItem pluginAdd = new MangoMenuItem(new ViewerMenuAction("Plugin Manager...", this.mango), "Plugin Manager (Toolbox)", 11, true);
        MangoMenuItem addFilter = new MangoMenuItem(new ViewerMenuAction("Filter Manager...", this.mango), "Filter Manager (Toolbox)", 11, true);
        this.showConsole = new MangoMenuItem(new ViewerMenuAction("Show Console", this.mango), "Show Console (Toolbox)", 11, true);
        MangoMenuItem installUtilities = new MangoMenuItem(new ViewerMenuAction("Install Utilities...", this.mango), "Install Utilities (Toolbox)", 11, true);
        installUtilities.setEnabled(true);
        this.globalItem = new MangoCheckBoxMenuItem("Use Global Range", "Use Global Range (Toolbox)", 11, true);
        this.globalItem.setActionCommand("global");
        this.globalItem.addActionListener(this);
        this.globalItem.setSelected(false);
        this.linkedItem = new MangoCheckBoxMenuItem("Link Viewer Navigation", "Link Navigation (Toolbox)", 11, true);
        this.linkedItem.setActionCommand("linked");
        this.linkedItem.addActionListener(this);
        this.linkedItem.setSelected(false);
        this.linkedZoomItem = new MangoCheckBoxMenuItem("Link Viewer Zoom", "Link Zoom (Toolbox)", 11, true);
        this.linkedZoomItem.setActionCommand("linkedzoom");
        this.linkedZoomItem.addActionListener(this);
        this.linkedZoomItem.setSelected(false);
        this.linkedItemMain = new MangoCheckBoxMenuItem("Link Slice Navigation", "Link Slice Navigation (Toolbox)", 11, true);
        this.linkedItemMain.setActionCommand("linkedslice");
        this.linkedItemMain.addActionListener(this);
        this.linkedItemMain.setSelected(false);
        this.linkedItemSurface = new MangoCheckBoxMenuItem("Link Surface Navigation", "Link Surface Navigation (Toolbox)", 11, true);
        this.linkedItemSurface.setActionCommand("linkedsurface");
        this.linkedItemSurface.addActionListener(this);
        this.linkedItemSurface.setSelected(false);
        this.groupOverlayWindow = new MangoCheckBoxMenuItem("Use Group Overlay Range", "Use Group Overlay Range (Toolbox)", 11, true);
        this.groupOverlayWindow.setActionCommand("group");
        this.groupOverlayWindow.addActionListener(this);
        this.groupOverlayWindow.setSelected(false);
        this.fixedTimeseries = new MangoCheckBoxMenuItem("Use Fixed Series Range", "Use Fixed Series Range (Toolbox)", 11, true);
        this.fixedTimeseries.setActionCommand("fixedtimeseries");
        this.fixedTimeseries.addActionListener(this);
        this.fixedTimeseries.setSelected(this.fixedRange);
        MangoMenuItem preferences = new MangoMenuItem(new ViewerMenuAction("Preferences...", this.mango), "Preferences (Toolbox)", 11, true);
        MangoMenuItem addLUT = new MangoMenuItem(new ViewerMenuAction("Color Table Manager...", this.mango), "Color Table Manager (Toolbox)", 11, true);
        MangoMenuItem syncToIpad = new MangoMenuItem(new ViewerMenuAction("Sync to iPad...", this.mango), "Sync to iPad (Toolbox)", 11, true);
        MangoMenuItem scriptManagerItem = new MangoMenuItem(new ViewerMenuAction("Script Manager...", this.mango), "Script Manager (Toolbox)", 11, true);
        this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.optionsMenu.add(this.globalItem);
        this.optionsMenu.add(this.groupOverlayWindow);
        this.optionsMenu.add(this.fixedTimeseries);
        this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.optionsMenu.add(this.linkedItemMain);
        this.optionsMenu.add(this.linkedItem);
        this.optionsMenu.add(this.linkedZoomItem);
        this.optionsMenu.add(this.linkedItemSurface);
        this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.optionsMenu.add(addLUT);
        this.optionsMenu.add(addFilter);
        this.optionsMenu.add(pluginAdd);
        this.optionsMenu.add(scriptManagerItem);
        if (!Platform.VANILLA) {
            this.optionsMenu.add(installUtilities);
        }
        this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.optionsMenu.add(preferences);
        this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        if (Platform.MAC && !Platform.VANILLA) {
            this.optionsMenu.add(syncToIpad);
            this.optionsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        }
        this.windowsMenu = new MangoMenu(ACTION_WINDOW, 11, true);
        this.windowsMenu.addMenuListener(this);
        this.windowsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent me) {
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuSelected(MenuEvent me) {
                Toolbox.this.updateWindowMenu();
            }
        });
        this.windowMenuMinimizeAll = new MangoMenuItem(new ViewerMenuAction("Dock All", this.mango), "Minimize All (Toolbox)", 11, true);
        this.filePreviewFolder = new MangoMenuItem(new ViewerMenuAction("Show Image Browser", this.mango), null, 11, true);
        this.allToFront = new MangoMenuItem(new ViewerMenuAction("Bring All to Front", this.mango), "Bring All to Front (Toolbox)", 11, true);
        this.arrangeStack = new MangoMenuItem(new ViewerMenuAction("Stack Viewers", this.mango), "Stack Viewers (Toolbox)", 11, true);
        this.viewResults = new MangoMenuItem("Hide Results", "Toggle Results (Toolbox)", 11, true);
        this.viewResults.setAction(new ViewerMenuAction("Hide Results", this.mango));
        this.updateWindowMenu();
        this.quitMenu = new MangoMenu("Quit", 11, true);
        MangoMenuItem quit = new MangoMenuItem(new ViewerMenuAction("Quit", this.mango), null, 11, true);
        MangoMenuItem closeAllViewers = new MangoMenuItem(new ViewerMenuAction("Close All", this.mango), "Close All (Toolbox)", 11, true);
        this.quitMenu.add(closeAllViewers);
        this.quitMenu.add(quit);
        this.helpMenu = new MangoMenu("Help", 11, true);
        MangoMenuItem forumItem = new MangoMenuItem(new ViewerMenuAction("Questions, Bugs & Feedback", this.mango), null, 11, true);
        MangoMenuItem userGuide = new MangoMenuItem(new ViewerMenuAction("User Guide", this.mango), null, 11, true);
        userGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        MangoMenuItem faq = new MangoMenuItem(new ViewerMenuAction("Getting Started", this.mango), null, 11, true);
        MangoMenuItem about = new MangoMenuItem(new ViewerMenuAction("About Mango", this.mango), null, 11, true);
        MangoMenuItem checkForUpdate = new MangoMenuItem(new ViewerMenuAction("Check for Updates", this.mango), null, 11, true);
        checkForUpdate.setEnabled(true);
        MangoMenuItem videoDems = new MangoMenuItem(new ViewerMenuAction("Video Tutorials", this.mango), null, 11, true);
        videoDems.setEnabled(true);
        MangoMenuItem licenseAgreement = new MangoMenuItem(new ViewerMenuAction("License Agreement", this.mango), null, 11, true);
        licenseAgreement.setEnabled(true);
        MangoMenuItem navReference = new MangoMenuItem(new ViewerMenuAction("Mouse & Keyboard Reference", this.mango), "Mouse & Keyboard Reference (Toolbox)", 11, true);
        navReference.setEnabled(true);
        this.helpMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.helpMenu.add(about);
        this.helpMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.helpMenu.add(userGuide);
        this.helpMenu.add(videoDems);
        this.helpMenu.add(navReference);
        this.helpMenu.add(forumItem);
        this.helpMenu.add(faq);
        this.helpMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.helpMenu.add(checkForUpdate);
        this.helpMenu.add(licenseAgreement);
        this.helpMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.openMenu.setForeground(Color.BLACK);
        this.helpMenu.setForeground(Color.BLACK);
        this.optionsMenu.setForeground(Color.BLACK);
        this.windowsMenu.setForeground(Color.BLACK);
        this.quitMenu.setForeground(Color.BLACK);
        this.menu = new JMenuBar();
        this.menu.setLayout(new BoxLayout(this.menu, 0));
        this.menu.setPreferredSize(new Dimension(250, 15));
        this.menu.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.menu.add(this.openMenu);
        this.menu.add(Box.createHorizontalGlue());
        this.menu.add(this.optionsMenu);
        this.menu.add(Box.createHorizontalGlue());
        this.menu.add(this.helpMenu);
        this.menu.add(Box.createHorizontalGlue());
        this.menu.add(this.windowsMenu);
        this.menu.add(Box.createHorizontalGlue());
        this.menu.add(this.quitMenu);
    }

    private void makeOverlayPopupMenu() {
        this.popupOverlay = new JPopupMenu();
        this.popupOverlay.addPopupMenuListener(this);
    }

    private void makeROIEditPopupMenu() {
        MangoSquareMenuItem navItem = new MangoSquareMenuItem(MangoStyle.ICON_EDIT_ROI.get(0));
        navItem.setPreferredSize(new Dimension(30, 30));
        navItem.setBackground(POPUP_MENU_ITEM_COLOR);
        navItem.setActionCommand("Navigate Mode");
        navItem.addActionListener(this);
        this.roiSubMenuPaint = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(1));
        this.roiSubMenuPaint.setPreferredSize(new Dimension(30, 30));
        this.roiSubMenuPaint.setBackground(POPUP_MENU_ITEM_COLOR);
        this.roiSubMenuPaint.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.updateROIEditState(1);
                Toolbox.this.roiSubMenuPaint.getPopupMenu().setVisible(false);
                Toolbox.this.popupROIEdit.setVisible(false);
            }
        });
        this.editItem = new JCheckBoxMenuItem("Edit Mode");
        this.editItem.addActionListener(this);
        this.editItem.setFont(MENU_FONT);
        this.editItem.setSelected(true);
        this.paintItem = new JCheckBoxMenuItem("Paint Mode");
        this.paintItem.addActionListener(this);
        this.paintItem.setFont(MENU_FONT);
        this.eraseItem = new JCheckBoxMenuItem("Erase Mode");
        this.eraseItem.addActionListener(this);
        this.eraseItem.setFont(MENU_FONT);
        this.ellipseItem = new JCheckBoxMenuItem("Ellipse Tool");
        this.ellipseItem.addActionListener(this);
        this.ellipseItem.setFont(MENU_FONT);
        this.ellipseItem.setSelected(true);
        this.rectangleItem = new JCheckBoxMenuItem("Rectangle Tool");
        this.rectangleItem.addActionListener(this);
        this.rectangleItem.setFont(MENU_FONT);
        JMenuItem sliceRangeItem = new JMenuItem("Set Tool Slice Range...");
        sliceRangeItem.addActionListener(this);
        sliceRangeItem.setFont(MENU_FONT.deriveFont(2));
        JMenuItem incrementToolItem = new JMenuItem("Increase Tool Size");
        incrementToolItem.addActionListener(this);
        incrementToolItem.setFont(MENU_FONT.deriveFont(2));
        incrementToolItem.setAccelerator(KeyStroke.getKeyStroke(521, 0));
        JMenuItem decrementToolItem = new JMenuItem("Decrease Tool Size");
        decrementToolItem.addActionListener(this);
        decrementToolItem.setFont(MENU_FONT.deriveFont(2));
        decrementToolItem.setAccelerator(KeyStroke.getKeyStroke(45, 0));
        JMenu toolSizeMenu = new JMenu("Set Tool Size");
        toolSizeMenu.setFont(MENU_FONT.deriveFont(2));
        toolSizeMenu.add(incrementToolItem);
        toolSizeMenu.add(decrementToolItem);
        toolSizeMenu.add(sliceRangeItem);
        this.setRangeItem2 = new JMenuItem(ACTION_SET_EXPLICIT_VALUE_RANGE);
        this.setRangeItem2.addActionListener(this);
        this.setRangeItem2.setFont(MENU_FONT.deriveFont(2));
        this.roiSubMenuPaint.add(this.editItem);
        this.roiSubMenuPaint.add(this.paintItem);
        this.roiSubMenuPaint.add(this.eraseItem);
        this.roiSubMenuPaint.add(this.setRangeItem2);
        this.roiSubMenuPaint.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.roiSubMenuPaint.add(this.ellipseItem);
        this.roiSubMenuPaint.add(this.rectangleItem);
        this.roiSubMenuPaint.add(toolSizeMenu);
        this.roiSubMenuTrace = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(7));
        this.roiSubMenuTrace.setPreferredSize(new Dimension(30, 30));
        this.roiSubMenuTrace.setBackground(POPUP_MENU_ITEM_COLOR);
        this.roiSubMenuTrace.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.updateROIEditState(2);
                Toolbox.this.roiSubMenuTrace.getPopupMenu().setVisible(false);
                Toolbox.this.popupROIEdit.setVisible(false);
            }
        });
        this.rectangleDrawItem = new JCheckBoxMenuItem("Draw Region as Rectangle");
        this.rectangleDrawItem.addActionListener(this);
        this.rectangleDrawItem.setFont(MENU_FONT);
        this.rectangleDrawItem.setSelected(true);
        this.ellipseDrawItem = new JCheckBoxMenuItem("Draw Region as Ellipse");
        this.ellipseDrawItem.addActionListener(this);
        this.ellipseDrawItem.setFont(MENU_FONT);
        this.drawItem = new JCheckBoxMenuItem("Trace Region");
        this.drawItem.addActionListener(this);
        this.drawItem.setFont(MENU_FONT);
        this.lineItem = new JCheckBoxMenuItem("Trace Line");
        this.lineItem.addActionListener(this);
        this.lineItem.setFont(MENU_FONT);
        this.pointItem = new JCheckBoxMenuItem("Add Points");
        this.pointItem.addActionListener(this);
        this.pointItem.setFont(MENU_FONT);
        this.setRangeItem = new JMenuItem(ACTION_SET_EXPLICIT_VALUE_RANGE);
        this.setRangeItem.addActionListener(this);
        this.setRangeItem.setFont(MENU_FONT.deriveFont(2));
        this.roiSubMenuTrace.add(this.rectangleDrawItem);
        this.roiSubMenuTrace.add(this.ellipseDrawItem);
        this.roiSubMenuTrace.add(this.drawItem);
        this.roiSubMenuTrace.add(this.setRangeItem);
        this.roiSubMenuTrace.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.roiSubMenuTrace.add(this.lineItem);
        this.roiSubMenuTrace.add(this.pointItem);
        this.roiSubMenuMagic = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(12));
        this.roiSubMenuMagic.setPreferredSize(new Dimension(30, 30));
        this.roiSubMenuMagic.setBackground(POPUP_MENU_ITEM_COLOR);
        this.roiSubMenuMagic.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.updateROIEditState(3);
                Toolbox.this.roiSubMenuMagic.getPopupMenu().setVisible(false);
                Toolbox.this.popupROIEdit.setVisible(false);
            }
        });
        this.addItem = new JCheckBoxMenuItem("Add Region in Value Range");
        this.addItem.addActionListener(this);
        this.addItem.setFont(MENU_FONT);
        this.addItem.setSelected(true);
        this.preserveItem = new JCheckBoxMenuItem("Preserve Region");
        this.preserveItem.addActionListener(this);
        this.preserveItem.setFont(MENU_FONT);
        this.removeItem = new JCheckBoxMenuItem("Remove Region");
        this.removeItem.addActionListener(this);
        this.removeItem.setFont(MENU_FONT);
        this.dilateItem = new JCheckBoxMenuItem("Dilate/Erode Region");
        this.dilateItem.addActionListener(this);
        this.dilateItem.setFont(MENU_FONT);
        this.copyItem = new JCheckBoxMenuItem("Copy Region");
        this.copyItem.addActionListener(this);
        this.copyItem.setFont(MENU_FONT);
        this.magicWandRange = new JMenuItem("Set Relative Value Range...");
        this.magicWandRange.addActionListener(this);
        this.magicWandRange.setFont(MENU_FONT.deriveFont(2));
        this.setRangeItem3 = new JMenuItem(ACTION_SET_EXPLICIT_VALUE_RANGE);
        this.setRangeItem3.addActionListener(this);
        this.setRangeItem3.setFont(MENU_FONT.deriveFont(2));
        this.roiSubMenuMagic.add(this.addItem);
        this.roiSubMenuMagic.add(this.magicWandRange);
        this.roiSubMenuMagic.add(this.setRangeItem3);
        this.roiSubMenuMagic.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.roiSubMenuMagic.add(this.preserveItem);
        this.roiSubMenuMagic.add(this.removeItem);
        this.roiSubMenuMagic.add(this.dilateItem);
        this.roiSubMenuMagic.add(this.copyItem);
        this.roiSubMenuMagic.getPopupMenu().setLightWeightPopupEnabled(false);
        this.popupROIEdit = new JPopupMenu();
        this.popupROIEdit.add(navItem);
        this.popupROIEdit.add(this.roiSubMenuPaint);
        this.popupROIEdit.add(this.roiSubMenuTrace);
        this.popupROIEdit.add(this.roiSubMenuMagic);
        this.popupROIEdit.addPopupMenuListener(this);
    }

    private MangoTransparencySlider makeTransparencySlider(ScreenVolume screenVolume, JMenu alphaMenu) {
        MangoTransparencySlider slider = new MangoTransparencySlider(0, 0, 100, screenVolume.getTransparency(), this, true);
        slider.setScreenVolume(screenVolume);
        slider.setMenu(alphaMenu);
        slider.setMajorTickSpacing(10);
        slider.setSnapToTicks(true);
        slider.setBackground(MangoStyle.COLOR_BACKGROUND);
        slider.setPreferredSize(new Dimension(50, 40));
        slider.setFocusable(false);
        slider.setBorder(BorderFactory.createEmptyBorder(16, 8, 8, 8));
        slider.setEnabled(true);
        slider.setBackground(Color.WHITE);
        return slider;
    }

    private void notifyScreenVolListenersOfChange() {
        if (this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
            this.currentViewer.getBaseScreenVolume().notifyListenersOfChange(false);
        } else if (this.overlayGroup) {
            this.currentViewer.notifyOverlayListenersOfChange();
        } else {
            this.currentViewer.getCurrentScreenVolume().notifyListenersOfChange(false);
        }
    }

    private void resetSliderValues(boolean changeExtents) {
        this.resetSliderValues(null, changeExtents);
    }

    private void resetSliderValues(ScreenVolume aScreenVolVal, boolean changeExtents) {
        ScreenVolume aScreenVol = aScreenVolVal;
        if (aScreenVol == null) {
            aScreenVol = this.currentViewer.getCurrentScreenVolume();
        }
        if (this.global) {
            if (changeExtents) {
                this.globalScreenMin = this.mango.findGlobalMin();
                this.globalScreenMax = this.mango.findGlobalMax();
                this.mango.updateScreenRatios();
            }
            this.mango.updateScreenSlices();
        } else {
            if (changeExtents) {
                aScreenVol.setScreenMin(aScreenVol.getVolume().getDisplayMin());
                aScreenVol.setScreenMax(aScreenVol.getVolume().getDisplayMax());
                aScreenVol.getVolume().setHeaderAsDirty();
                aScreenVol.setNegativeState(false);
                aScreenVol.updateScreenRatio();
            }
            this.currentViewer.updateScreenSlices();
            this.currentViewer.updateViewer();
        }
        if (aScreenVol == this.currentViewer.getCurrentScreenVolume()) {
            this.slider.setValueAt(0, 0);
            this.slider.setValueAt(127, 1);
            this.slider.setValueAt(255, 2);
            this.updateLUTInfo();
            this.slider.updateThumbLocations();
            this.slider.repaint();
        }
    }

    private void roiColorChosen(int index) {
        this.currentViewer.recordAction("setRoiColor", new String[]{String.valueOf(index)});
        this.currentViewer.setROIColor(index);
        this.updateMangoColorButton();
    }

    private void unsetGlobalState() {
        if (this.currentViewer != null) {
            if (this.currentViewer.getCurrentScreenVolume().isBaseImage()) {
                this.resetSliderValues();
            }
            this.mango.resetBaseImageLUT();
            this.mango.updateScreenRatios();
            this.mango.updateScreenSlices();
            this.updateCurrentState();
            this.updateSlider();
        }
    }

    private void updateBaseImageIconLUTImage() {
        if (this.currentViewer != null) {
            this.currentViewer.getBaseScreenVolume().getLookupTableManager().getOp().filter(this.baseImage, this.baseImageFiltered);
        } else {
            this.lutManagerDefault.getOp().filter(this.baseImage, this.baseImageFiltered);
        }
    }

    private void updateBottomPanel() {
        if (this.scriptPaused) {
            this.cardLayout.show(this.cardPanel, CARD_CONTINUE);
        } else if (this.progressBarsShowing > 0) {
            this.cardLayout.show(this.cardPanel, CARD_PROGRESS);
        } else {
            this.cardLayout.show(this.cardPanel, CARD_ORIGINAL);
        }
    }

    private void updateCoordinatePopupMenu() {
        this.popupCoordinate.removeAll();
        MangoSquareMenu indexOption = new MangoSquareMenu(MangoStyle.ICON_COORDINATES.get(0));
        indexOption.setPreferredSize(new Dimension(30, 30));
        indexOption.setBackground(POPUP_MENU_ITEM_COLOR);
        indexOption.setContentAreaFilled(true);
        indexOption.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.popupCoordinate.setVisible(false);
                Toolbox.this.updateCoordinate(0);
            }
        });
        this.worldOption = new MangoSquareMenu(MangoStyle.ICON_COORDINATES.get(2));
        this.worldOption.setPreferredSize(new Dimension(30, 30));
        this.worldOption.setBackground(POPUP_MENU_ITEM_COLOR);
        this.worldOption.setContentAreaFilled(true);
        this.worldOption.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                Toolbox.this.worldOption.getPopupMenu().setVisible(false);
                Toolbox.this.popupCoordinate.setVisible(false);
                Toolbox.this.updateCoordinate(4);
            }
        });
        JMenu atlasMenu = new JMenu("Atlas");
        atlasMenu.setFont(MENU_FONT);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(NO_ATLAS_NAME);
        item.setFont(MENU_FONT);
        item.setActionCommand("atlasNone");
        item.addActionListener(this);
        item.setSelected(this.currentAtlas == null);
        atlasMenu.add(item);
        for (int ctr = 0; ctr < this.allAtlases.size(); ++ctr) {
            Atlas atlas = this.allAtlases.get(ctr);
            String name = PluginManagerDialog.getPluginName(atlas);
            item = new JCheckBoxMenuItem(name);
            item.setFont(MENU_FONT);
            item.setActionCommand("atlas" + name);
            item.addActionListener(this);
            item.setSelected(this.currentAtlas != null && PluginManagerDialog.getPluginName(this.currentAtlas).equals(name));
            atlasMenu.add(item);
        }
        this.worldOption.add(atlasMenu);
        this.popupCoordinate.add(indexOption);
        this.popupCoordinate.add(this.worldOption);
        this.popupCoordinate.addPopupMenuListener(this);
    }

    private void updateLabelsPanel(int numLabelsVal) {
        int numLabels = numLabelsVal;
        numLabels = Math.min(numLabels, 4);
        this.labelsPanel.removeAll();
        if (this.applet) {
            JPanel coordPanel = new JPanel(new GridLayout(1, Math.min(4, numLabels)));
            if (numLabels >= 1) {
                coordPanel.add(this.labelsTD1);
            }
            if (numLabels >= 3) {
                coordPanel.add(this.labelsTD3);
            }
            if (numLabels >= 2) {
                coordPanel.add(this.labelsTD2);
            }
            if (numLabels >= 4) {
                coordPanel.add(this.labelsTD4);
            }
            this.labelsPanel.setPreferredSize(START_SIZE_COMPACT_LABELS);
            this.labelsPanel.add((Component)coordPanel, "Center");
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this.labelsPanel, (Color)Color.BLACK);
        } else {
            JPanel topPanel = null;
            JPanel bottomPanel = null;
            topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 0));
            topPanel.setBackground(Color.BLACK);
            JPanel labelPanel1 = new JPanel();
            labelPanel1.setLayout(new BoxLayout(labelPanel1, 0));
            labelPanel1.add(Box.createHorizontalStrut(4));
            labelPanel1.add(this.labelsTD1);
            labelPanel1.add(Box.createHorizontalGlue());
            labelPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, labelPanel1.getPreferredSize().height));
            labelPanel1.setMinimumSize(new Dimension(1, labelPanel1.getPreferredSize().height));
            topPanel.add(labelPanel1);
            if (numLabels >= 3) {
                JPanel labelPanel2 = new JPanel();
                labelPanel2.setLayout(new BoxLayout(labelPanel2, 0));
                labelPanel2.add(Box.createHorizontalGlue());
                labelPanel2.add(this.labelsTD2);
                labelPanel2.add(Box.createHorizontalStrut(4));
                labelPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, labelPanel2.getPreferredSize().height));
                labelPanel2.setMinimumSize(new Dimension(1, labelPanel2.getPreferredSize().height));
                topPanel.add(labelPanel2);
            }
            if (numLabels >= 2) {
                bottomPanel = new JPanel();
                bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
                bottomPanel.setBackground(Color.BLACK);
                JPanel labelPanel3 = new JPanel();
                labelPanel3.setLayout(new BoxLayout(labelPanel3, 0));
                labelPanel3.add(Box.createHorizontalStrut(4));
                labelPanel3.add(this.labelsTD3);
                labelPanel3.add(Box.createHorizontalGlue());
                labelPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, labelPanel3.getPreferredSize().height));
                labelPanel3.setMinimumSize(new Dimension(1, labelPanel3.getPreferredSize().height));
                bottomPanel.add(labelPanel3);
                if (numLabels >= 4) {
                    JPanel labelPanel4 = new JPanel();
                    labelPanel4.setLayout(new BoxLayout(labelPanel4, 0));
                    labelPanel4.add(Box.createHorizontalGlue());
                    labelPanel4.add(this.labelsTD4);
                    labelPanel4.add(Box.createHorizontalStrut(4));
                    labelPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, labelPanel4.getPreferredSize().height));
                    labelPanel4.setMinimumSize(new Dimension(1, labelPanel4.getPreferredSize().height));
                    bottomPanel.add(labelPanel4);
                }
            }
            JPanel labelsPanelIn = new JPanel();
            labelsPanelIn.setLayout(new BoxLayout(labelsPanelIn, 1));
            labelsPanelIn.add(Box.createVerticalGlue());
            labelsPanelIn.add(topPanel);
            if (bottomPanel != null) {
                labelsPanelIn.add(Box.createVerticalGlue());
                labelsPanelIn.add(bottomPanel);
            }
            labelsPanelIn.add(Box.createVerticalGlue());
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)labelsPanelIn, (Color)Color.BLACK);
            this.labelsPanel.add((Component)labelsPanelIn, "Center");
        }
        if (numLabels == 1) {
            this.labelsTD1.setForeground(Color.WHITE);
        } else if (numLabels == 2) {
            this.labelsTD1.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD3.setForeground(Color.WHITE);
        } else if (numLabels == 3) {
            this.labelsTD1.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD3.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD2.setForeground(Color.WHITE);
        } else if (numLabels == 4) {
            this.labelsTD1.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD3.setForeground(MangoStyle.COLOR_MANGO_ORANGE);
            this.labelsTD2.setForeground(Color.WHITE);
            this.labelsTD4.setForeground(Color.WHITE);
        }
        this.labelsPanel.validate();
    }

    public void updateMangoColorButton() {
        this.roiButton.setColor(this.currentViewer.getRoiColor(), this.currentViewer.getROIManager().getLabel(this.currentViewer.getRoiColor(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(this.currentViewer.getRoiColor(), this.currentViewer.getROIManager().getBuffer().getMaximumColors())));
    }

    private void updateMenu() {
        this.globalItem.setSelected(this.global);
        this.linkedItem.setSelected(this.mango.getViewerSyncer().getType() == 2);
        this.linkedItemMain.setSelected(this.mango.getViewerSyncer().getType() == 1);
        this.linkedZoomItem.setSelected(this.mango.getViewerSyncer().isZoom());
        this.linkedItemSurface.setSelected(this.mango.getSurfaceSyncer().isSynced());
        this.updateOpenMenu();
    }

    private void updateMouseLabelOutOfBounds(boolean withNumbers) {
        this.mousePlane = -1;
        if (withNumbers) {
            this.mouseX.setText("0");
            this.mouseY.setText("0");
            this.mouseZ.setText("0");
            this.mouseValue.setText("0");
        } else {
            this.mouseX.setText("");
            this.mouseY.setText("");
            this.mouseZ.setText("");
            this.mouseValue.setText("");
        }
        this.labelsTD1.setText(" ");
        this.labelsTD2.setText(" ");
        this.labelsTD3.setText(" ");
        this.labelsTD4.setText(" ");
    }

    private void updateOpenMenu() {
        this.openMenu.removeAll();
        LinkedList<URI> recentFiles = this.mango.getRecentFiles();
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.openMenu.add(this.fileOpen);
        this.openMenu.add(this.fileSample);
        this.openMenu.add(this.fileOpenURL);
        this.openMenu.add(this.fileOpenFolder);
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.openMenu.add(this.fileOpenBrowser);
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.openMenu.add(this.fileOpenRaw);
        this.openMenu.add(this.fileAddNew);
        this.openMenu.add(this.fileEditHeader);
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.openMenu.add(new JSeparator());
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        for (int ctr = 0; ctr < recentFiles.size(); ++ctr) {
            URI aFile = recentFiles.get(ctr);
            String filename = FileUtilities.getName((URI)aFile);
            if (filename == null || filename.equals("null") || filename.equals("")) {
                filename = aFile.toString();
            }
            JMenuItem mi = new JMenuItem(new ViewerMenuAction(filename, this.mango, recentFiles.get(ctr)));
            mi.setFont(new Font("SansSerif", 0, 11));
            this.openMenu.add(mi);
        }
        this.openMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
    }

    private void updateOverlayButtonIcons() {
        this.updateBaseImageIconLUTImage();
        this.baseImageIcon = new ImageIcon(this.baseImageFiltered);
        this.updateOverlayImageIconLUTImages();
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        this.updateOverlayPopupMenu();
    }

    private void updateOverlayImageIconLUTImages() {
        if (this.currentViewer != null) {
            ScreenVolume[] allOverlays = this.currentViewer.getOverlayManager().getAllOverlays();
            for (int ctr = 0; ctr < 8; ++ctr) {
                if (allOverlays[ctr] == null) continue;
                allOverlays[ctr].getLookupTableManager().getOp().filter(this.overlayImages[ctr], this.overlayImagesFiltered[ctr]);
            }
        }
    }

    private void updateROIEditState(int modeChanged) {
        if (this.ellipseItem.isSelected()) {
            if (this.editItem.isSelected()) {
                this.roiPaintMode = 1;
            } else if (this.eraseItem.isSelected()) {
                this.roiPaintMode = 2;
            } else if (this.paintItem.isSelected()) {
                this.roiPaintMode = 3;
            }
        } else if (this.rectangleItem.isSelected()) {
            if (this.editItem.isSelected()) {
                this.roiPaintMode = 4;
            } else if (this.eraseItem.isSelected()) {
                this.roiPaintMode = 5;
            } else if (this.paintItem.isSelected()) {
                this.roiPaintMode = 6;
            }
        }
        this.roiSubMenuPaint.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiPaintMode));
        if (this.rectangleDrawItem.isSelected()) {
            this.roiTraceMode = 7;
        } else if (this.ellipseDrawItem.isSelected()) {
            this.roiTraceMode = 8;
        } else if (this.drawItem.isSelected()) {
            this.roiTraceMode = 9;
        } else if (this.lineItem.isSelected()) {
            this.roiTraceMode = 10;
        } else if (this.pointItem.isSelected()) {
            this.roiTraceMode = 11;
        }
        this.roiSubMenuTrace.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiTraceMode));
        if (this.addItem.isSelected()) {
            this.roiMagicMode = 12;
        } else if (this.preserveItem.isSelected()) {
            this.roiMagicMode = 13;
        } else if (this.removeItem.isSelected()) {
            this.roiMagicMode = 14;
        } else if (this.dilateItem.isSelected()) {
            this.roiMagicMode = 15;
        } else if (this.copyItem.isSelected()) {
            this.roiMagicMode = 17;
        }
        this.roiSubMenuMagic.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiMagicMode));
        int oldMode = this.roiEditMode;
        if (modeChanged == 0) {
            this.roiEditMode = 0;
        } else if (modeChanged == 1) {
            this.roiEditMode = this.roiPaintMode;
        } else if (modeChanged == 2) {
            this.roiEditMode = this.roiTraceMode;
        } else if (modeChanged == 3) {
            this.roiEditMode = this.roiMagicMode;
        }
        this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.roiEditMode));
        if (oldMode != this.roiEditMode) {
            this.mango.clearActivePolylines();
            this.mango.setRecentTool(this.roiEditMode);
        }
        this.mango.recordAction("setTool", new String[]{String.valueOf(this.roiEditMode)});
        this.popupROIEdit.setVisible(false);
    }

    private void updateSlider(ScreenVolume aScreenVol) {
        boolean rgb = false;
        if (this.currentViewer != null) {
            this.slider.setValueAt(aScreenVol.getMinLUT(), 0);
            this.slider.setValueAt(aScreenVol.getMaxLUT(), 2);
            this.slider.setValueAt((this.slider.getValueAt(2) - this.slider.getValueAt(0)) / 2 + this.slider.getValueAt(0), 1);
            this.slider.updateThumbLocations();
            this.updateSliderImage();
            this.updateTextFields();
            if (aScreenVol.isLogical()) {
                this.slider.setEnabled(false, false);
                this.updateLUTInfo();
                aScreenVol.getLookupTableManager().updateLUT();
            } else {
                this.slider.setEnabled(true, true);
            }
            rgb = this.currentViewer.isRGB();
        }
        this.slider.setRGB(rgb);
        ((BasicMThumbSliderUI)this.slider.getUI()).recalculateIfInsetsChangedPublic();
        this.slider.validate();
        this.slider.updateUI();
        this.slider.repaint();
    }

    private void updateSliderImage() {
        if (this.currentViewer != null) {
            this.currentViewer.getCurrentScreenVolume().getLookupTableManager().getOp().filter(this.sliderImage, this.sliderImageFiltered);
        } else {
            this.lutManagerDefault.getOp().filter(this.sliderImage, this.sliderImageFiltered);
        }
    }

    private void updateTDPanel() {
        if (!this.applet) {
            Runnable updateTDPanelRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!Toolbox.this.tdLabelPanelAdded) {
                        int compIndex = 0;
                        int compCount = Toolbox.this.mainPanelSub.getComponentCount();
                        for (int ctr = 0; ctr < compCount; ++ctr) {
                            if (Toolbox.this.mainPanelSub.getComponent(ctr) != Toolbox.this.coordinatePanel) continue;
                            compIndex = ctr;
                            break;
                        }
                        Toolbox.this.mainPanelSub.add((Component)Toolbox.this.labelsPanel, compIndex + 1);
                        Toolbox.this.setSize((int)Toolbox.this.getSize().getWidth(), (int)(Toolbox.this.getSize().getHeight() + (double)Toolbox.START_SIZE_TOOLBAR_TOP.height));
                        Toolbox.this.tdLabelPanelAdded = true;
                        Toolbox.this.mainPanelSub.revalidate();
                        Toolbox.this.mainPanelSub.repaint();
                        Toolbox.this.validate();
                        Toolbox.this.repaint();
                    } else {
                        int compIndex = 0;
                        int compCount = Toolbox.this.mainPanelSub.getComponentCount();
                        for (int ctr = 0; ctr < compCount; ++ctr) {
                            if (Toolbox.this.mainPanelSub.getComponent(ctr) != Toolbox.this.labelsPanel) continue;
                            compIndex = ctr;
                            break;
                        }
                        Toolbox.this.mainPanelSub.remove(compIndex);
                        Toolbox.this.setSize((int)Toolbox.this.getSize().getWidth(), (int)(Toolbox.this.getSize().getHeight() - (double)Toolbox.START_SIZE_TOOLBAR_TOP.height));
                        Toolbox.this.tdLabelPanelAdded = false;
                        Toolbox.this.mainPanel.revalidate();
                        Toolbox.this.mainPanel.repaint();
                        Toolbox.this.validate();
                        Toolbox.this.repaint();
                    }
                }
            };
            SwingWidgetUtilities.invokeLaterSafely((Runnable)updateTDPanelRunnable);
        }
    }

    private void updateTextFieldState() {
        if (this.currentViewer != null && !this.currentViewer.isRGB()) {
            this.textFieldMin.setEnabled(true);
            this.textFieldMax.setEnabled(true);
        } else {
            this.textFieldMin.setEnabled(false);
            this.textFieldMax.setEnabled(false);
        }
    }

    private void updateWindowMenu() {
        boolean resultsShowing = this.mango.getResultsManager().isVisible();
        boolean hasSliceViewers = this.mango.getAllViewers().size() > 0;
        boolean hasToolboxAssociatedWindows = this.associatedWindows.size() > 0;
        this.viewResults.setText(resultsShowing ? "Hide Results" : "Show Results");
        this.showConsole.setText(this.mango.isShowingConsole() ? "Hide Console" : "Show Console");
        this.windowsMenu.removeAll();
        this.windowsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowsMenu.add(this.windowMenuMinimizeAll);
        this.windowsMenu.add(this.allToFront);
        this.windowsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowsMenu.add(this.arrangeStack);
        if (hasSliceViewers || hasToolboxAssociatedWindows) {
            this.windowsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        }
        if (hasSliceViewers) {
            Vector<SliceViewer> allViewers = this.mango.getAllViewers();
            for (SliceViewer current : allViewers) {
                if (!current.isReady()) break;
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ViewerMenuAction(ACTION_WINDOW, this.mango, current, current.getFrame()));
                item.setText(current.getImageTitle());
                item.setFont(new Font("SansSerif", 0, 11));
                this.windowsMenu.add(item);
                item.setSelected(current.isFrameActive());
                ViewerAssociated[] otherWindows = current.getAllAssociatedWindows();
                if (otherWindows == null) continue;
                for (ViewerAssociated otherWindow : otherWindows) {
                    item = new JCheckBoxMenuItem(new ViewerMenuAction(ACTION_WINDOW, this.mango, current, otherWindow.getWindow()));
                    item.setText("  " + otherWindow.getDescription());
                    item.setFont(new Font("SansSerif", 0, 11));
                    this.windowsMenu.add(item);
                    item.setSelected(otherWindow.getWindow().isActive());
                }
            }
        }
        if (hasToolboxAssociatedWindows) {
            for (ToolboxAssociated win : this.associatedWindows) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ViewerMenuAction(ACTION_WINDOW, this.mango, win.getWindow()));
                item.setText(win.getDescription());
                item.setFont(new Font("SansSerif", 0, 11));
                this.windowsMenu.add(item);
                item.setSelected(win.getWindow().isActive());
            }
        }
        this.updateImageBrowserItem();
        this.windowsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowsMenu.add(this.filePreviewFolder);
        this.windowsMenu.add(this.viewResults);
        this.windowsMenu.add(this.showConsole);
        this.windowsMenu.add(new JToolBar.Separator(new Dimension(0, 8)));
        this.windowsMenu.validate();
    }

    private String validateLabel(String labelVal, int labelIndex, int maxLabels) {
        String label = labelVal;
        int length = label.length();
        if (length == 0) {
            label = " ";
        } else if (maxLabels <= 2) {
            if (length > 45) {
                label = label.substring(0, 45);
            }
        } else if (maxLabels == 3) {
            if (labelIndex <= 2) {
                if (length > 23) {
                    label = label.substring(0, 23);
                }
            } else if (length > 45) {
                label = label.substring(0, 45);
            }
        } else if (length > 23) {
            label = label.substring(0, 23);
        }
        return label;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        Window window = we.getWindow();
        if (window instanceof ToolboxAssociated) {
            ToolboxAssociated ta = (ToolboxAssociated)((Object)window);
            this.associatedWindows.remove(ta);
        }
        this.updateFocusState();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void openInspector() {
        this.currentViewer.showROIInspector();
    }
}

