/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.window;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.keyboard.KeyboardMap;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.menus.SurfaceViewerMenu;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SurfaceFrame
extends JFrame
implements WindowListener,
ViewerAssociated,
ComponentListener {
    private JLabel panInfoLabel;
    private JLabel panLabel;
    private JLabel rotateLabel;
    private JLabel rotationInfoLabel;
    private JPanel infoPanel;
    private JPanel measurePanel;
    private JPanel positionPanel;
    private JLabel rulerLabel;
    private JLabel rulerInfoLabel;
    private JLabel angleLabel;
    private JLabel angleInfoLabel;
    private JPanel rulerPanel;
    private JPanel anglePanel;
    private SurfaceViewer renderer;
    private SurfaceViewerMenu menu;
    private boolean sticky;
    private int heightDecorationSize;
    private int widthDecorationSize;
    private static final long serialVersionUID = 1L;
    public static final Color INFO_COLOR_DARK = new Color(13158);
    public static final Color INFO_COLOR_LIGHT = new Color(16580014);
    public static final Font LABEL_FONT = new Font("SansSerif", 1, 12);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(2, true);
    public static final String TITLE_PREFIX = "Surface";
    public static final double INCREMENT_FACTOR = 0.1;
    public static final int INNER_PAD = 4;
    public static final int MINIMUM_WIDTH = 250;

    public SurfaceFrame(final SurfaceViewer renderer, final Point loc, Dimension dim, String name) {
        this.renderer = renderer;
        this.menu = new SurfaceViewerMenu(renderer);
        this.setJMenuBar(this.menu.create());
        final JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        contentPanel.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.setContentPane(contentPanel);
        KeyboardMap.createKeyboardMap(this.getRootPane(), renderer.getViewer());
        this.addComponentListener(this);
        this.setDefaultCloseOperation(1);
        this.updateWindowTitle(name);
        this.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.doNewSize(dim.width, true);
        this.changeSize(dim.width);
        this.setResizable(false);
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                contentPanel.add((Component)renderer.getCanvas(), "Center");
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SurfaceFrame.this.setLocation(loc);
                            SurfaceFrame.this.setVisible(true);
                            if (!renderer.getViewer().getMango().isApplet()) {
                                renderer.getViewer().getViewerFrame().addStickyWindow(renderer);
                            }
                            SurfaceFrame.this.requestFocus();
                            renderer.getCanvas().requestFocusInWindow();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    AppLogger.error((Throwable)ex);
                }
            }
        }, "SurfaceFrame<init> Thread");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(workThread, 500L, TimeUnit.MILLISECONDS);
    }

    public void addPluginMenuItem(String string) {
        this.menu.addPluginMenuItem(string);
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
        if (!this.renderer.getViewer().getMango().isApplet()) {
            this.renderer.getViewer().getViewerFrame().removeStickyWindow(this.renderer);
            this.setSticky(false);
        }
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
        if (!this.renderer.getViewer().getMango().isApplet() && this.isSticky()) {
            this.renderer.getViewer().doSticky();
        }
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        if (!this.renderer.getViewer().getMango().isApplet()) {
            this.renderer.getViewer().getViewerFrame().addStickyWindow(this.renderer);
        }
    }

    @Override
    public void componentShown(ComponentEvent ce) {
    }

    public void decrementSize() {
        this.doNewSize(this.checkSize((int)Math.round((double)this.getSize().width - (double)this.getSize().width * 0.1)), false);
        this.updateInfoPanel(this.renderer.getPreferences().isShowPosition(), this.renderer.getPreferences().isShowRuler() || this.renderer.getPreferences().isShowAngle());
    }

    @Override
    public String getDescription() {
        return this.getTitle();
    }

    public JMenuItem getMenuItem(String string) {
        return this.menu.getMenuItem(string);
    }

    @Override
    public SliceViewer getViewer() {
        return this.renderer.getViewer();
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public void incrementSize() {
        this.doNewSize(this.checkSize((int)Math.round((double)this.getSize().width + (double)this.getSize().width * 0.1)), false);
        this.updateInfoPanel(this.renderer.getPreferences().isShowPosition(), this.renderer.getPreferences().isShowRuler() || this.renderer.getPreferences().isShowAngle());
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void maximize() {
        this.doNewSize(this.checkSize(Integer.MAX_VALUE), false);
        this.setLocation(new Point(this.getLocation().x, DisplayUtils.findInsetsOfDisplay((int)DisplayUtils.findCurrentDisplayIndex((Component)this)).top));
        this.updateInfoPanel(this.renderer.getPreferences().isShowPosition(), this.renderer.getPreferences().isShowRuler() || this.renderer.getPreferences().isShowAngle());
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void updateInfoPanel(boolean showPosition, boolean showMeasurements) {
        int width = this.getSize().width;
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        }
        if (showPosition && showMeasurements) {
            this.infoPanel.setPreferredSize(new Dimension(width, 50));
        } else {
            this.infoPanel.setPreferredSize(new Dimension(width, 25));
        }
        if (showPosition) {
            Component[] comps;
            if (this.positionPanel == null) {
                this.positionPanel = new JPanel();
                this.positionPanel.setPreferredSize(new Dimension(width, 25));
                this.panLabel = new JLabel(width > 400 ? "Translation:" : "Trans:");
                this.panLabel.setForeground(Color.WHITE);
                this.panLabel.setFont(LABEL_FONT);
                this.panInfoLabel = new JLabel(" -00.000  -00.000  -00.000");
                this.panInfoLabel.setFont(LABEL_FONT);
                JPanel panPanel = new JPanel();
                panPanel.setLayout(new BoxLayout(panPanel, 0));
                panPanel.add(this.panLabel);
                panPanel.add(Box.createHorizontalStrut(2));
                panPanel.add(this.panInfoLabel);
                this.rotateLabel = new JLabel(width > 400 ? "Rotation:" : "Rot:");
                this.rotateLabel.setForeground(Color.WHITE);
                this.rotateLabel.setFont(LABEL_FONT);
                this.rotationInfoLabel = new JLabel(" -00.000  -00.000  -00.000");
                this.rotationInfoLabel.setFont(LABEL_FONT);
                JPanel rotPanel = new JPanel();
                rotPanel.setLayout(new BoxLayout(rotPanel, 0));
                rotPanel.add(this.rotateLabel);
                rotPanel.add(Box.createHorizontalStrut(2));
                rotPanel.add(this.rotationInfoLabel);
                this.positionPanel.setLayout(new BoxLayout(this.positionPanel, 0));
                this.positionPanel.add(Box.createHorizontalGlue());
                this.positionPanel.add(panPanel);
                this.positionPanel.add(Box.createHorizontalGlue());
                this.positionPanel.add(rotPanel);
                this.positionPanel.add(Box.createHorizontalGlue());
            }
            this.panLabel.setText(width > 400 ? "Translation:" : "Trans:");
            this.rotateLabel.setText(width > 400 ? "Rotation:" : "Rot:");
            boolean found = false;
            for (Component comp : comps = this.infoPanel.getComponents()) {
                if (comp != this.positionPanel) continue;
                found = true;
                break;
            }
            if (!found) {
                this.infoPanel.add(this.positionPanel);
            }
        } else if (this.positionPanel != null) {
            this.infoPanel.remove(this.positionPanel);
        }
        if (showMeasurements) {
            Component[] comps;
            if (this.measurePanel == null) {
                this.measurePanel = new JPanel();
                this.measurePanel.setPreferredSize(new Dimension(width, 25));
                this.rulerLabel = new JLabel("Ruler Length:");
                this.rulerLabel.setForeground(Color.WHITE);
                this.rulerLabel.setFont(LABEL_FONT);
                this.rulerInfoLabel = new JLabel(" 0.0");
                this.rulerInfoLabel.setFont(LABEL_FONT);
                this.rulerPanel = new JPanel();
                this.rulerPanel.setLayout(new BoxLayout(this.rulerPanel, 0));
                this.rulerPanel.add(this.rulerLabel);
                this.rulerPanel.add(Box.createHorizontalStrut(2));
                this.rulerPanel.add(this.rulerInfoLabel);
                this.angleLabel = new JLabel("Angle:");
                this.angleLabel.setForeground(Color.WHITE);
                this.angleLabel.setFont(LABEL_FONT);
                this.angleInfoLabel = new JLabel(" 0.0");
                this.angleInfoLabel.setFont(LABEL_FONT);
                this.anglePanel = new JPanel();
                this.anglePanel.setLayout(new BoxLayout(this.anglePanel, 0));
                this.anglePanel.add(this.angleLabel);
                this.anglePanel.add(Box.createHorizontalStrut(2));
                this.anglePanel.add(this.angleInfoLabel);
                this.measurePanel.setLayout(new BoxLayout(this.measurePanel, 0));
            }
            this.measurePanel.removeAll();
            this.measurePanel.add(Box.createHorizontalGlue());
            boolean added = false;
            if (this.renderer.getPreferences().isShowRuler()) {
                if (added) {
                    this.measurePanel.add(Box.createHorizontalGlue());
                }
                added = true;
                this.measurePanel.add(this.rulerPanel);
            }
            if (this.renderer.getPreferences().isShowAngle()) {
                if (added) {
                    this.measurePanel.add(Box.createHorizontalGlue());
                }
                added = true;
                this.measurePanel.add(this.anglePanel);
            }
            this.measurePanel.add(Box.createHorizontalGlue());
            boolean found = false;
            for (Component comp : comps = this.infoPanel.getComponents()) {
                if (comp != this.measurePanel) continue;
                found = true;
                break;
            }
            if (!found) {
                this.infoPanel.add(this.measurePanel);
            }
        } else if (this.measurePanel != null) {
            this.infoPanel.remove(this.measurePanel);
        }
        this.updateInfoPanelColors();
        if (showPosition || showMeasurements) {
            this.getContentPane().add((Component)this.infoPanel, "North");
        } else {
            this.getContentPane().remove(this.infoPanel);
        }
        this.doNewSize(this.getSize().width, false);
        this.validate();
        this.repaint();
    }

    public void updateInfoPanelColors() {
        SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this.infoPanel, (Color)this.renderer.getBackgroundColor());
        if (this.positionPanel != null) {
            this.panInfoLabel.setForeground(this.renderer.getBackgroundColorOpposite());
            this.rotationInfoLabel.setForeground(this.renderer.getBackgroundColorOpposite());
            if (this.renderer.isBackgroundColorDark()) {
                this.panLabel.setForeground(INFO_COLOR_LIGHT);
                this.rotateLabel.setForeground(INFO_COLOR_LIGHT);
            } else {
                this.panLabel.setForeground(INFO_COLOR_DARK);
                this.rotateLabel.setForeground(INFO_COLOR_DARK);
            }
        }
        if (this.measurePanel != null) {
            this.rulerInfoLabel.setForeground(this.renderer.getBackgroundColorOpposite());
            this.angleInfoLabel.setForeground(this.renderer.getBackgroundColorOpposite());
            this.rulerLabel.setForeground(ROIColor.getColor(5));
            this.angleLabel.setForeground(ROIColor.getColor(4));
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
        if (this.renderer != null) {
            Mango.getInstance().getToolBox().updateFocusState();
            Mango.getInstance().getToolBox().updateEnabledItems();
            this.renderer.updateCursor();
        }
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
        Mango.getInstance().getToolBox().updateTextFields();
        Mango.getInstance().getToolBox().closePopups();
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
        Mango.getInstance().getToolBox().setState(0);
        Mango.getInstance().getToolBox().toFront();
        Mango.getInstance().getToolBox().updateFocusState();
        Mango.getInstance().getToolBox().updateEnabledItems();
    }

    @Override
    public void windowIconified(WindowEvent we) {
        Mango.getInstance().getToolBox().updateFocusState();
        Mango.getInstance().getToolBox().updateEnabledItems();
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    public void clear() {
        this.setVisible(false);
        this.renderer = null;
        this.menu = null;
    }

    public void updatePositionInfo(double shiftX, double shiftY, double zoom, double rotX, double rotY, double rotZ) {
        if (this.panInfoLabel != null) {
            this.panInfoLabel.setText(" " + FORMATTER.format(shiftX) + "  " + FORMATTER.format(shiftY) + "  " + FORMATTER.format(zoom));
            this.rotationInfoLabel.setText(" " + FORMATTER.format(rotX) + "  " + FORMATTER.format(rotY) + "  " + FORMATTER.format(rotZ));
            this.panInfoLabel.setPreferredSize(this.panInfoLabel.getMaximumSize());
            this.rotationInfoLabel.setPreferredSize(this.rotationInfoLabel.getMaximumSize());
        }
    }

    public void updateMeasurementIInfo(double rulerLength, double angle) {
        this.rulerInfoLabel.setText(" " + FORMATTER.format(rulerLength));
        this.angleInfoLabel.setText(" " + FORMATTER.format(angle) + "\u00b0");
    }

    private void changeSize(int currentWidth) {
        this.doNewSize(this.checkSize(currentWidth), false);
    }

    private int checkSize(int currentWidthVal) {
        int currentWidth = currentWidthVal;
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(this);
        Dimension displaySize = DisplayUtils.findSizeOfDisplay(displayIndex);
        Insets displayInsets = DisplayUtils.findInsetsOfDisplay(displayIndex);
        int displayHeight = displaySize.height - (displayInsets.top + displayInsets.bottom);
        int maxWidth = displayHeight - this.getHeightDecorationSize() + 8;
        if (currentWidth > maxWidth) {
            currentWidth = maxWidth;
        } else if (currentWidth < 250) {
            currentWidth = 250;
        }
        return currentWidth;
    }

    private void doNewSize(int currentWidth, boolean doPack) {
        if (doPack) {
            this.pack();
            this.heightDecorationSize = this.getSize().height;
            this.widthDecorationSize = this.getInsets().left + this.getInsets().right;
        } else {
            this.setSize(new Dimension(currentWidth + this.widthDecorationSize, currentWidth + this.getHeightDecorationSize() - 8));
        }
    }

    private int getHeightDecorationSize() {
        int position = this.renderer.getPreferences().isShowPosition() ? 25 : 0;
        int measure = this.renderer.getPreferences().isShowRuler() || this.renderer.getPreferences().isShowAngle() ? 25 : 0;
        return this.heightDecorationSize + position + measure;
    }

    private void updateWindowTitle(String str) {
        if (str == null) {
            this.setTitle(TITLE_PREFIX);
        } else {
            this.setTitle("Surface: " + str);
        }
    }

    public SurfaceViewerMenu getMenu() {
        return this.menu;
    }
}

