/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.utilities;

import Jama.Matrix;
import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.LineSegment;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceDataHolder;
import edu.uthscsa.ric.utilities.MathUtilities;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

public final class SurfaceUtils {
    public static final double EPSILON = 1.0E-6;
    public static final double PROXIMITY_FACTOR = 3.0;
    public static final double THIRD = 0.3333333333333333;
    public static final double SIXTH = 0.16666666666666666;

    private SurfaceUtils() {
    }

    public static double calculateArea(double[][] points) {
        double disA = Math.sqrt(MathUtilities.pow((double)(points[0][0] - points[1][0]), (double)2.0) + MathUtilities.pow((double)(points[0][1] - points[1][1]), (double)2.0) + MathUtilities.pow((double)(points[0][2] - points[1][2]), (double)2.0));
        double disB = Math.sqrt(MathUtilities.pow((double)(points[1][0] - points[2][0]), (double)2.0) + MathUtilities.pow((double)(points[1][1] - points[2][1]), (double)2.0) + MathUtilities.pow((double)(points[1][2] - points[2][2]), (double)2.0));
        double disC = Math.sqrt(MathUtilities.pow((double)(points[2][0] - points[0][0]), (double)2.0) + MathUtilities.pow((double)(points[2][1] - points[0][1]), (double)2.0) + MathUtilities.pow((double)(points[2][2] - points[0][2]), (double)2.0));
        double halfPerim = (disA + disB + disC) * 0.5;
        double area = Math.sqrt(halfPerim * (halfPerim - disA) * (halfPerim - disB) * (halfPerim - disC));
        return area;
    }

    public static double calculateArea(Point3d[] points) {
        double disA = Math.sqrt(MathUtilities.pow((double)(points[0].x - points[1].x), (double)2.0) + MathUtilities.pow((double)(points[0].y - points[1].y), (double)2.0) + MathUtilities.pow((double)(points[0].z - points[1].z), (double)2.0));
        double disB = Math.sqrt(MathUtilities.pow((double)(points[1].x - points[2].x), (double)2.0) + MathUtilities.pow((double)(points[1].y - points[2].y), (double)2.0) + MathUtilities.pow((double)(points[1].z - points[2].z), (double)2.0));
        double disC = Math.sqrt(MathUtilities.pow((double)(points[2].x - points[0].x), (double)2.0) + MathUtilities.pow((double)(points[2].y - points[0].y), (double)2.0) + MathUtilities.pow((double)(points[2].z - points[0].z), (double)2.0));
        double halfPerim = (disA + disB + disC) * 0.5;
        double area = Math.sqrt(halfPerim * (halfPerim - disA) * (halfPerim - disB) * (halfPerim - disC));
        return area;
    }

    public static Point3d calculateCenter(Point3d center, Point3d[] points) {
        center.x = (points[0].x + points[1].x + points[2].x) * 0.3333333333333333;
        center.y = (points[0].y + points[1].y + points[2].y) * 0.3333333333333333;
        center.z = (points[0].z + points[1].z + points[2].z) * 0.3333333333333333;
        return center;
    }

    public static void changeOrder(double[][] tri) {
        double[] temp = tri[1];
        tri[1] = tri[2];
        tri[2] = temp;
    }

    public static void changeOrder(Point3d[] tri) {
        Point3d temp = tri[1];
        tri[1] = tri[2];
        tri[2] = temp;
    }

    public static boolean compareOrder(double[][] triangle, Vector3d normal, Vector3d cp, Vector3d vecB, Vector3d vecC) {
        Point3d[] tri = new Point3d[3];
        for (int ctr = 0; ctr < 3; ++ctr) {
            tri[ctr] = new Point3d(triangle[ctr][0], triangle[ctr][1], triangle[ctr][2]);
        }
        SurfaceUtils.crossProduct(cp, vecB, vecC, tri, true);
        cp.normalize();
        normal.normalize();
        return cp.epsilonEquals((Tuple3d)normal, 1.0E-6);
    }

    public static FloatBuffer convertIndicesToTriangles(FloatBuffer buffer, int[] triangles, boolean isTriple) {
        int multiplier = isTriple ? 3 : 1;
        FloatBuffer bufferNew = Buffers.newDirectFloatBuffer((int)(triangles.length * multiplier));
        for (int triangle : triangles) {
            bufferNew.put(buffer.get(triangle * multiplier));
            if (!isTriple) continue;
            bufferNew.put(buffer.get(triangle * multiplier + 1));
            bufferNew.put(buffer.get(triangle * multiplier + 2));
        }
        return bufferNew;
    }

    public static IntBuffer convertStripCountsToIndices(int[] triangleData) {
        int numIndices = 0;
        for (int element : triangleData) {
            if (element < 3) continue;
            numIndices += (element - 2) * 3;
        }
        IntBuffer bufferNew = Buffers.newDirectIntBuffer((int)numIndices);
        int ctrNew = 0;
        int counter = 0;
        for (int pointCount : triangleData) {
            if (pointCount < 3) continue;
            counter += 2;
            int stripCounter = 0;
            for (int ctrC = 2; ctrC < pointCount; ++ctrC) {
                if (stripCounter % 2 == 0) {
                    bufferNew.put(ctrNew++, counter - 2);
                    bufferNew.put(ctrNew++, counter - 1);
                    bufferNew.put(ctrNew++, counter);
                } else {
                    bufferNew.put(ctrNew++, counter - 1);
                    bufferNew.put(ctrNew++, counter - 2);
                    bufferNew.put(ctrNew++, counter);
                }
                ++stripCounter;
                ++counter;
            }
        }
        return bufferNew;
    }

    public static Vector4d createPlane(Point3d p1, Point3d p2, Point3d p3, Matrix matrix) {
        double[][] mat = matrix.getArray();
        mat[0][0] = 1.0;
        mat[0][1] = p1.y;
        mat[0][2] = p1.z;
        mat[1][0] = 1.0;
        mat[1][1] = p2.y;
        mat[1][2] = p2.z;
        mat[2][0] = 1.0;
        mat[2][1] = p3.y;
        mat[2][2] = p3.z;
        double a = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = 1.0;
        mat[0][2] = p1.z;
        mat[1][0] = p2.x;
        mat[1][1] = 1.0;
        mat[1][2] = p2.z;
        mat[2][0] = p3.x;
        mat[2][1] = 1.0;
        mat[2][2] = p3.z;
        double b = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = p1.y;
        mat[0][2] = 1.0;
        mat[1][0] = p2.x;
        mat[1][1] = p2.y;
        mat[1][2] = 1.0;
        mat[2][0] = p3.x;
        mat[2][1] = p3.y;
        mat[2][2] = 1.0;
        double c = matrix.det();
        mat[0][0] = p1.x;
        mat[0][1] = p1.y;
        mat[0][2] = p1.z;
        mat[1][0] = p2.x;
        mat[1][1] = p2.y;
        mat[1][2] = p2.z;
        mat[2][0] = p3.x;
        mat[2][1] = p3.y;
        mat[2][2] = p3.z;
        double d = -1.0 * matrix.det();
        Vector4d result = new Vector4d(a, b, c, d);
        result.normalize();
        return result;
    }

    public static Vector3d crossProduct(Vector3d cp, Vector3d vecA, Vector3d vecB, Point3d[] points, boolean normalize) {
        vecA.sub((Tuple3d)points[1], (Tuple3d)points[0]);
        vecB.sub((Tuple3d)points[1], (Tuple3d)points[2]);
        cp.cross(vecA, vecB);
        if (normalize) {
            cp.normalize();
        }
        return cp;
    }

    public static Vector3f crossProduct(Vector3f cp, Vector3f vecA, Vector3f vecB, Point3f[] points, boolean normalize) {
        vecA.sub((Tuple3f)points[1], (Tuple3f)points[0]);
        vecB.sub((Tuple3f)points[1], (Tuple3f)points[2]);
        cp.cross(vecA, vecB);
        if (normalize) {
            cp.normalize();
        }
        return cp;
    }

    public static Point3d[] findSurfaceLine(SurfaceViewer render, CompositeSurface surface, Point3d start, Point3d end, Point3d thirdPointVal) {
        int ctr;
        int index;
        int index2;
        double postDistance;
        boolean userDefinedPlane = false;
        Point3d thirdPoint = thirdPointVal;
        if (thirdPoint == null) {
            thirdPoint = SurfaceUtils.findSurfaceLineThirdPoint(render, surface, start, end);
        } else {
            userDefinedPlane = true;
        }
        Matrix tempMatrix = new Matrix(new double[3][3]);
        Vector4d cutPlane = SurfaceUtils.createPlane(start, end, thirdPoint, tempMatrix);
        HashSet<LineSegment> edgeLineSegments = new HashSet<LineSegment>();
        Point3d pointA = new Point3d();
        Point3d pointB = new Point3d();
        Point3d pointC = new Point3d();
        Point3d pointD = new Point3d();
        SurfacePosition surfacePosition = render.getPosition();
        boolean hasTransform = !surfacePosition.isImageTransformIdentity();
        for (int ctrPart = 0; ctrPart < surface.getNumParts(); ++ctrPart) {
            SurfaceDataHolder data = new SurfaceDataHolder(surface, ctrPart);
            while (data.hasMoreTriangles()) {
                int ctrP;
                Point3d[] triangle = data.getNextTriangleDouble();
                for (int ctrPoint = 0; ctrPoint < 3; ++ctrPoint) {
                    if (!hasTransform) continue;
                    surfacePosition.applyImageTransform(triangle[ctrPoint], null);
                }
                double area = SurfaceUtils.calculateArea(triangle);
                if (area == 0.0) continue;
                int pos = SurfaceUtils.positionRelativeToPlane(triangle, cutPlane);
                LineSegment ls = new LineSegment();
                if (pos == -2 || pos == 2) {
                    for (ctrP = 0; ctrP < 3; ++ctrP) {
                        if (SurfaceUtils.positionRelativeToPlane(triangle[ctrP], cutPlane) != 0) continue;
                        ls.addPoint(new Point3d(triangle[ctrP]));
                    }
                    edgeLineSegments.add(ls);
                    continue;
                }
                if (pos == -4 || pos == 4) {
                    for (ctrP = 0; ctrP < 3; ++ctrP) {
                        if (SurfaceUtils.positionRelativeToPlane(triangle[ctrP], cutPlane) == SurfaceUtils.positionRelativeToPlane(triangle[(ctrP + 1) % 3], cutPlane)) continue;
                        pointA.set((Tuple3d)triangle[ctrP]);
                        pointB.set((Tuple3d)triangle[(ctrP + 1) % 3]);
                        double intersectionRatio = SurfaceUtils.linePlaneIntersection(pointA, pointB, cutPlane);
                        pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, intersectionRatio);
                        ls.addPoint(new Point3d(pointC));
                    }
                    edgeLineSegments.add(ls);
                    continue;
                }
                if (pos != 0) continue;
                int negIndex = 0;
                int alignIndex = 0;
                int posIndex = 0;
                for (int ctrP2 = 0; ctrP2 < 3; ++ctrP2) {
                    int position = SurfaceUtils.positionRelativeToPlane(triangle[ctrP2], cutPlane);
                    if (position == -1) {
                        negIndex = ctrP2;
                        continue;
                    }
                    if (position == 0) {
                        alignIndex = ctrP2;
                        continue;
                    }
                    if (position != 1) continue;
                    posIndex = ctrP2;
                }
                double intersectionRatio = SurfaceUtils.linePlaneIntersection(triangle[negIndex], triangle[posIndex], cutPlane);
                pointA.set((Tuple3d)triangle[negIndex]);
                pointB.set((Tuple3d)triangle[posIndex]);
                pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, intersectionRatio);
                pointD.set((Tuple3d)triangle[alignIndex]);
                ls.addPoint(new Point3d(pointC));
                ls.addPoint(new Point3d(pointD));
                edgeLineSegments.add(ls);
            }
        }
        if (edgeLineSegments.size() == 0) {
            render.showErrorDialog("Could not make path!", "Surface Line Error");
            return null;
        }
        LineSegment startLineSegment = null;
        boolean searchStartLS = true;
        double startDistance = Double.MAX_VALUE;
        for (LineSegment ls : edgeLineSegments) {
            Point3d[] lsPoints = ls.getPoints();
            for (int ctr2 = 0; ctr2 < 2; ++ctr2) {
                Point3d point = lsPoints[ctr2];
                double currentStartDistance = point.distance(start);
                if (!(currentStartDistance < startDistance)) continue;
                startDistance = currentStartDistance;
                startLineSegment = ls;
            }
        }
        if (startLineSegment == null) {
            return null;
        }
        Vector<Point3d> linePoints = new Vector<Point3d>();
        Point3d currentPoint = startLineSegment.getPoints()[0];
        Point3d endPoint = startLineSegment.getPoints()[1];
        linePoints.add(currentPoint);
        linePoints.add(endPoint);
        edgeLineSegments.remove(startLineSegment);
        boolean foundEnd = false;
        while (edgeLineSegments.size() > 0) {
            Iterator linesIt = edgeLineSegments.iterator();
            boolean found = false;
            while (linesIt.hasNext()) {
                LineSegment ls = (LineSegment)linesIt.next();
                if (!ls.connects(currentPoint)) continue;
                Point3d pointToAdd = ls.getOppositePoint(currentPoint);
                linePoints.add(pointToAdd);
                currentPoint = pointToAdd;
                if (ls.connects(endPoint)) {
                    foundEnd = true;
                }
                edgeLineSegments.remove(ls);
                found = true;
                break;
            }
            if (found && !foundEnd) continue;
            break;
        }
        if (!foundEnd) {
            render.showErrorDialog("Could not make path!", "Surface Line Error");
            return null;
        }
        double startDistance2 = Double.MAX_VALUE;
        double endDistance = Double.MAX_VALUE;
        Point3d startPathPoint = null;
        Point3d endPathPoint = null;
        int numPoints = linePoints.size();
        for (int ctr3 = 0; ctr3 < numPoints; ++ctr3) {
            Point3d point = (Point3d)linePoints.elementAt(ctr3);
            double currentStartDistance = point.distance(start);
            double currentEndDistance = point.distance(end);
            if (currentStartDistance < startDistance2) {
                startDistance2 = currentStartDistance;
                startPathPoint = point;
            }
            if (!(currentEndDistance < endDistance)) continue;
            endDistance = currentEndDistance;
            endPathPoint = point;
        }
        int startPathIndex = linePoints.indexOf(startPathPoint);
        int preIndex = startPathIndex == 0 ? linePoints.size() - 1 : startPathIndex - 1;
        int postIndex = (startPathIndex + 1) % linePoints.size();
        double preDistance = ((Point3d)linePoints.get(preIndex)).distance(start);
        if (preDistance <= (postDistance = ((Point3d)linePoints.get(postIndex)).distance(start))) {
            linePoints.insertElementAt(start, startPathIndex);
        } else {
            linePoints.insertElementAt(start, postIndex);
        }
        int endPathIndex = linePoints.indexOf(endPathPoint);
        preIndex = endPathIndex == 0 ? linePoints.size() - 1 : endPathIndex - 1;
        postIndex = (endPathIndex + 1) % linePoints.size();
        preDistance = ((Point3d)linePoints.get(preIndex)).distance(end);
        postDistance = ((Point3d)linePoints.get(postIndex)).distance(end);
        if (preDistance <= postDistance) {
            linePoints.insertElementAt(end, endPathIndex);
        } else {
            linePoints.insertElementAt(end, postIndex);
        }
        int startIndex = linePoints.indexOf(start);
        int endIndex = linePoints.indexOf(end);
        double forwardDistance = 0.0;
        double forwardDistanceClosest = Double.MAX_VALUE;
        Point3d previousPoint = (Point3d)linePoints.elementAt(startIndex);
        for (int ctr4 = 1; ctr4 < numPoints && (index2 = (startIndex + ctr4) % numPoints) != endIndex; ++ctr4) {
            Point3d point = (Point3d)linePoints.elementAt(index2);
            if (userDefinedPlane) {
                double dist = point.distance(thirdPoint);
                if (!(dist < forwardDistanceClosest)) continue;
                forwardDistanceClosest = dist;
                continue;
            }
            forwardDistance += point.distance(previousPoint);
        }
        double backwardDistance = 0.0;
        double backwardDistanceClosest = Double.MAX_VALUE;
        previousPoint = (Point3d)linePoints.elementAt(endIndex);
        for (int ctr5 = 1; ctr5 < numPoints && (index = (endIndex + ctr5) % numPoints) != startIndex; ++ctr5) {
            Point3d point = (Point3d)linePoints.elementAt(index);
            if (userDefinedPlane) {
                double dist = point.distance(thirdPoint);
                if (!(dist < backwardDistanceClosest)) continue;
                backwardDistanceClosest = dist;
                continue;
            }
            backwardDistance += point.distance(previousPoint);
        }
        if (userDefinedPlane) {
            if (forwardDistanceClosest <= backwardDistanceClosest) {
                forwardDistance = 0.0;
                backwardDistance = 1.0;
            } else {
                forwardDistance = 1.0;
                backwardDistance = 0.0;
            }
        }
        Vector surfaceLinePoints = new Vector();
        if (forwardDistance <= backwardDistance) {
            for (ctr = 0; ctr < numPoints; ++ctr) {
                int index3 = (startIndex + ctr) % numPoints;
                if (surfaceLinePoints.size() > 1) {
                    surfaceLinePoints.add(surfaceLinePoints.lastElement());
                }
                surfaceLinePoints.add(linePoints.elementAt(index3));
                if (index3 != endIndex) {
                    continue;
                }
                break;
            }
        } else {
            for (ctr = 0; ctr < numPoints; ++ctr) {
                int index4 = (endIndex + ctr) % numPoints;
                if (surfaceLinePoints.size() > 1) {
                    surfaceLinePoints.add(surfaceLinePoints.lastElement());
                }
                surfaceLinePoints.add(linePoints.elementAt(index4));
                if (index4 != startIndex) {
                    continue;
                }
                break;
            }
        }
        return surfaceLinePoints.toArray(new Point3d[surfaceLinePoints.size()]);
    }

    public static void fixOrder(Point3d[] triOld, Point3d[] triNew, Vector3d vecA, Vector3d vecB, Vector3d vecC, Vector3d vecD) {
        SurfaceUtils.crossProduct(vecA, vecB, vecC, triOld, true);
        Vector3d normalOld = vecA;
        SurfaceUtils.crossProduct(vecD, vecB, vecC, triNew, true);
        Vector3d normalNew = vecD;
        if (!normalOld.epsilonEquals((Tuple3d)normalNew, 1.0E-6)) {
            SurfaceUtils.changeOrder(triNew);
        }
    }

    public static double halfSpaceTest(Vector4d plane, double x, double y, double z) {
        return x * plane.x + y * plane.y + z * plane.z + plane.w;
    }

    public static double halfSpaceTest(Vector4d plane, Point3d point) {
        return point.x * plane.x + point.y * plane.y + point.z * plane.z + plane.w;
    }

    public static double linePlaneIntersection(Point3d pointA, Point3d pointB, Vector4d plane) {
        double num = SurfaceUtils.halfSpaceTest(plane, pointA);
        double dem = plane.x * (pointB.x - pointA.x) + plane.y * (pointB.y - pointA.y) + plane.z * (pointB.z - pointA.z);
        return -num / dem;
    }

    public static int positionRelativeToAxis(double[][] triangle, double edge, int axis) {
        int neg = 0;
        int pos = 0;
        int aligned = 0;
        for (double[] element : triangle) {
            if (element[axis] < edge) {
                neg = (neg - 1) * 2;
                continue;
            }
            if (element[axis] > edge) {
                pos = (pos + 1) * 2;
                continue;
            }
            ++aligned;
        }
        if (aligned == 3) {
            return Integer.MIN_VALUE;
        }
        return neg + pos;
    }

    public static int positionRelativeToPlane(Point3d point, Vector4d plane) {
        double test = SurfaceUtils.halfSpaceTest(plane, point);
        if (Math.abs(test) < 1.0E-6) {
            return 0;
        }
        if (test < 0.0) {
            return -1;
        }
        return 1;
    }

    public static int positionRelativeToPlane(Point3d[] triangle, Vector4d plane) {
        int neg = 0;
        int pos = 0;
        int aligned = 0;
        for (Point3d element : triangle) {
            double test = SurfaceUtils.halfSpaceTest(plane, element);
            if (Math.abs(test) < 1.0E-6) {
                ++aligned;
                continue;
            }
            if (test < 0.0) {
                neg = (neg - 1) * 2;
                continue;
            }
            pos = (pos + 1) * 2;
        }
        if (aligned == 3) {
            return Integer.MIN_VALUE;
        }
        return neg + pos;
    }

    private static Point3d findSurfaceLineThirdPoint(SurfaceViewer render, CompositeSurface surface, Point3d start, Point3d end) {
        SurfacePosition position = render.getPosition();
        double xSize = render.getViewer().getXSize();
        double ySize = render.getViewer().getYSize();
        double zSize = render.getViewer().getZSize();
        double averageVoxSize = (xSize + ySize + zSize) / 3.0;
        Vector3d averageNormal = new Vector3d();
        Vector3d currentNormal = new Vector3d();
        Point3d tempPoint = new Point3d();
        double proximityThresh = averageVoxSize * 3.0;
        int numNormalsAdded = 0;
        boolean hasTransform = !position.isImageTransformIdentity();
        for (int ctrPart = 0; ctrPart < surface.getNumParts(); ++ctrPart) {
            SurfaceDataHolder data = new SurfaceDataHolder(surface, ctrPart, true);
            while (data.hasMoreTriangles()) {
                Point3f[] tri = data.getNextTriangle();
                Vector3f[] normals = data.getNormals();
                for (int ctrPoint = 0; ctrPoint < 3; ++ctrPoint) {
                    Point3f point = tri[ctrPoint];
                    currentNormal.set((Tuple3f)normals[ctrPoint]);
                    tempPoint.set((Tuple3f)point);
                    if (hasTransform) {
                        position.applyImageTransform(tempPoint, null);
                    }
                    if (!(tempPoint.distance(start) <= proximityThresh) && !(tempPoint.distance(end) <= proximityThresh)) continue;
                    averageNormal.add((Tuple3d)currentNormal);
                    ++numNormalsAdded;
                }
            }
        }
        averageNormal.x /= (double)numNormalsAdded;
        averageNormal.y /= (double)numNormalsAdded;
        averageNormal.z /= (double)numNormalsAdded;
        averageNormal.normalize();
        return new Point3d(start.x + averageNormal.x, start.y + averageNormal.y, start.z + averageNormal.z);
    }

    public static Vector4d transformPlane(double[] plane, double[][] matrix) {
        double[] origin = new double[]{plane[0] * plane[3], plane[1] * plane[3], plane[2] * plane[3], 1.0};
        double[] normal = new double[]{plane[0], plane[1], plane[2], 0.0};
        double[] origin2 = new double[]{origin[0] * matrix[0][0] + origin[1] * matrix[0][1] + origin[2] * matrix[0][2] + matrix[0][3], origin[0] * matrix[1][0] + origin[1] * matrix[1][1] + origin[2] * matrix[1][2] + matrix[1][3], origin[0] * matrix[2][0] + origin[1] * matrix[2][1] + origin[2] * matrix[2][2] + matrix[2][3], origin[0] * matrix[3][0] + origin[1] * matrix[3][1] + origin[2] * matrix[3][2] + matrix[3][3]};
        double[][] matrix2 = new Matrix(matrix).inverse().transpose().getArrayCopy();
        double[] normal2 = new double[]{normal[0] * matrix2[0][0] + normal[1] * matrix2[0][1] + normal[2] * matrix2[0][2], normal[0] * matrix2[1][0] + normal[1] * matrix2[1][1] + normal[2] * matrix2[1][2], normal[0] * matrix2[2][0] + normal[1] * matrix2[2][1] + normal[2] * matrix2[2][2], normal[0] * matrix2[3][0] + normal[1] * matrix2[3][1] + normal[2] * matrix2[3][2]};
        Vector3d vectO = new Vector3d(origin2[0], origin2[1], origin2[2]);
        Vector3d vectN = new Vector3d(normal2[0], normal2[1], normal2[2]);
        double d = vectO.dot(vectN);
        return new Vector4d(normal2[0], normal2[1], normal2[2], -d);
    }

    public static Vector4d flipPlane(Vector4d plane) {
        plane.x *= -1.0;
        plane.y *= -1.0;
        plane.z *= -1.0;
        plane.w *= -1.0;
        return plane;
    }

    public static double calculateSignedVolumeOfTriangleToOrigin(double[][] triangle) {
        double v321 = triangle[2][0] * triangle[1][1] * triangle[0][2];
        double v231 = triangle[1][0] * triangle[2][1] * triangle[0][2];
        double v312 = triangle[2][0] * triangle[0][1] * triangle[1][2];
        double v132 = triangle[0][0] * triangle[2][1] * triangle[1][2];
        double v213 = triangle[1][0] * triangle[0][1] * triangle[2][2];
        double v123 = triangle[0][0] * triangle[1][1] * triangle[2][2];
        return 0.16666666666666666 * (-v321 + v231 + v312 - v132 - v213 + v123);
    }
}

