/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.screen;

import com.jogamp.opengl.GL2;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import java.awt.Color;

public final class Material {
    private Material tempMaterial;
    private boolean showOnlyThisOverlayColors;
    private boolean showOverlayColors;
    private double distance;
    private double distanceDefault;
    private float emissivity;
    private float shininess;
    private float transparency;
    private int polygonMode;
    private int polygonType;
    private int shadeModel;
    private final float[] materialAmbient;
    private final float[] materialColor = new float[3];
    private final float[] materialDiffuse;
    private final float[] materialEmissive;
    private final float[] materialSpecular;
    public static final float DEFAULT_EMISSIVE = 0.0f;
    public static final float DEFAULT_MATERIAL_COLOR = 1.0f;
    public static final float DEFAULT_SHININESS = 0.5f;
    public static final float DEFAULT_TRANSPARENCY = 0.0f;
    public static final float MINIMUM_SPECULAR_FOR_SHININESS = 0.3f;
    public static final float SHININESS_MAX = 128.0f;
    public static final int POLYGON_STYLE_POINTS = 2;
    public static final int POLYGON_STYLE_TRIANGLES = 0;
    public static final int POLYGON_STYLE_WIREFRAME = 1;
    public static final int SEARCH_DISTANCE_MAX_MULTIPLIER = 5;

    public Material() {
        this.materialAmbient = new float[4];
        this.materialDiffuse = new float[4];
        this.materialEmissive = new float[4];
        this.materialSpecular = new float[4];
        this.initialize();
    }

    public Material(Material material) {
        this();
        this.setValues(material);
    }

    public void apply(GL2 gl, Lighting lightingVal) {
        Lighting lighting = lightingVal;
        if (lighting.getTempLighting() != null) {
            lighting = lighting.getTempLighting();
        }
        if (this.tempMaterial != null) {
            this.tempMaterial.apply(gl, lighting);
        } else {
            this.updateMaterial(lighting);
            gl.glMaterialfv(1028, 4608, this.materialAmbient, 0);
            gl.glMaterialfv(1028, 4609, this.materialDiffuse, 0);
            gl.glMaterialfv(1028, 4610, this.materialSpecular, 0);
            gl.glMaterialfv(1028, 5632, this.materialEmissive, 0);
            gl.glMaterialf(1028, 5633, this.shininess);
        }
    }

    public Color getColor() {
        return new Color(this.materialColor[0], this.materialColor[1], this.materialColor[2]);
    }

    public float[] getColorComponents() {
        return this.materialColor;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getDistanceDefault() {
        return this.distanceDefault;
    }

    public double getDistanceMax() {
        return Math.max(1L, Math.round(this.distanceDefault) * 5L);
    }

    public float getEmissivity() {
        return this.emissivity;
    }

    public int getPolygonMode() {
        if (this.tempMaterial != null) {
            return this.tempMaterial.getPolygonMode();
        }
        return this.polygonMode;
    }

    public int getPolygonStyle() {
        if (this.polygonType == 4) {
            if (this.polygonMode == 6914) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public int getPolygonType() {
        if (this.tempMaterial != null) {
            return this.tempMaterial.getPolygonType();
        }
        return this.polygonType;
    }

    public int getShadeModel() {
        if (this.tempMaterial != null) {
            return this.tempMaterial.getShadeModel();
        }
        return this.shadeModel;
    }

    public float getShininess() {
        return this.shininess;
    }

    public Material getTempMaterial() {
        return this.tempMaterial;
    }

    public float getTransparency() {
        if (this.tempMaterial != null) {
            return this.tempMaterial.getTransparency();
        }
        return this.transparency;
    }

    public boolean isOpaque() {
        return !this.isTransparent();
    }

    public boolean isShowOnlyThisOverlayColors() {
        return this.showOnlyThisOverlayColors;
    }

    public boolean isShowOverlayColors() {
        return this.showOverlayColors;
    }

    public boolean isSmoothShading() {
        return this.shadeModel == 7425;
    }

    public boolean isTransparent() {
        if (this.tempMaterial != null) {
            return this.tempMaterial.isTransparent();
        }
        return this.transparency > 0.0f;
    }

    public void setColor(Color color) {
        float[] comps = color.getColorComponents(null);
        this.materialColor[0] = comps[0];
        this.materialColor[1] = comps[1];
        this.materialColor[2] = comps[2];
    }

    public void setColorComponents(float[] color) {
        this.materialColor[0] = color[0];
        this.materialColor[1] = color[1];
        this.materialColor[2] = color[2];
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setDistanceDefault(double distanceDefault) {
        this.distanceDefault = distanceDefault;
    }

    public void setEmissivity(float val) {
        this.emissivity = val;
    }

    public void setPolygonMode(int polygonMode) {
        this.polygonMode = polygonMode;
    }

    public void setPolygonStyle(int type) {
        if (type == 0) {
            this.polygonType = 4;
            this.polygonMode = 6914;
        } else if (type == 1) {
            this.polygonType = 4;
            this.polygonMode = 6913;
        } else {
            this.polygonType = 0;
            this.polygonMode = 6914;
        }
    }

    public void setPolygonType(int polygonType) {
        this.polygonType = polygonType;
    }

    public void setShadeModel(int shadeModel) {
        this.shadeModel = shadeModel;
    }

    public void setShininess(float val) {
        this.shininess = val;
    }

    public void setShowOnlyThisOverlayColors(boolean showOnlyThisOverlayColors) {
        this.showOnlyThisOverlayColors = showOnlyThisOverlayColors;
    }

    public void setShowOverlayColors(boolean showOverlayColors) {
        this.showOverlayColors = showOverlayColors;
    }

    public void setTempMaterial(Material tempMaterial) {
        this.tempMaterial = tempMaterial;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    public void setUsingSmoothShading(boolean bool) {
        this.shadeModel = bool ? 7425 : 7424;
    }

    public void setValues(Material material) {
        this.materialColor[0] = material.materialColor[0];
        this.materialColor[1] = material.materialColor[1];
        this.materialColor[2] = material.materialColor[2];
        this.shininess = material.shininess;
        this.emissivity = material.emissivity;
        this.transparency = material.transparency;
        this.distance = material.distance;
        this.distanceDefault = material.distanceDefault;
        this.polygonType = material.polygonType;
        this.polygonMode = material.polygonMode;
        this.shadeModel = material.shadeModel;
        this.showOverlayColors = material.showOverlayColors;
        this.showOnlyThisOverlayColors = material.showOnlyThisOverlayColors;
        this.tempMaterial = null;
    }

    private void initialize() {
        this.shininess = 64.0f;
        this.emissivity = 0.0f;
        this.materialColor[0] = 1.0f;
        this.materialColor[1] = 1.0f;
        this.materialColor[2] = 1.0f;
        this.shadeModel = 7425;
        this.polygonType = 4;
        this.polygonMode = 6914;
    }

    private void updateMaterial(Lighting lighting) {
        for (int ctr = 0; ctr < 3; ++ctr) {
            this.materialAmbient[ctr] = this.materialColor[ctr] * lighting.getAmbient();
            this.materialDiffuse[ctr] = this.materialColor[ctr] * lighting.getDiffuse();
            this.materialSpecular[ctr] = this.materialColor[ctr] * lighting.getSpecular();
            this.materialEmissive[ctr] = this.materialColor[ctr] * this.emissivity;
        }
        this.materialSpecular[3] = this.materialEmissive[3] = 1.0f - this.transparency;
        this.materialDiffuse[3] = this.materialEmissive[3];
        this.materialAmbient[3] = this.materialEmissive[3];
    }
}

