/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.screen;

import com.jogamp.opengl.GL2;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.util.List;
import javax.vecmath.Vector3f;

public final class Lighting {
    private Lighting tempLighting;
    private final float[] directionalLightBack;
    private final float[] directionalLightFront;
    private final float[] lightingAmbient = new float[4];
    private final float[] lightingDiffuse = new float[4];
    private final float[] lightingSpecular = new float[4];
    public static final float DEFAULT_AMBIENT = 0.2f;
    public static final float DEFAULT_DIFFUSE = 0.9f;
    public static final float DEFAULT_SPECULAR = 0.4f;
    public static final List<Float> DEFAULT_DIRECTION = CollectionUtilities.immutable((Float[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});

    public Lighting() {
        this.directionalLightFront = new float[4];
        this.directionalLightBack = new float[4];
        this.initialize();
    }

    public Lighting(Lighting lighting) {
        this();
        this.setValues(lighting);
    }

    public void apply(GL2 gl) {
        if (this.tempLighting != null) {
            this.tempLighting.apply(gl);
        } else {
            gl.glLightfv(16384, 4608, this.lightingAmbient, 0);
            gl.glLightfv(16384, 4609, this.lightingDiffuse, 0);
            gl.glLightfv(16384, 4610, this.lightingSpecular, 0);
            gl.glLightfv(16384, 4611, this.directionalLightFront, 0);
            gl.glLightfv(16385, 4608, this.lightingAmbient, 0);
            gl.glLightfv(16385, 4609, this.lightingDiffuse, 0);
            gl.glLightfv(16385, 4610, this.lightingSpecular, 0);
            gl.glLightfv(16385, 4611, this.directionalLightBack, 0);
        }
    }

    public float getAmbient() {
        return this.lightingAmbient[0];
    }

    public float getDiffuse() {
        return this.lightingDiffuse[0];
    }

    public float[] getDirection() {
        return this.directionalLightFront;
    }

    public float getSpecular() {
        return this.lightingSpecular[0];
    }

    public Lighting getTempLighting() {
        return this.tempLighting;
    }

    public void setLightingDirection(float[] values) {
        Vector3f vec = new Vector3f(values[0], values[1], values[2]);
        vec.normalize();
        this.directionalLightFront[0] = vec.x;
        this.directionalLightFront[1] = vec.y;
        this.directionalLightFront[2] = vec.z;
        this.directionalLightFront[3] = 0.0f;
        this.directionalLightBack[0] = -vec.x;
        this.directionalLightBack[1] = -vec.y;
        this.directionalLightBack[2] = -vec.z;
        this.directionalLightBack[3] = 0.0f;
    }

    public void setLightingParameters(float ambient, float diffuse, float specular) {
        this.lightingAmbient[1] = this.lightingAmbient[2] = ambient;
        this.lightingAmbient[0] = this.lightingAmbient[2];
        this.lightingDiffuse[1] = this.lightingDiffuse[2] = diffuse;
        this.lightingDiffuse[0] = this.lightingDiffuse[2];
        this.lightingSpecular[1] = this.lightingSpecular[2] = specular;
        this.lightingSpecular[0] = this.lightingSpecular[2];
    }

    public void setTempLighting(Lighting tempLighting) {
        this.tempLighting = tempLighting;
    }

    public void setValues(Lighting lighting) {
        this.lightingAmbient[0] = lighting.lightingAmbient[0];
        this.lightingAmbient[1] = lighting.lightingAmbient[1];
        this.lightingAmbient[2] = lighting.lightingAmbient[2];
        this.lightingAmbient[3] = lighting.lightingAmbient[3];
        this.lightingDiffuse[0] = lighting.lightingDiffuse[0];
        this.lightingDiffuse[1] = lighting.lightingDiffuse[1];
        this.lightingDiffuse[2] = lighting.lightingDiffuse[2];
        this.lightingDiffuse[3] = lighting.lightingDiffuse[3];
        this.lightingSpecular[0] = lighting.lightingSpecular[0];
        this.lightingSpecular[1] = lighting.lightingSpecular[1];
        this.lightingSpecular[2] = lighting.lightingSpecular[2];
        this.lightingSpecular[3] = lighting.lightingSpecular[3];
        this.directionalLightFront[0] = lighting.directionalLightFront[0];
        this.directionalLightFront[1] = lighting.directionalLightFront[1];
        this.directionalLightFront[2] = lighting.directionalLightFront[2];
        this.directionalLightFront[3] = lighting.directionalLightFront[3];
        this.directionalLightBack[0] = lighting.directionalLightBack[0];
        this.directionalLightBack[1] = lighting.directionalLightBack[1];
        this.directionalLightBack[2] = lighting.directionalLightBack[2];
        this.directionalLightBack[3] = lighting.directionalLightBack[3];
        this.tempLighting = null;
    }

    private void initialize() {
        this.lightingAmbient[0] = 0.2f;
        this.lightingAmbient[1] = 0.2f;
        this.lightingAmbient[2] = 0.2f;
        this.lightingAmbient[3] = 1.0f;
        this.lightingDiffuse[0] = 0.9f;
        this.lightingDiffuse[1] = 0.9f;
        this.lightingDiffuse[2] = 0.9f;
        this.lightingDiffuse[3] = 1.0f;
        this.lightingSpecular[0] = 0.4f;
        this.lightingSpecular[1] = 0.4f;
        this.lightingSpecular[2] = 0.4f;
        this.lightingSpecular[3] = 1.0f;
        this.setLightingDirection(CollectionUtilities.arrayFloats(DEFAULT_DIRECTION));
    }
}

