/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.measurement;

import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.core.Triangle;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleData;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceDataHolder;
import edu.uthscsa.ric.mango.viewersurface.utilities.SurfaceUtils;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class SurfaceSlicer {
    public static final int SLICE_X = 0;
    public static final int SLICE_Y = 1;
    public static final int SLICE_Z = 2;

    private SurfaceSlicer() {
    }

    protected static TriangleData sliceShape(SurfaceDataHolder data, SurfacePosition position, Point3d currentCoor, int axis, boolean isPos, boolean doCutSurface, int ctrPart) {
        boolean hasTransform = !position.isImageTransformIdentity();
        double[] edgeLocs = new double[3];
        currentCoor.get(edgeLocs);
        double[][] triangle = new double[3][3];
        Point3d[] pointsToTriangulate = new Point3d[4];
        Point3d[] triangleNew = new Point3d[3];
        Point3d[] triNew = new Point3d[3];
        Point3d[] triOld = new Point3d[3];
        Point3d pointA = new Point3d();
        Point3d pointB = new Point3d();
        Point3d pointC = new Point3d();
        Point3d pointD = new Point3d();
        Point3d pointE = new Point3d();
        Point3d pointF = new Point3d();
        Point3d pointG = new Point3d();
        Point3d pointH = new Point3d();
        Point3d pointI = new Point3d();
        Vector3d cpA = new Vector3d();
        Vector3d cpB = new Vector3d();
        Vector3d cpC = new Vector3d();
        Vector3d cpD = new Vector3d();
        TriangleData triDataNeg = new TriangleData(ctrPart);
        TriangleData triDataPos = new TriangleData(ctrPart);
        while (data.hasMoreTriangles()) {
            double alpha;
            int ctrP;
            int triangleNewIndex;
            int triangulateIndex;
            Point3f[] tri = data.getNextTriangle();
            for (int ctrPoint = 0; ctrPoint < 3; ++ctrPoint) {
                Point3f tempPoint = tri[ctrPoint];
                if (hasTransform) {
                    pointH.x = tempPoint.x;
                    pointH.y = tempPoint.y;
                    pointH.z = tempPoint.z;
                    position.applyImageTransform(pointH, pointI);
                    tempPoint.x = (float)pointI.x;
                    tempPoint.y = (float)pointI.y;
                    tempPoint.z = (float)pointI.z;
                }
                triangle[ctrPoint][0] = tempPoint.x;
                triangle[ctrPoint][1] = tempPoint.y;
                triangle[ctrPoint][2] = tempPoint.z;
            }
            double area = SurfaceUtils.calculateArea(triangle);
            if (area == 0.0) continue;
            int pos = SurfaceUtils.positionRelativeToAxis(triangle, edgeLocs[axis], axis);
            if (pos == -14) {
                SurfaceSlicer.addTriangle(triDataNeg, triangle);
                continue;
            }
            if (pos == -6) {
                SurfaceSlicer.addTriangle(triDataNeg, triangle);
                continue;
            }
            if (pos == -2) {
                SurfaceSlicer.addTriangle(triDataNeg, triangle);
                continue;
            }
            if (pos == -4) {
                triangulateIndex = 0;
                triangleNewIndex = 0;
                for (ctrP = 0; ctrP < 3; ++ctrP) {
                    if (triangle[ctrP][axis] < edgeLocs[axis] && triangle[(ctrP + 1) % 3][axis] > edgeLocs[axis]) {
                        alpha = Math.abs(triangle[ctrP][axis] - edgeLocs[axis]) / Math.abs(triangle[ctrP][axis] - triangle[(ctrP + 1) % 3][axis]);
                        pointA.set(triangle[ctrP][0], triangle[ctrP][1], triangle[ctrP][2]);
                        pointB.set(triangle[(ctrP + 1) % 3][0], triangle[(ctrP + 1) % 3][1], triangle[(ctrP + 1) % 3][2]);
                        pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, alpha);
                        pointsToTriangulate[triangulateIndex++] = new Point3d(pointA);
                        pointsToTriangulate[triangulateIndex++] = new Point3d(pointC);
                        triangleNew[triangleNewIndex++] = new Point3d(pointC);
                        triangleNew[triangleNewIndex++] = new Point3d(pointB);
                        continue;
                    }
                    if (!(triangle[ctrP][axis] > edgeLocs[axis]) || !(triangle[(ctrP + 1) % 3][axis] < edgeLocs[axis])) continue;
                    alpha = Math.abs(triangle[ctrP][axis] - edgeLocs[axis]) / Math.abs(triangle[ctrP][axis] - triangle[(ctrP + 1) % 3][axis]);
                    pointA.set(triangle[ctrP][0], triangle[ctrP][1], triangle[ctrP][2]);
                    pointB.set(triangle[(ctrP + 1) % 3][0], triangle[(ctrP + 1) % 3][1], triangle[(ctrP + 1) % 3][2]);
                    pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, alpha);
                    pointsToTriangulate[triangulateIndex++] = new Point3d(pointC);
                    pointsToTriangulate[triangulateIndex++] = new Point3d(pointB);
                    triangleNew[triangleNewIndex++] = new Point3d(pointC);
                }
                pointA.set(triangle[0][0], triangle[0][1], triangle[0][2]);
                pointB.set(triangle[1][0], triangle[1][1], triangle[1][2]);
                pointC.set(triangle[2][0], triangle[2][1], triangle[2][2]);
                triOld[0] = pointA;
                triOld[1] = pointB;
                triOld[2] = pointC;
                triNew[0] = pointsToTriangulate[0];
                triNew[1] = pointsToTriangulate[1];
                triNew[2] = pointsToTriangulate[2];
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataNeg, triNew);
                triNew[0] = pointsToTriangulate[2];
                triNew[1] = pointsToTriangulate[3];
                triNew[2] = pointsToTriangulate[0];
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataNeg, triNew);
                SurfaceUtils.fixOrder(triOld, triangleNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataPos, triangleNew);
                continue;
            }
            if (pos == 0) {
                int negIndex = 0;
                int alignIndex = 0;
                int posIndex = 0;
                for (int ctrP2 = 0; ctrP2 < 3; ++ctrP2) {
                    if (triangle[ctrP2][axis] < edgeLocs[axis]) {
                        negIndex = ctrP2;
                        continue;
                    }
                    if (triangle[ctrP2][axis] == edgeLocs[axis]) {
                        alignIndex = ctrP2;
                        continue;
                    }
                    if (!(triangle[ctrP2][axis] > edgeLocs[axis])) continue;
                    posIndex = ctrP2;
                }
                alpha = Math.abs(triangle[negIndex][axis] - edgeLocs[axis]) / Math.abs(triangle[negIndex][axis] - triangle[posIndex][axis]);
                pointA.set(triangle[negIndex][0], triangle[negIndex][1], triangle[negIndex][2]);
                pointB.set(triangle[posIndex][0], triangle[posIndex][1], triangle[posIndex][2]);
                pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, alpha);
                pointD.set(triangle[alignIndex][0], triangle[alignIndex][1], triangle[alignIndex][2]);
                pointE.set(triangle[0][0], triangle[0][1], triangle[0][2]);
                pointF.set(triangle[1][0], triangle[1][1], triangle[1][2]);
                pointG.set(triangle[2][0], triangle[2][1], triangle[2][2]);
                triOld[0] = pointE;
                triOld[1] = pointF;
                triOld[2] = pointG;
                triNew[0] = pointA;
                triNew[1] = pointD;
                triNew[2] = pointC;
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataNeg, triNew);
                triNew[0] = pointD;
                triNew[1] = pointB;
                triNew[2] = pointC;
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataPos, triNew);
                continue;
            }
            if (pos == 4) {
                triangulateIndex = 0;
                triangleNewIndex = 0;
                for (ctrP = 0; ctrP < 3; ++ctrP) {
                    if (triangle[ctrP][axis] > edgeLocs[axis] && triangle[(ctrP + 1) % 3][axis] < edgeLocs[axis]) {
                        alpha = Math.abs(triangle[ctrP][axis] - edgeLocs[axis]) / Math.abs(triangle[ctrP][axis] - triangle[(ctrP + 1) % 3][axis]);
                        pointA.set(triangle[ctrP][0], triangle[ctrP][1], triangle[ctrP][2]);
                        pointB.set(triangle[(ctrP + 1) % 3][0], triangle[(ctrP + 1) % 3][1], triangle[(ctrP + 1) % 3][2]);
                        pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, alpha);
                        pointsToTriangulate[triangulateIndex++] = new Point3d(pointA);
                        pointsToTriangulate[triangulateIndex++] = new Point3d(pointC);
                        triangleNew[triangleNewIndex++] = new Point3d(pointC);
                        triangleNew[triangleNewIndex++] = new Point3d(pointB);
                        continue;
                    }
                    if (!(triangle[ctrP][axis] < edgeLocs[axis]) || !(triangle[(ctrP + 1) % 3][axis] > edgeLocs[axis])) continue;
                    alpha = Math.abs(triangle[ctrP][axis] - edgeLocs[axis]) / Math.abs(triangle[ctrP][axis] - triangle[(ctrP + 1) % 3][axis]);
                    pointA.set(triangle[ctrP][0], triangle[ctrP][1], triangle[ctrP][2]);
                    pointB.set(triangle[(ctrP + 1) % 3][0], triangle[(ctrP + 1) % 3][1], triangle[(ctrP + 1) % 3][2]);
                    pointC.interpolate((Tuple3d)pointA, (Tuple3d)pointB, alpha);
                    pointsToTriangulate[triangulateIndex++] = new Point3d(pointC);
                    pointsToTriangulate[triangulateIndex++] = new Point3d(pointB);
                    triangleNew[triangleNewIndex++] = new Point3d(pointC);
                }
                pointA.set(triangle[0][0], triangle[0][1], triangle[0][2]);
                pointB.set(triangle[1][0], triangle[1][1], triangle[1][2]);
                pointC.set(triangle[2][0], triangle[2][1], triangle[2][2]);
                triOld[0] = pointA;
                triOld[1] = pointB;
                triOld[2] = pointC;
                triNew[0] = pointsToTriangulate[0];
                triNew[1] = pointsToTriangulate[1];
                triNew[2] = pointsToTriangulate[2];
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataPos, triNew);
                triNew[0] = pointsToTriangulate[2];
                triNew[1] = pointsToTriangulate[3];
                triNew[2] = pointsToTriangulate[0];
                SurfaceUtils.fixOrder(triOld, triNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataPos, triNew);
                SurfaceUtils.fixOrder(triOld, triangleNew, cpA, cpB, cpC, cpD);
                SurfaceSlicer.addTriangle(triDataNeg, triangleNew);
                continue;
            }
            if (pos == 2) {
                SurfaceSlicer.addTriangle(triDataPos, triangle);
                continue;
            }
            if (pos == 6) {
                SurfaceSlicer.addTriangle(triDataPos, triangle);
                continue;
            }
            if (pos != 14) continue;
            SurfaceSlicer.addTriangle(triDataPos, triangle);
        }
        if (isPos) {
            return triDataPos;
        }
        return triDataNeg;
    }

    private static void addTriangle(TriangleData triData, double[][] triangle) {
        Point3f tempPoint = new Point3f((float)triangle[0][0], (float)triangle[0][1], (float)triangle[0][2]);
        TriangleVertex vert1 = null;
        if (triData.containsVertex(tempPoint)) {
            vert1 = triData.getVertex(tempPoint);
        } else {
            vert1 = new TriangleVertex(tempPoint);
            triData.addVertex(vert1.point, vert1);
        }
        tempPoint = new Point3f((float)triangle[1][0], (float)triangle[1][1], (float)triangle[1][2]);
        TriangleVertex vert2 = null;
        if (triData.containsVertex(tempPoint)) {
            vert2 = triData.getVertex(tempPoint);
        } else {
            vert2 = new TriangleVertex(new Point3f(tempPoint));
            triData.addVertex(vert2.point, vert2);
        }
        tempPoint = new Point3f((float)triangle[2][0], (float)triangle[2][1], (float)triangle[2][2]);
        TriangleVertex vert3 = null;
        if (triData.containsVertex(tempPoint)) {
            vert3 = triData.getVertex(tempPoint);
        } else {
            vert3 = new TriangleVertex(new Point3f(tempPoint));
            triData.addVertex(vert3.point, vert3);
        }
        Triangle tri = new Triangle(vert1, vert2, vert3);
        triData.addTriangle(tri);
        vert1.addTriangle(tri);
        vert2.addTriangle(tri);
        vert3.addTriangle(tri);
    }

    private static void addTriangle(TriangleData triData, Point3d[] triangle) {
        Point3f tempPoint = new Point3f((float)triangle[0].x, (float)triangle[0].y, (float)triangle[0].z);
        TriangleVertex vert1 = null;
        if (triData.containsVertex(tempPoint)) {
            vert1 = triData.getVertex(tempPoint);
        } else {
            vert1 = new TriangleVertex(tempPoint);
            triData.addVertex(vert1.point, vert1);
        }
        tempPoint = new Point3f((float)triangle[1].x, (float)triangle[1].y, (float)triangle[1].z);
        TriangleVertex vert2 = null;
        if (triData.containsVertex(tempPoint)) {
            vert2 = triData.getVertex(tempPoint);
        } else {
            vert2 = new TriangleVertex(new Point3f(tempPoint));
            triData.addVertex(vert2.point, vert2);
        }
        tempPoint = new Point3f((float)triangle[2].x, (float)triangle[2].y, (float)triangle[2].z);
        TriangleVertex vert3 = null;
        if (triData.containsVertex(tempPoint)) {
            vert3 = triData.getVertex(tempPoint);
        } else {
            vert3 = new TriangleVertex(new Point3f(tempPoint));
            triData.addVertex(vert3.point, vert3);
        }
        Triangle tri = new Triangle(vert1, vert2, vert3);
        triData.addTriangle(tri);
        vert1.addTriangle(tri);
        vert2.addTriangle(tri);
        vert3.addTriangle(tri);
    }
}

