/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.measurement;

import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.Triangle;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleData;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SurfaceDataHolder {
    private FloatBuffer normalsBuffer;
    private FloatBuffer pointsBuffer;
    private Iterator<Triangle> iterator;
    private TriangleData triData;
    private Vector3f[] triangleNormals;
    private int triangleIndex;
    private final IntBuffer indicesBuffer;
    private final Point3d[] triangleDouble;
    private final Point3f[] triangle;
    private final boolean normals;
    private final int numIndices;

    public SurfaceDataHolder(CompositeSurface surface, int ctrPart) {
        this(surface, ctrPart, false);
    }

    public SurfaceDataHolder(CompositeSurface surface, int ctrPart, boolean useNormals) {
        this.normals = useNormals;
        this.pointsBuffer = (FloatBuffer)surface.getPointsBuffer(ctrPart).rewind();
        this.indicesBuffer = (IntBuffer)surface.getIndicesBuffer(ctrPart).rewind();
        this.numIndices = this.indicesBuffer.capacity();
        this.triangle = new Point3f[3];
        this.triangle[0] = new Point3f();
        this.triangle[1] = new Point3f();
        this.triangle[2] = new Point3f();
        this.triangleDouble = new Point3d[3];
        this.triangleDouble[0] = new Point3d();
        this.triangleDouble[1] = new Point3d();
        this.triangleDouble[2] = new Point3d();
        if (useNormals) {
            this.normalsBuffer = (FloatBuffer)surface.getNormalsBuffer(ctrPart).rewind();
            this.triangleNormals = new Vector3f[3];
            this.triangleNormals[0] = new Vector3f();
            this.triangleNormals[1] = new Vector3f();
            this.triangleNormals[2] = new Vector3f();
        }
    }

    public Point3f[] getNextTriangle() {
        if (this.pointsBuffer != null) {
            int vertIndex1 = this.indicesBuffer.get(this.triangleIndex++) * 3;
            this.triangle[0].x = this.pointsBuffer.get(vertIndex1);
            this.triangle[0].y = this.pointsBuffer.get(vertIndex1 + 1);
            this.triangle[0].z = this.pointsBuffer.get(vertIndex1 + 2);
            int vertIndex2 = this.indicesBuffer.get(this.triangleIndex++) * 3;
            this.triangle[1].x = this.pointsBuffer.get(vertIndex2);
            this.triangle[1].y = this.pointsBuffer.get(vertIndex2 + 1);
            this.triangle[1].z = this.pointsBuffer.get(vertIndex2 + 2);
            int vertIndex3 = this.indicesBuffer.get(this.triangleIndex++) * 3;
            this.triangle[2].x = this.pointsBuffer.get(vertIndex3);
            this.triangle[2].y = this.pointsBuffer.get(vertIndex3 + 1);
            this.triangle[2].z = this.pointsBuffer.get(vertIndex3 + 2);
            if (this.normals) {
                this.triangleNormals[0].x = this.normalsBuffer.get(vertIndex1);
                this.triangleNormals[0].y = this.normalsBuffer.get(vertIndex1 + 1);
                this.triangleNormals[0].z = this.normalsBuffer.get(vertIndex1 + 2);
                this.triangleNormals[1].x = this.normalsBuffer.get(vertIndex2);
                this.triangleNormals[1].y = this.normalsBuffer.get(vertIndex2 + 1);
                this.triangleNormals[1].z = this.normalsBuffer.get(vertIndex2 + 2);
                this.triangleNormals[2].x = this.normalsBuffer.get(vertIndex3);
                this.triangleNormals[2].y = this.normalsBuffer.get(vertIndex3 + 1);
                this.triangleNormals[2].z = this.normalsBuffer.get(vertIndex3 + 2);
            }
        } else {
            Triangle tri = this.iterator.next();
            this.triangle[0].x = tri.vert1.point.x;
            this.triangle[0].y = tri.vert1.point.y;
            this.triangle[0].z = tri.vert1.point.z;
            this.triangle[1].x = tri.vert2.point.x;
            this.triangle[1].y = tri.vert2.point.y;
            this.triangle[1].z = tri.vert2.point.z;
            this.triangle[2].x = tri.vert3.point.x;
            this.triangle[2].y = tri.vert3.point.y;
            this.triangle[2].z = tri.vert3.point.z;
        }
        return this.triangle;
    }

    public Point3d[] getNextTriangleDouble() {
        this.getNextTriangle();
        for (int ctr = 0; ctr < 3; ++ctr) {
            this.triangleDouble[ctr].set((Tuple3f)this.triangle[ctr]);
        }
        return this.triangleDouble;
    }

    public Vector3f[] getNormals() {
        return this.triangleNormals;
    }

    public TriangleData getTriangleData() {
        return this.triData;
    }

    public boolean hasMoreTriangles() {
        if (this.pointsBuffer != null) {
            return this.triangleIndex < this.numIndices;
        }
        return this.iterator.hasNext();
    }

    public void setTriangleData(TriangleData triDataNew) {
        this.pointsBuffer = null;
        if (this.triData != null) {
            Set<Triangle> triangles = triDataNew.getTriangles();
            for (Triangle tri : triangles) {
                Point3f tempPoint = tri.vert1.point;
                TriangleVertex vert1 = null;
                if (this.triData.containsVertex(tempPoint)) {
                    vert1 = this.triData.getVertex(tempPoint);
                } else {
                    vert1 = new TriangleVertex(tempPoint);
                    this.triData.addVertex(vert1.point, vert1);
                }
                tempPoint = tri.vert2.point;
                TriangleVertex vert2 = null;
                if (this.triData.containsVertex(tempPoint)) {
                    vert2 = this.triData.getVertex(tempPoint);
                } else {
                    vert2 = new TriangleVertex(new Point3f(tempPoint));
                    this.triData.addVertex(vert2.point, vert2);
                }
                tempPoint = tri.vert3.point;
                TriangleVertex vert3 = null;
                if (this.triData.containsVertex(tempPoint)) {
                    vert3 = this.triData.getVertex(tempPoint);
                } else {
                    vert3 = new TriangleVertex(new Point3f(tempPoint));
                    this.triData.addVertex(vert3.point, vert3);
                }
                Triangle tris = new Triangle(vert1, vert2, vert3);
                this.triData.addTriangle(tris);
                vert1.addTriangle(tris);
                vert2.addTriangle(tris);
                vert3.addTriangle(tris);
            }
        } else {
            this.triData = triDataNew;
        }
        this.iterator = this.triData.getTriangles().iterator();
    }

    protected void reset() {
        if (this.pointsBuffer != null) {
            this.triangleIndex = 0;
        } else {
            this.iterator = this.triData.getTriangles().iterator();
        }
    }
}

