/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.measurement;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfacePreferences;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantBuilder;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantRunner;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceDataHolder;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceStatistic;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceStatisticListener;
import edu.uthscsa.ric.mango.viewersurface.utilities.SurfaceUtils;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.net.URI;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public class SurfaceArea
implements OctantRunner,
SurfaceStatistic {
    private double area;
    private double areaCutAway;
    private SurfaceStatisticListener listener;
    private double xSum;
    private double ySum;
    private double zSum;
    private int pointCount;
    private final SurfacePosition position;
    private final SurfacePreferences preferences;
    private final CompositeSurface surface;
    private final VolumeManager viewer;

    public SurfaceArea(VolumeManager viewer, CompositeSurface surface, SurfacePosition position, SurfacePreferences preferences) {
        this.viewer = viewer;
        this.surface = surface;
        this.position = position;
        this.preferences = preferences;
    }

    @Override
    public Analysis getVisibleSurfaceStat() {
        AnalysisImpl analysis = new AnalysisImpl();
        analysis.setRegionSize(this.getResult());
        analysis.setType(7);
        analysis.setDescription(this.getLabel());
        if (!this.getSurface().isBaseSurface()) {
            float[] colorf = this.getSurface().getColor();
            analysis.setColor(new Color(colorf[0], colorf[1], colorf[2]));
        }
        Volume vol = (Volume)(this.getSurface().isBaseSurface() ? this.viewer.getBaseVolume() : (this.getSurface().getAssociatedOvelray() != null ? this.getSurface().getAssociatedOvelray() : null));
        if (this.getSurface().isBaseSurface()) {
            analysis.setName("Surface");
        } else if (vol != null) {
            analysis.setName(StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)vol.getImageDescription().getFile())));
        } else {
            analysis.setName(this.getSurface().getName());
        }
        return analysis;
    }

    @Override
    public Analysis getCutAwaySurfaceStat() {
        AnalysisImpl analysis = new AnalysisImpl();
        analysis.setRegionSize(this.getResultCutAway());
        analysis.setType(7);
        analysis.setDescription(this.getLabelCutAway());
        if (!this.getSurface().isBaseSurface()) {
            float[] colorf = this.getSurface().getColor();
            analysis.setColor(new Color(colorf[0], colorf[1], colorf[2]));
        }
        Volume vol = (Volume)(this.getSurface().isBaseSurface() ? this.viewer.getBaseVolume() : (this.getSurface().getAssociatedOvelray() != null ? this.getSurface().getAssociatedOvelray() : null));
        if (this.getSurface().isBaseSurface()) {
            analysis.setName("Surface");
        } else if (vol != null) {
            analysis.setName(StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)vol.getImageDescription().getFile())));
        } else {
            analysis.setName(this.getSurface().getName());
        }
        return analysis;
    }

    public void calculateSurfaceArea(SurfaceStatisticListener listener) {
        this.listener = listener;
        if (this.surface.getNumParts() == 1) {
            this.doSingleProcess();
        } else {
            OctantBuilder builder = new OctantBuilder(this, true);
            builder.start();
        }
    }

    public void calculateSurfaceAreaSync(SurfaceStatisticListener listener) {
        this.listener = listener;
        if (this.surface.getNumParts() == 1) {
            this.calculateSurfaceArea(0);
        } else {
            OctantBuilder builder = new OctantBuilder(this, true);
            builder.setSync(true);
            builder.start();
        }
    }

    @Override
    public void finishProcess(boolean sync) {
        this.calculateSurfaceArea(this.surface.getNumParts() - 1);
        this.listener.calculationFinished(this, sync);
    }

    public synchronized String getLabel() {
        return "Surface Area";
    }

    public double getResult() {
        return this.area;
    }

    @Override
    public CompositeSurface getSurface() {
        return this.surface;
    }

    @Override
    public void process(int numProcesses, int threadIndex, int ctr, int index) {
        this.calculateSurfaceArea(index);
    }

    @Override
    public boolean testProcess() {
        return true;
    }

    private synchronized void addArea(double localArea) {
        if (!Double.isNaN(localArea)) {
            this.area += localArea;
        }
    }

    private synchronized void addAreaCutAway(double localArea) {
        if (!Double.isNaN(localArea)) {
            this.areaCutAway += localArea;
        }
    }

    private void calculateSurfaceArea(int ctrPart) {
        SurfaceDataHolder data = new SurfaceDataHolder(this.surface, ctrPart);
        boolean hasTransform = false;
        boolean hasCutPlaneAxial = false;
        boolean hasCutPlaneCoronal = false;
        boolean hasCutPlaneSagittal = false;
        boolean hasCutPlane = false;
        boolean cutPlaneDirectionPositiveAxial = false;
        boolean cutPlaneDirectionPositiveCoronal = false;
        boolean cutPlaneDirectionPositiveSagittal = false;
        Point3d currentCoor = new Point3d();
        if (this.position != null && this.preferences != null && this.surface.isBaseSurface()) {
            hasTransform = !this.position.isImageTransformIdentity();
            hasCutPlaneAxial = this.preferences.isUsingAxialCutPlane();
            hasCutPlaneCoronal = this.preferences.isUsingCoronalCutPlane();
            hasCutPlaneSagittal = this.preferences.isUsingSagittalCutPlane();
            hasCutPlane = hasCutPlaneAxial || hasCutPlaneCoronal || hasCutPlaneSagittal;
            cutPlaneDirectionPositiveAxial = (this.position.getLastPickedOctant() & 4) != 0;
            cutPlaneDirectionPositiveCoronal = (this.position.getLastPickedOctant() & 2) == 0;
            cutPlaneDirectionPositiveSagittal = (this.position.getLastPickedOctant() & 1) != 0;
            currentCoor = this.position.getCurrentCoordinate();
        }
        double[] edgeLocs = new double[3];
        currentCoor.get(edgeLocs);
        double[][] triangle = new double[3][3];
        while (data.hasMoreTriangles()) {
            int ctrPoint;
            Point3f[] tri = data.getNextTriangle();
            for (ctrPoint = 0; ctrPoint < 3; ++ctrPoint) {
                Point3f tempPoint = tri[ctrPoint];
                triangle[ctrPoint][0] = tempPoint.x;
                triangle[ctrPoint][1] = tempPoint.y;
                triangle[ctrPoint][2] = tempPoint.z;
                if (!hasTransform || this.position == null) continue;
                this.position.applyImageTransform(triangle[ctrPoint][0], triangle[ctrPoint][1], triangle[ctrPoint][2], null);
            }
            if (hasCutPlane) {
                boolean cutAway = true;
                if (hasCutPlaneAxial) {
                    int position = SurfaceUtils.positionRelativeToAxis(triangle, edgeLocs[2], 2);
                    cutAway &= position >= 0 ^ cutPlaneDirectionPositiveAxial;
                }
                if (hasCutPlaneCoronal) {
                    int position = SurfaceUtils.positionRelativeToAxis(triangle, edgeLocs[1], 1);
                    cutAway &= position >= 0 ^ cutPlaneDirectionPositiveCoronal;
                }
                if (hasCutPlaneSagittal) {
                    int position = SurfaceUtils.positionRelativeToAxis(triangle, edgeLocs[0], 0);
                    cutAway &= position >= 0 ^ cutPlaneDirectionPositiveSagittal;
                }
                if (cutAway) {
                    this.addAreaCutAway(SurfaceUtils.calculateArea(triangle));
                    continue;
                }
                this.addArea(SurfaceUtils.calculateArea(triangle));
                for (int ctrPoint2 = 0; ctrPoint2 < 3; ++ctrPoint2) {
                    this.xSum += triangle[ctrPoint2][0];
                    this.ySum += triangle[ctrPoint2][1];
                    this.zSum += triangle[ctrPoint2][2];
                    ++this.pointCount;
                }
                continue;
            }
            this.addArea(SurfaceUtils.calculateArea(triangle));
            for (ctrPoint = 0; ctrPoint < 3; ++ctrPoint) {
                this.xSum += triangle[ctrPoint][0];
                this.ySum += triangle[ctrPoint][1];
                this.zSum += triangle[ctrPoint][2];
                ++this.pointCount;
            }
        }
    }

    private void doSingleProcess() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SurfaceArea.this.testProcess()) {
                    ProgressMeter pb = SurfaceArea.this.viewer.makeProgressMeter();
                    pb.start(0, 0, 100);
                    pb.setValue(1);
                    pb.setIndeterminateMode(true);
                    SurfaceArea.this.calculateSurfaceArea(0);
                    SurfaceArea.this.listener.calculationFinished(SurfaceArea.this, false);
                    pb.setValue(pb.getMax());
                }
            }
        }, "SurfaceArea.doSingleProcess() Thread");
        workThread.start();
    }

    public String getLabelCutAway() {
        String label = "";
        if (this.preferences != null && this.position != null) {
            boolean isPos;
            if (this.preferences.isUsingSagittalCutPlane()) {
                isPos = (this.position.getLastPickedOctant() & 1) != 0;
                label = label + (isPos ? "L" : "R");
            }
            if (this.preferences.isUsingCoronalCutPlane()) {
                isPos = (this.position.getLastPickedOctant() & 2) == 0;
                label = label + (isPos ? "A" : "P");
            }
            if (this.preferences.isUsingAxialCutPlane()) {
                isPos = (this.position.getLastPickedOctant() & 4) != 0;
                label = label + (isPos ? "S" : "I");
            }
        }
        return "Surface Area Cut-away (" + label + ")";
    }

    public double getResultCutAway() {
        return this.areaCutAway;
    }

    @Override
    public Point3d getCentroid() {
        return new Point3d(this.xSum / (double)this.pointCount, this.ySum / (double)this.pointCount, this.zSum / (double)this.pointCount);
    }
}

