/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.measurement;

import edu.uthscsa.ric.mango.viewersurface.core.LineSegment;
import edu.uthscsa.ric.mango.viewersurface.core.Polygon;
import edu.uthscsa.ric.utilities.AppLogger;
import java.util.Vector;

public class PolygonBuilder {
    private final Vector<Polygon> polygons = new Vector();

    protected void add(LineSegment segment) {
        Vector<Polygon> connectingPolys = new Vector<Polygon>();
        for (Polygon polygon : this.polygons) {
            if (!polygon.connect(segment)) continue;
            connectingPolys.add(polygon);
        }
        if (connectingPolys.size() == 0) {
            this.polygons.add(new Polygon(segment));
        } else if (connectingPolys.size() == 2) {
            Polygon poly2;
            Polygon poly1 = (Polygon)connectingPolys.get(0);
            if (!poly1.connect(poly2 = (Polygon)connectingPolys.get(1)) && AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)"Error: Connecting polygons didn't connect!");
            }
            this.polygons.remove(poly2);
        } else if (connectingPolys.size() != 1) {
            if (AppLogger.isDebugEnabled() && AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)("Error: Invalid number of connecting polys! (" + connectingPolys.size() + ")"));
            }
            for (int ctr = 0; ctr < connectingPolys.size(); ++ctr) {
                if (!AppLogger.isDebugEnabled()) continue;
                AppLogger.debug((String)((Polygon)connectingPolys.get(ctr)).toString());
            }
        }
    }

    public Vector<Polygon> getPolygons() {
        return this.polygons;
    }
}

